// components/omnibox/browser/searchbox.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_H_
#define COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/omnibox/browser/searchbox.mojom-features.h"  // IWYU pragma: export
#include "components/omnibox/browser/searchbox.mojom-shared.h"  // IWYU pragma: export
#include "components/omnibox/browser/searchbox.mojom-forward.h"  // IWYU pragma: export
#include "components/omnibox/browser/omnibox.mojom-forward.h"
#include "components/omnibox/composebox/composebox_query.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace searchbox::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "searchbox.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetPageMinVersion = 0,
    kOnFocusChangedMinVersion = 0,
    kQueryAutocompleteMinVersion = 0,
    kStopAutocompleteMinVersion = 0,
    kOpenAutocompleteMatchMinVersion = 0,
    kOnNavigationLikelyMinVersion = 0,
    kDeleteAutocompleteMatchMinVersion = 0,
    kActivateKeywordMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kExecuteActionMinVersion = 0,
    kOnThumbnailRemovedMinVersion = 0,
    kGetPlaceholderConfigMinVersion = 0,
    kGetRecentTabsMinVersion = 0,
    kGetTabPreviewMinVersion = 0,
    kNotifySessionStartedMinVersion = 0,
    kNotifySessionAbandonedMinVersion = 0,
    kAddFileContextMinVersion = 0,
    kAddTabContextMinVersion = 0,
    kDeleteContextMinVersion = 0,
    kClearFilesMinVersion = 0,
    kSubmitQueryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFocusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueryAutocomplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopAutocomplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenAutocompleteMatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNavigationLikely_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAutocompleteMatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivateKeyword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnThumbnailRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPlaceholderConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRecentTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifySessionStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifySessionAbandoned_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFileContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddTabContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearFiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitQuery_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void SetPage(::mojo::PendingRemote<Page> page) = 0;

  virtual void OnFocusChanged(bool focused) = 0;

  virtual void QueryAutocomplete(const ::std::u16string& input, bool prevent_inline_autocomplete) = 0;

  virtual void StopAutocomplete(bool clear_result) = 0;

  virtual void OpenAutocompleteMatch(uint8_t line, const ::GURL& url, bool are_matches_showing, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) = 0;

  virtual void OnNavigationLikely(uint8_t line, const ::GURL& url, ::omnibox::mojom::NavigationPredictor navigation_predictor) = 0;

  virtual void DeleteAutocompleteMatch(uint8_t line, const ::GURL& url) = 0;

  virtual void ActivateKeyword(uint8_t line, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, bool is_mouse_event) = 0;

  virtual void ShowContextMenu(const ::gfx::Point& point) = 0;

  virtual void ExecuteAction(uint8_t line, uint8_t action_index, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) = 0;

  virtual void OnThumbnailRemoved() = 0;

  using GetPlaceholderConfigCallback = base::OnceCallback<void(PlaceholderConfigPtr)>;
  using GetPlaceholderConfigMojoCallback = base::OnceCallback<void(PlaceholderConfigPtr)>;

  virtual void GetPlaceholderConfig(GetPlaceholderConfigCallback callback) = 0;

  using GetRecentTabsCallback = base::OnceCallback<void(std::vector<TabInfoPtr>)>;
  using GetRecentTabsMojoCallback = base::OnceCallback<void(std::vector<TabInfoPtr>)>;

  virtual void GetRecentTabs(GetRecentTabsCallback callback) = 0;

  using GetTabPreviewCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using GetTabPreviewMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void GetTabPreview(int32_t tab_id, GetTabPreviewCallback callback) = 0;

  virtual void NotifySessionStarted() = 0;

  virtual void NotifySessionAbandoned() = 0;

  using AddFileContextCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  using AddFileContextMojoCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;

  virtual void AddFileContext(SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes, AddFileContextCallback callback) = 0;

  using AddTabContextCallback = base::OnceCallback<void(const std::optional<::base::UnguessableToken>&)>;
  using AddTabContextMojoCallback = base::OnceCallback<void(const std::optional<::base::UnguessableToken>&)>;

  virtual void AddTabContext(int32_t tab_id, bool delay_upload, AddTabContextCallback callback) = 0;

  virtual void DeleteContext(const ::base::UnguessableToken& token) = 0;

  virtual void ClearFiles() = 0;

  virtual void SubmitQuery(const std::string& query_text, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "searchbox.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAutocompleteResultChangedMinVersion = 0,
    kUpdateSelectionMinVersion = 0,
    kSetKeywordSelectedMinVersion = 0,
    kOnShowMinVersion = 0,
    kSetInputTextMinVersion = 0,
    kSetThumbnailMinVersion = 0,
    kOnContextualInputStatusChangedMinVersion = 0,
    kOnTabStripChangedMinVersion = 0,
    kAddFileContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AutocompleteResultChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetKeywordSelected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnShow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInputText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetThumbnail_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnContextualInputStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTabStripChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFileContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void AutocompleteResultChanged(AutocompleteResultPtr result) = 0;

  virtual void UpdateSelection(OmniboxPopupSelectionPtr old_selection, OmniboxPopupSelectionPtr selection) = 0;

  virtual void SetKeywordSelected(bool is_keyword_selected) = 0;

  virtual void OnShow() = 0;

  virtual void SetInputText(const std::string& input) = 0;

  virtual void SetThumbnail(const std::string& thumbnail_url, bool is_deletable) = 0;

  virtual void OnContextualInputStatusChanged(const ::base::UnguessableToken& token, ::composebox_query::mojom::FileUploadStatus status, std::optional<::composebox_query::mojom::FileUploadErrorType> error_type) = 0;

  virtual void OnTabStripChanged() = 0;

  virtual void AddFileContext(const ::base::UnguessableToken& token, SelectedFileInfoPtr file_info) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPage(::mojo::PendingRemote<Page> page) final;
  
  void OnFocusChanged(bool focused) final;
  
  void QueryAutocomplete(const ::std::u16string& input, bool prevent_inline_autocomplete) final;
  
  void StopAutocomplete(bool clear_result) final;
  
  void OpenAutocompleteMatch(uint8_t line, const ::GURL& url, bool are_matches_showing, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) final;
  
  void OnNavigationLikely(uint8_t line, const ::GURL& url, ::omnibox::mojom::NavigationPredictor navigation_predictor) final;
  
  void DeleteAutocompleteMatch(uint8_t line, const ::GURL& url) final;
  
  void ActivateKeyword(uint8_t line, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, bool is_mouse_event) final;
  
  void ShowContextMenu(const ::gfx::Point& point) final;
  
  void ExecuteAction(uint8_t line, uint8_t action_index, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) final;
  
  void OnThumbnailRemoved() final;
  
  void GetPlaceholderConfig(GetPlaceholderConfigCallback callback) final;
  
  void GetRecentTabs(GetRecentTabsCallback callback) final;
  
  void GetTabPreview(int32_t tab_id, GetTabPreviewCallback callback) final;
  
  void NotifySessionStarted() final;
  
  void NotifySessionAbandoned() final;
  
  void AddFileContext(SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes, AddFileContextCallback callback) final;
  
  void AddTabContext(int32_t tab_id, bool delay_upload, AddTabContextCallback callback) final;
  
  void DeleteContext(const ::base::UnguessableToken& token) final;
  
  void ClearFiles() final;
  
  void SubmitQuery(const std::string& query_text, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AutocompleteResultChanged(AutocompleteResultPtr result) final;
  
  void UpdateSelection(OmniboxPopupSelectionPtr old_selection, OmniboxPopupSelectionPtr selection) final;
  
  void SetKeywordSelected(bool is_keyword_selected) final;
  
  void OnShow() final;
  
  void SetInputText(const std::string& input) final;
  
  void SetThumbnail(const std::string& thumbnail_url, bool is_deletable) final;
  
  void OnContextualInputStatusChanged(const ::base::UnguessableToken& token, ::composebox_query::mojom::FileUploadStatus status, std::optional<::composebox_query::mojom::FileUploadErrorType> error_type) final;
  
  void OnTabStripChanged() final;
  
  void AddFileContext(const ::base::UnguessableToken& token, SelectedFileInfoPtr file_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ACMatchClassification {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ACMatchClassification, T>::value>;
  using DataView = ACMatchClassificationDataView;
  using Data_ = internal::ACMatchClassification_Data;

  template <typename... Args>
  static ACMatchClassificationPtr New(Args&&... args) {
    return ACMatchClassificationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ACMatchClassificationPtr From(const U& u) {
    return mojo::TypeConverter<ACMatchClassificationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ACMatchClassification>::Convert(*this);
  }


  ACMatchClassification();

  ACMatchClassification(
      uint32_t offset,
      int32_t style);


  ~ACMatchClassification();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ACMatchClassificationPtr>
  ACMatchClassificationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ACMatchClassification::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ACMatchClassification::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ACMatchClassification::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ACMatchClassification_UnserializedMessageContext<
            UserType, ACMatchClassification::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ACMatchClassification::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ACMatchClassification::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ACMatchClassification_UnserializedMessageContext<
            UserType, ACMatchClassification::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ACMatchClassification::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t offset;
  
  int32_t style;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Action {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Action, T>::value>;
  using DataView = ActionDataView;
  using Data_ = internal::Action_Data;

  template <typename... Args>
  static ActionPtr New(Args&&... args) {
    return ActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ActionPtr From(const U& u) {
    return mojo::TypeConverter<ActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Action>::Convert(*this);
  }


  Action();

  Action(
      const std::string& hint,
      const std::string& suggestion_contents,
      const std::string& icon_path,
      const std::string& a11y_label);


  ~Action();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ActionPtr>
  ActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Action::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Action::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Action::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Action::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Action::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Action::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Action_UnserializedMessageContext<
            UserType, Action::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Action::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Action::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Action_UnserializedMessageContext<
            UserType, Action::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Action::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string hint;
  
  std::string suggestion_contents;
  
  std::string icon_path;
  
  std::string a11y_label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}














class  OmniboxPopupSelection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OmniboxPopupSelection, T>::value>;
  using DataView = OmniboxPopupSelectionDataView;
  using Data_ = internal::OmniboxPopupSelection_Data;

  template <typename... Args>
  static OmniboxPopupSelectionPtr New(Args&&... args) {
    return OmniboxPopupSelectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OmniboxPopupSelectionPtr From(const U& u) {
    return mojo::TypeConverter<OmniboxPopupSelectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OmniboxPopupSelection>::Convert(*this);
  }


  OmniboxPopupSelection();

  OmniboxPopupSelection(
      uint8_t line,
      SelectionLineState state,
      uint8_t action_index);


  ~OmniboxPopupSelection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OmniboxPopupSelectionPtr>
  OmniboxPopupSelectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OmniboxPopupSelection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OmniboxPopupSelection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OmniboxPopupSelection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OmniboxPopupSelection_UnserializedMessageContext<
            UserType, OmniboxPopupSelection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OmniboxPopupSelection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OmniboxPopupSelection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OmniboxPopupSelection_UnserializedMessageContext<
            UserType, OmniboxPopupSelection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OmniboxPopupSelection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t line;
  
  SelectionLineState state;
  
  uint8_t action_index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OmniboxPopupSelection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SearchContextAttachmentStub {
 public:
  using DataView = SearchContextAttachmentStubDataView;
  using Data_ = internal::SearchContextAttachmentStub_Data;
  using Tag = Data_::SearchContextAttachmentStub_Tag;

  template <typename... Args>
  static SearchContextAttachmentStubPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |file_attachment|.
  static SearchContextAttachmentStubPtr NewFileAttachment(
      FileAttachmentStubPtr value);
  // Construct an instance holding |tab_attachment|.
  static SearchContextAttachmentStubPtr NewTabAttachment(
      TabAttachmentStubPtr value);

  template <typename U>
  static SearchContextAttachmentStubPtr From(const U& u) {
    return mojo::TypeConverter<SearchContextAttachmentStubPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchContextAttachmentStub>::Convert(*this);
  }
  ~SearchContextAttachmentStub();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SearchContextAttachmentStub(const SearchContextAttachmentStub& other) = delete;
  SearchContextAttachmentStub& operator=(const SearchContextAttachmentStub& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SearchContextAttachmentStubPtr>
  SearchContextAttachmentStubPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SearchContextAttachmentStub>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SearchContextAttachmentStub>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_file_attachment() const { return tag_ == Tag::kFileAttachment; }
  const FileAttachmentStubPtr& get_file_attachment() const {
    CHECK(tag_ == Tag::kFileAttachment);
    return data_.file_attachment;
  }
  FileAttachmentStubPtr& get_file_attachment() {
    CHECK(tag_ == Tag::kFileAttachment);
    return data_.file_attachment;
  }
  void set_file_attachment(FileAttachmentStubPtr file_attachment);

  bool is_tab_attachment() const { return tag_ == Tag::kTabAttachment; }
  const TabAttachmentStubPtr& get_tab_attachment() const {
    CHECK(tag_ == Tag::kTabAttachment);
    return data_.tab_attachment;
  }
  TabAttachmentStubPtr& get_tab_attachment() {
    CHECK(tag_ == Tag::kTabAttachment);
    return data_.tab_attachment;
  }
  void set_tab_attachment(TabAttachmentStubPtr tab_attachment);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchContextAttachmentStub::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SearchContextAttachmentStub::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFileAttachment)>,
        FileAttachmentStubPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabAttachment)>,
        TabAttachmentStubPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    FileAttachmentStubPtr file_attachment;
    TabAttachmentStubPtr tab_attachment;
  };

  SearchContextAttachmentStub(
      std::in_place_index_t<static_cast<size_t>(Tag::kFileAttachment)>,
      FileAttachmentStubPtr value);
  SearchContextAttachmentStub(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabAttachment)>,
      TabAttachmentStubPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};







class  SuggestionAnswer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SuggestionAnswer, T>::value>;
  using DataView = SuggestionAnswerDataView;
  using Data_ = internal::SuggestionAnswer_Data;

  template <typename... Args>
  static SuggestionAnswerPtr New(Args&&... args) {
    return SuggestionAnswerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SuggestionAnswerPtr From(const U& u) {
    return mojo::TypeConverter<SuggestionAnswerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SuggestionAnswer>::Convert(*this);
  }


  SuggestionAnswer();

  SuggestionAnswer(
      const ::std::u16string& first_line,
      const ::std::u16string& second_line);


  ~SuggestionAnswer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SuggestionAnswerPtr>
  SuggestionAnswerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuggestionAnswer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuggestionAnswer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SuggestionAnswer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SuggestionAnswer_UnserializedMessageContext<
            UserType, SuggestionAnswer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SuggestionAnswer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SuggestionAnswer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SuggestionAnswer_UnserializedMessageContext<
            UserType, SuggestionAnswer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SuggestionAnswer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string first_line;
  
  ::std::u16string second_line;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SuggestionAnswer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutocompleteMatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteMatch, T>::value>;
  using DataView = AutocompleteMatchDataView;
  using Data_ = internal::AutocompleteMatch_Data;

  template <typename... Args>
  static AutocompleteMatchPtr New(Args&&... args) {
    return AutocompleteMatchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteMatchPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteMatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteMatch>::Convert(*this);
  }


  AutocompleteMatch();

  AutocompleteMatch(
      bool is_hidden,
      const ::std::u16string& a11y_label,
      bool allowed_to_be_default_match,
      std::vector<ActionPtr> actions,
      SuggestionAnswerPtr answer,
      const ::std::u16string& contents,
      std::vector<ACMatchClassificationPtr> contents_class,
      const ::std::u16string& description,
      std::vector<ACMatchClassificationPtr> description_class,
      const ::GURL& destination_url,
      const ::std::u16string& inline_autocompletion,
      const ::std::u16string& fill_into_edit,
      std::optional<bool> is_weather_answer_suggestion,
      const std::string& icon_path,
      const ::GURL& icon_url,
      const std::string& image_dominant_color,
      const std::string& image_url,
      bool is_noncanned_aim_suggestion,
      bool is_rich_suggestion,
      bool is_search_type,
      bool is_enterprise_search_aggregator_people_type,
      const std::string& type,
      const ::std::u16string& remove_button_a11y_label,
      bool swap_contents_and_description,
      int32_t suggestion_group_id,
      bool supports_deletion,
      const std::optional<::std::u16string>& tail_suggest_common_prefix,
      bool has_instant_keyword,
      const std::string& keyword_chip_hint,
      const std::string& keyword_chip_a11y);

AutocompleteMatch(const AutocompleteMatch&) = delete;
AutocompleteMatch& operator=(const AutocompleteMatch&) = delete;

  ~AutocompleteMatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteMatchPtr>
  AutocompleteMatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteMatch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteMatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteMatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteMatch_UnserializedMessageContext<
            UserType, AutocompleteMatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteMatch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteMatch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteMatch_UnserializedMessageContext<
            UserType, AutocompleteMatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteMatch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_hidden;
  
  ::std::u16string a11y_label;
  
  bool allowed_to_be_default_match;
  
  std::vector<ActionPtr> actions;
  
  SuggestionAnswerPtr answer;
  
  ::std::u16string contents;
  
  std::vector<ACMatchClassificationPtr> contents_class;
  
  ::std::u16string description;
  
  std::vector<ACMatchClassificationPtr> description_class;
  
  ::GURL destination_url;
  
  ::std::u16string inline_autocompletion;
  
  ::std::u16string fill_into_edit;
  
  std::optional<bool> is_weather_answer_suggestion;
  
  std::string icon_path;
  
  ::GURL icon_url;
  
  std::string image_dominant_color;
  
  std::string image_url;
  
  bool is_noncanned_aim_suggestion;
  
  bool is_rich_suggestion;
  
  bool is_search_type;
  
  bool is_enterprise_search_aggregator_people_type;
  
  std::string type;
  
  ::std::u16string remove_button_a11y_label;
  
  bool swap_contents_and_description;
  
  int32_t suggestion_group_id;
  
  bool supports_deletion;
  
  std::optional<::std::u16string> tail_suggest_common_prefix;
  
  bool has_instant_keyword;
  
  std::string keyword_chip_hint;
  
  std::string keyword_chip_a11y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabInfo, T>::value>;
  using DataView = TabInfoDataView;
  using Data_ = internal::TabInfo_Data;

  template <typename... Args>
  static TabInfoPtr New(Args&&... args) {
    return TabInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabInfoPtr From(const U& u) {
    return mojo::TypeConverter<TabInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabInfo>::Convert(*this);
  }


  TabInfo();

  TabInfo(
      int32_t tab_id,
      const std::string& title,
      const ::GURL& url,
      bool show_in_recent_tab_chip,
      ::base::TimeTicks last_active);


  ~TabInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabInfoPtr>
  TabInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabInfo_UnserializedMessageContext<
            UserType, TabInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabInfo_UnserializedMessageContext<
            UserType, TabInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  std::string title;
  
  ::GURL url;
  
  bool show_in_recent_tab_chip;
  
  ::base::TimeTicks last_active;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FileAttachmentStub {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileAttachmentStub, T>::value>;
  using DataView = FileAttachmentStubDataView;
  using Data_ = internal::FileAttachmentStub_Data;

  template <typename... Args>
  static FileAttachmentStubPtr New(Args&&... args) {
    return FileAttachmentStubPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileAttachmentStubPtr From(const U& u) {
    return mojo::TypeConverter<FileAttachmentStubPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileAttachmentStub>::Convert(*this);
  }


  FileAttachmentStub();

  FileAttachmentStub(
      const ::base::UnguessableToken& uuid,
      const std::string& name,
      const std::string& mime_type,
      const std::optional<std::string>& image_data_url);


  ~FileAttachmentStub();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileAttachmentStubPtr>
  FileAttachmentStubPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileAttachmentStub::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileAttachmentStub::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileAttachmentStub::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileAttachmentStub_UnserializedMessageContext<
            UserType, FileAttachmentStub::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileAttachmentStub::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileAttachmentStub::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileAttachmentStub_UnserializedMessageContext<
            UserType, FileAttachmentStub::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileAttachmentStub::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken uuid;
  
  std::string name;
  
  std::string mime_type;
  
  std::optional<std::string> image_data_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabAttachmentStub {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabAttachmentStub, T>::value>;
  using DataView = TabAttachmentStubDataView;
  using Data_ = internal::TabAttachmentStub_Data;

  template <typename... Args>
  static TabAttachmentStubPtr New(Args&&... args) {
    return TabAttachmentStubPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabAttachmentStubPtr From(const U& u) {
    return mojo::TypeConverter<TabAttachmentStubPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabAttachmentStub>::Convert(*this);
  }


  TabAttachmentStub();

  TabAttachmentStub(
      int32_t tab_id,
      const std::string& title,
      const ::GURL& url);


  ~TabAttachmentStub();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabAttachmentStubPtr>
  TabAttachmentStubPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabAttachmentStub::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabAttachmentStub::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabAttachmentStub::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabAttachmentStub_UnserializedMessageContext<
            UserType, TabAttachmentStub::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabAttachmentStub::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabAttachmentStub::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabAttachmentStub_UnserializedMessageContext<
            UserType, TabAttachmentStub::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabAttachmentStub::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  std::string title;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabAttachmentStub::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SearchContextStub {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchContextStub, T>::value>;
  using DataView = SearchContextStubDataView;
  using Data_ = internal::SearchContextStub_Data;

  template <typename... Args>
  static SearchContextStubPtr New(Args&&... args) {
    return SearchContextStubPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchContextStubPtr From(const U& u) {
    return mojo::TypeConverter<SearchContextStubPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchContextStub>::Convert(*this);
  }


  SearchContextStub();

  SearchContextStub(
      const std::string& input,
      std::vector<SearchContextAttachmentStubPtr> attachments,
      ToolMode tool_mode);

SearchContextStub(const SearchContextStub&) = delete;
SearchContextStub& operator=(const SearchContextStub&) = delete;

  ~SearchContextStub();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchContextStubPtr>
  SearchContextStubPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchContextStub::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchContextStub::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchContextStub::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchContextStub_UnserializedMessageContext<
            UserType, SearchContextStub::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchContextStub::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchContextStub::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchContextStub_UnserializedMessageContext<
            UserType, SearchContextStub::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchContextStub::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string input;
  
  std::vector<SearchContextAttachmentStubPtr> attachments;
  
  ToolMode tool_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchContextStub::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SelectedFileInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectedFileInfo, T>::value>;
  using DataView = SelectedFileInfoDataView;
  using Data_ = internal::SelectedFileInfo_Data;

  template <typename... Args>
  static SelectedFileInfoPtr New(Args&&... args) {
    return SelectedFileInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectedFileInfoPtr From(const U& u) {
    return mojo::TypeConverter<SelectedFileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectedFileInfo>::Convert(*this);
  }


  SelectedFileInfo();

  SelectedFileInfo(
      const std::string& file_name,
      const std::string& mime_type,
      const std::optional<std::string>& image_data_url,
      bool is_deletable,
      ::base::Time selection_time);


  ~SelectedFileInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectedFileInfoPtr>
  SelectedFileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectedFileInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectedFileInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectedFileInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectedFileInfo_UnserializedMessageContext<
            UserType, SelectedFileInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectedFileInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectedFileInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectedFileInfo_UnserializedMessageContext<
            UserType, SelectedFileInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectedFileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string file_name;
  
  std::string mime_type;
  
  std::optional<std::string> image_data_url;
  
  bool is_deletable;
  
  ::base::Time selection_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectedFileInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SuggestionGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SuggestionGroup, T>::value>;
  using DataView = SuggestionGroupDataView;
  using Data_ = internal::SuggestionGroup_Data;

  template <typename... Args>
  static SuggestionGroupPtr New(Args&&... args) {
    return SuggestionGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SuggestionGroupPtr From(const U& u) {
    return mojo::TypeConverter<SuggestionGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SuggestionGroup>::Convert(*this);
  }


  SuggestionGroup();

  SuggestionGroup(
      const ::std::u16string& header,
      RenderType render_type,
      SideType side_type);


  ~SuggestionGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SuggestionGroupPtr>
  SuggestionGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuggestionGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuggestionGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SuggestionGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SuggestionGroup_UnserializedMessageContext<
            UserType, SuggestionGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SuggestionGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SuggestionGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SuggestionGroup_UnserializedMessageContext<
            UserType, SuggestionGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SuggestionGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string header;
  
  RenderType render_type;
  
  SideType side_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SuggestionGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutocompleteResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteResult, T>::value>;
  using DataView = AutocompleteResultDataView;
  using Data_ = internal::AutocompleteResult_Data;

  template <typename... Args>
  static AutocompleteResultPtr New(Args&&... args) {
    return AutocompleteResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteResultPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteResult>::Convert(*this);
  }


  AutocompleteResult();

  AutocompleteResult(
      const ::std::u16string& input,
      base::flat_map<int32_t, SuggestionGroupPtr> suggestion_groups_map,
      std::vector<AutocompleteMatchPtr> matches,
      const std::optional<::std::u16string>& smart_compose_inline_hint);

AutocompleteResult(const AutocompleteResult&) = delete;
AutocompleteResult& operator=(const AutocompleteResult&) = delete;

  ~AutocompleteResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteResultPtr>
  AutocompleteResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteResult_UnserializedMessageContext<
            UserType, AutocompleteResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteResult_UnserializedMessageContext<
            UserType, AutocompleteResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string input;
  
  base::flat_map<int32_t, SuggestionGroupPtr> suggestion_groups_map;
  
  std::vector<AutocompleteMatchPtr> matches;
  
  std::optional<::std::u16string> smart_compose_inline_hint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PlaceholderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlaceholderConfig, T>::value>;
  using DataView = PlaceholderConfigDataView;
  using Data_ = internal::PlaceholderConfig_Data;

  template <typename... Args>
  static PlaceholderConfigPtr New(Args&&... args) {
    return PlaceholderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlaceholderConfigPtr From(const U& u) {
    return mojo::TypeConverter<PlaceholderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlaceholderConfig>::Convert(*this);
  }


  PlaceholderConfig();

  PlaceholderConfig(
      std::vector<::std::u16string> texts,
      ::base::TimeDelta change_text_animation_interval,
      ::base::TimeDelta fade_text_animation_duration);


  ~PlaceholderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlaceholderConfigPtr>
  PlaceholderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaceholderConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaceholderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlaceholderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlaceholderConfig_UnserializedMessageContext<
            UserType, PlaceholderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PlaceholderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PlaceholderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlaceholderConfig_UnserializedMessageContext<
            UserType, PlaceholderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlaceholderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::std::u16string> texts;
  
  ::base::TimeDelta change_text_animation_interval;
  
  ::base::TimeDelta fade_text_animation_duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlaceholderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SearchContextAttachmentStubPtr SearchContextAttachmentStub::Clone() const {
  switch (tag_) {
    case Tag::kFileAttachment:
      return NewFileAttachment(
          mojo::Clone(data_.file_attachment));
    case Tag::kTabAttachment:
      return NewTabAttachment(
          mojo::Clone(data_.tab_attachment));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SearchContextAttachmentStub>::value>::type*>
bool SearchContextAttachmentStub::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFileAttachment:
      return mojo::Equals(data_.file_attachment, other.data_.file_attachment);
    case Tag::kTabAttachment:
      return mojo::Equals(data_.tab_attachment, other.data_.tab_attachment);
  }

  return false;
}
template <typename StructPtrType>
ACMatchClassificationPtr ACMatchClassification::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(style)
  );
}

template <typename T, ACMatchClassification::EnableIfSame<T>*>
bool ACMatchClassification::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->style, other_struct.style))
    return false;
  return true;
}

template <typename T, ACMatchClassification::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.style < rhs.style)
    return true;
  if (rhs.style < lhs.style)
    return false;
  return false;
}
template <typename StructPtrType>
ActionPtr Action::Clone() const {
  return New(
      mojo::Clone(hint),
      mojo::Clone(suggestion_contents),
      mojo::Clone(icon_path),
      mojo::Clone(a11y_label)
  );
}

template <typename T, Action::EnableIfSame<T>*>
bool Action::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->hint, other_struct.hint))
    return false;
  if (!mojo::Equals(this->suggestion_contents, other_struct.suggestion_contents))
    return false;
  if (!mojo::Equals(this->icon_path, other_struct.icon_path))
    return false;
  if (!mojo::Equals(this->a11y_label, other_struct.a11y_label))
    return false;
  return true;
}

template <typename T, Action::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.hint < rhs.hint)
    return true;
  if (rhs.hint < lhs.hint)
    return false;
  if (lhs.suggestion_contents < rhs.suggestion_contents)
    return true;
  if (rhs.suggestion_contents < lhs.suggestion_contents)
    return false;
  if (lhs.icon_path < rhs.icon_path)
    return true;
  if (rhs.icon_path < lhs.icon_path)
    return false;
  if (lhs.a11y_label < rhs.a11y_label)
    return true;
  if (rhs.a11y_label < lhs.a11y_label)
    return false;
  return false;
}
template <typename StructPtrType>
SuggestionAnswerPtr SuggestionAnswer::Clone() const {
  return New(
      mojo::Clone(first_line),
      mojo::Clone(second_line)
  );
}

template <typename T, SuggestionAnswer::EnableIfSame<T>*>
bool SuggestionAnswer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->first_line, other_struct.first_line))
    return false;
  if (!mojo::Equals(this->second_line, other_struct.second_line))
    return false;
  return true;
}

template <typename T, SuggestionAnswer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.first_line < rhs.first_line)
    return true;
  if (rhs.first_line < lhs.first_line)
    return false;
  if (lhs.second_line < rhs.second_line)
    return true;
  if (rhs.second_line < lhs.second_line)
    return false;
  return false;
}
template <typename StructPtrType>
AutocompleteMatchPtr AutocompleteMatch::Clone() const {
  return New(
      mojo::Clone(is_hidden),
      mojo::Clone(a11y_label),
      mojo::Clone(allowed_to_be_default_match),
      mojo::Clone(actions),
      mojo::Clone(answer),
      mojo::Clone(contents),
      mojo::Clone(contents_class),
      mojo::Clone(description),
      mojo::Clone(description_class),
      mojo::Clone(destination_url),
      mojo::Clone(inline_autocompletion),
      mojo::Clone(fill_into_edit),
      mojo::Clone(is_weather_answer_suggestion),
      mojo::Clone(icon_path),
      mojo::Clone(icon_url),
      mojo::Clone(image_dominant_color),
      mojo::Clone(image_url),
      mojo::Clone(is_noncanned_aim_suggestion),
      mojo::Clone(is_rich_suggestion),
      mojo::Clone(is_search_type),
      mojo::Clone(is_enterprise_search_aggregator_people_type),
      mojo::Clone(type),
      mojo::Clone(remove_button_a11y_label),
      mojo::Clone(swap_contents_and_description),
      mojo::Clone(suggestion_group_id),
      mojo::Clone(supports_deletion),
      mojo::Clone(tail_suggest_common_prefix),
      mojo::Clone(has_instant_keyword),
      mojo::Clone(keyword_chip_hint),
      mojo::Clone(keyword_chip_a11y)
  );
}

template <typename T, AutocompleteMatch::EnableIfSame<T>*>
bool AutocompleteMatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_hidden, other_struct.is_hidden))
    return false;
  if (!mojo::Equals(this->a11y_label, other_struct.a11y_label))
    return false;
  if (!mojo::Equals(this->allowed_to_be_default_match, other_struct.allowed_to_be_default_match))
    return false;
  if (!mojo::Equals(this->actions, other_struct.actions))
    return false;
  if (!mojo::Equals(this->answer, other_struct.answer))
    return false;
  if (!mojo::Equals(this->contents, other_struct.contents))
    return false;
  if (!mojo::Equals(this->contents_class, other_struct.contents_class))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->description_class, other_struct.description_class))
    return false;
  if (!mojo::Equals(this->destination_url, other_struct.destination_url))
    return false;
  if (!mojo::Equals(this->inline_autocompletion, other_struct.inline_autocompletion))
    return false;
  if (!mojo::Equals(this->fill_into_edit, other_struct.fill_into_edit))
    return false;
  if (!mojo::Equals(this->is_weather_answer_suggestion, other_struct.is_weather_answer_suggestion))
    return false;
  if (!mojo::Equals(this->icon_path, other_struct.icon_path))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  if (!mojo::Equals(this->image_dominant_color, other_struct.image_dominant_color))
    return false;
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->is_noncanned_aim_suggestion, other_struct.is_noncanned_aim_suggestion))
    return false;
  if (!mojo::Equals(this->is_rich_suggestion, other_struct.is_rich_suggestion))
    return false;
  if (!mojo::Equals(this->is_search_type, other_struct.is_search_type))
    return false;
  if (!mojo::Equals(this->is_enterprise_search_aggregator_people_type, other_struct.is_enterprise_search_aggregator_people_type))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->remove_button_a11y_label, other_struct.remove_button_a11y_label))
    return false;
  if (!mojo::Equals(this->swap_contents_and_description, other_struct.swap_contents_and_description))
    return false;
  if (!mojo::Equals(this->suggestion_group_id, other_struct.suggestion_group_id))
    return false;
  if (!mojo::Equals(this->supports_deletion, other_struct.supports_deletion))
    return false;
  if (!mojo::Equals(this->tail_suggest_common_prefix, other_struct.tail_suggest_common_prefix))
    return false;
  if (!mojo::Equals(this->has_instant_keyword, other_struct.has_instant_keyword))
    return false;
  if (!mojo::Equals(this->keyword_chip_hint, other_struct.keyword_chip_hint))
    return false;
  if (!mojo::Equals(this->keyword_chip_a11y, other_struct.keyword_chip_a11y))
    return false;
  return true;
}

template <typename T, AutocompleteMatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_hidden < rhs.is_hidden)
    return true;
  if (rhs.is_hidden < lhs.is_hidden)
    return false;
  if (lhs.a11y_label < rhs.a11y_label)
    return true;
  if (rhs.a11y_label < lhs.a11y_label)
    return false;
  if (lhs.allowed_to_be_default_match < rhs.allowed_to_be_default_match)
    return true;
  if (rhs.allowed_to_be_default_match < lhs.allowed_to_be_default_match)
    return false;
  if (lhs.actions < rhs.actions)
    return true;
  if (rhs.actions < lhs.actions)
    return false;
  if (lhs.answer < rhs.answer)
    return true;
  if (rhs.answer < lhs.answer)
    return false;
  if (lhs.contents < rhs.contents)
    return true;
  if (rhs.contents < lhs.contents)
    return false;
  if (lhs.contents_class < rhs.contents_class)
    return true;
  if (rhs.contents_class < lhs.contents_class)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.description_class < rhs.description_class)
    return true;
  if (rhs.description_class < lhs.description_class)
    return false;
  if (lhs.destination_url < rhs.destination_url)
    return true;
  if (rhs.destination_url < lhs.destination_url)
    return false;
  if (lhs.inline_autocompletion < rhs.inline_autocompletion)
    return true;
  if (rhs.inline_autocompletion < lhs.inline_autocompletion)
    return false;
  if (lhs.fill_into_edit < rhs.fill_into_edit)
    return true;
  if (rhs.fill_into_edit < lhs.fill_into_edit)
    return false;
  if (lhs.is_weather_answer_suggestion < rhs.is_weather_answer_suggestion)
    return true;
  if (rhs.is_weather_answer_suggestion < lhs.is_weather_answer_suggestion)
    return false;
  if (lhs.icon_path < rhs.icon_path)
    return true;
  if (rhs.icon_path < lhs.icon_path)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  if (lhs.image_dominant_color < rhs.image_dominant_color)
    return true;
  if (rhs.image_dominant_color < lhs.image_dominant_color)
    return false;
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.is_noncanned_aim_suggestion < rhs.is_noncanned_aim_suggestion)
    return true;
  if (rhs.is_noncanned_aim_suggestion < lhs.is_noncanned_aim_suggestion)
    return false;
  if (lhs.is_rich_suggestion < rhs.is_rich_suggestion)
    return true;
  if (rhs.is_rich_suggestion < lhs.is_rich_suggestion)
    return false;
  if (lhs.is_search_type < rhs.is_search_type)
    return true;
  if (rhs.is_search_type < lhs.is_search_type)
    return false;
  if (lhs.is_enterprise_search_aggregator_people_type < rhs.is_enterprise_search_aggregator_people_type)
    return true;
  if (rhs.is_enterprise_search_aggregator_people_type < lhs.is_enterprise_search_aggregator_people_type)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.remove_button_a11y_label < rhs.remove_button_a11y_label)
    return true;
  if (rhs.remove_button_a11y_label < lhs.remove_button_a11y_label)
    return false;
  if (lhs.swap_contents_and_description < rhs.swap_contents_and_description)
    return true;
  if (rhs.swap_contents_and_description < lhs.swap_contents_and_description)
    return false;
  if (lhs.suggestion_group_id < rhs.suggestion_group_id)
    return true;
  if (rhs.suggestion_group_id < lhs.suggestion_group_id)
    return false;
  if (lhs.supports_deletion < rhs.supports_deletion)
    return true;
  if (rhs.supports_deletion < lhs.supports_deletion)
    return false;
  if (lhs.tail_suggest_common_prefix < rhs.tail_suggest_common_prefix)
    return true;
  if (rhs.tail_suggest_common_prefix < lhs.tail_suggest_common_prefix)
    return false;
  if (lhs.has_instant_keyword < rhs.has_instant_keyword)
    return true;
  if (rhs.has_instant_keyword < lhs.has_instant_keyword)
    return false;
  if (lhs.keyword_chip_hint < rhs.keyword_chip_hint)
    return true;
  if (rhs.keyword_chip_hint < lhs.keyword_chip_hint)
    return false;
  if (lhs.keyword_chip_a11y < rhs.keyword_chip_a11y)
    return true;
  if (rhs.keyword_chip_a11y < lhs.keyword_chip_a11y)
    return false;
  return false;
}
template <typename StructPtrType>
TabInfoPtr TabInfo::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(show_in_recent_tab_chip),
      mojo::Clone(last_active)
  );
}

template <typename T, TabInfo::EnableIfSame<T>*>
bool TabInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->show_in_recent_tab_chip, other_struct.show_in_recent_tab_chip))
    return false;
  if (!mojo::Equals(this->last_active, other_struct.last_active))
    return false;
  return true;
}

template <typename T, TabInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.show_in_recent_tab_chip < rhs.show_in_recent_tab_chip)
    return true;
  if (rhs.show_in_recent_tab_chip < lhs.show_in_recent_tab_chip)
    return false;
  if (lhs.last_active < rhs.last_active)
    return true;
  if (rhs.last_active < lhs.last_active)
    return false;
  return false;
}
template <typename StructPtrType>
FileAttachmentStubPtr FileAttachmentStub::Clone() const {
  return New(
      mojo::Clone(uuid),
      mojo::Clone(name),
      mojo::Clone(mime_type),
      mojo::Clone(image_data_url)
  );
}

template <typename T, FileAttachmentStub::EnableIfSame<T>*>
bool FileAttachmentStub::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->image_data_url, other_struct.image_data_url))
    return false;
  return true;
}

template <typename T, FileAttachmentStub::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.image_data_url < rhs.image_data_url)
    return true;
  if (rhs.image_data_url < lhs.image_data_url)
    return false;
  return false;
}
template <typename StructPtrType>
TabAttachmentStubPtr TabAttachmentStub::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(title),
      mojo::Clone(url)
  );
}

template <typename T, TabAttachmentStub::EnableIfSame<T>*>
bool TabAttachmentStub::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, TabAttachmentStub::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
SearchContextStubPtr SearchContextStub::Clone() const {
  return New(
      mojo::Clone(input),
      mojo::Clone(attachments),
      mojo::Clone(tool_mode)
  );
}

template <typename T, SearchContextStub::EnableIfSame<T>*>
bool SearchContextStub::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  if (!mojo::Equals(this->attachments, other_struct.attachments))
    return false;
  if (!mojo::Equals(this->tool_mode, other_struct.tool_mode))
    return false;
  return true;
}

template <typename T, SearchContextStub::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  if (lhs.attachments < rhs.attachments)
    return true;
  if (rhs.attachments < lhs.attachments)
    return false;
  if (lhs.tool_mode < rhs.tool_mode)
    return true;
  if (rhs.tool_mode < lhs.tool_mode)
    return false;
  return false;
}
template <typename StructPtrType>
SelectedFileInfoPtr SelectedFileInfo::Clone() const {
  return New(
      mojo::Clone(file_name),
      mojo::Clone(mime_type),
      mojo::Clone(image_data_url),
      mojo::Clone(is_deletable),
      mojo::Clone(selection_time)
  );
}

template <typename T, SelectedFileInfo::EnableIfSame<T>*>
bool SelectedFileInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_name, other_struct.file_name))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->image_data_url, other_struct.image_data_url))
    return false;
  if (!mojo::Equals(this->is_deletable, other_struct.is_deletable))
    return false;
  if (!mojo::Equals(this->selection_time, other_struct.selection_time))
    return false;
  return true;
}

template <typename T, SelectedFileInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_name < rhs.file_name)
    return true;
  if (rhs.file_name < lhs.file_name)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.image_data_url < rhs.image_data_url)
    return true;
  if (rhs.image_data_url < lhs.image_data_url)
    return false;
  if (lhs.is_deletable < rhs.is_deletable)
    return true;
  if (rhs.is_deletable < lhs.is_deletable)
    return false;
  if (lhs.selection_time < rhs.selection_time)
    return true;
  if (rhs.selection_time < lhs.selection_time)
    return false;
  return false;
}
template <typename StructPtrType>
SuggestionGroupPtr SuggestionGroup::Clone() const {
  return New(
      mojo::Clone(header),
      mojo::Clone(render_type),
      mojo::Clone(side_type)
  );
}

template <typename T, SuggestionGroup::EnableIfSame<T>*>
bool SuggestionGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->header, other_struct.header))
    return false;
  if (!mojo::Equals(this->render_type, other_struct.render_type))
    return false;
  if (!mojo::Equals(this->side_type, other_struct.side_type))
    return false;
  return true;
}

template <typename T, SuggestionGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.header < rhs.header)
    return true;
  if (rhs.header < lhs.header)
    return false;
  if (lhs.render_type < rhs.render_type)
    return true;
  if (rhs.render_type < lhs.render_type)
    return false;
  if (lhs.side_type < rhs.side_type)
    return true;
  if (rhs.side_type < lhs.side_type)
    return false;
  return false;
}
template <typename StructPtrType>
AutocompleteResultPtr AutocompleteResult::Clone() const {
  return New(
      mojo::Clone(input),
      mojo::Clone(suggestion_groups_map),
      mojo::Clone(matches),
      mojo::Clone(smart_compose_inline_hint)
  );
}

template <typename T, AutocompleteResult::EnableIfSame<T>*>
bool AutocompleteResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  if (!mojo::Equals(this->suggestion_groups_map, other_struct.suggestion_groups_map))
    return false;
  if (!mojo::Equals(this->matches, other_struct.matches))
    return false;
  if (!mojo::Equals(this->smart_compose_inline_hint, other_struct.smart_compose_inline_hint))
    return false;
  return true;
}

template <typename T, AutocompleteResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  if (lhs.suggestion_groups_map < rhs.suggestion_groups_map)
    return true;
  if (rhs.suggestion_groups_map < lhs.suggestion_groups_map)
    return false;
  if (lhs.matches < rhs.matches)
    return true;
  if (rhs.matches < lhs.matches)
    return false;
  if (lhs.smart_compose_inline_hint < rhs.smart_compose_inline_hint)
    return true;
  if (rhs.smart_compose_inline_hint < lhs.smart_compose_inline_hint)
    return false;
  return false;
}
template <typename StructPtrType>
OmniboxPopupSelectionPtr OmniboxPopupSelection::Clone() const {
  return New(
      mojo::Clone(line),
      mojo::Clone(state),
      mojo::Clone(action_index)
  );
}

template <typename T, OmniboxPopupSelection::EnableIfSame<T>*>
bool OmniboxPopupSelection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->action_index, other_struct.action_index))
    return false;
  return true;
}

template <typename T, OmniboxPopupSelection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.action_index < rhs.action_index)
    return true;
  if (rhs.action_index < lhs.action_index)
    return false;
  return false;
}
template <typename StructPtrType>
PlaceholderConfigPtr PlaceholderConfig::Clone() const {
  return New(
      mojo::Clone(texts),
      mojo::Clone(change_text_animation_interval),
      mojo::Clone(fade_text_animation_duration)
  );
}

template <typename T, PlaceholderConfig::EnableIfSame<T>*>
bool PlaceholderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->texts, other_struct.texts))
    return false;
  if (!mojo::Equals(this->change_text_animation_interval, other_struct.change_text_animation_interval))
    return false;
  if (!mojo::Equals(this->fade_text_animation_duration, other_struct.fade_text_animation_duration))
    return false;
  return true;
}

template <typename T, PlaceholderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.texts < rhs.texts)
    return true;
  if (rhs.texts < lhs.texts)
    return false;
  if (lhs.change_text_animation_interval < rhs.change_text_animation_interval)
    return true;
  if (rhs.change_text_animation_interval < lhs.change_text_animation_interval)
    return false;
  if (lhs.fade_text_animation_duration < rhs.fade_text_animation_duration)
    return true;
  if (rhs.fade_text_animation_duration < lhs.fade_text_animation_duration)
    return false;
  return false;
}


}  // searchbox::mojom

namespace mojo {


template <>
struct  StructTraits<::searchbox::mojom::ACMatchClassification::DataView,
                                         ::searchbox::mojom::ACMatchClassificationPtr> {
  static bool IsNull(const ::searchbox::mojom::ACMatchClassificationPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::ACMatchClassificationPtr* output) { output->reset(); }

  static decltype(::searchbox::mojom::ACMatchClassification::offset) offset(
      const ::searchbox::mojom::ACMatchClassificationPtr& input) {
    return input->offset;
  }

  static decltype(::searchbox::mojom::ACMatchClassification::style) style(
      const ::searchbox::mojom::ACMatchClassificationPtr& input) {
    return input->style;
  }

  static bool Read(::searchbox::mojom::ACMatchClassification::DataView input, ::searchbox::mojom::ACMatchClassificationPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::Action::DataView,
                                         ::searchbox::mojom::ActionPtr> {
  static bool IsNull(const ::searchbox::mojom::ActionPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::ActionPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::Action::hint)& hint(
      const ::searchbox::mojom::ActionPtr& input) {
    return input->hint;
  }

  static const decltype(::searchbox::mojom::Action::suggestion_contents)& suggestion_contents(
      const ::searchbox::mojom::ActionPtr& input) {
    return input->suggestion_contents;
  }

  static const decltype(::searchbox::mojom::Action::icon_path)& icon_path(
      const ::searchbox::mojom::ActionPtr& input) {
    return input->icon_path;
  }

  static const decltype(::searchbox::mojom::Action::a11y_label)& a11y_label(
      const ::searchbox::mojom::ActionPtr& input) {
    return input->a11y_label;
  }

  static bool Read(::searchbox::mojom::Action::DataView input, ::searchbox::mojom::ActionPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::SuggestionAnswer::DataView,
                                         ::searchbox::mojom::SuggestionAnswerPtr> {
  static bool IsNull(const ::searchbox::mojom::SuggestionAnswerPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::SuggestionAnswerPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::SuggestionAnswer::first_line)& first_line(
      const ::searchbox::mojom::SuggestionAnswerPtr& input) {
    return input->first_line;
  }

  static const decltype(::searchbox::mojom::SuggestionAnswer::second_line)& second_line(
      const ::searchbox::mojom::SuggestionAnswerPtr& input) {
    return input->second_line;
  }

  static bool Read(::searchbox::mojom::SuggestionAnswer::DataView input, ::searchbox::mojom::SuggestionAnswerPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::AutocompleteMatch::DataView,
                                         ::searchbox::mojom::AutocompleteMatchPtr> {
  static bool IsNull(const ::searchbox::mojom::AutocompleteMatchPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::AutocompleteMatchPtr* output) { output->reset(); }

  static decltype(::searchbox::mojom::AutocompleteMatch::is_hidden) is_hidden(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->is_hidden;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::a11y_label)& a11y_label(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->a11y_label;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::allowed_to_be_default_match) allowed_to_be_default_match(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->allowed_to_be_default_match;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::actions)& actions(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->actions;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::answer)& answer(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->answer;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::contents)& contents(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->contents;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::contents_class)& contents_class(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->contents_class;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::description)& description(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->description;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::description_class)& description_class(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->description_class;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::destination_url)& destination_url(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->destination_url;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::inline_autocompletion)& inline_autocompletion(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->inline_autocompletion;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::fill_into_edit)& fill_into_edit(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->fill_into_edit;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::is_weather_answer_suggestion) is_weather_answer_suggestion(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->is_weather_answer_suggestion;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::icon_path)& icon_path(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->icon_path;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::icon_url)& icon_url(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->icon_url;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::image_dominant_color)& image_dominant_color(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->image_dominant_color;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::image_url)& image_url(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->image_url;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::is_noncanned_aim_suggestion) is_noncanned_aim_suggestion(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->is_noncanned_aim_suggestion;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::is_rich_suggestion) is_rich_suggestion(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->is_rich_suggestion;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::is_search_type) is_search_type(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->is_search_type;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::is_enterprise_search_aggregator_people_type) is_enterprise_search_aggregator_people_type(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->is_enterprise_search_aggregator_people_type;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::type)& type(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->type;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::remove_button_a11y_label)& remove_button_a11y_label(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->remove_button_a11y_label;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::swap_contents_and_description) swap_contents_and_description(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->swap_contents_and_description;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::suggestion_group_id) suggestion_group_id(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->suggestion_group_id;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::supports_deletion) supports_deletion(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->supports_deletion;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::tail_suggest_common_prefix)& tail_suggest_common_prefix(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->tail_suggest_common_prefix;
  }

  static decltype(::searchbox::mojom::AutocompleteMatch::has_instant_keyword) has_instant_keyword(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->has_instant_keyword;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::keyword_chip_hint)& keyword_chip_hint(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->keyword_chip_hint;
  }

  static const decltype(::searchbox::mojom::AutocompleteMatch::keyword_chip_a11y)& keyword_chip_a11y(
      const ::searchbox::mojom::AutocompleteMatchPtr& input) {
    return input->keyword_chip_a11y;
  }

  static bool Read(::searchbox::mojom::AutocompleteMatch::DataView input, ::searchbox::mojom::AutocompleteMatchPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::TabInfo::DataView,
                                         ::searchbox::mojom::TabInfoPtr> {
  static bool IsNull(const ::searchbox::mojom::TabInfoPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::TabInfoPtr* output) { output->reset(); }

  static decltype(::searchbox::mojom::TabInfo::tab_id) tab_id(
      const ::searchbox::mojom::TabInfoPtr& input) {
    return input->tab_id;
  }

  static const decltype(::searchbox::mojom::TabInfo::title)& title(
      const ::searchbox::mojom::TabInfoPtr& input) {
    return input->title;
  }

  static const decltype(::searchbox::mojom::TabInfo::url)& url(
      const ::searchbox::mojom::TabInfoPtr& input) {
    return input->url;
  }

  static decltype(::searchbox::mojom::TabInfo::show_in_recent_tab_chip) show_in_recent_tab_chip(
      const ::searchbox::mojom::TabInfoPtr& input) {
    return input->show_in_recent_tab_chip;
  }

  static const decltype(::searchbox::mojom::TabInfo::last_active)& last_active(
      const ::searchbox::mojom::TabInfoPtr& input) {
    return input->last_active;
  }

  static bool Read(::searchbox::mojom::TabInfo::DataView input, ::searchbox::mojom::TabInfoPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::FileAttachmentStub::DataView,
                                         ::searchbox::mojom::FileAttachmentStubPtr> {
  static bool IsNull(const ::searchbox::mojom::FileAttachmentStubPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::FileAttachmentStubPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::FileAttachmentStub::uuid)& uuid(
      const ::searchbox::mojom::FileAttachmentStubPtr& input) {
    return input->uuid;
  }

  static const decltype(::searchbox::mojom::FileAttachmentStub::name)& name(
      const ::searchbox::mojom::FileAttachmentStubPtr& input) {
    return input->name;
  }

  static const decltype(::searchbox::mojom::FileAttachmentStub::mime_type)& mime_type(
      const ::searchbox::mojom::FileAttachmentStubPtr& input) {
    return input->mime_type;
  }

  static const decltype(::searchbox::mojom::FileAttachmentStub::image_data_url)& image_data_url(
      const ::searchbox::mojom::FileAttachmentStubPtr& input) {
    return input->image_data_url;
  }

  static bool Read(::searchbox::mojom::FileAttachmentStub::DataView input, ::searchbox::mojom::FileAttachmentStubPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::TabAttachmentStub::DataView,
                                         ::searchbox::mojom::TabAttachmentStubPtr> {
  static bool IsNull(const ::searchbox::mojom::TabAttachmentStubPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::TabAttachmentStubPtr* output) { output->reset(); }

  static decltype(::searchbox::mojom::TabAttachmentStub::tab_id) tab_id(
      const ::searchbox::mojom::TabAttachmentStubPtr& input) {
    return input->tab_id;
  }

  static const decltype(::searchbox::mojom::TabAttachmentStub::title)& title(
      const ::searchbox::mojom::TabAttachmentStubPtr& input) {
    return input->title;
  }

  static const decltype(::searchbox::mojom::TabAttachmentStub::url)& url(
      const ::searchbox::mojom::TabAttachmentStubPtr& input) {
    return input->url;
  }

  static bool Read(::searchbox::mojom::TabAttachmentStub::DataView input, ::searchbox::mojom::TabAttachmentStubPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::SearchContextStub::DataView,
                                         ::searchbox::mojom::SearchContextStubPtr> {
  static bool IsNull(const ::searchbox::mojom::SearchContextStubPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::SearchContextStubPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::SearchContextStub::input)& input(
      const ::searchbox::mojom::SearchContextStubPtr& input) {
    return input->input;
  }

  static const decltype(::searchbox::mojom::SearchContextStub::attachments)& attachments(
      const ::searchbox::mojom::SearchContextStubPtr& input) {
    return input->attachments;
  }

  static decltype(::searchbox::mojom::SearchContextStub::tool_mode) tool_mode(
      const ::searchbox::mojom::SearchContextStubPtr& input) {
    return input->tool_mode;
  }

  static bool Read(::searchbox::mojom::SearchContextStub::DataView input, ::searchbox::mojom::SearchContextStubPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::SelectedFileInfo::DataView,
                                         ::searchbox::mojom::SelectedFileInfoPtr> {
  static bool IsNull(const ::searchbox::mojom::SelectedFileInfoPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::SelectedFileInfoPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::SelectedFileInfo::file_name)& file_name(
      const ::searchbox::mojom::SelectedFileInfoPtr& input) {
    return input->file_name;
  }

  static const decltype(::searchbox::mojom::SelectedFileInfo::mime_type)& mime_type(
      const ::searchbox::mojom::SelectedFileInfoPtr& input) {
    return input->mime_type;
  }

  static const decltype(::searchbox::mojom::SelectedFileInfo::image_data_url)& image_data_url(
      const ::searchbox::mojom::SelectedFileInfoPtr& input) {
    return input->image_data_url;
  }

  static decltype(::searchbox::mojom::SelectedFileInfo::is_deletable) is_deletable(
      const ::searchbox::mojom::SelectedFileInfoPtr& input) {
    return input->is_deletable;
  }

  static const decltype(::searchbox::mojom::SelectedFileInfo::selection_time)& selection_time(
      const ::searchbox::mojom::SelectedFileInfoPtr& input) {
    return input->selection_time;
  }

  static bool Read(::searchbox::mojom::SelectedFileInfo::DataView input, ::searchbox::mojom::SelectedFileInfoPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::SuggestionGroup::DataView,
                                         ::searchbox::mojom::SuggestionGroupPtr> {
  static bool IsNull(const ::searchbox::mojom::SuggestionGroupPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::SuggestionGroupPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::SuggestionGroup::header)& header(
      const ::searchbox::mojom::SuggestionGroupPtr& input) {
    return input->header;
  }

  static decltype(::searchbox::mojom::SuggestionGroup::render_type) render_type(
      const ::searchbox::mojom::SuggestionGroupPtr& input) {
    return input->render_type;
  }

  static decltype(::searchbox::mojom::SuggestionGroup::side_type) side_type(
      const ::searchbox::mojom::SuggestionGroupPtr& input) {
    return input->side_type;
  }

  static bool Read(::searchbox::mojom::SuggestionGroup::DataView input, ::searchbox::mojom::SuggestionGroupPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::AutocompleteResult::DataView,
                                         ::searchbox::mojom::AutocompleteResultPtr> {
  static bool IsNull(const ::searchbox::mojom::AutocompleteResultPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::AutocompleteResultPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::AutocompleteResult::input)& input(
      const ::searchbox::mojom::AutocompleteResultPtr& input) {
    return input->input;
  }

  static const decltype(::searchbox::mojom::AutocompleteResult::suggestion_groups_map)& suggestion_groups_map(
      const ::searchbox::mojom::AutocompleteResultPtr& input) {
    return input->suggestion_groups_map;
  }

  static const decltype(::searchbox::mojom::AutocompleteResult::matches)& matches(
      const ::searchbox::mojom::AutocompleteResultPtr& input) {
    return input->matches;
  }

  static const decltype(::searchbox::mojom::AutocompleteResult::smart_compose_inline_hint)& smart_compose_inline_hint(
      const ::searchbox::mojom::AutocompleteResultPtr& input) {
    return input->smart_compose_inline_hint;
  }

  static bool Read(::searchbox::mojom::AutocompleteResult::DataView input, ::searchbox::mojom::AutocompleteResultPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::OmniboxPopupSelection::DataView,
                                         ::searchbox::mojom::OmniboxPopupSelectionPtr> {
  static bool IsNull(const ::searchbox::mojom::OmniboxPopupSelectionPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::OmniboxPopupSelectionPtr* output) { output->reset(); }

  static decltype(::searchbox::mojom::OmniboxPopupSelection::line) line(
      const ::searchbox::mojom::OmniboxPopupSelectionPtr& input) {
    return input->line;
  }

  static decltype(::searchbox::mojom::OmniboxPopupSelection::state) state(
      const ::searchbox::mojom::OmniboxPopupSelectionPtr& input) {
    return input->state;
  }

  static decltype(::searchbox::mojom::OmniboxPopupSelection::action_index) action_index(
      const ::searchbox::mojom::OmniboxPopupSelectionPtr& input) {
    return input->action_index;
  }

  static bool Read(::searchbox::mojom::OmniboxPopupSelection::DataView input, ::searchbox::mojom::OmniboxPopupSelectionPtr* output);
};


template <>
struct  StructTraits<::searchbox::mojom::PlaceholderConfig::DataView,
                                         ::searchbox::mojom::PlaceholderConfigPtr> {
  static bool IsNull(const ::searchbox::mojom::PlaceholderConfigPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::PlaceholderConfigPtr* output) { output->reset(); }

  static const decltype(::searchbox::mojom::PlaceholderConfig::texts)& texts(
      const ::searchbox::mojom::PlaceholderConfigPtr& input) {
    return input->texts;
  }

  static const decltype(::searchbox::mojom::PlaceholderConfig::change_text_animation_interval)& change_text_animation_interval(
      const ::searchbox::mojom::PlaceholderConfigPtr& input) {
    return input->change_text_animation_interval;
  }

  static const decltype(::searchbox::mojom::PlaceholderConfig::fade_text_animation_duration)& fade_text_animation_duration(
      const ::searchbox::mojom::PlaceholderConfigPtr& input) {
    return input->fade_text_animation_duration;
  }

  static bool Read(::searchbox::mojom::PlaceholderConfig::DataView input, ::searchbox::mojom::PlaceholderConfigPtr* output);
};


template <>
struct  UnionTraits<::searchbox::mojom::SearchContextAttachmentStub::DataView,
                                        ::searchbox::mojom::SearchContextAttachmentStubPtr> {
  static bool IsNull(const ::searchbox::mojom::SearchContextAttachmentStubPtr& input) { return !input; }
  static void SetToNull(::searchbox::mojom::SearchContextAttachmentStubPtr* output) { output->reset(); }

  static ::searchbox::mojom::SearchContextAttachmentStub::Tag GetTag(const ::searchbox::mojom::SearchContextAttachmentStubPtr& input) {
    return input->which();
  }

  static const ::searchbox::mojom::FileAttachmentStubPtr& file_attachment(const ::searchbox::mojom::SearchContextAttachmentStubPtr& input) {
    return input->get_file_attachment();
  }

  static const ::searchbox::mojom::TabAttachmentStubPtr& tab_attachment(const ::searchbox::mojom::SearchContextAttachmentStubPtr& input) {
    return input->get_tab_attachment();
  }

  static bool Read(::searchbox::mojom::SearchContextAttachmentStub::DataView input, ::searchbox::mojom::SearchContextAttachmentStubPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_H_