// components/mirroring/mojom/session_parameters.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SHARED_H_
#define COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/mirroring/mojom/session_parameters.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "components/mirroring/mojom/session_parameters.mojom-data-view.h"




namespace std {

template <>
struct hash<::mirroring::mojom::SessionType>
    : public mojo::internal::EnumHashImpl<::mirroring::mojom::SessionType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mirroring::mojom::SessionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::mirroring::mojom::SessionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::mirroring::mojom::SessionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mirroring::mojom::SessionParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mirroring::mojom::SessionParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mirroring::mojom::internal::SessionParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::mirroring::mojom::SessionType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::receiver_address(input)) in_receiver_address = Traits::receiver_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->receiver_address)::BaseType> receiver_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_receiver_address,
      receiver_address_fragment);

    fragment->receiver_address.Set(
        receiver_address_fragment.is_null() ? nullptr : receiver_address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->receiver_address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver_address in SessionParameters struct");

    decltype(Traits::receiver_friendly_name(input)) in_receiver_friendly_name = Traits::receiver_friendly_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->receiver_friendly_name)::BaseType> receiver_friendly_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_receiver_friendly_name,
      receiver_friendly_name_fragment);

    fragment->receiver_friendly_name.Set(
        receiver_friendly_name_fragment.is_null() ? nullptr : receiver_friendly_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->receiver_friendly_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver_friendly_name in SessionParameters struct");

    decltype(Traits::source_id(input)) in_source_id = Traits::source_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_id)::BaseType> source_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_source_id,
      source_id_fragment);

    fragment->source_id.Set(
        source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_id in SessionParameters struct");

    decltype(Traits::destination_id(input)) in_destination_id = Traits::destination_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->destination_id)::BaseType> destination_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_destination_id,
      destination_id_fragment);

    fragment->destination_id.Set(
        destination_id_fragment.is_null() ? nullptr : destination_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->destination_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null destination_id in SessionParameters struct");

    decltype(Traits::target_playout_delay(input)) in_target_playout_delay = Traits::target_playout_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_playout_delay)::BaseType> target_playout_delay_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_target_playout_delay,
      target_playout_delay_fragment);

    fragment->target_playout_delay.Set(
        target_playout_delay_fragment.is_null() ? nullptr : target_playout_delay_fragment.data());

    fragment->is_remote_playback = Traits::is_remote_playback(input);

    fragment->force_letterboxing = Traits::force_letterboxing(input);

    fragment->enable_rtcp_reporting = Traits::enable_rtcp_reporting(input);
  }

  static bool Deserialize(::mirroring::mojom::internal::SessionParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mirroring::mojom::SessionParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mirroring::mojom {

inline void SessionParametersDataView::GetReceiverAddressDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->receiver_address.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}
inline void SessionParametersDataView::GetReceiverFriendlyNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->receiver_friendly_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SessionParametersDataView::GetSourceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SessionParametersDataView::GetDestinationIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->destination_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SessionParametersDataView::GetTargetPlayoutDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->target_playout_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // mirroring::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::mirroring::mojom::SessionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::mirroring::mojom::SessionType value);
};

} // namespace perfetto

#endif  // COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SHARED_H_