// components/mirroring/mojom/session_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_SESSION_OBSERVER_MOJOM_H_
#define COMPONENTS_MIRRORING_MOJOM_SESSION_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/mirroring/mojom/session_observer.mojom-features.h"  // IWYU pragma: export
#include "components/mirroring/mojom/session_observer.mojom-shared.h"  // IWYU pragma: export
#include "components/mirroring/mojom/session_observer.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mirroring::mojom {

class SessionObserverProxy;

template <typename ImplRefTraits>
class SessionObserverStub;

class SessionObserverRequestValidator;


class SessionObserver
    : public SessionObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mirroring.mojom.SessionObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SessionObserverInterfaceBase;
  using Proxy_ = SessionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionObserverStub<ImplRefTraits>;

  using RequestValidator_ = SessionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnErrorMinVersion = 0,
    kDidStartMinVersion = 0,
    kDidStopMinVersion = 0,
    kLogInfoMessageMinVersion = 0,
    kLogErrorMessageMinVersion = 0,
    kOnSourceChangedMinVersion = 0,
    kOnRemotingStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogInfoMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogErrorMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSourceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRemotingStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SessionObserver() = default;

  virtual void OnError(SessionError error) = 0;

  virtual void DidStart() = 0;

  virtual void DidStop() = 0;

  virtual void LogInfoMessage(const std::string& message) = 0;

  virtual void LogErrorMessage(const std::string& message) = 0;

  virtual void OnSourceChanged() = 0;

  virtual void OnRemotingStateChanged(bool is_remoting) = 0;
};



class  SessionObserverProxy
    : public SessionObserver {
 public:
  using InterfaceType = SessionObserver;

  explicit SessionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnError(SessionError error) final;
  
  void DidStart() final;
  
  void DidStop() final;
  
  void LogInfoMessage(const std::string& message) final;
  
  void LogErrorMessage(const std::string& message) final;
  
  void OnSourceChanged() final;
  
  void OnRemotingStateChanged(bool is_remoting) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SessionObserverStubDispatch {
 public:
  static bool Accept(SessionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SessionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SessionObserver>>
class SessionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionObserverStub() = default;
  ~SessionObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SessionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // mirroring::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_MIRRORING_MOJOM_SESSION_OBSERVER_MOJOM_H_