// components/mirroring/mojom/cast_message_channel.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_H_
#define COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/mirroring/mojom/cast_message_channel.mojom-features.h"  // IWYU pragma: export
#include "components/mirroring/mojom/cast_message_channel.mojom-shared.h"  // IWYU pragma: export
#include "components/mirroring/mojom/cast_message_channel.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mirroring::mojom {

class CastMessageChannelProxy;

template <typename ImplRefTraits>
class CastMessageChannelStub;

class CastMessageChannelRequestValidator;


class CastMessageChannel
    : public CastMessageChannelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mirroring.mojom.CastMessageChannel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CastMessageChannelInterfaceBase;
  using Proxy_ = CastMessageChannelProxy;

  template <typename ImplRefTraits>
  using Stub_ = CastMessageChannelStub<ImplRefTraits>;

  using RequestValidator_ = CastMessageChannelRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnMessageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CastMessageChannel() = default;

  virtual void OnMessage(CastMessagePtr message) = 0;
};



class  CastMessageChannelProxy
    : public CastMessageChannel {
 public:
  using InterfaceType = CastMessageChannel;

  explicit CastMessageChannelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMessage(CastMessagePtr message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CastMessageChannelStubDispatch {
 public:
  static bool Accept(CastMessageChannel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CastMessageChannel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CastMessageChannel>>
class CastMessageChannelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CastMessageChannelStub() = default;
  ~CastMessageChannelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CastMessageChannelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CastMessageChannelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CastMessageChannelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  CastMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CastMessage, T>::value>;
  using DataView = CastMessageDataView;
  using Data_ = internal::CastMessage_Data;

  template <typename... Args>
  static CastMessagePtr New(Args&&... args) {
    return CastMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CastMessagePtr From(const U& u) {
    return mojo::TypeConverter<CastMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CastMessage>::Convert(*this);
  }


  CastMessage();

  CastMessage(
      const std::string& message_namespace,
      const std::string& json_format_data);


  ~CastMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CastMessagePtr>
  CastMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastMessage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastMessage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CastMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CastMessage_UnserializedMessageContext<
            UserType, CastMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CastMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CastMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CastMessage_UnserializedMessageContext<
            UserType, CastMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CastMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string message_namespace;
  
  std::string json_format_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CastMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
CastMessagePtr CastMessage::Clone() const {
  return New(
      mojo::Clone(message_namespace),
      mojo::Clone(json_format_data)
  );
}

template <typename T, CastMessage::EnableIfSame<T>*>
bool CastMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message_namespace, other_struct.message_namespace))
    return false;
  if (!mojo::Equals(this->json_format_data, other_struct.json_format_data))
    return false;
  return true;
}

template <typename T, CastMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.message_namespace < rhs.message_namespace)
    return true;
  if (rhs.message_namespace < lhs.message_namespace)
    return false;
  if (lhs.json_format_data < rhs.json_format_data)
    return true;
  if (rhs.json_format_data < lhs.json_format_data)
    return false;
  return false;
}


}  // mirroring::mojom

namespace mojo {


template <>
struct  StructTraits<::mirroring::mojom::CastMessage::DataView,
                                         ::mirroring::mojom::CastMessagePtr> {
  static bool IsNull(const ::mirroring::mojom::CastMessagePtr& input) { return !input; }
  static void SetToNull(::mirroring::mojom::CastMessagePtr* output) { output->reset(); }

  static const decltype(::mirroring::mojom::CastMessage::message_namespace)& message_namespace(
      const ::mirroring::mojom::CastMessagePtr& input) {
    return input->message_namespace;
  }

  static const decltype(::mirroring::mojom::CastMessage::json_format_data)& json_format_data(
      const ::mirroring::mojom::CastMessagePtr& input) {
    return input->json_format_data;
  }

  static bool Read(::mirroring::mojom::CastMessage::DataView input, ::mirroring::mojom::CastMessagePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_H_