// components/metrics/dwa/mojom/dwa_interface.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/metrics/dwa/mojom/dwa_interface.mojom-shared-internal.h"


namespace metrics::dwa::mojom {
class DwaEntryDataView;



}  // metrics::dwa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::metrics::dwa::mojom::DwaEntryDataView> {
  using Data = ::metrics::dwa::mojom::internal::DwaEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace metrics::dwa::mojom {
// Interface base classes. They are used for type safety check.
class DwaRecorderClientInterfaceInterfaceBase {};

using DwaRecorderClientInterfacePtrDataView =
    mojo::InterfacePtrDataView<DwaRecorderClientInterfaceInterfaceBase>;
using DwaRecorderClientInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<DwaRecorderClientInterfaceInterfaceBase>;
using DwaRecorderClientInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DwaRecorderClientInterfaceInterfaceBase>;
using DwaRecorderClientInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DwaRecorderClientInterfaceInterfaceBase>;
class DwaRecorderInterfaceInterfaceBase {};

using DwaRecorderInterfacePtrDataView =
    mojo::InterfacePtrDataView<DwaRecorderInterfaceInterfaceBase>;
using DwaRecorderInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<DwaRecorderInterfaceInterfaceBase>;
using DwaRecorderInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DwaRecorderInterfaceInterfaceBase>;
using DwaRecorderInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DwaRecorderInterfaceInterfaceBase>;
class DwaRecorderFactoryInterfaceBase {};

using DwaRecorderFactoryPtrDataView =
    mojo::InterfacePtrDataView<DwaRecorderFactoryInterfaceBase>;
using DwaRecorderFactoryRequestDataView =
    mojo::InterfaceRequestDataView<DwaRecorderFactoryInterfaceBase>;
using DwaRecorderFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DwaRecorderFactoryInterfaceBase>;
using DwaRecorderFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DwaRecorderFactoryInterfaceBase>;


class DwaEntryDataView {
 public:
  DwaEntryDataView() = default;

  DwaEntryDataView(
      internal::DwaEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t event_hash() const {
    return data_->event_hash;
  }
  uint64_t content_hash() const {
    return data_->content_hash;
  }
  inline void GetStudiesOfInterestDataView(
      mojo::MapDataView<mojo::StringDataView, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStudiesOfInterest(UserType* output) {
    
    auto* pointer = data_->studies_of_interest.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, bool>>(
        pointer, output, message_);
  }
  inline void GetMetricsDataView(
      mojo::MapDataView<uint64_t, int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetrics(UserType* output) {
    
    auto* pointer = data_->metrics.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, int64_t>>(
        pointer, output, message_);
  }
 private:
  internal::DwaEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // metrics::dwa::mojom

#endif  // COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_DATA_VIEW_H_