// components/history_clusters/public/mojom/history_cluster_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/history_clusters/public/mojom/history_cluster_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-params-data.h"
#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared-message-ids.h"

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-import-headers.h"
#include "components/history_clusters/public/mojom/history_cluster_types.mojom-test-utils.h"


namespace history_clusters::mojom {
MatchPosition::MatchPosition()
    : begin(),
      end() {}

MatchPosition::MatchPosition(
    uint32_t begin_in,
    uint32_t end_in)
    : begin(std::move(begin_in)),
      end(std::move(end_in)) {}

MatchPosition::~MatchPosition() = default;
size_t MatchPosition::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->begin);
  seed = mojo::internal::Hash(seed, this->end);
  return seed;
}

void MatchPosition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin"), this->begin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end"), this->end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MatchPosition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchQuery::SearchQuery()
    : query(),
      url() {}

SearchQuery::SearchQuery(
    const std::string& query_in,
    const ::GURL& url_in)
    : query(std::move(query_in)),
      url(std::move(url_in)) {}

SearchQuery::~SearchQuery() = default;

void SearchQuery::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchQuery::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawVisitData::RawVisitData()
    : url(),
      visit_time() {}

RawVisitData::RawVisitData(
    const ::GURL& url_in,
    ::base::Time visit_time_in)
    : url(std::move(url_in)),
      visit_time(std::move(visit_time_in)) {}

RawVisitData::~RawVisitData() = default;

void RawVisitData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_time"), this->visit_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RawVisitData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLVisit::URLVisit()
    : visit_id(),
      normalized_url(),
      url_for_display(),
      page_title(),
      title_match_positions(),
      url_for_display_match_positions(),
      raw_visit_data(),
      duplicates(),
      relative_date(),
      annotations(),
      is_known_to_sync(),
      debug_info(),
      has_url_keyed_image() {}

URLVisit::URLVisit(
    int64_t visit_id_in,
    const ::GURL& normalized_url_in,
    const std::string& url_for_display_in,
    const std::string& page_title_in,
    std::vector<MatchPositionPtr> title_match_positions_in,
    std::vector<MatchPositionPtr> url_for_display_match_positions_in,
    RawVisitDataPtr raw_visit_data_in,
    std::vector<RawVisitDataPtr> duplicates_in,
    const std::string& relative_date_in,
    std::vector<Annotation> annotations_in,
    bool is_known_to_sync_in,
    const base::flat_map<std::string, std::string>& debug_info_in,
    bool has_url_keyed_image_in)
    : visit_id(std::move(visit_id_in)),
      normalized_url(std::move(normalized_url_in)),
      url_for_display(std::move(url_for_display_in)),
      page_title(std::move(page_title_in)),
      title_match_positions(std::move(title_match_positions_in)),
      url_for_display_match_positions(std::move(url_for_display_match_positions_in)),
      raw_visit_data(std::move(raw_visit_data_in)),
      duplicates(std::move(duplicates_in)),
      relative_date(std::move(relative_date_in)),
      annotations(std::move(annotations_in)),
      is_known_to_sync(std::move(is_known_to_sync_in)),
      debug_info(std::move(debug_info_in)),
      has_url_keyed_image(std::move(has_url_keyed_image_in)) {}

URLVisit::~URLVisit() = default;

void URLVisit::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_id"), this->visit_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "normalized_url"), this->normalized_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_for_display"), this->url_for_display,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_title"), this->page_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title_match_positions"), this->title_match_positions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MatchPositionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_for_display_match_positions"), this->url_for_display_match_positions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MatchPositionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_visit_data"), this->raw_visit_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RawVisitDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplicates"), this->duplicates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<RawVisitDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_date"), this->relative_date,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "annotations"), this->annotations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<Annotation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_known_to_sync"), this->is_known_to_sync,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_info"), this->debug_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_url_keyed_image"), this->has_url_keyed_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLVisit::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Cluster::Cluster()
    : id(),
      visits(),
      label(),
      tab_group_name(),
      label_match_positions(),
      related_searches(),
      image_url(),
      from_persistence(),
      debug_info() {}

Cluster::Cluster(
    int64_t id_in,
    std::vector<URLVisitPtr> visits_in,
    const std::string& label_in,
    const std::optional<std::string>& tab_group_name_in,
    std::vector<MatchPositionPtr> label_match_positions_in,
    std::vector<SearchQueryPtr> related_searches_in,
    const std::optional<::GURL>& image_url_in,
    bool from_persistence_in,
    const std::optional<std::string>& debug_info_in)
    : id(std::move(id_in)),
      visits(std::move(visits_in)),
      label(std::move(label_in)),
      tab_group_name(std::move(tab_group_name_in)),
      label_match_positions(std::move(label_match_positions_in)),
      related_searches(std::move(related_searches_in)),
      image_url(std::move(image_url_in)),
      from_persistence(std::move(from_persistence_in)),
      debug_info(std::move(debug_info_in)) {}

Cluster::~Cluster() = default;

void Cluster::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visits"), this->visits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<URLVisitPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_group_name"), this->tab_group_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label_match_positions"), this->label_match_positions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MatchPositionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "related_searches"), this->related_searches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SearchQueryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from_persistence"), this->from_persistence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_info"), this->debug_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Cluster::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // history_clusters::mojom


namespace mojo {


// static
bool StructTraits<::history_clusters::mojom::MatchPosition::DataView, ::history_clusters::mojom::MatchPositionPtr>::Read(
    ::history_clusters::mojom::MatchPosition::DataView input,
    ::history_clusters::mojom::MatchPositionPtr* output) {
  bool success = true;
  ::history_clusters::mojom::MatchPositionPtr result(::history_clusters::mojom::MatchPosition::New());
  
      if (success)
        result->begin = input.begin();
      if (success)
        result->end = input.end();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_clusters::mojom::SearchQuery::DataView, ::history_clusters::mojom::SearchQueryPtr>::Read(
    ::history_clusters::mojom::SearchQuery::DataView input,
    ::history_clusters::mojom::SearchQueryPtr* output) {
  bool success = true;
  ::history_clusters::mojom::SearchQueryPtr result(::history_clusters::mojom::SearchQuery::New());
  
      if (success && !input.ReadQuery(&result->query))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_clusters::mojom::RawVisitData::DataView, ::history_clusters::mojom::RawVisitDataPtr>::Read(
    ::history_clusters::mojom::RawVisitData::DataView input,
    ::history_clusters::mojom::RawVisitDataPtr* output) {
  bool success = true;
  ::history_clusters::mojom::RawVisitDataPtr result(::history_clusters::mojom::RawVisitData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadVisitTime(&result->visit_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_clusters::mojom::URLVisit::DataView, ::history_clusters::mojom::URLVisitPtr>::Read(
    ::history_clusters::mojom::URLVisit::DataView input,
    ::history_clusters::mojom::URLVisitPtr* output) {
  bool success = true;
  ::history_clusters::mojom::URLVisitPtr result(::history_clusters::mojom::URLVisit::New());
  
      if (success)
        result->visit_id = input.visit_id();
      if (success && !input.ReadNormalizedUrl(&result->normalized_url))
        success = false;
      if (success && !input.ReadUrlForDisplay(&result->url_for_display))
        success = false;
      if (success && !input.ReadPageTitle(&result->page_title))
        success = false;
      if (success && !input.ReadTitleMatchPositions(&result->title_match_positions))
        success = false;
      if (success && !input.ReadUrlForDisplayMatchPositions(&result->url_for_display_match_positions))
        success = false;
      if (success && !input.ReadRawVisitData(&result->raw_visit_data))
        success = false;
      if (success && !input.ReadDuplicates(&result->duplicates))
        success = false;
      if (success && !input.ReadRelativeDate(&result->relative_date))
        success = false;
      if (success && !input.ReadAnnotations(&result->annotations))
        success = false;
      if (success)
        result->is_known_to_sync = input.is_known_to_sync();
      if (success && !input.ReadDebugInfo(&result->debug_info))
        success = false;
      if (success)
        result->has_url_keyed_image = input.has_url_keyed_image();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history_clusters::mojom::Cluster::DataView, ::history_clusters::mojom::ClusterPtr>::Read(
    ::history_clusters::mojom::Cluster::DataView input,
    ::history_clusters::mojom::ClusterPtr* output) {
  bool success = true;
  ::history_clusters::mojom::ClusterPtr result(::history_clusters::mojom::Cluster::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadVisits(&result->visits))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadTabGroupName(&result->tab_group_name))
        success = false;
      if (success && !input.ReadLabelMatchPositions(&result->label_match_positions))
        success = false;
      if (success && !input.ReadRelatedSearches(&result->related_searches))
        success = false;
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success)
        result->from_persistence = input.from_persistence();
      if (success && !input.ReadDebugInfo(&result->debug_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace history_clusters::mojom {




}  // history_clusters::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif