// components/heap_profiling/in_process/mojom/snapshot_controller.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_HEAP_PROFILING_IN_PROCESS_MOJOM_SNAPSHOT_CONTROLLER_MOJOM_H_
#define COMPONENTS_HEAP_PROFILING_IN_PROCESS_MOJOM_SNAPSHOT_CONTROLLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-features.h"  // IWYU pragma: export
#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-shared.h"  // IWYU pragma: export
#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace heap_profiling::mojom {

class SnapshotControllerProxy;

template <typename ImplRefTraits>
class SnapshotControllerStub;

class SnapshotControllerRequestValidator;


class SnapshotController
    : public SnapshotControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "heap_profiling.mojom.SnapshotController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SnapshotControllerInterfaceBase;
  using Proxy_ = SnapshotControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SnapshotControllerStub<ImplRefTraits>;

  using RequestValidator_ = SnapshotControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kTakeSnapshotMinVersion = 0,
    kLogMetricsWithoutSnapshotMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TakeSnapshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogMetricsWithoutSnapshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SnapshotController() = default;

  virtual void TakeSnapshot(uint32_t process_probability_pct, uint32_t process_index) = 0;

  virtual void LogMetricsWithoutSnapshot() = 0;
};



class  SnapshotControllerProxy
    : public SnapshotController {
 public:
  using InterfaceType = SnapshotController;

  explicit SnapshotControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TakeSnapshot(uint32_t process_probability_pct, uint32_t process_index) final;
  
  void LogMetricsWithoutSnapshot() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SnapshotControllerStubDispatch {
 public:
  static bool Accept(SnapshotController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SnapshotController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SnapshotController>>
class SnapshotControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SnapshotControllerStub() = default;
  ~SnapshotControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SnapshotControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SnapshotControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SnapshotControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // heap_profiling::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_HEAP_PROFILING_IN_PROCESS_MOJOM_SNAPSHOT_CONTROLLER_MOJOM_H_