// components/guest_view/common/guest_view.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_GUEST_VIEW_COMMON_GUEST_VIEW_MOJOM_H_
#define COMPONENTS_GUEST_VIEW_COMMON_GUEST_VIEW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/guest_view/common/guest_view.mojom-features.h"  // IWYU pragma: export
#include "components/guest_view/common/guest_view.mojom-shared.h"  // IWYU pragma: export
#include "components/guest_view/common/guest_view.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace guest_view::mojom {

class ViewHandleProxy;

template <typename ImplRefTraits>
class ViewHandleStub;

class ViewHandleRequestValidator;


class ViewHandle
    : public ViewHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "guest_view.mojom.ViewHandle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ViewHandleInterfaceBase;
  using Proxy_ = ViewHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = ViewHandleStub<ImplRefTraits>;

  using RequestValidator_ = ViewHandleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ViewHandle() = default;
};

class GuestViewHostProxy;

template <typename ImplRefTraits>
class GuestViewHostStub;

class GuestViewHostRequestValidator;
class GuestViewHostResponseValidator;


class GuestViewHost
    : public GuestViewHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "guest_view.mojom.GuestViewHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GuestViewHostInterfaceBase;
  using Proxy_ = GuestViewHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = GuestViewHostStub<ImplRefTraits>;

  using RequestValidator_ = GuestViewHostRequestValidator;
  using ResponseValidator_ = GuestViewHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAttachToEmbedderFrameMinVersion = 0,
    kViewCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AttachToEmbedderFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ViewCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GuestViewHost() = default;

  using AttachToEmbedderFrameCallback = base::OnceCallback<void()>;
  using AttachToEmbedderFrameMojoCallback = base::OnceCallback<void()>;

  virtual void AttachToEmbedderFrame(int32_t element_instance_id, int32_t guest_instance_id, ::base::Value::Dict params, AttachToEmbedderFrameCallback callback) = 0;

  virtual void ViewCreated(int32_t view_instance_id, const std::string& view_type, ::mojo::PendingReceiver<ViewHandle> keep_alive_handle_receiver) = 0;
};



class  ViewHandleProxy
    : public ViewHandle {
 public:
  using InterfaceType = ViewHandle;

  explicit ViewHandleProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GuestViewHostProxy
    : public GuestViewHost {
 public:
  using InterfaceType = GuestViewHost;

  explicit GuestViewHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AttachToEmbedderFrame(int32_t element_instance_id, int32_t guest_instance_id, ::base::Value::Dict params, AttachToEmbedderFrameCallback callback) final;
  
  void ViewCreated(int32_t view_instance_id, const std::string& view_type, ::mojo::PendingReceiver<ViewHandle> keep_alive_handle_receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ViewHandleStubDispatch {
 public:
  static bool Accept(ViewHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ViewHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ViewHandle>>
class ViewHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ViewHandleStub() = default;
  ~ViewHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ViewHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ViewHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GuestViewHostStubDispatch {
 public:
  static bool Accept(GuestViewHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GuestViewHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GuestViewHost>>
class GuestViewHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GuestViewHostStub() = default;
  ~GuestViewHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestViewHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestViewHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ViewHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GuestViewHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GuestViewHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // guest_view::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_GUEST_VIEW_COMMON_GUEST_VIEW_MOJOM_H_