// components/feed/mojom/rss_link_reader.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_SEND_VALIDATION_H_

#include "components/feed/mojom/rss_link_reader.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/feed/mojom/rss_link_reader.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::feed::mojom::RssLinksDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::feed::mojom::RssLinksDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::feed::mojom::internal::RssLinks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::page_url(input)) in_page_url = Traits::page_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->page_url)::BaseType> page_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_page_url,
        page_url_fragment);

      fragment->page_url.Set(
          page_url_fragment.is_null() ? nullptr : page_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->page_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_url in RssLinks struct");

      decltype(Traits::links(input)) in_links = Traits::links(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->links)::BaseType>
          links_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& links_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>, send_validation>(
        in_links,
        links_fragment,
        &links_validate_params);

      fragment->links.Set(
          links_fragment.is_null() ? nullptr : links_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->links.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null links in RssLinks struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_SEND_VALIDATION_H_