// components/facilitated_payments/core/mojom/pix_code_validator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/facilitated_payments/core/mojom/pix_code_validator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/facilitated_payments/core/mojom/pix_code_validator.mojom-params-data.h"
namespace payments {
namespace facilitated {
namespace mojom {

NOINLINE static const char* PixQrCodeTypeToStringHelper(PixQrCodeType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PixQrCodeType::kInvalid:
      return "kInvalid";
    case PixQrCodeType::kDynamic:
      return "kDynamic";
    case PixQrCodeType::kStatic:
      return "kStatic";
    default:
      return nullptr;
  }
}

std::string PixQrCodeTypeToString(PixQrCodeType value) {
  const char *str = PixQrCodeTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PixQrCodeType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PixQrCodeType value) {
  return os << PixQrCodeTypeToString(value);
}

namespace internal {


// static
bool PixCodeValidator_ValidatePixCode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PixCodeValidator_ValidatePixCode_Params_Data* object =
      static_cast<const PixCodeValidator_ValidatePixCode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_text, validation_context,
                                         &input_text_validate_params)) {
    return false;
  }

  return true;
}

PixCodeValidator_ValidatePixCode_Params_Data::PixCodeValidator_ValidatePixCode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PixCodeValidator_ValidatePixCode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PixCodeValidator_ValidatePixCode_ResponseParams_Data* object =
      static_cast<const PixCodeValidator_ValidatePixCode_ResponseParams_Data*>(data);


  if (!::payments::facilitated::mojom::internal::PixQrCodeType_Data
        ::Validate(object->pix_qr_code_type_$value, validation_context))
    return false;

  return true;
}

PixCodeValidator_ValidatePixCode_ResponseParams_Data::PixCodeValidator_ValidatePixCode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace facilitated
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::facilitated::mojom::PixQrCodeType>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::facilitated::mojom::PixQrCodeType value) {
  return std::move(context).WriteString(::payments::facilitated::mojom::PixQrCodeTypeToString(value));
}

} // namespace perfetto