// components/enterprise/watermarking/mojom/watermark.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ENTERPRISE_WATERMARKING_MOJOM_WATERMARK_MOJOM_H_
#define COMPONENTS_ENTERPRISE_WATERMARKING_MOJOM_WATERMARK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/enterprise/watermarking/mojom/watermark.mojom-features.h"  // IWYU pragma: export
#include "components/enterprise/watermarking/mojom/watermark.mojom-shared.h"  // IWYU pragma: export
#include "components/enterprise/watermarking/mojom/watermark.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace watermark::mojom {








class  WatermarkBlock {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WatermarkBlock, T>::value>;
  using DataView = WatermarkBlockDataView;
  using Data_ = internal::WatermarkBlock_Data;

  template <typename... Args>
  static WatermarkBlockPtr New(Args&&... args) {
    return WatermarkBlockPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WatermarkBlockPtr From(const U& u) {
    return mojo::TypeConverter<WatermarkBlockPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WatermarkBlock>::Convert(*this);
  }


  WatermarkBlock();

  WatermarkBlock(
      ::base::ReadOnlySharedMemoryRegion serialized_skpicture,
      uint32_t width,
      uint32_t height);

WatermarkBlock(const WatermarkBlock&) = delete;
WatermarkBlock& operator=(const WatermarkBlock&) = delete;

  ~WatermarkBlock();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WatermarkBlockPtr>
  WatermarkBlockPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WatermarkBlock::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WatermarkBlock_UnserializedMessageContext<
            UserType, WatermarkBlock::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WatermarkBlock::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WatermarkBlock::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WatermarkBlock_UnserializedMessageContext<
            UserType, WatermarkBlock::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WatermarkBlock::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::ReadOnlySharedMemoryRegion serialized_skpicture;
  
  uint32_t width;
  
  uint32_t height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WatermarkBlock::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WatermarkBlockPtr WatermarkBlock::Clone() const {
  return New(
      mojo::Clone(serialized_skpicture),
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, WatermarkBlock::EnableIfSame<T>*>
bool WatermarkBlock::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->serialized_skpicture, other_struct.serialized_skpicture))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, WatermarkBlock::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.serialized_skpicture < rhs.serialized_skpicture)
    return true;
  if (rhs.serialized_skpicture < lhs.serialized_skpicture)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}


}  // watermark::mojom

namespace mojo {


template <>
struct  StructTraits<::watermark::mojom::WatermarkBlock::DataView,
                                         ::watermark::mojom::WatermarkBlockPtr> {
  static bool IsNull(const ::watermark::mojom::WatermarkBlockPtr& input) { return !input; }
  static void SetToNull(::watermark::mojom::WatermarkBlockPtr* output) { output->reset(); }

  static  decltype(::watermark::mojom::WatermarkBlock::serialized_skpicture)& serialized_skpicture(
       ::watermark::mojom::WatermarkBlockPtr& input) {
    return input->serialized_skpicture;
  }

  static decltype(::watermark::mojom::WatermarkBlock::width) width(
      const ::watermark::mojom::WatermarkBlockPtr& input) {
    return input->width;
  }

  static decltype(::watermark::mojom::WatermarkBlock::height) height(
      const ::watermark::mojom::WatermarkBlockPtr& input) {
    return input->height;
  }

  static bool Read(::watermark::mojom::WatermarkBlock::DataView input, ::watermark::mojom::WatermarkBlockPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_ENTERPRISE_WATERMARKING_MOJOM_WATERMARK_MOJOM_H_