// components/device_signals/core/common/mojom/system_signals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_H_
#define COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/device_signals/core/common/mojom/system_signals.mojom-features.h"  // IWYU pragma: export
#include "components/device_signals/core/common/mojom/system_signals.mojom-shared.h"  // IWYU pragma: export
#include "components/device_signals/core/common/mojom/system_signals.mojom-forward.h"  // IWYU pragma: export
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/device_signals/core/common/mojom/system_signals_mojom_traits_common.h"




namespace device_signals::mojom {

class SystemSignalsServiceProxy;

template <typename ImplRefTraits>
class SystemSignalsServiceStub;

class SystemSignalsServiceRequestValidator;
class SystemSignalsServiceResponseValidator;


class SystemSignalsService
    : public SystemSignalsServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device_signals.mojom.SystemSignalsService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SystemSignalsServiceInterfaceBase;
  using Proxy_ = SystemSignalsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SystemSignalsServiceStub<ImplRefTraits>;

  using RequestValidator_ = SystemSignalsServiceRequestValidator;
  using ResponseValidator_ = SystemSignalsServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetFileSystemSignalsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetFileSystemSignals_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SystemSignalsService() = default;

  using GetFileSystemSignalsCallback = base::OnceCallback<void(const std::vector<::device_signals::FileSystemItem>&)>;
  using GetFileSystemSignalsMojoCallback = base::OnceCallback<void(const std::vector<::device_signals::FileSystemItem>&)>;

  virtual void GetFileSystemSignals(const std::vector<::device_signals::GetFileSystemInfoOptions>& requests, GetFileSystemSignalsCallback callback) = 0;
};



class  SystemSignalsServiceProxy
    : public SystemSignalsService {
 public:
  using InterfaceType = SystemSignalsService;

  explicit SystemSignalsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetFileSystemSignals(const std::vector<::device_signals::GetFileSystemInfoOptions>& requests, GetFileSystemSignalsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SystemSignalsServiceStubDispatch {
 public:
  static bool Accept(SystemSignalsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SystemSignalsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SystemSignalsService>>
class SystemSignalsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SystemSignalsServiceStub() = default;
  ~SystemSignalsServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemSignalsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemSignalsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SystemSignalsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SystemSignalsServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  ExecutableMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExecutableMetadata, T>::value>;
  using DataView = ExecutableMetadataDataView;
  using Data_ = internal::ExecutableMetadata_Data;

  template <typename... Args>
  static ExecutableMetadataPtr New(Args&&... args) {
    return ExecutableMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExecutableMetadataPtr From(const U& u) {
    return mojo::TypeConverter<ExecutableMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExecutableMetadata>::Convert(*this);
  }


  ExecutableMetadata();

  ExecutableMetadata(
      bool is_running,
      std::optional<std::vector<std::string>> public_keys_hashes,
      const std::optional<std::string>& product_name,
      const std::optional<std::string>& version,
      bool is_os_verified,
      const std::optional<std::string>& subject_name);


  ~ExecutableMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExecutableMetadataPtr>
  ExecutableMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExecutableMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExecutableMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExecutableMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExecutableMetadata_UnserializedMessageContext<
            UserType, ExecutableMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExecutableMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExecutableMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExecutableMetadata_UnserializedMessageContext<
            UserType, ExecutableMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExecutableMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_running;
  
  std::optional<std::vector<std::string>> public_keys_hashes;
  
  std::optional<std::string> product_name;
  
  std::optional<std::string> version;
  
  bool is_os_verified;
  
  std::optional<std::string> subject_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExecutableMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FileSystemItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemItem, T>::value>;
  using DataView = FileSystemItemDataView;
  using Data_ = internal::FileSystemItem_Data;

  template <typename... Args>
  static FileSystemItemPtr New(Args&&... args) {
    return FileSystemItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemItemPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemItem>::Convert(*this);
  }


  FileSystemItem();

  FileSystemItem(
      const ::base::FilePath& file_path,
      ::device_signals::PresenceValue presence,
      const std::optional<std::string>& sha256_hash,
      const std::optional<::device_signals::ExecutableMetadata>& executable_metadata);


  ~FileSystemItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemItemPtr>
  FileSystemItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemItem_UnserializedMessageContext<
            UserType, FileSystemItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemItem_UnserializedMessageContext<
            UserType, FileSystemItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath file_path;
  
  ::device_signals::PresenceValue presence;
  
  std::optional<std::string> sha256_hash;
  
  std::optional<::device_signals::ExecutableMetadata> executable_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FileSystemItemRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemItemRequest, T>::value>;
  using DataView = FileSystemItemRequestDataView;
  using Data_ = internal::FileSystemItemRequest_Data;

  template <typename... Args>
  static FileSystemItemRequestPtr New(Args&&... args) {
    return FileSystemItemRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemItemRequestPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemItemRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemItemRequest>::Convert(*this);
  }


  FileSystemItemRequest();

  FileSystemItemRequest(
      const ::base::FilePath& file_path,
      bool compute_sha256,
      bool compute_executable_metadata);


  ~FileSystemItemRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemItemRequestPtr>
  FileSystemItemRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemItemRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemItemRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemItemRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemItemRequest_UnserializedMessageContext<
            UserType, FileSystemItemRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemItemRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemItemRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemItemRequest_UnserializedMessageContext<
            UserType, FileSystemItemRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemItemRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath file_path;
  
  bool compute_sha256;
  
  bool compute_executable_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemItemRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExecutableMetadataPtr ExecutableMetadata::Clone() const {
  return New(
      mojo::Clone(is_running),
      mojo::Clone(public_keys_hashes),
      mojo::Clone(product_name),
      mojo::Clone(version),
      mojo::Clone(is_os_verified),
      mojo::Clone(subject_name)
  );
}

template <typename T, ExecutableMetadata::EnableIfSame<T>*>
bool ExecutableMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_running, other_struct.is_running))
    return false;
  if (!mojo::Equals(this->public_keys_hashes, other_struct.public_keys_hashes))
    return false;
  if (!mojo::Equals(this->product_name, other_struct.product_name))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->is_os_verified, other_struct.is_os_verified))
    return false;
  if (!mojo::Equals(this->subject_name, other_struct.subject_name))
    return false;
  return true;
}

template <typename T, ExecutableMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_running < rhs.is_running)
    return true;
  if (rhs.is_running < lhs.is_running)
    return false;
  if (lhs.public_keys_hashes < rhs.public_keys_hashes)
    return true;
  if (rhs.public_keys_hashes < lhs.public_keys_hashes)
    return false;
  if (lhs.product_name < rhs.product_name)
    return true;
  if (rhs.product_name < lhs.product_name)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.is_os_verified < rhs.is_os_verified)
    return true;
  if (rhs.is_os_verified < lhs.is_os_verified)
    return false;
  if (lhs.subject_name < rhs.subject_name)
    return true;
  if (rhs.subject_name < lhs.subject_name)
    return false;
  return false;
}
template <typename StructPtrType>
FileSystemItemPtr FileSystemItem::Clone() const {
  return New(
      mojo::Clone(file_path),
      mojo::Clone(presence),
      mojo::Clone(sha256_hash),
      mojo::Clone(executable_metadata)
  );
}

template <typename T, FileSystemItem::EnableIfSame<T>*>
bool FileSystemItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_path, other_struct.file_path))
    return false;
  if (!mojo::Equals(this->presence, other_struct.presence))
    return false;
  if (!mojo::Equals(this->sha256_hash, other_struct.sha256_hash))
    return false;
  if (!mojo::Equals(this->executable_metadata, other_struct.executable_metadata))
    return false;
  return true;
}

template <typename T, FileSystemItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_path < rhs.file_path)
    return true;
  if (rhs.file_path < lhs.file_path)
    return false;
  if (lhs.presence < rhs.presence)
    return true;
  if (rhs.presence < lhs.presence)
    return false;
  if (lhs.sha256_hash < rhs.sha256_hash)
    return true;
  if (rhs.sha256_hash < lhs.sha256_hash)
    return false;
  if (lhs.executable_metadata < rhs.executable_metadata)
    return true;
  if (rhs.executable_metadata < lhs.executable_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
FileSystemItemRequestPtr FileSystemItemRequest::Clone() const {
  return New(
      mojo::Clone(file_path),
      mojo::Clone(compute_sha256),
      mojo::Clone(compute_executable_metadata)
  );
}

template <typename T, FileSystemItemRequest::EnableIfSame<T>*>
bool FileSystemItemRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_path, other_struct.file_path))
    return false;
  if (!mojo::Equals(this->compute_sha256, other_struct.compute_sha256))
    return false;
  if (!mojo::Equals(this->compute_executable_metadata, other_struct.compute_executable_metadata))
    return false;
  return true;
}

template <typename T, FileSystemItemRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_path < rhs.file_path)
    return true;
  if (rhs.file_path < lhs.file_path)
    return false;
  if (lhs.compute_sha256 < rhs.compute_sha256)
    return true;
  if (rhs.compute_sha256 < lhs.compute_sha256)
    return false;
  if (lhs.compute_executable_metadata < rhs.compute_executable_metadata)
    return true;
  if (rhs.compute_executable_metadata < lhs.compute_executable_metadata)
    return false;
  return false;
}


}  // device_signals::mojom

namespace mojo {


template <>
struct  StructTraits<::device_signals::mojom::ExecutableMetadata::DataView,
                                         ::device_signals::mojom::ExecutableMetadataPtr> {
  static bool IsNull(const ::device_signals::mojom::ExecutableMetadataPtr& input) { return !input; }
  static void SetToNull(::device_signals::mojom::ExecutableMetadataPtr* output) { output->reset(); }

  static decltype(::device_signals::mojom::ExecutableMetadata::is_running) is_running(
      const ::device_signals::mojom::ExecutableMetadataPtr& input) {
    return input->is_running;
  }

  static const decltype(::device_signals::mojom::ExecutableMetadata::public_keys_hashes)& public_keys_hashes(
      const ::device_signals::mojom::ExecutableMetadataPtr& input) {
    return input->public_keys_hashes;
  }

  static const decltype(::device_signals::mojom::ExecutableMetadata::product_name)& product_name(
      const ::device_signals::mojom::ExecutableMetadataPtr& input) {
    return input->product_name;
  }

  static const decltype(::device_signals::mojom::ExecutableMetadata::version)& version(
      const ::device_signals::mojom::ExecutableMetadataPtr& input) {
    return input->version;
  }

  static decltype(::device_signals::mojom::ExecutableMetadata::is_os_verified) is_os_verified(
      const ::device_signals::mojom::ExecutableMetadataPtr& input) {
    return input->is_os_verified;
  }

  static const decltype(::device_signals::mojom::ExecutableMetadata::subject_name)& subject_name(
      const ::device_signals::mojom::ExecutableMetadataPtr& input) {
    return input->subject_name;
  }

  static bool Read(::device_signals::mojom::ExecutableMetadata::DataView input, ::device_signals::mojom::ExecutableMetadataPtr* output);
};


template <>
struct  StructTraits<::device_signals::mojom::FileSystemItem::DataView,
                                         ::device_signals::mojom::FileSystemItemPtr> {
  static bool IsNull(const ::device_signals::mojom::FileSystemItemPtr& input) { return !input; }
  static void SetToNull(::device_signals::mojom::FileSystemItemPtr* output) { output->reset(); }

  static const decltype(::device_signals::mojom::FileSystemItem::file_path)& file_path(
      const ::device_signals::mojom::FileSystemItemPtr& input) {
    return input->file_path;
  }

  static decltype(::device_signals::mojom::FileSystemItem::presence) presence(
      const ::device_signals::mojom::FileSystemItemPtr& input) {
    return input->presence;
  }

  static const decltype(::device_signals::mojom::FileSystemItem::sha256_hash)& sha256_hash(
      const ::device_signals::mojom::FileSystemItemPtr& input) {
    return input->sha256_hash;
  }

  static const decltype(::device_signals::mojom::FileSystemItem::executable_metadata)& executable_metadata(
      const ::device_signals::mojom::FileSystemItemPtr& input) {
    return input->executable_metadata;
  }

  static bool Read(::device_signals::mojom::FileSystemItem::DataView input, ::device_signals::mojom::FileSystemItemPtr* output);
};


template <>
struct  StructTraits<::device_signals::mojom::FileSystemItemRequest::DataView,
                                         ::device_signals::mojom::FileSystemItemRequestPtr> {
  static bool IsNull(const ::device_signals::mojom::FileSystemItemRequestPtr& input) { return !input; }
  static void SetToNull(::device_signals::mojom::FileSystemItemRequestPtr* output) { output->reset(); }

  static const decltype(::device_signals::mojom::FileSystemItemRequest::file_path)& file_path(
      const ::device_signals::mojom::FileSystemItemRequestPtr& input) {
    return input->file_path;
  }

  static decltype(::device_signals::mojom::FileSystemItemRequest::compute_sha256) compute_sha256(
      const ::device_signals::mojom::FileSystemItemRequestPtr& input) {
    return input->compute_sha256;
  }

  static decltype(::device_signals::mojom::FileSystemItemRequest::compute_executable_metadata) compute_executable_metadata(
      const ::device_signals::mojom::FileSystemItemRequestPtr& input) {
    return input->compute_executable_metadata;
  }

  static bool Read(::device_signals::mojom::FileSystemItemRequest::DataView input, ::device_signals::mojom::FileSystemItemRequestPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_H_