// components/device_signals/core/common/mojom/system_signals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_SEND_VALIDATION_H_

#include "components/device_signals/core/common/mojom/system_signals.mojom-shared-internal.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"

#include "components/device_signals/core/common/mojom/system_signals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device_signals::mojom::PresenceValue, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_signals::mojom::ExecutableMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_signals::mojom::ExecutableMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_signals::mojom::internal::ExecutableMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_running = Traits::is_running(input);

      decltype(Traits::public_keys_hashes(input)) in_public_keys_hashes = Traits::public_keys_hashes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->public_keys_hashes)::BaseType>
          public_keys_hashes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& public_keys_hashes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>, send_validation>(
        in_public_keys_hashes,
        public_keys_hashes_fragment,
        &public_keys_hashes_validate_params);

      fragment->public_keys_hashes.Set(
          public_keys_hashes_fragment.is_null() ? nullptr : public_keys_hashes_fragment.data());

      decltype(Traits::product_name(input)) in_product_name = Traits::product_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->product_name)::BaseType> product_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_product_name,
        product_name_fragment);

      fragment->product_name.Set(
          product_name_fragment.is_null() ? nullptr : product_name_fragment.data());

      decltype(Traits::version(input)) in_version = Traits::version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->version)::BaseType> version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_version,
        version_fragment);

      fragment->version.Set(
          version_fragment.is_null() ? nullptr : version_fragment.data());

      fragment->is_os_verified = Traits::is_os_verified(input);

      decltype(Traits::subject_name(input)) in_subject_name = Traits::subject_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subject_name)::BaseType> subject_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_subject_name,
        subject_name_fragment);

      fragment->subject_name.Set(
          subject_name_fragment.is_null() ? nullptr : subject_name_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_signals::mojom::FileSystemItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_signals::mojom::FileSystemItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_signals::mojom::internal::FileSystemItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::file_path(input)) in_file_path = Traits::file_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_path)::BaseType> file_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_file_path,
        file_path_fragment);

      fragment->file_path.Set(
          file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_path in FileSystemItem struct");

      
      mojo::internal::Serialize<::device_signals::mojom::PresenceValue>(
        Traits::presence(input),
        &fragment->presence);

      decltype(Traits::sha256_hash(input)) in_sha256_hash = Traits::sha256_hash(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sha256_hash)::BaseType> sha256_hash_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_sha256_hash,
        sha256_hash_fragment);

      fragment->sha256_hash.Set(
          sha256_hash_fragment.is_null() ? nullptr : sha256_hash_fragment.data());

      decltype(Traits::executable_metadata(input)) in_executable_metadata = Traits::executable_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->executable_metadata)::BaseType> executable_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device_signals::mojom::ExecutableMetadataDataView, send_validation>(
        in_executable_metadata,
        executable_metadata_fragment);

      fragment->executable_metadata.Set(
          executable_metadata_fragment.is_null() ? nullptr : executable_metadata_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device_signals::mojom::FileSystemItemRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_signals::mojom::FileSystemItemRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_signals::mojom::internal::FileSystemItemRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::file_path(input)) in_file_path = Traits::file_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_path)::BaseType> file_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_file_path,
        file_path_fragment);

      fragment->file_path.Set(
          file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_path in FileSystemItemRequest struct");

      fragment->compute_sha256 = Traits::compute_sha256(input);

      fragment->compute_executable_metadata = Traits::compute_executable_metadata(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_SEND_VALIDATION_H_