// components/data_sharing/public/protocol/group_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_DATA_VIEW_H_
#define COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/data_sharing/public/protocol/group_data.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace data_sharing::mojom {
class GroupMemberDataView;

class GroupDataDataView;



}  // data_sharing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::data_sharing::mojom::GroupMemberDataView> {
  using Data = ::data_sharing::mojom::internal::GroupMember_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::GroupDataDataView> {
  using Data = ::data_sharing::mojom::internal::GroupData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace data_sharing::mojom {


enum class MemberRole : int32_t {
  
  kUnspecified = 0,
  
  kOwner = 1,
  
  kMember = 2,
  
  kInvitee = 3,
  
  kFormerMember = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, MemberRole value);
inline bool IsKnownEnumValue(MemberRole value) {
  return internal::MemberRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GroupMemberDataView {
 public:
  GroupMemberDataView() = default;

  GroupMemberDataView(
      internal::GroupMember_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGaiaIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGaiaId(UserType* output) {
    
    auto* pointer = data_->gaia_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::data_sharing::mojom::MemberRole>(
        data_value, output);
  }
  MemberRole role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::data_sharing::mojom::MemberRole>(data_->role));
  }
  inline void GetAvatarUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvatarUrl(UserType* output) {
    
    auto* pointer = data_->avatar_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetGivenNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGivenName(UserType* output) {
    
    auto* pointer = data_->given_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCreationTimeDataView(
      ::mojo_base::mojom::JSTimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationTime(UserType* output) {
    
    auto* pointer = data_->creation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::JSTimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdatedTimeDataView(
      ::mojo_base::mojom::JSTimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdatedTime(UserType* output) {
    
    auto* pointer = data_->last_updated_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::JSTimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::GroupMember_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GroupDataDataView {
 public:
  GroupDataDataView() = default;

  GroupDataDataView(
      internal::GroupData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMembersDataView(
      mojo::ArrayDataView<GroupMemberDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMembers(UserType* output) {
    
    auto* pointer = data_->members.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_sharing::mojom::GroupMemberDataView>>(
        pointer, output, message_);
  }
  inline void GetFormerMembersDataView(
      mojo::ArrayDataView<GroupMemberDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormerMembers(UserType* output) {
    
    auto* pointer = data_->former_members.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_sharing::mojom::GroupMemberDataView>>(
        pointer, output, message_);
  }
  inline void GetAccessTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessToken(UserType* output) {
    
    auto* pointer = data_->access_token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GroupData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // data_sharing::mojom

#endif  // COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_DATA_VIEW_H_