// components/continuous_search/common/public/mojom/continuous_search.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-params-data.h"
namespace continuous_search {
namespace mojom {

NOINLINE static const char* ResultTypeToStringHelper(ResultType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResultType::kSearchResults:
      return "kSearchResults";
    case ResultType::kRelatedSearches:
      return "kRelatedSearches";
    default:
      return nullptr;
  }
}

std::string ResultTypeToString(ResultType value) {
  const char *str = ResultTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResultType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResultType value) {
  return os << ResultTypeToString(value);
}

NOINLINE static const char* CategoryToStringHelper(Category value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Category::kNone:
      return "kNone";
    case Category::kOrganic:
      return "kOrganic";
    default:
      return nullptr;
  }
}

std::string CategoryToString(Category value) {
  const char *str = CategoryToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Category value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Category value) {
  return os << CategoryToString(value);
}

NOINLINE static const char* SearchResultExtractor_StatusToStringHelper(SearchResultExtractor_Status value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SearchResultExtractor_Status::kSuccess:
      return "kSuccess";
    case SearchResultExtractor_Status::kNoResults:
      return "kNoResults";
    default:
      return nullptr;
  }
}

std::string SearchResultExtractor_StatusToString(SearchResultExtractor_Status value) {
  const char *str = SearchResultExtractor_StatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SearchResultExtractor_Status value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SearchResultExtractor_Status value) {
  return os << SearchResultExtractor_StatusToString(value);
}

namespace internal {


// static
bool SearchResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchResult_Data* object =
      static_cast<const SearchResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->link, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->link, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

SearchResult_Data::SearchResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResultGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResultGroup_Data* object =
      static_cast<const ResultGroup_Data*>(data);


  if (!::continuous_search::mojom::internal::ResultType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  return true;
}

ResultGroup_Data::ResultGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CategoryResults_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CategoryResults_Data* object =
      static_cast<const CategoryResults_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_url, validation_context))
    return false;


  if (!::continuous_search::mojom::internal::Category_Data
        ::Validate(object->category_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->groups, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->groups, validation_context,
                                         &groups_validate_params)) {
    return false;
  }

  return true;
}

CategoryResults_Data::CategoryResults_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchResultExtractor_ExtractCurrentSearchResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchResultExtractor_ExtractCurrentSearchResults_Params_Data* object =
      static_cast<const SearchResultExtractor_ExtractCurrentSearchResults_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result_types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::continuous_search::mojom::internal::ResultType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->result_types, validation_context,
                                         &result_types_validate_params)) {
    return false;
  }

  return true;
}

SearchResultExtractor_ExtractCurrentSearchResults_Params_Data::SearchResultExtractor_ExtractCurrentSearchResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data* object =
      static_cast<const SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data*>(data);


  if (!::continuous_search::mojom::internal::SearchResultExtractor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results, validation_context))
    return false;

  return true;
}

SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data::SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace continuous_search

namespace perfetto {

// static
void TraceFormatTraits<::continuous_search::mojom::ResultType>::WriteIntoTrace(
   perfetto::TracedValue context, ::continuous_search::mojom::ResultType value) {
  return std::move(context).WriteString(::continuous_search::mojom::ResultTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::continuous_search::mojom::Category>::WriteIntoTrace(
   perfetto::TracedValue context, ::continuous_search::mojom::Category value) {
  return std::move(context).WriteString(::continuous_search::mojom::CategoryToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::continuous_search::mojom::SearchResultExtractor_Status>::WriteIntoTrace(
   perfetto::TracedValue context, ::continuous_search::mojom::SearchResultExtractor_Status value) {
  return std::move(context).WriteString(::continuous_search::mojom::SearchResultExtractor_StatusToString(value));
}

} // namespace perfetto