// components/commerce/core/mojom/shopping_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/commerce/core/mojom/shopping_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/mojom/shopping_service.mojom-params-data.h"
namespace shopping_service {
namespace mojom {

NOINLINE static const char* UserFeedbackToStringHelper(UserFeedback value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserFeedback::kUnspecified:
      return "kUnspecified";
    case UserFeedback::kThumbsUp:
      return "kThumbsUp";
    case UserFeedback::kThumbsDown:
      return "kThumbsDown";
    default:
      return nullptr;
  }
}

std::string UserFeedbackToString(UserFeedback value) {
  const char *str = UserFeedbackToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserFeedback value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserFeedback value) {
  return os << UserFeedbackToString(value);
}

NOINLINE static const char* PriceInsightsInfo_PriceBucketToStringHelper(PriceInsightsInfo_PriceBucket value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PriceInsightsInfo_PriceBucket::kUnknown:
      return "kUnknown";
    case PriceInsightsInfo_PriceBucket::kLow:
      return "kLow";
    case PriceInsightsInfo_PriceBucket::kTypical:
      return "kTypical";
    case PriceInsightsInfo_PriceBucket::kHigh:
      return "kHigh";
    default:
      return nullptr;
  }
}

std::string PriceInsightsInfo_PriceBucketToString(PriceInsightsInfo_PriceBucket value) {
  const char *str = PriceInsightsInfo_PriceBucketToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PriceInsightsInfo_PriceBucket value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PriceInsightsInfo_PriceBucket value) {
  return os << PriceInsightsInfo_PriceBucketToString(value);
}

namespace internal {


// static
bool PricePoint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PricePoint_Data* object =
      static_cast<const PricePoint_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->date, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& date_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->date, validation_context,
                                         &date_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formatted_price, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& formatted_price_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->formatted_price, validation_context,
                                         &formatted_price_validate_params)) {
    return false;
  }

  return true;
}

PricePoint_Data::PricePoint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UrlInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UrlInfo_Data* object =
      static_cast<const UrlInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumbnail_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->thumbnail_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->previewText, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& previewText_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->previewText, validation_context,
                                         &previewText_validate_params)) {
    return false;
  }

  return true;
}

UrlInfo_Data::UrlInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PriceInsightsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PriceInsightsInfo_Data* object =
      static_cast<const PriceInsightsInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->typical_low_price, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& typical_low_price_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->typical_low_price, validation_context,
                                         &typical_low_price_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->typical_high_price, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& typical_high_price_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->typical_high_price, validation_context,
                                         &typical_high_price_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->catalog_attributes, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& catalog_attributes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->catalog_attributes, validation_context,
                                         &catalog_attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->jackpot, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->jackpot, validation_context))
    return false;


  if (!::shopping_service::mojom::internal::PriceInsightsInfo_PriceBucket_Data
        ::Validate(object->bucket, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->history, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& history_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->history, validation_context,
                                         &history_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->locale, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& locale_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->locale, validation_context,
                                         &locale_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->currency_code, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& currency_code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->currency_code, validation_context,
                                         &currency_code_validate_params)) {
    return false;
  }

  return true;
}

PriceInsightsInfo_Data::PriceInsightsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsDescriptionText_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsDescriptionText_Data* object =
      static_cast<const ProductSpecificationsDescriptionText_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecificationsDescriptionText_Data::ProductSpecificationsDescriptionText_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsOption_Data* object =
      static_cast<const ProductSpecificationsOption_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptions, validation_context,
                                         &descriptions_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecificationsOption_Data::ProductSpecificationsOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsDescription_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsDescription_Data* object =
      static_cast<const ProductSpecificationsDescription_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->options, validation_context,
                                         &options_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alt_text, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alt_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alt_text, validation_context,
                                         &alt_text_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecificationsDescription_Data::ProductSpecificationsDescription_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsValue_Data* object =
      static_cast<const ProductSpecificationsValue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->specification_descriptions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& specification_descriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->specification_descriptions, validation_context,
                                         &specification_descriptions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->summary, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& summary_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->summary, validation_context,
                                         &summary_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecificationsValue_Data::ProductSpecificationsValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsProduct_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsProduct_Data* object =
      static_cast<const ProductSpecificationsProduct_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->product_dimension_values, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& product_dimension_values_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->product_dimension_values, validation_context,
                                         &product_dimension_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->summary, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& summary_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->summary, validation_context,
                                         &summary_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buying_options_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buying_options_url, validation_context))
    return false;

  return true;
}

ProductSpecificationsProduct_Data::ProductSpecificationsProduct_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsFeatureState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsFeatureState_Data* object =
      static_cast<const ProductSpecificationsFeatureState_Data*>(data);

  return true;
}

ProductSpecificationsFeatureState_Data::ProductSpecificationsFeatureState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecifications_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecifications_Data* object =
      static_cast<const ProductSpecifications_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->product_dimension_map, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& product_dimension_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->product_dimension_map, validation_context,
                                         &product_dimension_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->products, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& products_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->products, validation_context,
                                         &products_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecifications_Data::ProductSpecifications_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data* object =
      static_cast<const ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data::ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data::ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->productInfo, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->productInfo, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data::ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductInfoForUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductInfoForUrl_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductInfoForUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductInfoForUrl_Params_Data::ShoppingServiceHandler_GetProductInfoForUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->productInfo, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->productInfo, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data::ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductInfoForUrls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductInfoForUrls_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductInfoForUrls_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_GetProductInfoForUrls_Params_Data::ShoppingServiceHandler_GetProductInfoForUrls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->productInfos, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& productInfos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->productInfos, validation_context,
                                         &productInfos_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data::ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->priceInsightsInfo, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->priceInsightsInfo, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data::ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->priceInsightsInfo, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->priceInsightsInfo, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data::ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data::ShoppingServiceHandler_GetProductSpecificationsForUrls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->productSpecs, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->productSpecs, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data::ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data::ShoppingServiceHandler_GetUrlInfosForProductTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_infos, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_infos, validation_context,
                                         &url_infos_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data::ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_infos, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_infos, validation_context,
                                         &url_infos_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data::ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_IsShoppingListEligible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_IsShoppingListEligible_Params_Data* object =
      static_cast<const ShoppingServiceHandler_IsShoppingListEligible_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_IsShoppingListEligible_Params_Data::ShoppingServiceHandler_IsShoppingListEligible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data*>(data);

  return true;
}

ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data::ShoppingServiceHandler_IsShoppingListEligible_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data::ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_OpenUrlInNewTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_OpenUrlInNewTab_Params_Data* object =
      static_cast<const ShoppingServiceHandler_OpenUrlInNewTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_OpenUrlInNewTab_Params_Data::ShoppingServiceHandler_OpenUrlInNewTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data* object =
      static_cast<const ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data::ShoppingServiceHandler_SwitchToOrOpenTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data::ShoppingServiceHandler_GetAllProductSpecificationsSets_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sets, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sets, validation_context,
                                         &sets_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data::ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->set, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data::ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data* object =
      static_cast<const ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data::ShoppingServiceHandler_AddProductSpecificationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->created_set, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data::ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data* object =
      static_cast<const ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data::ShoppingServiceHandler_DeleteProductSpecificationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data* object =
      static_cast<const ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data::ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->updated_set, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data::ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data* object =
      static_cast<const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->updated_set, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data::ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data* object =
      static_cast<const ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data*>(data);


  if (!::shopping_service::mojom::internal::UserFeedback_Data
        ::Validate(object->feedback, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data::ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data*>(data);

  return true;
}

ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data::ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data* object =
      static_cast<const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data::ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace shopping_service

namespace perfetto {

// static
void TraceFormatTraits<::shopping_service::mojom::UserFeedback>::WriteIntoTrace(
   perfetto::TracedValue context, ::shopping_service::mojom::UserFeedback value) {
  return std::move(context).WriteString(::shopping_service::mojom::UserFeedbackToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>::WriteIntoTrace(
   perfetto::TracedValue context, ::shopping_service::mojom::PriceInsightsInfo_PriceBucket value) {
  return std::move(context).WriteString(::shopping_service::mojom::PriceInsightsInfo_PriceBucketToString(value));
}

} // namespace perfetto