// components/browsing_topics/mojom/browsing_topics_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-params-data.h"
namespace browsing_topics {
namespace mojom {

namespace internal {
// static
bool WebUIGetBrowsingTopicsStateResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebUIGetBrowsingTopicsStateResult_Data* object = static_cast<const WebUIGetBrowsingTopicsStateResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebUIGetBrowsingTopicsStateResult_Tag::kOverrideStatusMessage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_override_status_message, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& override_status_message_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_override_status_message, validation_context,
                                             &override_status_message_validate_params)) {
        return false;
      }
      return true;
    }
    case WebUIGetBrowsingTopicsStateResult_Tag::kBrowsingTopicsState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_browsing_topics_state, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_browsing_topics_state, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebUIGetBrowsingTopicsStateResult");
      return false;
    }
  }
}
// static
bool WebUIGetModelInfoResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebUIGetModelInfoResult_Data* object = static_cast<const WebUIGetModelInfoResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebUIGetModelInfoResult_Tag::kOverrideStatusMessage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_override_status_message, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& override_status_message_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_override_status_message, validation_context,
                                             &override_status_message_validate_params)) {
        return false;
      }
      return true;
    }
    case WebUIGetModelInfoResult_Tag::kModelInfo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_model_info, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_model_info, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebUIGetModelInfoResult");
      return false;
    }
  }
}


// static
bool WebUIBrowsingTopicsConfiguration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIBrowsingTopicsConfiguration_Data* object =
      static_cast<const WebUIBrowsingTopicsConfiguration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_period_per_epoch, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_period_per_epoch, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_epoch_introduction_delay, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_epoch_introduction_delay, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_topics_list, 18, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& disabled_topics_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->disabled_topics_list, validation_context,
                                         &disabled_topics_list_validate_params)) {
    return false;
  }

  return true;
}

WebUIBrowsingTopicsConfiguration_Data::WebUIBrowsingTopicsConfiguration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUITopic_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUITopic_Data* object =
      static_cast<const WebUITopic_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->topic_name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->topic_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->observed_by_domains, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& observed_by_domains_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->observed_by_domains, validation_context,
                                         &observed_by_domains_validate_params)) {
    return false;
  }

  return true;
}

WebUITopic_Data::WebUITopic_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIEpoch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIEpoch_Data* object =
      static_cast<const WebUIEpoch_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->topics, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& topics_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->topics, validation_context,
                                         &topics_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->calculation_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->calculation_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_version, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_version, validation_context,
                                         &model_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->taxonomy_version, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& taxonomy_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->taxonomy_version, validation_context,
                                         &taxonomy_version_validate_params)) {
    return false;
  }

  return true;
}

WebUIEpoch_Data::WebUIEpoch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIBrowsingTopicsState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIBrowsingTopicsState_Data* object =
      static_cast<const WebUIBrowsingTopicsState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->epochs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& epochs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->epochs, validation_context,
                                         &epochs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->next_scheduled_calculation_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->next_scheduled_calculation_time, validation_context))
    return false;

  return true;
}

WebUIBrowsingTopicsState_Data::WebUIBrowsingTopicsState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIModelInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIModelInfo_Data* object =
      static_cast<const WebUIModelInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_version, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_version, validation_context,
                                         &model_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_file_path, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_file_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_file_path, validation_context,
                                         &model_file_path_validate_params)) {
    return false;
  }

  return true;
}

WebUIModelInfo_Data::WebUIModelInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBrowsingTopicsConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBrowsingTopicsConfiguration_Params_Data* object =
      static_cast<const PageHandler_GetBrowsingTopicsConfiguration_Params_Data*>(data);

  return true;
}

PageHandler_GetBrowsingTopicsConfiguration_Params_Data::PageHandler_GetBrowsingTopicsConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data* object =
      static_cast<const PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data::PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBrowsingTopicsState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBrowsingTopicsState_Params_Data* object =
      static_cast<const PageHandler_GetBrowsingTopicsState_Params_Data*>(data);

  return true;
}

PageHandler_GetBrowsingTopicsState_Params_Data::PageHandler_GetBrowsingTopicsState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBrowsingTopicsState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBrowsingTopicsState_ResponseParams_Data* object =
      static_cast<const PageHandler_GetBrowsingTopicsState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PageHandler_GetBrowsingTopicsState_ResponseParams_Data::PageHandler_GetBrowsingTopicsState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetModelInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetModelInfo_Params_Data* object =
      static_cast<const PageHandler_GetModelInfo_Params_Data*>(data);

  return true;
}

PageHandler_GetModelInfo_Params_Data::PageHandler_GetModelInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetModelInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetModelInfo_ResponseParams_Data* object =
      static_cast<const PageHandler_GetModelInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PageHandler_GetModelInfo_ResponseParams_Data::PageHandler_GetModelInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ClassifyHosts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ClassifyHosts_Params_Data* object =
      static_cast<const PageHandler_ClassifyHosts_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hosts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->hosts, validation_context,
                                         &hosts_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ClassifyHosts_Params_Data::PageHandler_ClassifyHosts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ClassifyHosts_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ClassifyHosts_ResponseParams_Data* object =
      static_cast<const PageHandler_ClassifyHosts_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->topics_for_hosts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& topics_for_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->topics_for_hosts, validation_context,
                                         &topics_for_hosts_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ClassifyHosts_ResponseParams_Data::PageHandler_ClassifyHosts_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace browsing_topics