// components/browser_apis/tab_strip/tab_strip_api_events.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_EVENTS_MOJOM_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_EVENTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom-features.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom-shared.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom-forward.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom.h"
#include <string>
#include <vector>








namespace tabs_api::mojom {












class  OnTabsCreatedEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnTabsCreatedEvent, T>::value>;
  using DataView = OnTabsCreatedEventDataView;
  using Data_ = internal::OnTabsCreatedEvent_Data;

  template <typename... Args>
  static OnTabsCreatedEventPtr New(Args&&... args) {
    return OnTabsCreatedEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnTabsCreatedEventPtr From(const U& u) {
    return mojo::TypeConverter<OnTabsCreatedEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnTabsCreatedEvent>::Convert(*this);
  }


  OnTabsCreatedEvent();

  explicit OnTabsCreatedEvent(
      std::vector<::tabs_api::mojom::TabCreatedContainerPtr> tabs);

OnTabsCreatedEvent(const OnTabsCreatedEvent&) = delete;
OnTabsCreatedEvent& operator=(const OnTabsCreatedEvent&) = delete;

  ~OnTabsCreatedEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnTabsCreatedEventPtr>
  OnTabsCreatedEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnTabsCreatedEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnTabsCreatedEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnTabsCreatedEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnTabsCreatedEvent_UnserializedMessageContext<
            UserType, OnTabsCreatedEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnTabsCreatedEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnTabsCreatedEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnTabsCreatedEvent_UnserializedMessageContext<
            UserType, OnTabsCreatedEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnTabsCreatedEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::tabs_api::mojom::TabCreatedContainerPtr> tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnTabsCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OnTabsClosedEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnTabsClosedEvent, T>::value>;
  using DataView = OnTabsClosedEventDataView;
  using Data_ = internal::OnTabsClosedEvent_Data;

  template <typename... Args>
  static OnTabsClosedEventPtr New(Args&&... args) {
    return OnTabsClosedEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnTabsClosedEventPtr From(const U& u) {
    return mojo::TypeConverter<OnTabsClosedEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnTabsClosedEvent>::Convert(*this);
  }


  OnTabsClosedEvent();

  explicit OnTabsClosedEvent(
      std::vector<::tabs_api::NodeId> tabs);


  ~OnTabsClosedEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnTabsClosedEventPtr>
  OnTabsClosedEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnTabsClosedEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnTabsClosedEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnTabsClosedEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnTabsClosedEvent_UnserializedMessageContext<
            UserType, OnTabsClosedEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnTabsClosedEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnTabsClosedEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnTabsClosedEvent_UnserializedMessageContext<
            UserType, OnTabsClosedEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnTabsClosedEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::tabs_api::NodeId> tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnTabsClosedEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OnDataChangedEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnDataChangedEvent, T>::value>;
  using DataView = OnDataChangedEventDataView;
  using Data_ = internal::OnDataChangedEvent_Data;

  template <typename... Args>
  static OnDataChangedEventPtr New(Args&&... args) {
    return OnDataChangedEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnDataChangedEventPtr From(const U& u) {
    return mojo::TypeConverter<OnDataChangedEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnDataChangedEvent>::Convert(*this);
  }


  OnDataChangedEvent();

  explicit OnDataChangedEvent(
      ::tabs_api::mojom::DataPtr data);

OnDataChangedEvent(const OnDataChangedEvent&) = delete;
OnDataChangedEvent& operator=(const OnDataChangedEvent&) = delete;

  ~OnDataChangedEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnDataChangedEventPtr>
  OnDataChangedEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnDataChangedEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnDataChangedEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnDataChangedEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnDataChangedEvent_UnserializedMessageContext<
            UserType, OnDataChangedEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnDataChangedEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnDataChangedEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnDataChangedEvent_UnserializedMessageContext<
            UserType, OnDataChangedEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnDataChangedEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::mojom::DataPtr data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnDataChangedEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OnCollectionCreatedEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnCollectionCreatedEvent, T>::value>;
  using DataView = OnCollectionCreatedEventDataView;
  using Data_ = internal::OnCollectionCreatedEvent_Data;

  template <typename... Args>
  static OnCollectionCreatedEventPtr New(Args&&... args) {
    return OnCollectionCreatedEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnCollectionCreatedEventPtr From(const U& u) {
    return mojo::TypeConverter<OnCollectionCreatedEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnCollectionCreatedEvent>::Convert(*this);
  }


  OnCollectionCreatedEvent();

  OnCollectionCreatedEvent(
      ::tabs_api::mojom::DataPtr data,
      const ::tabs_api::Position& position);

OnCollectionCreatedEvent(const OnCollectionCreatedEvent&) = delete;
OnCollectionCreatedEvent& operator=(const OnCollectionCreatedEvent&) = delete;

  ~OnCollectionCreatedEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnCollectionCreatedEventPtr>
  OnCollectionCreatedEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnCollectionCreatedEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnCollectionCreatedEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnCollectionCreatedEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnCollectionCreatedEvent_UnserializedMessageContext<
            UserType, OnCollectionCreatedEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnCollectionCreatedEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnCollectionCreatedEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnCollectionCreatedEvent_UnserializedMessageContext<
            UserType, OnCollectionCreatedEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnCollectionCreatedEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::mojom::DataPtr data;
  
  ::tabs_api::Position position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OnNodeMovedEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnNodeMovedEvent, T>::value>;
  using DataView = OnNodeMovedEventDataView;
  using Data_ = internal::OnNodeMovedEvent_Data;

  template <typename... Args>
  static OnNodeMovedEventPtr New(Args&&... args) {
    return OnNodeMovedEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnNodeMovedEventPtr From(const U& u) {
    return mojo::TypeConverter<OnNodeMovedEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnNodeMovedEvent>::Convert(*this);
  }


  OnNodeMovedEvent();

  OnNodeMovedEvent(
      const ::tabs_api::NodeId& id,
      const ::tabs_api::Position& from,
      const ::tabs_api::Position& to);


  ~OnNodeMovedEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnNodeMovedEventPtr>
  OnNodeMovedEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnNodeMovedEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnNodeMovedEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnNodeMovedEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnNodeMovedEvent_UnserializedMessageContext<
            UserType, OnNodeMovedEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnNodeMovedEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnNodeMovedEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnNodeMovedEvent_UnserializedMessageContext<
            UserType, OnNodeMovedEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnNodeMovedEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;
  
  ::tabs_api::Position from;
  
  ::tabs_api::Position to;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnNodeMovedEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OnTabsCreatedEventPtr OnTabsCreatedEvent::Clone() const {
  return New(
      mojo::Clone(tabs)
  );
}

template <typename T, OnTabsCreatedEvent::EnableIfSame<T>*>
bool OnTabsCreatedEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tabs, other_struct.tabs))
    return false;
  return true;
}

template <typename T, OnTabsCreatedEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tabs < rhs.tabs)
    return true;
  if (rhs.tabs < lhs.tabs)
    return false;
  return false;
}
template <typename StructPtrType>
OnTabsClosedEventPtr OnTabsClosedEvent::Clone() const {
  return New(
      mojo::Clone(tabs)
  );
}

template <typename T, OnTabsClosedEvent::EnableIfSame<T>*>
bool OnTabsClosedEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tabs, other_struct.tabs))
    return false;
  return true;
}

template <typename T, OnTabsClosedEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tabs < rhs.tabs)
    return true;
  if (rhs.tabs < lhs.tabs)
    return false;
  return false;
}
template <typename StructPtrType>
OnDataChangedEventPtr OnDataChangedEvent::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, OnDataChangedEvent::EnableIfSame<T>*>
bool OnDataChangedEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, OnDataChangedEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
OnCollectionCreatedEventPtr OnCollectionCreatedEvent::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(position)
  );
}

template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>*>
bool OnCollectionCreatedEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  return true;
}

template <typename T, OnCollectionCreatedEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  return false;
}
template <typename StructPtrType>
OnNodeMovedEventPtr OnNodeMovedEvent::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(from),
      mojo::Clone(to)
  );
}

template <typename T, OnNodeMovedEvent::EnableIfSame<T>*>
bool OnNodeMovedEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->from, other_struct.from))
    return false;
  if (!mojo::Equals(this->to, other_struct.to))
    return false;
  return true;
}

template <typename T, OnNodeMovedEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.from < rhs.from)
    return true;
  if (rhs.from < lhs.from)
    return false;
  if (lhs.to < rhs.to)
    return true;
  if (rhs.to < lhs.to)
    return false;
  return false;
}


}  // tabs_api::mojom

namespace mojo {


template <>
struct  StructTraits<::tabs_api::mojom::OnTabsCreatedEvent::DataView,
                                         ::tabs_api::mojom::OnTabsCreatedEventPtr> {
  static bool IsNull(const ::tabs_api::mojom::OnTabsCreatedEventPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::OnTabsCreatedEventPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::OnTabsCreatedEvent::tabs)& tabs(
      const ::tabs_api::mojom::OnTabsCreatedEventPtr& input) {
    return input->tabs;
  }

  static bool Read(::tabs_api::mojom::OnTabsCreatedEvent::DataView input, ::tabs_api::mojom::OnTabsCreatedEventPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::OnTabsClosedEvent::DataView,
                                         ::tabs_api::mojom::OnTabsClosedEventPtr> {
  static bool IsNull(const ::tabs_api::mojom::OnTabsClosedEventPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::OnTabsClosedEventPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::OnTabsClosedEvent::tabs)& tabs(
      const ::tabs_api::mojom::OnTabsClosedEventPtr& input) {
    return input->tabs;
  }

  static bool Read(::tabs_api::mojom::OnTabsClosedEvent::DataView input, ::tabs_api::mojom::OnTabsClosedEventPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::OnDataChangedEvent::DataView,
                                         ::tabs_api::mojom::OnDataChangedEventPtr> {
  static bool IsNull(const ::tabs_api::mojom::OnDataChangedEventPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::OnDataChangedEventPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::OnDataChangedEvent::data)& data(
      const ::tabs_api::mojom::OnDataChangedEventPtr& input) {
    return input->data;
  }

  static bool Read(::tabs_api::mojom::OnDataChangedEvent::DataView input, ::tabs_api::mojom::OnDataChangedEventPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::OnCollectionCreatedEvent::DataView,
                                         ::tabs_api::mojom::OnCollectionCreatedEventPtr> {
  static bool IsNull(const ::tabs_api::mojom::OnCollectionCreatedEventPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::OnCollectionCreatedEventPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::OnCollectionCreatedEvent::data)& data(
      const ::tabs_api::mojom::OnCollectionCreatedEventPtr& input) {
    return input->data;
  }

  static const decltype(::tabs_api::mojom::OnCollectionCreatedEvent::position)& position(
      const ::tabs_api::mojom::OnCollectionCreatedEventPtr& input) {
    return input->position;
  }

  static bool Read(::tabs_api::mojom::OnCollectionCreatedEvent::DataView input, ::tabs_api::mojom::OnCollectionCreatedEventPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::OnNodeMovedEvent::DataView,
                                         ::tabs_api::mojom::OnNodeMovedEventPtr> {
  static bool IsNull(const ::tabs_api::mojom::OnNodeMovedEventPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::OnNodeMovedEventPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::OnNodeMovedEvent::id)& id(
      const ::tabs_api::mojom::OnNodeMovedEventPtr& input) {
    return input->id;
  }

  static const decltype(::tabs_api::mojom::OnNodeMovedEvent::from)& from(
      const ::tabs_api::mojom::OnNodeMovedEventPtr& input) {
    return input->from;
  }

  static const decltype(::tabs_api::mojom::OnNodeMovedEvent::to)& to(
      const ::tabs_api::mojom::OnNodeMovedEventPtr& input) {
    return input->to;
  }

  static bool Read(::tabs_api::mojom::OnNodeMovedEvent::DataView input, ::tabs_api::mojom::OnNodeMovedEventPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_EVENTS_MOJOM_H_