// components/browser_apis/tab_strip/tab_strip_api.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-features.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api.mojom-shared.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api.mojom-forward.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom.h"
#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom.h"
#include "mojo/public/mojom/base/empty.mojom.h"
#include "mojo/public/mojom/base/error.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"




namespace tabs_api::mojom {

class TabStripServiceProxy;

template <typename ImplRefTraits>
class TabStripServiceStub;

class TabStripServiceRequestValidator;
class TabStripServiceResponseValidator;


class TabStripService
    : public TabStripServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tabs_api.mojom.TabStripService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TabStripServiceInterfaceBase;
  using Proxy_ = TabStripServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = TabStripServiceStub<ImplRefTraits>;

  using RequestValidator_ = TabStripServiceRequestValidator;
  using ResponseValidator_ = TabStripServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTabsMinVersion = 0,
    kGetTabMinVersion = 0,
    kCreateTabAtMinVersion = 0,
    kCloseTabsMinVersion = 0,
    kActivateTabMinVersion = 0,
    kSetSelectedTabsMinVersion = 0,
    kMoveNodeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTabAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivateTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSelectedTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TabStripService() = default;

  using GetTabsCallback = base::OnceCallback<void(base::expected<
  TabsSnapshotPtr,
  ::mojo_base::mojom::ErrorPtr>)>;
  using GetTabsResult = base::expected<
  TabsSnapshotPtr,
  ::mojo_base::mojom::ErrorPtr>;
  using GetTabsMojoCallback = base::OnceCallback<void(TabStripService_GetTabs_ResponseParam_ResultPtr)>;

  virtual void GetTabs(GetTabsCallback callback) = 0;

  using GetTabCallback = base::OnceCallback<void(base::expected<
  ::tabs_api::mojom::TabPtr,
  ::mojo_base::mojom::ErrorPtr>)>;
  using GetTabResult = base::expected<
  ::tabs_api::mojom::TabPtr,
  ::mojo_base::mojom::ErrorPtr>;
  using GetTabMojoCallback = base::OnceCallback<void(TabStripService_GetTab_ResponseParam_ResultPtr)>;

  virtual void GetTab(const ::tabs_api::NodeId& id, GetTabCallback callback) = 0;

  using CreateTabAtCallback = base::OnceCallback<void(base::expected<
  ::tabs_api::mojom::TabPtr,
  ::mojo_base::mojom::ErrorPtr>)>;
  using CreateTabAtResult = base::expected<
  ::tabs_api::mojom::TabPtr,
  ::mojo_base::mojom::ErrorPtr>;
  using CreateTabAtMojoCallback = base::OnceCallback<void(TabStripService_CreateTabAt_ResponseParam_ResultPtr)>;

  virtual void CreateTabAt(const std::optional<::tabs_api::Position>& pos, const std::optional<::GURL>& url, CreateTabAtCallback callback) = 0;

  using CloseTabsCallback = base::OnceCallback<void(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>)>;
  using CloseTabsResult = base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>;
  using CloseTabsMojoCallback = base::OnceCallback<void(TabStripService_CloseTabs_ResponseParam_ResultPtr)>;

  virtual void CloseTabs(const std::vector<::tabs_api::NodeId>& id, CloseTabsCallback callback) = 0;

  using ActivateTabCallback = base::OnceCallback<void(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>)>;
  using ActivateTabResult = base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>;
  using ActivateTabMojoCallback = base::OnceCallback<void(TabStripService_ActivateTab_ResponseParam_ResultPtr)>;

  virtual void ActivateTab(const ::tabs_api::NodeId& id, ActivateTabCallback callback) = 0;

  using SetSelectedTabsCallback = base::OnceCallback<void(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>)>;
  using SetSelectedTabsResult = base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>;
  using SetSelectedTabsMojoCallback = base::OnceCallback<void(TabStripService_SetSelectedTabs_ResponseParam_ResultPtr)>;

  virtual void SetSelectedTabs(const std::vector<::tabs_api::NodeId>& selection, const ::tabs_api::NodeId& tab_to_activate, SetSelectedTabsCallback callback) = 0;

  using MoveNodeCallback = base::OnceCallback<void(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>)>;
  using MoveNodeResult = base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>;
  using MoveNodeMojoCallback = base::OnceCallback<void(TabStripService_MoveNode_ResponseParam_ResultPtr)>;

  virtual void MoveNode(const ::tabs_api::NodeId& id, const ::tabs_api::Position& position, MoveNodeCallback callback) = 0;
};

class TabsObserverProxy;

template <typename ImplRefTraits>
class TabsObserverStub;

class TabsObserverRequestValidator;


class TabsObserver
    : public TabsObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tabs_api.mojom.TabsObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TabsObserverInterfaceBase;
  using Proxy_ = TabsObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = TabsObserverStub<ImplRefTraits>;

  using RequestValidator_ = TabsObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTabEventsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTabEvents_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TabsObserver() = default;

  virtual void OnTabEvents(std::vector<TabsEventPtr> events) = 0;
};



class  TabStripServiceProxy
    : public TabStripService {
 public:
  using InterfaceType = TabStripService;

  explicit TabStripServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTabs(GetTabsCallback callback) final;
  
  void GetTab(const ::tabs_api::NodeId& id, GetTabCallback callback) final;
  
  void CreateTabAt(const std::optional<::tabs_api::Position>& pos, const std::optional<::GURL>& url, CreateTabAtCallback callback) final;
  
  void CloseTabs(const std::vector<::tabs_api::NodeId>& id, CloseTabsCallback callback) final;
  
  void ActivateTab(const ::tabs_api::NodeId& id, ActivateTabCallback callback) final;
  
  void SetSelectedTabs(const std::vector<::tabs_api::NodeId>& selection, const ::tabs_api::NodeId& tab_to_activate, SetSelectedTabsCallback callback) final;
  
  void MoveNode(const ::tabs_api::NodeId& id, const ::tabs_api::Position& position, MoveNodeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TabsObserverProxy
    : public TabsObserver {
 public:
  using InterfaceType = TabsObserver;

  explicit TabsObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTabEvents(std::vector<TabsEventPtr> events) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TabStripServiceStubDispatch {
 public:
  static bool Accept(TabStripService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TabStripService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TabStripService>>
class TabStripServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TabStripServiceStub() = default;
  ~TabStripServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabStripServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabStripServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TabsObserverStubDispatch {
 public:
  static bool Accept(TabsObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TabsObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TabsObserver>>
class TabsObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TabsObserverStub() = default;
  ~TabsObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabsObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabsObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TabStripServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TabsObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TabStripServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  TabsEvent {
 public:
  using DataView = TabsEventDataView;
  using Data_ = internal::TabsEvent_Data;
  using Tag = Data_::TabsEvent_Tag;

  template <typename... Args>
  static TabsEventPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |tabs_created_event|.
  static TabsEventPtr NewTabsCreatedEvent(
      ::tabs_api::mojom::OnTabsCreatedEventPtr value);
  // Construct an instance holding |tabs_closed_event|.
  static TabsEventPtr NewTabsClosedEvent(
      ::tabs_api::mojom::OnTabsClosedEventPtr value);
  // Construct an instance holding |node_moved_event|.
  static TabsEventPtr NewNodeMovedEvent(
      ::tabs_api::mojom::OnNodeMovedEventPtr value);
  // Construct an instance holding |data_changed_event|.
  static TabsEventPtr NewDataChangedEvent(
      ::tabs_api::mojom::OnDataChangedEventPtr value);
  // Construct an instance holding |collection_created_event|.
  static TabsEventPtr NewCollectionCreatedEvent(
      ::tabs_api::mojom::OnCollectionCreatedEventPtr value);

  template <typename U>
  static TabsEventPtr From(const U& u) {
    return mojo::TypeConverter<TabsEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabsEvent>::Convert(*this);
  }
  ~TabsEvent();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabsEvent(const TabsEvent& other) = delete;
  TabsEvent& operator=(const TabsEvent& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabsEventPtr>
  TabsEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabsEvent>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabsEvent>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_tabs_created_event() const { return tag_ == Tag::kTabsCreatedEvent; }
  const ::tabs_api::mojom::OnTabsCreatedEventPtr& get_tabs_created_event() const {
    CHECK(tag_ == Tag::kTabsCreatedEvent);
    return data_.tabs_created_event;
  }
  ::tabs_api::mojom::OnTabsCreatedEventPtr& get_tabs_created_event() {
    CHECK(tag_ == Tag::kTabsCreatedEvent);
    return data_.tabs_created_event;
  }
  void set_tabs_created_event(::tabs_api::mojom::OnTabsCreatedEventPtr tabs_created_event);

  bool is_tabs_closed_event() const { return tag_ == Tag::kTabsClosedEvent; }
  const ::tabs_api::mojom::OnTabsClosedEventPtr& get_tabs_closed_event() const {
    CHECK(tag_ == Tag::kTabsClosedEvent);
    return data_.tabs_closed_event;
  }
  ::tabs_api::mojom::OnTabsClosedEventPtr& get_tabs_closed_event() {
    CHECK(tag_ == Tag::kTabsClosedEvent);
    return data_.tabs_closed_event;
  }
  void set_tabs_closed_event(::tabs_api::mojom::OnTabsClosedEventPtr tabs_closed_event);

  bool is_node_moved_event() const { return tag_ == Tag::kNodeMovedEvent; }
  const ::tabs_api::mojom::OnNodeMovedEventPtr& get_node_moved_event() const {
    CHECK(tag_ == Tag::kNodeMovedEvent);
    return data_.node_moved_event;
  }
  ::tabs_api::mojom::OnNodeMovedEventPtr& get_node_moved_event() {
    CHECK(tag_ == Tag::kNodeMovedEvent);
    return data_.node_moved_event;
  }
  void set_node_moved_event(::tabs_api::mojom::OnNodeMovedEventPtr node_moved_event);

  bool is_data_changed_event() const { return tag_ == Tag::kDataChangedEvent; }
  const ::tabs_api::mojom::OnDataChangedEventPtr& get_data_changed_event() const {
    CHECK(tag_ == Tag::kDataChangedEvent);
    return data_.data_changed_event;
  }
  ::tabs_api::mojom::OnDataChangedEventPtr& get_data_changed_event() {
    CHECK(tag_ == Tag::kDataChangedEvent);
    return data_.data_changed_event;
  }
  void set_data_changed_event(::tabs_api::mojom::OnDataChangedEventPtr data_changed_event);

  bool is_collection_created_event() const { return tag_ == Tag::kCollectionCreatedEvent; }
  const ::tabs_api::mojom::OnCollectionCreatedEventPtr& get_collection_created_event() const {
    CHECK(tag_ == Tag::kCollectionCreatedEvent);
    return data_.collection_created_event;
  }
  ::tabs_api::mojom::OnCollectionCreatedEventPtr& get_collection_created_event() {
    CHECK(tag_ == Tag::kCollectionCreatedEvent);
    return data_.collection_created_event;
  }
  void set_collection_created_event(::tabs_api::mojom::OnCollectionCreatedEventPtr collection_created_event);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabsEvent::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabsEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabsCreatedEvent)>,
        ::tabs_api::mojom::OnTabsCreatedEventPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabsClosedEvent)>,
        ::tabs_api::mojom::OnTabsClosedEventPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNodeMovedEvent)>,
        ::tabs_api::mojom::OnNodeMovedEventPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDataChangedEvent)>,
        ::tabs_api::mojom::OnDataChangedEventPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCollectionCreatedEvent)>,
        ::tabs_api::mojom::OnCollectionCreatedEventPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::tabs_api::mojom::OnTabsCreatedEventPtr tabs_created_event;
    ::tabs_api::mojom::OnTabsClosedEventPtr tabs_closed_event;
    ::tabs_api::mojom::OnNodeMovedEventPtr node_moved_event;
    ::tabs_api::mojom::OnDataChangedEventPtr data_changed_event;
    ::tabs_api::mojom::OnCollectionCreatedEventPtr collection_created_event;
  };

  TabsEvent(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabsCreatedEvent)>,
      ::tabs_api::mojom::OnTabsCreatedEventPtr value);
  TabsEvent(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabsClosedEvent)>,
      ::tabs_api::mojom::OnTabsClosedEventPtr value);
  TabsEvent(
      std::in_place_index_t<static_cast<size_t>(Tag::kNodeMovedEvent)>,
      ::tabs_api::mojom::OnNodeMovedEventPtr value);
  TabsEvent(
      std::in_place_index_t<static_cast<size_t>(Tag::kDataChangedEvent)>,
      ::tabs_api::mojom::OnDataChangedEventPtr value);
  TabsEvent(
      std::in_place_index_t<static_cast<size_t>(Tag::kCollectionCreatedEvent)>,
      ::tabs_api::mojom::OnCollectionCreatedEventPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_GetTabs_ResponseParam_Result {
 public:
  using DataView = TabStripService_GetTabs_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_GetTabs_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_GetTabs_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_GetTabs_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_GetTabs_ResponseParam_ResultPtr NewSuccess(
      TabsSnapshotPtr value);
  // Construct an instance holding |failure|.
  static TabStripService_GetTabs_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_GetTabs_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_GetTabs_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_GetTabs_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_GetTabs_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_GetTabs_ResponseParam_Result(const TabStripService_GetTabs_ResponseParam_Result& other) = delete;
  TabStripService_GetTabs_ResponseParam_Result& operator=(const TabStripService_GetTabs_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_GetTabs_ResponseParam_ResultPtr>
  TabStripService_GetTabs_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_GetTabs_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_GetTabs_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const TabsSnapshotPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  TabsSnapshotPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(TabsSnapshotPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_GetTabs_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_GetTabs_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        TabsSnapshotPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TabsSnapshotPtr success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_GetTabs_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      TabsSnapshotPtr value);
  TabStripService_GetTabs_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_GetTab_ResponseParam_Result {
 public:
  using DataView = TabStripService_GetTab_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_GetTab_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_GetTab_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_GetTab_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_GetTab_ResponseParam_ResultPtr NewSuccess(
      ::tabs_api::mojom::TabPtr value);
  // Construct an instance holding |failure|.
  static TabStripService_GetTab_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_GetTab_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_GetTab_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_GetTab_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_GetTab_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_GetTab_ResponseParam_Result(const TabStripService_GetTab_ResponseParam_Result& other) = delete;
  TabStripService_GetTab_ResponseParam_Result& operator=(const TabStripService_GetTab_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_GetTab_ResponseParam_ResultPtr>
  TabStripService_GetTab_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_GetTab_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_GetTab_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::tabs_api::mojom::TabPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::tabs_api::mojom::TabPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::tabs_api::mojom::TabPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_GetTab_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_GetTab_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::tabs_api::mojom::TabPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::tabs_api::mojom::TabPtr success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_GetTab_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::tabs_api::mojom::TabPtr value);
  TabStripService_GetTab_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_CreateTabAt_ResponseParam_Result {
 public:
  using DataView = TabStripService_CreateTabAt_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_CreateTabAt_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_CreateTabAt_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_CreateTabAt_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_CreateTabAt_ResponseParam_ResultPtr NewSuccess(
      ::tabs_api::mojom::TabPtr value);
  // Construct an instance holding |failure|.
  static TabStripService_CreateTabAt_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_CreateTabAt_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_CreateTabAt_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_CreateTabAt_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_CreateTabAt_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_CreateTabAt_ResponseParam_Result(const TabStripService_CreateTabAt_ResponseParam_Result& other) = delete;
  TabStripService_CreateTabAt_ResponseParam_Result& operator=(const TabStripService_CreateTabAt_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_CreateTabAt_ResponseParam_ResultPtr>
  TabStripService_CreateTabAt_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_CreateTabAt_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_CreateTabAt_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::tabs_api::mojom::TabPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::tabs_api::mojom::TabPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::tabs_api::mojom::TabPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_CreateTabAt_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_CreateTabAt_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::tabs_api::mojom::TabPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::tabs_api::mojom::TabPtr success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_CreateTabAt_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::tabs_api::mojom::TabPtr value);
  TabStripService_CreateTabAt_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_CloseTabs_ResponseParam_Result {
 public:
  using DataView = TabStripService_CloseTabs_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_CloseTabs_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_CloseTabs_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_CloseTabs_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_CloseTabs_ResponseParam_ResultPtr NewSuccess(
      const ::std::monostate& value);
  // Construct an instance holding |failure|.
  static TabStripService_CloseTabs_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_CloseTabs_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_CloseTabs_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_CloseTabs_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_CloseTabs_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_CloseTabs_ResponseParam_Result(const TabStripService_CloseTabs_ResponseParam_Result& other) = delete;
  TabStripService_CloseTabs_ResponseParam_Result& operator=(const TabStripService_CloseTabs_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_CloseTabs_ResponseParam_ResultPtr>
  TabStripService_CloseTabs_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_CloseTabs_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_CloseTabs_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::std::monostate& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::std::monostate& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::std::monostate& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_CloseTabs_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_CloseTabs_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::std::monostate& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::std::monostate success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_CloseTabs_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::std::monostate& value);
  TabStripService_CloseTabs_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_ActivateTab_ResponseParam_Result {
 public:
  using DataView = TabStripService_ActivateTab_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_ActivateTab_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_ActivateTab_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_ActivateTab_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_ActivateTab_ResponseParam_ResultPtr NewSuccess(
      const ::std::monostate& value);
  // Construct an instance holding |failure|.
  static TabStripService_ActivateTab_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_ActivateTab_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_ActivateTab_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_ActivateTab_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_ActivateTab_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_ActivateTab_ResponseParam_Result(const TabStripService_ActivateTab_ResponseParam_Result& other) = delete;
  TabStripService_ActivateTab_ResponseParam_Result& operator=(const TabStripService_ActivateTab_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_ActivateTab_ResponseParam_ResultPtr>
  TabStripService_ActivateTab_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_ActivateTab_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_ActivateTab_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::std::monostate& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::std::monostate& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::std::monostate& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_ActivateTab_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_ActivateTab_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::std::monostate& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::std::monostate success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_ActivateTab_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::std::monostate& value);
  TabStripService_ActivateTab_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_SetSelectedTabs_ResponseParam_Result {
 public:
  using DataView = TabStripService_SetSelectedTabs_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_SetSelectedTabs_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_SetSelectedTabs_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_SetSelectedTabs_ResponseParam_ResultPtr NewSuccess(
      const ::std::monostate& value);
  // Construct an instance holding |failure|.
  static TabStripService_SetSelectedTabs_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_SetSelectedTabs_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_SetSelectedTabs_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_SetSelectedTabs_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_SetSelectedTabs_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_SetSelectedTabs_ResponseParam_Result(const TabStripService_SetSelectedTabs_ResponseParam_Result& other) = delete;
  TabStripService_SetSelectedTabs_ResponseParam_Result& operator=(const TabStripService_SetSelectedTabs_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_SetSelectedTabs_ResponseParam_ResultPtr>
  TabStripService_SetSelectedTabs_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_SetSelectedTabs_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_SetSelectedTabs_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::std::monostate& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::std::monostate& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::std::monostate& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_SetSelectedTabs_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_SetSelectedTabs_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::std::monostate& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::std::monostate success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_SetSelectedTabs_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::std::monostate& value);
  TabStripService_SetSelectedTabs_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabStripService_MoveNode_ResponseParam_Result {
 public:
  using DataView = TabStripService_MoveNode_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripService_MoveNode_ResponseParam_Result_Data;
  using Tag = Data_::TabStripService_MoveNode_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripService_MoveNode_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripService_MoveNode_ResponseParam_ResultPtr NewSuccess(
      const ::std::monostate& value);
  // Construct an instance holding |failure|.
  static TabStripService_MoveNode_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripService_MoveNode_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripService_MoveNode_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripService_MoveNode_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripService_MoveNode_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripService_MoveNode_ResponseParam_Result(const TabStripService_MoveNode_ResponseParam_Result& other) = delete;
  TabStripService_MoveNode_ResponseParam_Result& operator=(const TabStripService_MoveNode_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripService_MoveNode_ResponseParam_ResultPtr>
  TabStripService_MoveNode_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_MoveNode_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripService_MoveNode_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::std::monostate& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::std::monostate& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::std::monostate& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripService_MoveNode_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripService_MoveNode_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::std::monostate& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::std::monostate success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripService_MoveNode_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::std::monostate& value);
  TabStripService_MoveNode_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  TabsSnapshot {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabsSnapshot, T>::value>;
  using DataView = TabsSnapshotDataView;
  using Data_ = internal::TabsSnapshot_Data;

  template <typename... Args>
  static TabsSnapshotPtr New(Args&&... args) {
    return TabsSnapshotPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabsSnapshotPtr From(const U& u) {
    return mojo::TypeConverter<TabsSnapshotPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabsSnapshot>::Convert(*this);
  }


  TabsSnapshot();

  TabsSnapshot(
      ::tabs_api::mojom::ContainerPtr tab_strip,
      ::mojo::PendingAssociatedReceiver<TabsObserver> stream);

TabsSnapshot(const TabsSnapshot&) = delete;
TabsSnapshot& operator=(const TabsSnapshot&) = delete;

  ~TabsSnapshot();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabsSnapshotPtr>
  TabsSnapshotPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabsSnapshot::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabsSnapshot_UnserializedMessageContext<
            UserType, TabsSnapshot::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabsSnapshot::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabsSnapshot::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabsSnapshot_UnserializedMessageContext<
            UserType, TabsSnapshot::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabsSnapshot::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::mojom::ContainerPtr tab_strip;
  
  ::mojo::PendingAssociatedReceiver<TabsObserver> stream;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabsSnapshot::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TabsEventPtr TabsEvent::Clone() const {
  switch (tag_) {
    case Tag::kTabsCreatedEvent:
      return NewTabsCreatedEvent(
          mojo::Clone(data_.tabs_created_event));
    case Tag::kTabsClosedEvent:
      return NewTabsClosedEvent(
          mojo::Clone(data_.tabs_closed_event));
    case Tag::kNodeMovedEvent:
      return NewNodeMovedEvent(
          mojo::Clone(data_.node_moved_event));
    case Tag::kDataChangedEvent:
      return NewDataChangedEvent(
          mojo::Clone(data_.data_changed_event));
    case Tag::kCollectionCreatedEvent:
      return NewCollectionCreatedEvent(
          mojo::Clone(data_.collection_created_event));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabsEvent>::value>::type*>
bool TabsEvent::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTabsCreatedEvent:
      return mojo::Equals(data_.tabs_created_event, other.data_.tabs_created_event);
    case Tag::kTabsClosedEvent:
      return mojo::Equals(data_.tabs_closed_event, other.data_.tabs_closed_event);
    case Tag::kNodeMovedEvent:
      return mojo::Equals(data_.node_moved_event, other.data_.node_moved_event);
    case Tag::kDataChangedEvent:
      return mojo::Equals(data_.data_changed_event, other.data_.data_changed_event);
    case Tag::kCollectionCreatedEvent:
      return mojo::Equals(data_.collection_created_event, other.data_.collection_created_event);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_GetTabs_ResponseParam_ResultPtr TabStripService_GetTabs_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_GetTabs_ResponseParam_Result>::value>::type*>
bool TabStripService_GetTabs_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_GetTab_ResponseParam_ResultPtr TabStripService_GetTab_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_GetTab_ResponseParam_Result>::value>::type*>
bool TabStripService_GetTab_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_CreateTabAt_ResponseParam_ResultPtr TabStripService_CreateTabAt_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_CreateTabAt_ResponseParam_Result>::value>::type*>
bool TabStripService_CreateTabAt_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_CloseTabs_ResponseParam_ResultPtr TabStripService_CloseTabs_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_CloseTabs_ResponseParam_Result>::value>::type*>
bool TabStripService_CloseTabs_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_ActivateTab_ResponseParam_ResultPtr TabStripService_ActivateTab_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_ActivateTab_ResponseParam_Result>::value>::type*>
bool TabStripService_ActivateTab_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_SetSelectedTabs_ResponseParam_ResultPtr TabStripService_SetSelectedTabs_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_SetSelectedTabs_ResponseParam_Result>::value>::type*>
bool TabStripService_SetSelectedTabs_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
TabStripService_MoveNode_ResponseParam_ResultPtr TabStripService_MoveNode_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripService_MoveNode_ResponseParam_Result>::value>::type*>
bool TabStripService_MoveNode_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
TabsSnapshotPtr TabsSnapshot::Clone() const {
  return New(
      mojo::Clone(tab_strip),
      mojo::Clone(stream)
  );
}

template <typename T, TabsSnapshot::EnableIfSame<T>*>
bool TabsSnapshot::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_strip, other_struct.tab_strip))
    return false;
  if (!mojo::Equals(this->stream, other_struct.stream))
    return false;
  return true;
}

template <typename T, TabsSnapshot::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_strip < rhs.tab_strip)
    return true;
  if (rhs.tab_strip < lhs.tab_strip)
    return false;
  if (lhs.stream < rhs.stream)
    return true;
  if (rhs.stream < lhs.stream)
    return false;
  return false;
}


}  // tabs_api::mojom

namespace mojo {


template <>
struct  StructTraits<::tabs_api::mojom::TabsSnapshot::DataView,
                                         ::tabs_api::mojom::TabsSnapshotPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabsSnapshotPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabsSnapshotPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::TabsSnapshot::tab_strip)& tab_strip(
      const ::tabs_api::mojom::TabsSnapshotPtr& input) {
    return input->tab_strip;
  }

  static  decltype(::tabs_api::mojom::TabsSnapshot::stream)& stream(
       ::tabs_api::mojom::TabsSnapshotPtr& input) {
    return input->stream;
  }

  static bool Read(::tabs_api::mojom::TabsSnapshot::DataView input, ::tabs_api::mojom::TabsSnapshotPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabsEvent::DataView,
                                        ::tabs_api::mojom::TabsEventPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabsEventPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabsEventPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabsEvent::Tag GetTag(const ::tabs_api::mojom::TabsEventPtr& input) {
    return input->which();
  }

  static const ::tabs_api::mojom::OnTabsCreatedEventPtr& tabs_created_event(const ::tabs_api::mojom::TabsEventPtr& input) {
    return input->get_tabs_created_event();
  }

  static const ::tabs_api::mojom::OnTabsClosedEventPtr& tabs_closed_event(const ::tabs_api::mojom::TabsEventPtr& input) {
    return input->get_tabs_closed_event();
  }

  static const ::tabs_api::mojom::OnNodeMovedEventPtr& node_moved_event(const ::tabs_api::mojom::TabsEventPtr& input) {
    return input->get_node_moved_event();
  }

  static const ::tabs_api::mojom::OnDataChangedEventPtr& data_changed_event(const ::tabs_api::mojom::TabsEventPtr& input) {
    return input->get_data_changed_event();
  }

  static const ::tabs_api::mojom::OnCollectionCreatedEventPtr& collection_created_event(const ::tabs_api::mojom::TabsEventPtr& input) {
    return input->get_collection_created_event();
  }

  static bool Read(::tabs_api::mojom::TabsEvent::DataView input, ::tabs_api::mojom::TabsEventPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::tabs_api::mojom::TabsSnapshotPtr& success( ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::tabs_api::mojom::TabPtr& success(const ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::tabs_api::mojom::TabPtr& success(const ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::std::monostate& success(const ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::std::monostate& success(const ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::std::monostate& success(const ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::std::monostate& success(const ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_H_