import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Color as tabGroups_mojom_Color } from './tab_group_types.mojom-webui.js';
import { Position as tabsApi_mojom_Position } from './tab_strip_api_types.mojom-webui.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const AlertStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum AlertState {
    MIN_VALUE = 0,
    MAX_VALUE = 17,
    kAudioMuting = 0,
    kAudioRecording = 1,
    kAudioPlaying = 2,
    kBluetoothConnected = 3,
    kBluetoothScanActive = 4,
    kDesktopCapturing = 5,
    kActorAccessing = 6,
    kActorWaitingOnUser = 7,
    kGlicAccessing = 8,
    kGlicSharing = 9,
    kHidConnected = 10,
    kMediaRecording = 11,
    kPipPlaying = 12,
    kSerialConnected = 13,
    kTabCapturing = 14,
    kUsbConnected = 15,
    kVideoRecording = 16,
    kVrPresentingInHeadset = 17
}
export declare const NetworkStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum NetworkState {
    MIN_VALUE = 0,
    MAX_VALUE = 3,
    kNone = 0,
    kWaiting = 1,
    kLoading = 2,
    kError = 3
}
export declare const ImageSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabStripSpec: {
    $: mojo.internal.MojomType;
};
export declare const PinnedTabsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UnpinnedTabsSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabGroupSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabGroupVisualDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const SplitTabSpec: {
    $: mojo.internal.MojomType;
};
export declare const SplitTabVisualDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const ContainerSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabCreatedContainerSpec: {
    $: mojo.internal.MojomType;
};
export declare const DataSpec: {
    $: mojo.internal.MojomType;
};
export interface ImageMojoType {
    dataUrl: url_mojom_Url;
}
export type Image = ImageMojoType;
export interface TabMojoType {
    id: string;
    title: string;
    url: url_mojom_Url;
    favicon: Image;
    alertStates: AlertState[];
    networkState: NetworkState;
    isActive: boolean;
    isSelected: boolean;
    isBlocked: boolean;
}
export type Tab = TabMojoType;
export interface TabStripMojoType {
    id: string;
}
export type TabStrip = TabStripMojoType;
export interface PinnedTabsMojoType {
    id: string;
}
export type PinnedTabs = PinnedTabsMojoType;
export interface UnpinnedTabsMojoType {
    id: string;
}
export type UnpinnedTabs = UnpinnedTabsMojoType;
export interface TabGroupMojoType {
    id: string;
    data: TabGroupVisualData;
}
export type TabGroup = TabGroupMojoType;
export interface TabGroupVisualDataMojoType {
    title: string;
    color: tabGroups_mojom_Color;
    isCollapsed: boolean;
}
export type TabGroupVisualData = TabGroupVisualDataMojoType;
export interface SplitTabMojoType {
    id: string;
    data: SplitTabVisualData;
}
export type SplitTab = SplitTabMojoType;
export declare const SplitTabVisualData_LayoutSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SplitTabVisualData_Layout {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kVertical = 0,
    kHorizontal = 1
}
export interface SplitTabVisualDataMojoType {
    layout: SplitTabVisualData_Layout;
    splitRatio: number;
}
export type SplitTabVisualData = SplitTabVisualDataMojoType;
export interface ContainerMojoType {
    data: Data;
    children: Container[];
}
export type Container = ContainerMojoType;
export interface TabCreatedContainerMojoType {
    tab: Tab;
    position: tabsApi_mojom_Position;
}
export type TabCreatedContainer = TabCreatedContainerMojoType;
export interface Data {
    tab?: Tab;
    tabStrip?: TabStrip;
    pinnedTabs?: PinnedTabs;
    unpinnedTabs?: UnpinnedTabs;
    tabGroup?: TabGroup;
    splitTab?: SplitTab;
}
export declare enum DataFieldTags {
    TAB = 0,
    TAB_STRIP = 1,
    PINNED_TABS = 2,
    UNPINNED_TABS = 3,
    TAB_GROUP = 4,
    SPLIT_TAB = 5
}
export declare function whichData(u: Data): DataFieldTags;
