// components/attribution_reporting/registration.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/attribution_reporting/registration.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('attributionReporting.mojom');
  var source_registration_time_config$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/source_registration_time_config.mojom', 'source_registration_time_config.mojom.js');
  }
  var trigger_data_matching$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/trigger_data_matching.mojom', 'trigger_data_matching.mojom.js');
  }
  var debug_types$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/debug_types.mojom', 'debug_types.mojom.js');
  }
  var int128$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/int128.mojom', '../../mojo/public/mojom/base/int128.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../mojo/public/mojom/base/time.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', '../../services/network/public/mojom/schemeful_site.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../url/mojom/url.mojom.js');
  }



  function SuitableOrigin(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SuitableOrigin.prototype.initDefaults_ = function() {
    this.origin = null;
  };
  SuitableOrigin.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SuitableOrigin.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuitableOrigin.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SuitableOrigin.encodedSize = codec.kStructHeaderSize + 8;

  SuitableOrigin.decode = function(decoder) {
    var packed;
    var val = new SuitableOrigin();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  SuitableOrigin.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SuitableOrigin.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
  };
  function FilterData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FilterData.prototype.initDefaults_ = function() {
    this.filterValues = null;
  };
  FilterData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FilterData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilterData.filterValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.ArrayOf(codec.String), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FilterData.encodedSize = codec.kStructHeaderSize + 8;

  FilterData.decode = function(decoder) {
    var packed;
    var val = new FilterData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filterValues =
        decoder.decodeMapPointer(codec.String, new codec.ArrayOf(codec.String));
    return val;
  };

  FilterData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FilterData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.ArrayOf(codec.String), val.filterValues);
  };
  function FilterConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FilterConfig.prototype.initDefaults_ = function() {
    this.lookbackWindow = null;
    this.filterValues = null;
  };
  FilterConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FilterConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilterConfig.lookbackWindow
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilterConfig.filterValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, new codec.ArrayOf(codec.String), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FilterConfig.encodedSize = codec.kStructHeaderSize + 16;

  FilterConfig.decode = function(decoder) {
    var packed;
    var val = new FilterConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lookbackWindow =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.filterValues =
        decoder.decodeMapPointer(codec.String, new codec.ArrayOf(codec.String));
    return val;
  };

  FilterConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FilterConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.lookbackWindow);
    encoder.encodeMapPointer(codec.String, new codec.ArrayOf(codec.String), val.filterValues);
  };
  function FilterPair(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FilterPair.prototype.initDefaults_ = function() {
    this.positive = null;
    this.negative = null;
  };
  FilterPair.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FilterPair.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilterPair.positive
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(FilterConfig), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilterPair.negative
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(FilterConfig), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FilterPair.encodedSize = codec.kStructHeaderSize + 16;

  FilterPair.decode = function(decoder) {
    var packed;
    var val = new FilterPair();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.positive =
        decoder.decodeArrayPointer(new codec.PointerTo(FilterConfig));
    val.negative =
        decoder.decodeArrayPointer(new codec.PointerTo(FilterConfig));
    return val;
  };

  FilterPair.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FilterPair.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(FilterConfig), val.positive);
    encoder.encodeArrayPointer(new codec.PointerTo(FilterConfig), val.negative);
  };
  function AggregationKeys(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregationKeys.prototype.initDefaults_ = function() {
    this.keys = null;
  };
  AggregationKeys.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregationKeys.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregationKeys.keys
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(int128$.Uint128), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregationKeys.encodedSize = codec.kStructHeaderSize + 8;

  AggregationKeys.decode = function(decoder) {
    var packed;
    var val = new AggregationKeys();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keys =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(int128$.Uint128));
    return val;
  };

  AggregationKeys.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregationKeys.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(int128$.Uint128), val.keys);
  };
  function AggregatableTriggerData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableTriggerData.prototype.initDefaults_ = function() {
    this.keyPiece = null;
    this.sourceKeys = null;
    this.filters = null;
  };
  AggregatableTriggerData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableTriggerData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableTriggerData.keyPiece
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, int128$.Uint128, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableTriggerData.sourceKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableTriggerData.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, FilterPair, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatableTriggerData.encodedSize = codec.kStructHeaderSize + 24;

  AggregatableTriggerData.decode = function(decoder) {
    var packed;
    var val = new AggregatableTriggerData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyPiece =
        decoder.decodeStructPointer(int128$.Uint128);
    val.sourceKeys =
        decoder.decodeArrayPointer(codec.String);
    val.filters =
        decoder.decodeStructPointer(FilterPair);
    return val;
  };

  AggregatableTriggerData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableTriggerData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(int128$.Uint128, val.keyPiece);
    encoder.encodeArrayPointer(codec.String, val.sourceKeys);
    encoder.encodeStructPointer(FilterPair, val.filters);
  };
  function DestinationSet(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DestinationSet.prototype.initDefaults_ = function() {
    this.destinations = null;
  };
  DestinationSet.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DestinationSet.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DestinationSet.destinations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(schemeful_site$.SchemefulSite), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DestinationSet.encodedSize = codec.kStructHeaderSize + 8;

  DestinationSet.decode = function(decoder) {
    var packed;
    var val = new DestinationSet();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.destinations =
        decoder.decodeArrayPointer(new codec.PointerTo(schemeful_site$.SchemefulSite));
    return val;
  };

  DestinationSet.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DestinationSet.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), val.destinations);
  };
  function EventReportWindows(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventReportWindows.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTimes = null;
  };
  EventReportWindows.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventReportWindows.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventReportWindows.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventReportWindows.endTimes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(time$.TimeDelta), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventReportWindows.encodedSize = codec.kStructHeaderSize + 16;

  EventReportWindows.decode = function(decoder) {
    var packed;
    var val = new EventReportWindows();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.endTimes =
        decoder.decodeArrayPointer(new codec.PointerTo(time$.TimeDelta));
    return val;
  };

  EventReportWindows.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventReportWindows.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.startTime);
    encoder.encodeArrayPointer(new codec.PointerTo(time$.TimeDelta), val.endTimes);
  };
  function TriggerDataSet(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TriggerDataSet.prototype.initDefaults_ = function() {
    this.triggerData = null;
  };
  TriggerDataSet.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TriggerDataSet.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerDataSet.triggerData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TriggerDataSet.encodedSize = codec.kStructHeaderSize + 8;

  TriggerDataSet.decode = function(decoder) {
    var packed;
    var val = new TriggerDataSet();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.triggerData =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  TriggerDataSet.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TriggerDataSet.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.triggerData);
  };
  function AggregatableDebugReportingContribution(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableDebugReportingContribution.prototype.initDefaults_ = function() {
    this.keyPiece = null;
    this.value = 0;
  };
  AggregatableDebugReportingContribution.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableDebugReportingContribution.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableDebugReportingContribution.keyPiece
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, int128$.Uint128, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AggregatableDebugReportingContribution.encodedSize = codec.kStructHeaderSize + 16;

  AggregatableDebugReportingContribution.decode = function(decoder) {
    var packed;
    var val = new AggregatableDebugReportingContribution();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyPiece =
        decoder.decodeStructPointer(int128$.Uint128);
    val.value =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AggregatableDebugReportingContribution.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableDebugReportingContribution.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(int128$.Uint128, val.keyPiece);
    encoder.encodeStruct(codec.Uint32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AggregatableDebugReportingConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableDebugReportingConfig.prototype.initDefaults_ = function() {
    this.keyPiece = null;
    this.debugData = null;
    this.aggregationCoordinatorOrigin = null;
  };
  AggregatableDebugReportingConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableDebugReportingConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableDebugReportingConfig.keyPiece
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, int128$.Uint128, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableDebugReportingConfig.debugData
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.Enum(debug_types$.DebugDataType), new codec.PointerTo(AggregatableDebugReportingContribution), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableDebugReportingConfig.aggregationCoordinatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, SuitableOrigin, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatableDebugReportingConfig.encodedSize = codec.kStructHeaderSize + 24;

  AggregatableDebugReportingConfig.decode = function(decoder) {
    var packed;
    var val = new AggregatableDebugReportingConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyPiece =
        decoder.decodeStructPointer(int128$.Uint128);
    val.debugData =
        decoder.decodeMapPointer(new codec.Enum(debug_types$.DebugDataType), new codec.PointerTo(AggregatableDebugReportingContribution));
    val.aggregationCoordinatorOrigin =
        decoder.decodeStructPointer(SuitableOrigin);
    return val;
  };

  AggregatableDebugReportingConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableDebugReportingConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(int128$.Uint128, val.keyPiece);
    encoder.encodeMapPointer(new codec.Enum(debug_types$.DebugDataType), new codec.PointerTo(AggregatableDebugReportingContribution), val.debugData);
    encoder.encodeStructPointer(SuitableOrigin, val.aggregationCoordinatorOrigin);
  };
  function SourceAggregatableDebugReportingConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SourceAggregatableDebugReportingConfig.prototype.initDefaults_ = function() {
    this.budget = 0;
    this.config = null;
  };
  SourceAggregatableDebugReportingConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SourceAggregatableDebugReportingConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SourceAggregatableDebugReportingConfig.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AggregatableDebugReportingConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SourceAggregatableDebugReportingConfig.encodedSize = codec.kStructHeaderSize + 16;

  SourceAggregatableDebugReportingConfig.decode = function(decoder) {
    var packed;
    var val = new SourceAggregatableDebugReportingConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.budget =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.config =
        decoder.decodeStructPointer(AggregatableDebugReportingConfig);
    return val;
  };

  SourceAggregatableDebugReportingConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SourceAggregatableDebugReportingConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.budget);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AggregatableDebugReportingConfig, val.config);
  };
  function AttributionScopesSet(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionScopesSet.prototype.initDefaults_ = function() {
    this.scopes = null;
  };
  AttributionScopesSet.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionScopesSet.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionScopesSet.scopes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AttributionScopesSet.encodedSize = codec.kStructHeaderSize + 8;

  AttributionScopesSet.decode = function(decoder) {
    var packed;
    var val = new AttributionScopesSet();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scopes =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  AttributionScopesSet.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionScopesSet.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.scopes);
  };
  function AttributionScopesData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionScopesData.prototype.initDefaults_ = function() {
    this.attributionScopesSet = null;
    this.attributionScopeLimit = 0;
    this.maxEventStates = 0;
  };
  AttributionScopesData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionScopesData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionScopesData.attributionScopesSet
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AttributionScopesSet, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AttributionScopesData.encodedSize = codec.kStructHeaderSize + 16;

  AttributionScopesData.decode = function(decoder) {
    var packed;
    var val = new AttributionScopesData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.attributionScopesSet =
        decoder.decodeStructPointer(AttributionScopesSet);
    val.attributionScopeLimit =
        decoder.decodeStruct(codec.Uint32);
    val.maxEventStates =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AttributionScopesData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionScopesData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AttributionScopesSet, val.attributionScopesSet);
    encoder.encodeStruct(codec.Uint32, val.attributionScopeLimit);
    encoder.encodeStruct(codec.Uint32, val.maxEventStates);
  };
  function AggregatableNamedBudgetDefs(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableNamedBudgetDefs.prototype.initDefaults_ = function() {
    this.budgets = null;
  };
  AggregatableNamedBudgetDefs.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableNamedBudgetDefs.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableNamedBudgetDefs.budgets
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, codec.Int32, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatableNamedBudgetDefs.encodedSize = codec.kStructHeaderSize + 8;

  AggregatableNamedBudgetDefs.decode = function(decoder) {
    var packed;
    var val = new AggregatableNamedBudgetDefs();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.budgets =
        decoder.decodeMapPointer(codec.String, codec.Int32);
    return val;
  };

  AggregatableNamedBudgetDefs.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableNamedBudgetDefs.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, codec.Int32, val.budgets);
  };
  function SourceRegistration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SourceRegistration.prototype.initDefaults_ = function() {
    this.destinations = null;
    this.sourceEventId = 0;
    this.expiry = null;
    this.triggerData = null;
    this.eventReportWindows = null;
    this.maxEventLevelReports = 0;
    this.debug_key_$flag = false;
    this.debugReporting = false;
    this.aggregatableReportWindow = null;
    this.priority = 0;
    this.debug_key_$value = 0;
    this.filterData = null;
    this.aggregationKeys = null;
    this.triggerDataMatching = 0;
    this.eventLevelEpsilon = 0;
    this.aggregatableDebugReportingConfig = null;
    this.destinationLimitPriority = 0;
    this.attributionScopesData = null;
    this.aggregatableNamedBudgetDefs = null;
  };
  SourceRegistration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SourceRegistration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SourceRegistration.destinations
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DestinationSet, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SourceRegistration.expiry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SourceRegistration.triggerData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, TriggerDataSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SourceRegistration.eventReportWindows
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, EventReportWindows, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SourceRegistration.aggregatableReportWindow
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate SourceRegistration.filterData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, FilterData, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SourceRegistration.aggregationKeys
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, AggregationKeys, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SourceRegistration.triggerDataMatching
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 88, trigger_data_matching$.TriggerDataMatching);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SourceRegistration.aggregatableDebugReportingConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, SourceAggregatableDebugReportingConfig, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SourceRegistration.attributionScopesData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, AttributionScopesData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SourceRegistration.aggregatableNamedBudgetDefs
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, AggregatableNamedBudgetDefs, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SourceRegistration.encodedSize = codec.kStructHeaderSize + 136;

  SourceRegistration.decode = function(decoder) {
    var packed;
    var val = new SourceRegistration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.destinations =
        decoder.decodeStructPointer(DestinationSet);
    val.sourceEventId =
        decoder.decodeStruct(codec.Uint64);
    val.expiry =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.triggerData =
        decoder.decodeStructPointer(TriggerDataSet);
    val.eventReportWindows =
        decoder.decodeStructPointer(EventReportWindows);
    val.maxEventLevelReports =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.debug_key_$flag = (packed >> 0) & 1 ? true : false;
    val.debugReporting = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.aggregatableReportWindow =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.priority =
        decoder.decodeStruct(codec.Int64);
    val.debug_key_$value =
        decoder.decodeStruct(codec.Uint64);
    val.filterData =
        decoder.decodeStructPointer(FilterData);
    val.aggregationKeys =
        decoder.decodeStructPointer(AggregationKeys);
    val.triggerDataMatching =
        decoder.decodeStruct(new codec.Enum(trigger_data_matching$.TriggerDataMatching));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.eventLevelEpsilon =
        decoder.decodeStruct(codec.Double);
    val.aggregatableDebugReportingConfig =
        decoder.decodeStructPointer(SourceAggregatableDebugReportingConfig);
    val.destinationLimitPriority =
        decoder.decodeStruct(codec.Int64);
    val.attributionScopesData =
        decoder.decodeStructPointer(AttributionScopesData);
    val.aggregatableNamedBudgetDefs =
        decoder.decodeStructPointer(AggregatableNamedBudgetDefs);
    return val;
  };

  SourceRegistration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SourceRegistration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DestinationSet, val.destinations);
    encoder.encodeStruct(codec.Uint64, val.sourceEventId);
    encoder.encodeStructPointer(time$.TimeDelta, val.expiry);
    encoder.encodeStructPointer(TriggerDataSet, val.triggerData);
    encoder.encodeStructPointer(EventReportWindows, val.eventReportWindows);
    encoder.encodeStruct(codec.Int32, val.maxEventLevelReports);
    packed = 0;
    packed |= (val.debug_key_$flag & 1) << 0
    packed |= (val.debugReporting & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.aggregatableReportWindow);
    encoder.encodeStruct(codec.Int64, val.priority);
    encoder.encodeStruct(codec.Uint64, val.debug_key_$value);
    encoder.encodeStructPointer(FilterData, val.filterData);
    encoder.encodeStructPointer(AggregationKeys, val.aggregationKeys);
    encoder.encodeStruct(codec.Int32, val.triggerDataMatching);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.eventLevelEpsilon);
    encoder.encodeStructPointer(SourceAggregatableDebugReportingConfig, val.aggregatableDebugReportingConfig);
    encoder.encodeStruct(codec.Int64, val.destinationLimitPriority);
    encoder.encodeStructPointer(AttributionScopesData, val.attributionScopesData);
    encoder.encodeStructPointer(AggregatableNamedBudgetDefs, val.aggregatableNamedBudgetDefs);
  };
  function EventTriggerData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventTriggerData.prototype.initDefaults_ = function() {
    this.data = 0;
    this.priority = 0;
    this.dedup_key_$flag = false;
    this.dedup_key_$value = 0;
    this.filters = null;
  };
  EventTriggerData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventTriggerData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate EventTriggerData.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, FilterPair, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventTriggerData.encodedSize = codec.kStructHeaderSize + 40;

  EventTriggerData.decode = function(decoder) {
    var packed;
    var val = new EventTriggerData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(codec.Uint64);
    val.priority =
        decoder.decodeStruct(codec.Int64);
    packed = decoder.readUint8();
    val.dedup_key_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dedup_key_$value =
        decoder.decodeStruct(codec.Uint64);
    val.filters =
        decoder.decodeStructPointer(FilterPair);
    return val;
  };

  EventTriggerData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventTriggerData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.data);
    encoder.encodeStruct(codec.Int64, val.priority);
    packed = 0;
    packed |= (val.dedup_key_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.dedup_key_$value);
    encoder.encodeStructPointer(FilterPair, val.filters);
  };
  function AggregatableDedupKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableDedupKey.prototype.initDefaults_ = function() {
    this.dedup_key_$flag = false;
    this.dedup_key_$value = 0;
    this.filters = null;
  };
  AggregatableDedupKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableDedupKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AggregatableDedupKey.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, FilterPair, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatableDedupKey.encodedSize = codec.kStructHeaderSize + 24;

  AggregatableDedupKey.decode = function(decoder) {
    var packed;
    var val = new AggregatableDedupKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.dedup_key_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dedup_key_$value =
        decoder.decodeStruct(codec.Uint64);
    val.filters =
        decoder.decodeStructPointer(FilterPair);
    return val;
  };

  AggregatableDedupKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableDedupKey.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.dedup_key_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.dedup_key_$value);
    encoder.encodeStructPointer(FilterPair, val.filters);
  };
  function AggregatableValuesValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableValuesValue.prototype.initDefaults_ = function() {
    this.value = 0;
    this.filteringId = 0;
  };
  AggregatableValuesValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableValuesValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AggregatableValuesValue.encodedSize = codec.kStructHeaderSize + 16;

  AggregatableValuesValue.decode = function(decoder) {
    var packed;
    var val = new AggregatableValuesValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.filteringId =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  AggregatableValuesValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableValuesValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.filteringId);
  };
  function AggregatableValues(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableValues.prototype.initDefaults_ = function() {
    this.values = null;
    this.filters = null;
  };
  AggregatableValues.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableValues.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableValues.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(AggregatableValuesValue), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableValues.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, FilterPair, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatableValues.encodedSize = codec.kStructHeaderSize + 16;

  AggregatableValues.decode = function(decoder) {
    var packed;
    var val = new AggregatableValues();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(AggregatableValuesValue));
    val.filters =
        decoder.decodeStructPointer(FilterPair);
    return val;
  };

  AggregatableValues.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableValues.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(AggregatableValuesValue), val.values);
    encoder.encodeStructPointer(FilterPair, val.filters);
  };
  function AggregatableNamedBudgetCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatableNamedBudgetCandidate.prototype.initDefaults_ = function() {
    this.name = null;
    this.filters = null;
  };
  AggregatableNamedBudgetCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatableNamedBudgetCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableNamedBudgetCandidate.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatableNamedBudgetCandidate.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, FilterPair, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatableNamedBudgetCandidate.encodedSize = codec.kStructHeaderSize + 16;

  AggregatableNamedBudgetCandidate.decode = function(decoder) {
    var packed;
    var val = new AggregatableNamedBudgetCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.filters =
        decoder.decodeStructPointer(FilterPair);
    return val;
  };

  AggregatableNamedBudgetCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatableNamedBudgetCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(FilterPair, val.filters);
  };
  function TriggerRegistration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TriggerRegistration.prototype.initDefaults_ = function() {
    this.eventTriggers = null;
    this.filters = null;
    this.aggregatableTriggerData = null;
    this.aggregatableValues = null;
    this.debug_key_$flag = false;
    this.debugReporting = false;
    this.aggregatableFilteringIdMaxBytes = 0;
    this.sourceRegistrationTimeConfig = 0;
    this.debug_key_$value = 0;
    this.aggregatableDedupKeys = null;
    this.aggregationCoordinatorOrigin = null;
    this.triggerContextId = null;
    this.aggregatableDebugReportingConfig = null;
    this.attributionScopes = null;
    this.aggregatableNamedBudgetCandidates = null;
  };
  TriggerRegistration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TriggerRegistration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.eventTriggers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(EventTriggerData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, FilterPair, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.aggregatableTriggerData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(AggregatableTriggerData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.aggregatableValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(AggregatableValues), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate TriggerRegistration.aggregatableDedupKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(AggregatableDedupKey), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TriggerRegistration.aggregationCoordinatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, SuitableOrigin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.sourceRegistrationTimeConfig
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, source_registration_time_config$.SourceRegistrationTimeConfig);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.triggerContextId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate TriggerRegistration.aggregatableDebugReportingConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, AggregatableDebugReportingConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.attributionScopes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, AttributionScopesSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TriggerRegistration.aggregatableNamedBudgetCandidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 88, 8, new codec.PointerTo(AggregatableNamedBudgetCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TriggerRegistration.encodedSize = codec.kStructHeaderSize + 96;

  TriggerRegistration.decode = function(decoder) {
    var packed;
    var val = new TriggerRegistration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventTriggers =
        decoder.decodeArrayPointer(new codec.PointerTo(EventTriggerData));
    val.filters =
        decoder.decodeStructPointer(FilterPair);
    val.aggregatableTriggerData =
        decoder.decodeArrayPointer(new codec.PointerTo(AggregatableTriggerData));
    val.aggregatableValues =
        decoder.decodeArrayPointer(new codec.PointerTo(AggregatableValues));
    packed = decoder.readUint8();
    val.debug_key_$flag = (packed >> 0) & 1 ? true : false;
    val.debugReporting = (packed >> 1) & 1 ? true : false;
    val.aggregatableFilteringIdMaxBytes =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    val.sourceRegistrationTimeConfig =
        decoder.decodeStruct(new codec.Enum(source_registration_time_config$.SourceRegistrationTimeConfig));
    val.debug_key_$value =
        decoder.decodeStruct(codec.Uint64);
    val.aggregatableDedupKeys =
        decoder.decodeArrayPointer(new codec.PointerTo(AggregatableDedupKey));
    val.aggregationCoordinatorOrigin =
        decoder.decodeStructPointer(SuitableOrigin);
    val.triggerContextId =
        decoder.decodeStruct(codec.String);
    val.aggregatableDebugReportingConfig =
        decoder.decodeStructPointer(AggregatableDebugReportingConfig);
    val.attributionScopes =
        decoder.decodeStructPointer(AttributionScopesSet);
    val.aggregatableNamedBudgetCandidates =
        decoder.decodeArrayPointer(new codec.PointerTo(AggregatableNamedBudgetCandidate));
    return val;
  };

  TriggerRegistration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TriggerRegistration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(EventTriggerData), val.eventTriggers);
    encoder.encodeStructPointer(FilterPair, val.filters);
    encoder.encodeArrayPointer(new codec.PointerTo(AggregatableTriggerData), val.aggregatableTriggerData);
    encoder.encodeArrayPointer(new codec.PointerTo(AggregatableValues), val.aggregatableValues);
    packed = 0;
    packed |= (val.debug_key_$flag & 1) << 0
    packed |= (val.debugReporting & 1) << 1
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.aggregatableFilteringIdMaxBytes);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.sourceRegistrationTimeConfig);
    encoder.encodeStruct(codec.Uint64, val.debug_key_$value);
    encoder.encodeArrayPointer(new codec.PointerTo(AggregatableDedupKey), val.aggregatableDedupKeys);
    encoder.encodeStructPointer(SuitableOrigin, val.aggregationCoordinatorOrigin);
    encoder.encodeStruct(codec.String, val.triggerContextId);
    encoder.encodeStructPointer(AggregatableDebugReportingConfig, val.aggregatableDebugReportingConfig);
    encoder.encodeStructPointer(AttributionScopesSet, val.attributionScopes);
    encoder.encodeArrayPointer(new codec.PointerTo(AggregatableNamedBudgetCandidate), val.aggregatableNamedBudgetCandidates);
  };
  function OsRegistrationItem(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OsRegistrationItem.prototype.initDefaults_ = function() {
    this.url = null;
    this.debugReporting = false;
  };
  OsRegistrationItem.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OsRegistrationItem.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OsRegistrationItem.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OsRegistrationItem.encodedSize = codec.kStructHeaderSize + 16;

  OsRegistrationItem.decode = function(decoder) {
    var packed;
    var val = new OsRegistrationItem();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.debugReporting = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OsRegistrationItem.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OsRegistrationItem.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    packed = 0;
    packed |= (val.debugReporting & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OsRegistration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OsRegistration.prototype.initDefaults_ = function() {
    this.items = null;
  };
  OsRegistration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OsRegistration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OsRegistration.items
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(OsRegistrationItem), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OsRegistration.encodedSize = codec.kStructHeaderSize + 8;

  OsRegistration.decode = function(decoder) {
    var packed;
    var val = new OsRegistration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.items =
        decoder.decodeArrayPointer(new codec.PointerTo(OsRegistrationItem));
    return val;
  };

  OsRegistration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OsRegistration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(OsRegistrationItem), val.items);
  };
  exports.SuitableOrigin = SuitableOrigin;
  exports.FilterData = FilterData;
  exports.FilterConfig = FilterConfig;
  exports.FilterPair = FilterPair;
  exports.AggregationKeys = AggregationKeys;
  exports.AggregatableTriggerData = AggregatableTriggerData;
  exports.DestinationSet = DestinationSet;
  exports.EventReportWindows = EventReportWindows;
  exports.TriggerDataSet = TriggerDataSet;
  exports.AggregatableDebugReportingContribution = AggregatableDebugReportingContribution;
  exports.AggregatableDebugReportingConfig = AggregatableDebugReportingConfig;
  exports.SourceAggregatableDebugReportingConfig = SourceAggregatableDebugReportingConfig;
  exports.AttributionScopesSet = AttributionScopesSet;
  exports.AttributionScopesData = AttributionScopesData;
  exports.AggregatableNamedBudgetDefs = AggregatableNamedBudgetDefs;
  exports.SourceRegistration = SourceRegistration;
  exports.EventTriggerData = EventTriggerData;
  exports.AggregatableDedupKey = AggregatableDedupKey;
  exports.AggregatableValuesValue = AggregatableValuesValue;
  exports.AggregatableValues = AggregatableValues;
  exports.AggregatableNamedBudgetCandidate = AggregatableNamedBudgetCandidate;
  exports.TriggerRegistration = TriggerRegistration;
  exports.OsRegistrationItem = OsRegistrationItem;
  exports.OsRegistration = OsRegistration;
})();