// components/attribution_reporting/registration.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_BLINK_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/attribution_reporting/registration.mojom-features.h"  // IWYU pragma: export
#include "components/attribution_reporting/registration.mojom-shared.h"  // IWYU pragma: export
#include "components/attribution_reporting/registration.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/attribution_reporting/source_registration_time_config.mojom-blink-forward.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-blink-forward.h"
#include "components/attribution_reporting/debug_types.mojom-blink.h"
#include "mojo/public/mojom/base/int128.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/schemeful_site.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "components/attribution_reporting/registration_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace attribution_reporting::mojom::blink {























class PLATFORM_EXPORT AggregatableValuesValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableValuesValue, T>::value>;
  using DataView = AggregatableValuesValueDataView;
  using Data_ = internal::AggregatableValuesValue_Data;

  template <typename... Args>
  static AggregatableValuesValuePtr New(Args&&... args) {
    return AggregatableValuesValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableValuesValuePtr From(const U& u) {
    return mojo::TypeConverter<AggregatableValuesValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableValuesValue>::Convert(*this);
  }


  AggregatableValuesValue();

  AggregatableValuesValue(
      uint32_t value,
      uint64_t filtering_id);


  ~AggregatableValuesValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableValuesValuePtr>
  AggregatableValuesValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableValuesValue::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableValuesValue::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableValuesValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableValuesValue_UnserializedMessageContext<
            UserType, AggregatableValuesValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableValuesValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableValuesValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableValuesValue_UnserializedMessageContext<
            UserType, AggregatableValuesValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableValuesValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t value;
  
  uint64_t filtering_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableValuesValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class PLATFORM_EXPORT SuitableOrigin {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SuitableOrigin, T>::value>;
  using DataView = SuitableOriginDataView;
  using Data_ = internal::SuitableOrigin_Data;

  template <typename... Args>
  static SuitableOriginPtr New(Args&&... args) {
    return SuitableOriginPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SuitableOriginPtr From(const U& u) {
    return mojo::TypeConverter<SuitableOriginPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SuitableOrigin>::Convert(*this);
  }


  SuitableOrigin();

  explicit SuitableOrigin(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin);


  ~SuitableOrigin();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SuitableOriginPtr>
  SuitableOriginPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuitableOrigin::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuitableOrigin::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SuitableOrigin::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SuitableOrigin_UnserializedMessageContext<
            UserType, SuitableOrigin::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SuitableOrigin::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SuitableOrigin::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SuitableOrigin_UnserializedMessageContext<
            UserType, SuitableOrigin::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SuitableOrigin::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SuitableOrigin::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FilterData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FilterData, T>::value>;
  using DataView = FilterDataDataView;
  using Data_ = internal::FilterData_Data;

  template <typename... Args>
  static FilterDataPtr New(Args&&... args) {
    return FilterDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilterDataPtr From(const U& u) {
    return mojo::TypeConverter<FilterDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilterData>::Convert(*this);
  }


  FilterData();

  explicit FilterData(
      const ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>>& filter_values);


  ~FilterData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilterDataPtr>
  FilterDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FilterData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FilterData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FilterData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilterData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FilterData_UnserializedMessageContext<
            UserType, FilterData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FilterData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FilterData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FilterData_UnserializedMessageContext<
            UserType, FilterData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FilterData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>> filter_values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FilterData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FilterData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FilterData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FilterData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FilterConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FilterConfig, T>::value>;
  using DataView = FilterConfigDataView;
  using Data_ = internal::FilterConfig_Data;

  template <typename... Args>
  static FilterConfigPtr New(Args&&... args) {
    return FilterConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilterConfigPtr From(const U& u) {
    return mojo::TypeConverter<FilterConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilterConfig>::Convert(*this);
  }


  FilterConfig();

  FilterConfig(
      std::optional<::base::TimeDelta> lookback_window,
      const ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>>& filter_values);


  ~FilterConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilterConfigPtr>
  FilterConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilterConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FilterConfig_UnserializedMessageContext<
            UserType, FilterConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FilterConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FilterConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FilterConfig_UnserializedMessageContext<
            UserType, FilterConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FilterConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> lookback_window;
  
  ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>> filter_values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FilterConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FilterPair {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FilterPair, T>::value>;
  using DataView = FilterPairDataView;
  using Data_ = internal::FilterPair_Data;

  template <typename... Args>
  static FilterPairPtr New(Args&&... args) {
    return FilterPairPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilterPairPtr From(const U& u) {
    return mojo::TypeConverter<FilterPairPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilterPair>::Convert(*this);
  }


  FilterPair();

  FilterPair(
      ::blink::Vector<FilterConfigPtr> positive,
      ::blink::Vector<FilterConfigPtr> negative);

FilterPair(const FilterPair&) = delete;
FilterPair& operator=(const FilterPair&) = delete;

  ~FilterPair();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilterPairPtr>
  FilterPairPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterPair::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterPair::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilterPair::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FilterPair_UnserializedMessageContext<
            UserType, FilterPair::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FilterPair::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FilterPair::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FilterPair_UnserializedMessageContext<
            UserType, FilterPair::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FilterPair::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<FilterConfigPtr> positive;
  
  ::blink::Vector<FilterConfigPtr> negative;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FilterPair::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregationKeys {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregationKeys, T>::value>;
  using DataView = AggregationKeysDataView;
  using Data_ = internal::AggregationKeys_Data;

  template <typename... Args>
  static AggregationKeysPtr New(Args&&... args) {
    return AggregationKeysPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregationKeysPtr From(const U& u) {
    return mojo::TypeConverter<AggregationKeysPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregationKeys>::Convert(*this);
  }


  AggregationKeys();

  explicit AggregationKeys(
      const ::blink::HashMap<::blink::String, ::absl::uint128>& keys);


  ~AggregationKeys();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregationKeysPtr>
  AggregationKeysPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregationKeys::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregationKeys::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregationKeys::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregationKeys_UnserializedMessageContext<
            UserType, AggregationKeys::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregationKeys::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregationKeys::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregationKeys_UnserializedMessageContext<
            UserType, AggregationKeys::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregationKeys::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::String, ::absl::uint128> keys;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregationKeys::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregatableTriggerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableTriggerData, T>::value>;
  using DataView = AggregatableTriggerDataDataView;
  using Data_ = internal::AggregatableTriggerData_Data;

  template <typename... Args>
  static AggregatableTriggerDataPtr New(Args&&... args) {
    return AggregatableTriggerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableTriggerDataPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableTriggerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableTriggerData>::Convert(*this);
  }


  AggregatableTriggerData();

  AggregatableTriggerData(
      const ::absl::uint128& key_piece,
      ::blink::Vector<::blink::String> source_keys,
      const ::attribution_reporting::FilterPair& filters);


  ~AggregatableTriggerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableTriggerDataPtr>
  AggregatableTriggerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableTriggerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableTriggerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableTriggerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableTriggerData_UnserializedMessageContext<
            UserType, AggregatableTriggerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableTriggerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableTriggerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableTriggerData_UnserializedMessageContext<
            UserType, AggregatableTriggerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableTriggerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::absl::uint128 key_piece;
  
  ::blink::Vector<::blink::String> source_keys;
  
  ::attribution_reporting::FilterPair filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableTriggerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DestinationSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DestinationSet, T>::value>;
  using DataView = DestinationSetDataView;
  using Data_ = internal::DestinationSet_Data;

  template <typename... Args>
  static DestinationSetPtr New(Args&&... args) {
    return DestinationSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DestinationSetPtr From(const U& u) {
    return mojo::TypeConverter<DestinationSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DestinationSet>::Convert(*this);
  }


  DestinationSet();

  explicit DestinationSet(
      ::blink::Vector<::blink::BlinkSchemefulSite> destinations);


  ~DestinationSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DestinationSetPtr>
  DestinationSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DestinationSet::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DestinationSet::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DestinationSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DestinationSet_UnserializedMessageContext<
            UserType, DestinationSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DestinationSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DestinationSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DestinationSet_UnserializedMessageContext<
            UserType, DestinationSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DestinationSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::BlinkSchemefulSite> destinations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DestinationSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT EventReportWindows {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventReportWindows, T>::value>;
  using DataView = EventReportWindowsDataView;
  using Data_ = internal::EventReportWindows_Data;

  template <typename... Args>
  static EventReportWindowsPtr New(Args&&... args) {
    return EventReportWindowsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventReportWindowsPtr From(const U& u) {
    return mojo::TypeConverter<EventReportWindowsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventReportWindows>::Convert(*this);
  }


  EventReportWindows();

  EventReportWindows(
      ::base::TimeDelta start_time,
      ::blink::Vector<::base::TimeDelta> end_times);


  ~EventReportWindows();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventReportWindowsPtr>
  EventReportWindowsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventReportWindows::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventReportWindows::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventReportWindows::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventReportWindows_UnserializedMessageContext<
            UserType, EventReportWindows::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventReportWindows::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventReportWindows::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventReportWindows_UnserializedMessageContext<
            UserType, EventReportWindows::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventReportWindows::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta start_time;
  
  ::blink::Vector<::base::TimeDelta> end_times;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventReportWindows::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT TriggerDataSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TriggerDataSet, T>::value>;
  using DataView = TriggerDataSetDataView;
  using Data_ = internal::TriggerDataSet_Data;

  template <typename... Args>
  static TriggerDataSetPtr New(Args&&... args) {
    return TriggerDataSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TriggerDataSetPtr From(const U& u) {
    return mojo::TypeConverter<TriggerDataSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TriggerDataSet>::Convert(*this);
  }


  TriggerDataSet();

  explicit TriggerDataSet(
      ::blink::Vector<uint32_t> trigger_data);


  ~TriggerDataSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TriggerDataSetPtr>
  TriggerDataSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TriggerDataSet::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TriggerDataSet::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TriggerDataSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TriggerDataSet_UnserializedMessageContext<
            UserType, TriggerDataSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TriggerDataSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TriggerDataSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TriggerDataSet_UnserializedMessageContext<
            UserType, TriggerDataSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TriggerDataSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<uint32_t> trigger_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TriggerDataSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregatableDebugReportingContribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableDebugReportingContribution, T>::value>;
  using DataView = AggregatableDebugReportingContributionDataView;
  using Data_ = internal::AggregatableDebugReportingContribution_Data;

  template <typename... Args>
  static AggregatableDebugReportingContributionPtr New(Args&&... args) {
    return AggregatableDebugReportingContributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableDebugReportingContributionPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableDebugReportingContributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableDebugReportingContribution>::Convert(*this);
  }


  AggregatableDebugReportingContribution();

  AggregatableDebugReportingContribution(
      const ::absl::uint128& key_piece,
      uint32_t value);


  ~AggregatableDebugReportingContribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableDebugReportingContributionPtr>
  AggregatableDebugReportingContributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableDebugReportingContribution::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableDebugReportingContribution::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableDebugReportingContribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableDebugReportingContribution_UnserializedMessageContext<
            UserType, AggregatableDebugReportingContribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableDebugReportingContribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableDebugReportingContribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableDebugReportingContribution_UnserializedMessageContext<
            UserType, AggregatableDebugReportingContribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableDebugReportingContribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::absl::uint128 key_piece;
  
  uint32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregatableDebugReportingConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableDebugReportingConfig, T>::value>;
  using DataView = AggregatableDebugReportingConfigDataView;
  using Data_ = internal::AggregatableDebugReportingConfig_Data;

  template <typename... Args>
  static AggregatableDebugReportingConfigPtr New(Args&&... args) {
    return AggregatableDebugReportingConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableDebugReportingConfigPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableDebugReportingConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableDebugReportingConfig>::Convert(*this);
  }


  AggregatableDebugReportingConfig();

  AggregatableDebugReportingConfig(
      const ::absl::uint128& key_piece,
      const ::blink::HashMap<::attribution_reporting::mojom::blink::DebugDataType, ::attribution_reporting::AggregatableDebugReportingContribution>& debug_data,
      std::optional<::attribution_reporting::SuitableOrigin> aggregation_coordinator_origin);

AggregatableDebugReportingConfig(const AggregatableDebugReportingConfig&) = delete;
AggregatableDebugReportingConfig& operator=(const AggregatableDebugReportingConfig&) = delete;

  ~AggregatableDebugReportingConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableDebugReportingConfigPtr>
  AggregatableDebugReportingConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableDebugReportingConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableDebugReportingConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableDebugReportingConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableDebugReportingConfig_UnserializedMessageContext<
            UserType, AggregatableDebugReportingConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableDebugReportingConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableDebugReportingConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableDebugReportingConfig_UnserializedMessageContext<
            UserType, AggregatableDebugReportingConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableDebugReportingConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::absl::uint128 key_piece;
  
  ::blink::HashMap<::attribution_reporting::mojom::blink::DebugDataType, ::attribution_reporting::AggregatableDebugReportingContribution> debug_data;
  
  std::optional<::attribution_reporting::SuitableOrigin> aggregation_coordinator_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SourceAggregatableDebugReportingConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SourceAggregatableDebugReportingConfig, T>::value>;
  using DataView = SourceAggregatableDebugReportingConfigDataView;
  using Data_ = internal::SourceAggregatableDebugReportingConfig_Data;

  template <typename... Args>
  static SourceAggregatableDebugReportingConfigPtr New(Args&&... args) {
    return SourceAggregatableDebugReportingConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SourceAggregatableDebugReportingConfigPtr From(const U& u) {
    return mojo::TypeConverter<SourceAggregatableDebugReportingConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SourceAggregatableDebugReportingConfig>::Convert(*this);
  }


  SourceAggregatableDebugReportingConfig();

  SourceAggregatableDebugReportingConfig(
      int32_t budget,
      const ::attribution_reporting::AggregatableDebugReportingConfig& config);


  ~SourceAggregatableDebugReportingConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SourceAggregatableDebugReportingConfigPtr>
  SourceAggregatableDebugReportingConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SourceAggregatableDebugReportingConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SourceAggregatableDebugReportingConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SourceAggregatableDebugReportingConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SourceAggregatableDebugReportingConfig_UnserializedMessageContext<
            UserType, SourceAggregatableDebugReportingConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SourceAggregatableDebugReportingConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SourceAggregatableDebugReportingConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SourceAggregatableDebugReportingConfig_UnserializedMessageContext<
            UserType, SourceAggregatableDebugReportingConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SourceAggregatableDebugReportingConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t budget;
  
  ::attribution_reporting::AggregatableDebugReportingConfig config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AttributionScopesSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttributionScopesSet, T>::value>;
  using DataView = AttributionScopesSetDataView;
  using Data_ = internal::AttributionScopesSet_Data;

  template <typename... Args>
  static AttributionScopesSetPtr New(Args&&... args) {
    return AttributionScopesSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttributionScopesSetPtr From(const U& u) {
    return mojo::TypeConverter<AttributionScopesSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttributionScopesSet>::Convert(*this);
  }


  AttributionScopesSet();

  explicit AttributionScopesSet(
      ::blink::Vector<::blink::String> scopes);


  ~AttributionScopesSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttributionScopesSetPtr>
  AttributionScopesSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionScopesSet::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionScopesSet::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttributionScopesSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttributionScopesSet_UnserializedMessageContext<
            UserType, AttributionScopesSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttributionScopesSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttributionScopesSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttributionScopesSet_UnserializedMessageContext<
            UserType, AttributionScopesSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttributionScopesSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> scopes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttributionScopesSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AttributionScopesData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttributionScopesData, T>::value>;
  using DataView = AttributionScopesDataDataView;
  using Data_ = internal::AttributionScopesData_Data;

  template <typename... Args>
  static AttributionScopesDataPtr New(Args&&... args) {
    return AttributionScopesDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttributionScopesDataPtr From(const U& u) {
    return mojo::TypeConverter<AttributionScopesDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttributionScopesData>::Convert(*this);
  }


  AttributionScopesData();

  AttributionScopesData(
      const ::attribution_reporting::AttributionScopesSet& attribution_scopes_set,
      uint32_t attribution_scope_limit,
      uint32_t max_event_states);


  ~AttributionScopesData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttributionScopesDataPtr>
  AttributionScopesDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionScopesData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionScopesData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttributionScopesData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttributionScopesData_UnserializedMessageContext<
            UserType, AttributionScopesData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttributionScopesData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttributionScopesData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttributionScopesData_UnserializedMessageContext<
            UserType, AttributionScopesData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttributionScopesData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::attribution_reporting::AttributionScopesSet attribution_scopes_set;
  
  uint32_t attribution_scope_limit;
  
  uint32_t max_event_states;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttributionScopesData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregatableNamedBudgetDefs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableNamedBudgetDefs, T>::value>;
  using DataView = AggregatableNamedBudgetDefsDataView;
  using Data_ = internal::AggregatableNamedBudgetDefs_Data;

  template <typename... Args>
  static AggregatableNamedBudgetDefsPtr New(Args&&... args) {
    return AggregatableNamedBudgetDefsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableNamedBudgetDefsPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableNamedBudgetDefsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableNamedBudgetDefs>::Convert(*this);
  }


  AggregatableNamedBudgetDefs();

  explicit AggregatableNamedBudgetDefs(
      const ::blink::HashMap<::blink::String, int32_t>& budgets);


  ~AggregatableNamedBudgetDefs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableNamedBudgetDefsPtr>
  AggregatableNamedBudgetDefsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableNamedBudgetDefs::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableNamedBudgetDefs::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableNamedBudgetDefs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableNamedBudgetDefs_UnserializedMessageContext<
            UserType, AggregatableNamedBudgetDefs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableNamedBudgetDefs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableNamedBudgetDefs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableNamedBudgetDefs_UnserializedMessageContext<
            UserType, AggregatableNamedBudgetDefs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableNamedBudgetDefs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::String, int32_t> budgets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SourceRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SourceRegistration, T>::value>;
  using DataView = SourceRegistrationDataView;
  using Data_ = internal::SourceRegistration_Data;

  template <typename... Args>
  static SourceRegistrationPtr New(Args&&... args) {
    return SourceRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SourceRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<SourceRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SourceRegistration>::Convert(*this);
  }


  SourceRegistration();

  SourceRegistration(
      const ::attribution_reporting::DestinationSet& destinations,
      uint64_t source_event_id,
      ::base::TimeDelta expiry,
      const ::attribution_reporting::TriggerDataSet& trigger_data,
      const ::attribution_reporting::EventReportWindows& event_report_windows,
      int32_t max_event_level_reports,
      ::base::TimeDelta aggregatable_report_window,
      int64_t priority,
      std::optional<uint64_t> debug_key,
      const ::attribution_reporting::FilterData& filter_data,
      const ::attribution_reporting::AggregationKeys& aggregation_keys,
      bool debug_reporting,
      ::attribution_reporting::mojom::blink::TriggerDataMatching trigger_data_matching,
      double event_level_epsilon,
      const ::attribution_reporting::SourceAggregatableDebugReportingConfig& aggregatable_debug_reporting_config,
      int64_t destination_limit_priority,
      const std::optional<::attribution_reporting::AttributionScopesData>& attribution_scopes_data,
      const ::attribution_reporting::AggregatableNamedBudgetDefs& aggregatable_named_budget_defs);


  ~SourceRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SourceRegistrationPtr>
  SourceRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SourceRegistration::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SourceRegistration::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SourceRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SourceRegistration_UnserializedMessageContext<
            UserType, SourceRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SourceRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SourceRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SourceRegistration_UnserializedMessageContext<
            UserType, SourceRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SourceRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::attribution_reporting::DestinationSet destinations;
  
  uint64_t source_event_id;
  
  ::base::TimeDelta expiry;
  
  ::attribution_reporting::TriggerDataSet trigger_data;
  
  ::attribution_reporting::EventReportWindows event_report_windows;
  
  int32_t max_event_level_reports;
  
  ::base::TimeDelta aggregatable_report_window;
  
  int64_t priority;
  
  std::optional<uint64_t> debug_key;
  
  ::attribution_reporting::FilterData filter_data;
  
  ::attribution_reporting::AggregationKeys aggregation_keys;
  
  bool debug_reporting;
  
  ::attribution_reporting::mojom::blink::TriggerDataMatching trigger_data_matching;
  
  double event_level_epsilon;
  
  ::attribution_reporting::SourceAggregatableDebugReportingConfig aggregatable_debug_reporting_config;
  
  int64_t destination_limit_priority;
  
  std::optional<::attribution_reporting::AttributionScopesData> attribution_scopes_data;
  
  ::attribution_reporting::AggregatableNamedBudgetDefs aggregatable_named_budget_defs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT EventTriggerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventTriggerData, T>::value>;
  using DataView = EventTriggerDataDataView;
  using Data_ = internal::EventTriggerData_Data;

  template <typename... Args>
  static EventTriggerDataPtr New(Args&&... args) {
    return EventTriggerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventTriggerDataPtr From(const U& u) {
    return mojo::TypeConverter<EventTriggerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventTriggerData>::Convert(*this);
  }


  EventTriggerData();

  EventTriggerData(
      uint64_t data,
      int64_t priority,
      std::optional<uint64_t> dedup_key,
      const ::attribution_reporting::FilterPair& filters);


  ~EventTriggerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventTriggerDataPtr>
  EventTriggerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventTriggerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventTriggerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventTriggerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventTriggerData_UnserializedMessageContext<
            UserType, EventTriggerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventTriggerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventTriggerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventTriggerData_UnserializedMessageContext<
            UserType, EventTriggerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventTriggerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t data;
  
  int64_t priority;
  
  std::optional<uint64_t> dedup_key;
  
  ::attribution_reporting::FilterPair filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventTriggerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregatableDedupKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableDedupKey, T>::value>;
  using DataView = AggregatableDedupKeyDataView;
  using Data_ = internal::AggregatableDedupKey_Data;

  template <typename... Args>
  static AggregatableDedupKeyPtr New(Args&&... args) {
    return AggregatableDedupKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableDedupKeyPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableDedupKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableDedupKey>::Convert(*this);
  }


  AggregatableDedupKey();

  AggregatableDedupKey(
      std::optional<uint64_t> dedup_key,
      const ::attribution_reporting::FilterPair& filters);


  ~AggregatableDedupKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableDedupKeyPtr>
  AggregatableDedupKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableDedupKey::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableDedupKey::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableDedupKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableDedupKey_UnserializedMessageContext<
            UserType, AggregatableDedupKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableDedupKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableDedupKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableDedupKey_UnserializedMessageContext<
            UserType, AggregatableDedupKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableDedupKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<uint64_t> dedup_key;
  
  ::attribution_reporting::FilterPair filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableDedupKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AggregatableValues {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableValues, T>::value>;
  using DataView = AggregatableValuesDataView;
  using Data_ = internal::AggregatableValues_Data;

  template <typename... Args>
  static AggregatableValuesPtr New(Args&&... args) {
    return AggregatableValuesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableValuesPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableValuesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableValues>::Convert(*this);
  }


  AggregatableValues();

  AggregatableValues(
      const ::blink::HashMap<::blink::String, ::attribution_reporting::AggregatableValuesValue>& values,
      const ::attribution_reporting::FilterPair& filters);


  ~AggregatableValues();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableValuesPtr>
  AggregatableValuesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableValues::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableValues::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableValues::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableValues_UnserializedMessageContext<
            UserType, AggregatableValues::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableValues::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableValues::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableValues_UnserializedMessageContext<
            UserType, AggregatableValues::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableValues::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::String, ::attribution_reporting::AggregatableValuesValue> values;
  
  ::attribution_reporting::FilterPair filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableValues::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AggregatableNamedBudgetCandidate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableNamedBudgetCandidate, T>::value>;
  using DataView = AggregatableNamedBudgetCandidateDataView;
  using Data_ = internal::AggregatableNamedBudgetCandidate_Data;

  template <typename... Args>
  static AggregatableNamedBudgetCandidatePtr New(Args&&... args) {
    return AggregatableNamedBudgetCandidatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableNamedBudgetCandidatePtr From(const U& u) {
    return mojo::TypeConverter<AggregatableNamedBudgetCandidatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableNamedBudgetCandidate>::Convert(*this);
  }


  AggregatableNamedBudgetCandidate();

  AggregatableNamedBudgetCandidate(
      const ::blink::String& name,
      const ::attribution_reporting::FilterPair& filters);


  ~AggregatableNamedBudgetCandidate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableNamedBudgetCandidatePtr>
  AggregatableNamedBudgetCandidatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableNamedBudgetCandidate::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableNamedBudgetCandidate::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableNamedBudgetCandidate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableNamedBudgetCandidate_UnserializedMessageContext<
            UserType, AggregatableNamedBudgetCandidate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableNamedBudgetCandidate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableNamedBudgetCandidate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableNamedBudgetCandidate_UnserializedMessageContext<
            UserType, AggregatableNamedBudgetCandidate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableNamedBudgetCandidate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::attribution_reporting::FilterPair filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT TriggerRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TriggerRegistration, T>::value>;
  using DataView = TriggerRegistrationDataView;
  using Data_ = internal::TriggerRegistration_Data;

  template <typename... Args>
  static TriggerRegistrationPtr New(Args&&... args) {
    return TriggerRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TriggerRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<TriggerRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TriggerRegistration>::Convert(*this);
  }


  TriggerRegistration();

  TriggerRegistration(
      ::blink::Vector<::attribution_reporting::EventTriggerData> event_triggers,
      const ::attribution_reporting::FilterPair& filters,
      ::blink::Vector<::attribution_reporting::AggregatableTriggerData> aggregatable_trigger_data,
      ::blink::Vector<::attribution_reporting::AggregatableValues> aggregatable_values,
      std::optional<uint64_t> debug_key,
      ::blink::Vector<::attribution_reporting::AggregatableDedupKey> aggregatable_dedup_keys,
      bool debug_reporting,
      std::optional<::attribution_reporting::SuitableOrigin> aggregation_coordinator_origin,
      ::attribution_reporting::mojom::blink::SourceRegistrationTimeConfig source_registration_time_config,
      const ::blink::String& trigger_context_id,
      uint8_t aggregatable_filtering_id_max_bytes,
      const ::attribution_reporting::AggregatableDebugReportingConfig& aggregatable_debug_reporting_config,
      const ::attribution_reporting::AttributionScopesSet& attribution_scopes,
      ::blink::Vector<::attribution_reporting::AggregatableNamedBudgetCandidate> aggregatable_named_budget_candidates);

TriggerRegistration(const TriggerRegistration&) = delete;
TriggerRegistration& operator=(const TriggerRegistration&) = delete;

  ~TriggerRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TriggerRegistrationPtr>
  TriggerRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TriggerRegistration::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TriggerRegistration::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TriggerRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TriggerRegistration_UnserializedMessageContext<
            UserType, TriggerRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TriggerRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TriggerRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TriggerRegistration_UnserializedMessageContext<
            UserType, TriggerRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TriggerRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::attribution_reporting::EventTriggerData> event_triggers;
  
  ::attribution_reporting::FilterPair filters;
  
  ::blink::Vector<::attribution_reporting::AggregatableTriggerData> aggregatable_trigger_data;
  
  ::blink::Vector<::attribution_reporting::AggregatableValues> aggregatable_values;
  
  std::optional<uint64_t> debug_key;
  
  ::blink::Vector<::attribution_reporting::AggregatableDedupKey> aggregatable_dedup_keys;
  
  bool debug_reporting;
  
  std::optional<::attribution_reporting::SuitableOrigin> aggregation_coordinator_origin;
  
  ::attribution_reporting::mojom::blink::SourceRegistrationTimeConfig source_registration_time_config;
  
  ::blink::String trigger_context_id;
  
  uint8_t aggregatable_filtering_id_max_bytes;
  
  ::attribution_reporting::AggregatableDebugReportingConfig aggregatable_debug_reporting_config;
  
  ::attribution_reporting::AttributionScopesSet attribution_scopes;
  
  ::blink::Vector<::attribution_reporting::AggregatableNamedBudgetCandidate> aggregatable_named_budget_candidates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TriggerRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT OsRegistrationItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OsRegistrationItem, T>::value>;
  using DataView = OsRegistrationItemDataView;
  using Data_ = internal::OsRegistrationItem_Data;

  template <typename... Args>
  static OsRegistrationItemPtr New(Args&&... args) {
    return OsRegistrationItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OsRegistrationItemPtr From(const U& u) {
    return mojo::TypeConverter<OsRegistrationItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OsRegistrationItem>::Convert(*this);
  }


  OsRegistrationItem();

  OsRegistrationItem(
      const ::blink::KURL& url,
      bool debug_reporting);


  ~OsRegistrationItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OsRegistrationItemPtr>
  OsRegistrationItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OsRegistrationItem::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OsRegistrationItem::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OsRegistrationItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OsRegistrationItem_UnserializedMessageContext<
            UserType, OsRegistrationItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OsRegistrationItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OsRegistrationItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OsRegistrationItem_UnserializedMessageContext<
            UserType, OsRegistrationItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OsRegistrationItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  bool debug_reporting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OsRegistrationItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT OsRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OsRegistration, T>::value>;
  using DataView = OsRegistrationDataView;
  using Data_ = internal::OsRegistration_Data;

  template <typename... Args>
  static OsRegistrationPtr New(Args&&... args) {
    return OsRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OsRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<OsRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OsRegistration>::Convert(*this);
  }


  OsRegistration();

  explicit OsRegistration(
      ::blink::Vector<::attribution_reporting::OsRegistrationItem> items);


  ~OsRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OsRegistrationPtr>
  OsRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OsRegistration::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OsRegistration::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OsRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OsRegistration_UnserializedMessageContext<
            UserType, OsRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OsRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OsRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OsRegistration_UnserializedMessageContext<
            UserType, OsRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OsRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::attribution_reporting::OsRegistrationItem> items;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OsRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SuitableOriginPtr SuitableOrigin::Clone() const {
  return New(
      mojo::Clone(origin)
  );
}

template <typename T, SuitableOrigin::EnableIfSame<T>*>
bool SuitableOrigin::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  return true;
}

template <typename T, SuitableOrigin::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  return false;
}
template <typename StructPtrType>
FilterDataPtr FilterData::Clone() const {
  return New(
      mojo::Clone(filter_values)
  );
}

template <typename T, FilterData::EnableIfSame<T>*>
bool FilterData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filter_values, other_struct.filter_values))
    return false;
  return true;
}

template <typename T, FilterData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filter_values < rhs.filter_values)
    return true;
  if (rhs.filter_values < lhs.filter_values)
    return false;
  return false;
}
template <typename StructPtrType>
FilterConfigPtr FilterConfig::Clone() const {
  return New(
      mojo::Clone(lookback_window),
      mojo::Clone(filter_values)
  );
}

template <typename T, FilterConfig::EnableIfSame<T>*>
bool FilterConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lookback_window, other_struct.lookback_window))
    return false;
  if (!mojo::Equals(this->filter_values, other_struct.filter_values))
    return false;
  return true;
}

template <typename T, FilterConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lookback_window < rhs.lookback_window)
    return true;
  if (rhs.lookback_window < lhs.lookback_window)
    return false;
  if (lhs.filter_values < rhs.filter_values)
    return true;
  if (rhs.filter_values < lhs.filter_values)
    return false;
  return false;
}
template <typename StructPtrType>
FilterPairPtr FilterPair::Clone() const {
  return New(
      mojo::Clone(positive),
      mojo::Clone(negative)
  );
}

template <typename T, FilterPair::EnableIfSame<T>*>
bool FilterPair::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->positive, other_struct.positive))
    return false;
  if (!mojo::Equals(this->negative, other_struct.negative))
    return false;
  return true;
}

template <typename T, FilterPair::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.positive < rhs.positive)
    return true;
  if (rhs.positive < lhs.positive)
    return false;
  if (lhs.negative < rhs.negative)
    return true;
  if (rhs.negative < lhs.negative)
    return false;
  return false;
}
template <typename StructPtrType>
AggregationKeysPtr AggregationKeys::Clone() const {
  return New(
      mojo::Clone(keys)
  );
}

template <typename T, AggregationKeys::EnableIfSame<T>*>
bool AggregationKeys::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->keys, other_struct.keys))
    return false;
  return true;
}

template <typename T, AggregationKeys::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.keys < rhs.keys)
    return true;
  if (rhs.keys < lhs.keys)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableTriggerDataPtr AggregatableTriggerData::Clone() const {
  return New(
      mojo::Clone(key_piece),
      mojo::Clone(source_keys),
      mojo::Clone(filters)
  );
}

template <typename T, AggregatableTriggerData::EnableIfSame<T>*>
bool AggregatableTriggerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_piece, other_struct.key_piece))
    return false;
  if (!mojo::Equals(this->source_keys, other_struct.source_keys))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, AggregatableTriggerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_piece < rhs.key_piece)
    return true;
  if (rhs.key_piece < lhs.key_piece)
    return false;
  if (lhs.source_keys < rhs.source_keys)
    return true;
  if (rhs.source_keys < lhs.source_keys)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  return false;
}
template <typename StructPtrType>
DestinationSetPtr DestinationSet::Clone() const {
  return New(
      mojo::Clone(destinations)
  );
}

template <typename T, DestinationSet::EnableIfSame<T>*>
bool DestinationSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->destinations, other_struct.destinations))
    return false;
  return true;
}

template <typename T, DestinationSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.destinations < rhs.destinations)
    return true;
  if (rhs.destinations < lhs.destinations)
    return false;
  return false;
}
template <typename StructPtrType>
EventReportWindowsPtr EventReportWindows::Clone() const {
  return New(
      mojo::Clone(start_time),
      mojo::Clone(end_times)
  );
}

template <typename T, EventReportWindows::EnableIfSame<T>*>
bool EventReportWindows::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  if (!mojo::Equals(this->end_times, other_struct.end_times))
    return false;
  return true;
}

template <typename T, EventReportWindows::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  if (lhs.end_times < rhs.end_times)
    return true;
  if (rhs.end_times < lhs.end_times)
    return false;
  return false;
}
template <typename StructPtrType>
TriggerDataSetPtr TriggerDataSet::Clone() const {
  return New(
      mojo::Clone(trigger_data)
  );
}

template <typename T, TriggerDataSet::EnableIfSame<T>*>
bool TriggerDataSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trigger_data, other_struct.trigger_data))
    return false;
  return true;
}

template <typename T, TriggerDataSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.trigger_data < rhs.trigger_data)
    return true;
  if (rhs.trigger_data < lhs.trigger_data)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableDebugReportingContributionPtr AggregatableDebugReportingContribution::Clone() const {
  return New(
      mojo::Clone(key_piece),
      mojo::Clone(value)
  );
}

template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>*>
bool AggregatableDebugReportingContribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_piece, other_struct.key_piece))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AggregatableDebugReportingContribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_piece < rhs.key_piece)
    return true;
  if (rhs.key_piece < lhs.key_piece)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableDebugReportingConfigPtr AggregatableDebugReportingConfig::Clone() const {
  return New(
      mojo::Clone(key_piece),
      mojo::Clone(debug_data),
      mojo::Clone(aggregation_coordinator_origin)
  );
}

template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>*>
bool AggregatableDebugReportingConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_piece, other_struct.key_piece))
    return false;
  if (!mojo::Equals(this->debug_data, other_struct.debug_data))
    return false;
  if (!mojo::Equals(this->aggregation_coordinator_origin, other_struct.aggregation_coordinator_origin))
    return false;
  return true;
}

template <typename T, AggregatableDebugReportingConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_piece < rhs.key_piece)
    return true;
  if (rhs.key_piece < lhs.key_piece)
    return false;
  if (lhs.debug_data < rhs.debug_data)
    return true;
  if (rhs.debug_data < lhs.debug_data)
    return false;
  if (lhs.aggregation_coordinator_origin < rhs.aggregation_coordinator_origin)
    return true;
  if (rhs.aggregation_coordinator_origin < lhs.aggregation_coordinator_origin)
    return false;
  return false;
}
template <typename StructPtrType>
SourceAggregatableDebugReportingConfigPtr SourceAggregatableDebugReportingConfig::Clone() const {
  return New(
      mojo::Clone(budget),
      mojo::Clone(config)
  );
}

template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>*>
bool SourceAggregatableDebugReportingConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->budget, other_struct.budget))
    return false;
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  return true;
}

template <typename T, SourceAggregatableDebugReportingConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.budget < rhs.budget)
    return true;
  if (rhs.budget < lhs.budget)
    return false;
  if (lhs.config < rhs.config)
    return true;
  if (rhs.config < lhs.config)
    return false;
  return false;
}
template <typename StructPtrType>
AttributionScopesSetPtr AttributionScopesSet::Clone() const {
  return New(
      mojo::Clone(scopes)
  );
}

template <typename T, AttributionScopesSet::EnableIfSame<T>*>
bool AttributionScopesSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scopes, other_struct.scopes))
    return false;
  return true;
}

template <typename T, AttributionScopesSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scopes < rhs.scopes)
    return true;
  if (rhs.scopes < lhs.scopes)
    return false;
  return false;
}
template <typename StructPtrType>
AttributionScopesDataPtr AttributionScopesData::Clone() const {
  return New(
      mojo::Clone(attribution_scopes_set),
      mojo::Clone(attribution_scope_limit),
      mojo::Clone(max_event_states)
  );
}

template <typename T, AttributionScopesData::EnableIfSame<T>*>
bool AttributionScopesData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->attribution_scopes_set, other_struct.attribution_scopes_set))
    return false;
  if (!mojo::Equals(this->attribution_scope_limit, other_struct.attribution_scope_limit))
    return false;
  if (!mojo::Equals(this->max_event_states, other_struct.max_event_states))
    return false;
  return true;
}

template <typename T, AttributionScopesData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.attribution_scopes_set < rhs.attribution_scopes_set)
    return true;
  if (rhs.attribution_scopes_set < lhs.attribution_scopes_set)
    return false;
  if (lhs.attribution_scope_limit < rhs.attribution_scope_limit)
    return true;
  if (rhs.attribution_scope_limit < lhs.attribution_scope_limit)
    return false;
  if (lhs.max_event_states < rhs.max_event_states)
    return true;
  if (rhs.max_event_states < lhs.max_event_states)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableNamedBudgetDefsPtr AggregatableNamedBudgetDefs::Clone() const {
  return New(
      mojo::Clone(budgets)
  );
}

template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>*>
bool AggregatableNamedBudgetDefs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->budgets, other_struct.budgets))
    return false;
  return true;
}

template <typename T, AggregatableNamedBudgetDefs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.budgets < rhs.budgets)
    return true;
  if (rhs.budgets < lhs.budgets)
    return false;
  return false;
}
template <typename StructPtrType>
SourceRegistrationPtr SourceRegistration::Clone() const {
  return New(
      mojo::Clone(destinations),
      mojo::Clone(source_event_id),
      mojo::Clone(expiry),
      mojo::Clone(trigger_data),
      mojo::Clone(event_report_windows),
      mojo::Clone(max_event_level_reports),
      mojo::Clone(aggregatable_report_window),
      mojo::Clone(priority),
      mojo::Clone(debug_key),
      mojo::Clone(filter_data),
      mojo::Clone(aggregation_keys),
      mojo::Clone(debug_reporting),
      mojo::Clone(trigger_data_matching),
      mojo::Clone(event_level_epsilon),
      mojo::Clone(aggregatable_debug_reporting_config),
      mojo::Clone(destination_limit_priority),
      mojo::Clone(attribution_scopes_data),
      mojo::Clone(aggregatable_named_budget_defs)
  );
}

template <typename T, SourceRegistration::EnableIfSame<T>*>
bool SourceRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->destinations, other_struct.destinations))
    return false;
  if (!mojo::Equals(this->source_event_id, other_struct.source_event_id))
    return false;
  if (!mojo::Equals(this->expiry, other_struct.expiry))
    return false;
  if (!mojo::Equals(this->trigger_data, other_struct.trigger_data))
    return false;
  if (!mojo::Equals(this->event_report_windows, other_struct.event_report_windows))
    return false;
  if (!mojo::Equals(this->max_event_level_reports, other_struct.max_event_level_reports))
    return false;
  if (!mojo::Equals(this->aggregatable_report_window, other_struct.aggregatable_report_window))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->debug_key, other_struct.debug_key))
    return false;
  if (!mojo::Equals(this->filter_data, other_struct.filter_data))
    return false;
  if (!mojo::Equals(this->aggregation_keys, other_struct.aggregation_keys))
    return false;
  if (!mojo::Equals(this->debug_reporting, other_struct.debug_reporting))
    return false;
  if (!mojo::Equals(this->trigger_data_matching, other_struct.trigger_data_matching))
    return false;
  if (!mojo::Equals(this->event_level_epsilon, other_struct.event_level_epsilon))
    return false;
  if (!mojo::Equals(this->aggregatable_debug_reporting_config, other_struct.aggregatable_debug_reporting_config))
    return false;
  if (!mojo::Equals(this->destination_limit_priority, other_struct.destination_limit_priority))
    return false;
  if (!mojo::Equals(this->attribution_scopes_data, other_struct.attribution_scopes_data))
    return false;
  if (!mojo::Equals(this->aggregatable_named_budget_defs, other_struct.aggregatable_named_budget_defs))
    return false;
  return true;
}

template <typename T, SourceRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.destinations < rhs.destinations)
    return true;
  if (rhs.destinations < lhs.destinations)
    return false;
  if (lhs.source_event_id < rhs.source_event_id)
    return true;
  if (rhs.source_event_id < lhs.source_event_id)
    return false;
  if (lhs.expiry < rhs.expiry)
    return true;
  if (rhs.expiry < lhs.expiry)
    return false;
  if (lhs.trigger_data < rhs.trigger_data)
    return true;
  if (rhs.trigger_data < lhs.trigger_data)
    return false;
  if (lhs.event_report_windows < rhs.event_report_windows)
    return true;
  if (rhs.event_report_windows < lhs.event_report_windows)
    return false;
  if (lhs.max_event_level_reports < rhs.max_event_level_reports)
    return true;
  if (rhs.max_event_level_reports < lhs.max_event_level_reports)
    return false;
  if (lhs.aggregatable_report_window < rhs.aggregatable_report_window)
    return true;
  if (rhs.aggregatable_report_window < lhs.aggregatable_report_window)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.debug_key < rhs.debug_key)
    return true;
  if (rhs.debug_key < lhs.debug_key)
    return false;
  if (lhs.filter_data < rhs.filter_data)
    return true;
  if (rhs.filter_data < lhs.filter_data)
    return false;
  if (lhs.aggregation_keys < rhs.aggregation_keys)
    return true;
  if (rhs.aggregation_keys < lhs.aggregation_keys)
    return false;
  if (lhs.debug_reporting < rhs.debug_reporting)
    return true;
  if (rhs.debug_reporting < lhs.debug_reporting)
    return false;
  if (lhs.trigger_data_matching < rhs.trigger_data_matching)
    return true;
  if (rhs.trigger_data_matching < lhs.trigger_data_matching)
    return false;
  if (lhs.event_level_epsilon < rhs.event_level_epsilon)
    return true;
  if (rhs.event_level_epsilon < lhs.event_level_epsilon)
    return false;
  if (lhs.aggregatable_debug_reporting_config < rhs.aggregatable_debug_reporting_config)
    return true;
  if (rhs.aggregatable_debug_reporting_config < lhs.aggregatable_debug_reporting_config)
    return false;
  if (lhs.destination_limit_priority < rhs.destination_limit_priority)
    return true;
  if (rhs.destination_limit_priority < lhs.destination_limit_priority)
    return false;
  if (lhs.attribution_scopes_data < rhs.attribution_scopes_data)
    return true;
  if (rhs.attribution_scopes_data < lhs.attribution_scopes_data)
    return false;
  if (lhs.aggregatable_named_budget_defs < rhs.aggregatable_named_budget_defs)
    return true;
  if (rhs.aggregatable_named_budget_defs < lhs.aggregatable_named_budget_defs)
    return false;
  return false;
}
template <typename StructPtrType>
EventTriggerDataPtr EventTriggerData::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(priority),
      mojo::Clone(dedup_key),
      mojo::Clone(filters)
  );
}

template <typename T, EventTriggerData::EnableIfSame<T>*>
bool EventTriggerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->dedup_key, other_struct.dedup_key))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, EventTriggerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.dedup_key < rhs.dedup_key)
    return true;
  if (rhs.dedup_key < lhs.dedup_key)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableDedupKeyPtr AggregatableDedupKey::Clone() const {
  return New(
      mojo::Clone(dedup_key),
      mojo::Clone(filters)
  );
}

template <typename T, AggregatableDedupKey::EnableIfSame<T>*>
bool AggregatableDedupKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dedup_key, other_struct.dedup_key))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, AggregatableDedupKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dedup_key < rhs.dedup_key)
    return true;
  if (rhs.dedup_key < lhs.dedup_key)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableValuesValuePtr AggregatableValuesValue::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(filtering_id)
  );
}

template <typename T, AggregatableValuesValue::EnableIfSame<T>*>
bool AggregatableValuesValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->filtering_id, other_struct.filtering_id))
    return false;
  return true;
}

template <typename T, AggregatableValuesValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.filtering_id < rhs.filtering_id)
    return true;
  if (rhs.filtering_id < lhs.filtering_id)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableValuesPtr AggregatableValues::Clone() const {
  return New(
      mojo::Clone(values),
      mojo::Clone(filters)
  );
}

template <typename T, AggregatableValues::EnableIfSame<T>*>
bool AggregatableValues::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->values, other_struct.values))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, AggregatableValues::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.values < rhs.values)
    return true;
  if (rhs.values < lhs.values)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableNamedBudgetCandidatePtr AggregatableNamedBudgetCandidate::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(filters)
  );
}

template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>*>
bool AggregatableNamedBudgetCandidate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, AggregatableNamedBudgetCandidate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  return false;
}
template <typename StructPtrType>
TriggerRegistrationPtr TriggerRegistration::Clone() const {
  return New(
      mojo::Clone(event_triggers),
      mojo::Clone(filters),
      mojo::Clone(aggregatable_trigger_data),
      mojo::Clone(aggregatable_values),
      mojo::Clone(debug_key),
      mojo::Clone(aggregatable_dedup_keys),
      mojo::Clone(debug_reporting),
      mojo::Clone(aggregation_coordinator_origin),
      mojo::Clone(source_registration_time_config),
      mojo::Clone(trigger_context_id),
      mojo::Clone(aggregatable_filtering_id_max_bytes),
      mojo::Clone(aggregatable_debug_reporting_config),
      mojo::Clone(attribution_scopes),
      mojo::Clone(aggregatable_named_budget_candidates)
  );
}

template <typename T, TriggerRegistration::EnableIfSame<T>*>
bool TriggerRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->event_triggers, other_struct.event_triggers))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->aggregatable_trigger_data, other_struct.aggregatable_trigger_data))
    return false;
  if (!mojo::Equals(this->aggregatable_values, other_struct.aggregatable_values))
    return false;
  if (!mojo::Equals(this->debug_key, other_struct.debug_key))
    return false;
  if (!mojo::Equals(this->aggregatable_dedup_keys, other_struct.aggregatable_dedup_keys))
    return false;
  if (!mojo::Equals(this->debug_reporting, other_struct.debug_reporting))
    return false;
  if (!mojo::Equals(this->aggregation_coordinator_origin, other_struct.aggregation_coordinator_origin))
    return false;
  if (!mojo::Equals(this->source_registration_time_config, other_struct.source_registration_time_config))
    return false;
  if (!mojo::Equals(this->trigger_context_id, other_struct.trigger_context_id))
    return false;
  if (!mojo::Equals(this->aggregatable_filtering_id_max_bytes, other_struct.aggregatable_filtering_id_max_bytes))
    return false;
  if (!mojo::Equals(this->aggregatable_debug_reporting_config, other_struct.aggregatable_debug_reporting_config))
    return false;
  if (!mojo::Equals(this->attribution_scopes, other_struct.attribution_scopes))
    return false;
  if (!mojo::Equals(this->aggregatable_named_budget_candidates, other_struct.aggregatable_named_budget_candidates))
    return false;
  return true;
}

template <typename T, TriggerRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.event_triggers < rhs.event_triggers)
    return true;
  if (rhs.event_triggers < lhs.event_triggers)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  if (lhs.aggregatable_trigger_data < rhs.aggregatable_trigger_data)
    return true;
  if (rhs.aggregatable_trigger_data < lhs.aggregatable_trigger_data)
    return false;
  if (lhs.aggregatable_values < rhs.aggregatable_values)
    return true;
  if (rhs.aggregatable_values < lhs.aggregatable_values)
    return false;
  if (lhs.debug_key < rhs.debug_key)
    return true;
  if (rhs.debug_key < lhs.debug_key)
    return false;
  if (lhs.aggregatable_dedup_keys < rhs.aggregatable_dedup_keys)
    return true;
  if (rhs.aggregatable_dedup_keys < lhs.aggregatable_dedup_keys)
    return false;
  if (lhs.debug_reporting < rhs.debug_reporting)
    return true;
  if (rhs.debug_reporting < lhs.debug_reporting)
    return false;
  if (lhs.aggregation_coordinator_origin < rhs.aggregation_coordinator_origin)
    return true;
  if (rhs.aggregation_coordinator_origin < lhs.aggregation_coordinator_origin)
    return false;
  if (lhs.source_registration_time_config < rhs.source_registration_time_config)
    return true;
  if (rhs.source_registration_time_config < lhs.source_registration_time_config)
    return false;
  if (lhs.trigger_context_id < rhs.trigger_context_id)
    return true;
  if (rhs.trigger_context_id < lhs.trigger_context_id)
    return false;
  if (lhs.aggregatable_filtering_id_max_bytes < rhs.aggregatable_filtering_id_max_bytes)
    return true;
  if (rhs.aggregatable_filtering_id_max_bytes < lhs.aggregatable_filtering_id_max_bytes)
    return false;
  if (lhs.aggregatable_debug_reporting_config < rhs.aggregatable_debug_reporting_config)
    return true;
  if (rhs.aggregatable_debug_reporting_config < lhs.aggregatable_debug_reporting_config)
    return false;
  if (lhs.attribution_scopes < rhs.attribution_scopes)
    return true;
  if (rhs.attribution_scopes < lhs.attribution_scopes)
    return false;
  if (lhs.aggregatable_named_budget_candidates < rhs.aggregatable_named_budget_candidates)
    return true;
  if (rhs.aggregatable_named_budget_candidates < lhs.aggregatable_named_budget_candidates)
    return false;
  return false;
}
template <typename StructPtrType>
OsRegistrationItemPtr OsRegistrationItem::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(debug_reporting)
  );
}

template <typename T, OsRegistrationItem::EnableIfSame<T>*>
bool OsRegistrationItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->debug_reporting, other_struct.debug_reporting))
    return false;
  return true;
}

template <typename T, OsRegistrationItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.debug_reporting < rhs.debug_reporting)
    return true;
  if (rhs.debug_reporting < lhs.debug_reporting)
    return false;
  return false;
}
template <typename StructPtrType>
OsRegistrationPtr OsRegistration::Clone() const {
  return New(
      mojo::Clone(items)
  );
}

template <typename T, OsRegistration::EnableIfSame<T>*>
bool OsRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  return true;
}

template <typename T, OsRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  return false;
}


}  // attribution_reporting::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::SuitableOrigin::DataView,
                                         ::attribution_reporting::mojom::blink::SuitableOriginPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::SuitableOriginPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::SuitableOriginPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::SuitableOrigin::origin)& origin(
      const ::attribution_reporting::mojom::blink::SuitableOriginPtr& input) {
    return input->origin;
  }

  static bool Read(::attribution_reporting::mojom::blink::SuitableOrigin::DataView input, ::attribution_reporting::mojom::blink::SuitableOriginPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::FilterData::DataView,
                                         ::attribution_reporting::mojom::blink::FilterDataPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::FilterDataPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::FilterDataPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::FilterData::filter_values)& filter_values(
      const ::attribution_reporting::mojom::blink::FilterDataPtr& input) {
    return input->filter_values;
  }

  static bool Read(::attribution_reporting::mojom::blink::FilterData::DataView input, ::attribution_reporting::mojom::blink::FilterDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::FilterConfig::DataView,
                                         ::attribution_reporting::mojom::blink::FilterConfigPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::FilterConfigPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::FilterConfigPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::FilterConfig::lookback_window)& lookback_window(
      const ::attribution_reporting::mojom::blink::FilterConfigPtr& input) {
    return input->lookback_window;
  }

  static const decltype(::attribution_reporting::mojom::blink::FilterConfig::filter_values)& filter_values(
      const ::attribution_reporting::mojom::blink::FilterConfigPtr& input) {
    return input->filter_values;
  }

  static bool Read(::attribution_reporting::mojom::blink::FilterConfig::DataView input, ::attribution_reporting::mojom::blink::FilterConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::FilterPair::DataView,
                                         ::attribution_reporting::mojom::blink::FilterPairPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::FilterPairPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::FilterPairPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::FilterPair::positive)& positive(
      const ::attribution_reporting::mojom::blink::FilterPairPtr& input) {
    return input->positive;
  }

  static const decltype(::attribution_reporting::mojom::blink::FilterPair::negative)& negative(
      const ::attribution_reporting::mojom::blink::FilterPairPtr& input) {
    return input->negative;
  }

  static bool Read(::attribution_reporting::mojom::blink::FilterPair::DataView input, ::attribution_reporting::mojom::blink::FilterPairPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregationKeys::DataView,
                                         ::attribution_reporting::mojom::blink::AggregationKeysPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregationKeysPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregationKeysPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregationKeys::keys)& keys(
      const ::attribution_reporting::mojom::blink::AggregationKeysPtr& input) {
    return input->keys;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregationKeys::DataView input, ::attribution_reporting::mojom::blink::AggregationKeysPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableTriggerData::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableTriggerData::key_piece)& key_piece(
      const ::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr& input) {
    return input->key_piece;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableTriggerData::source_keys)& source_keys(
      const ::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr& input) {
    return input->source_keys;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableTriggerData::filters)& filters(
      const ::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr& input) {
    return input->filters;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableTriggerData::DataView input, ::attribution_reporting::mojom::blink::AggregatableTriggerDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::DestinationSet::DataView,
                                         ::attribution_reporting::mojom::blink::DestinationSetPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::DestinationSetPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::DestinationSetPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::DestinationSet::destinations)& destinations(
      const ::attribution_reporting::mojom::blink::DestinationSetPtr& input) {
    return input->destinations;
  }

  static bool Read(::attribution_reporting::mojom::blink::DestinationSet::DataView input, ::attribution_reporting::mojom::blink::DestinationSetPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::EventReportWindows::DataView,
                                         ::attribution_reporting::mojom::blink::EventReportWindowsPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::EventReportWindowsPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::EventReportWindowsPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::EventReportWindows::start_time)& start_time(
      const ::attribution_reporting::mojom::blink::EventReportWindowsPtr& input) {
    return input->start_time;
  }

  static const decltype(::attribution_reporting::mojom::blink::EventReportWindows::end_times)& end_times(
      const ::attribution_reporting::mojom::blink::EventReportWindowsPtr& input) {
    return input->end_times;
  }

  static bool Read(::attribution_reporting::mojom::blink::EventReportWindows::DataView input, ::attribution_reporting::mojom::blink::EventReportWindowsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::TriggerDataSet::DataView,
                                         ::attribution_reporting::mojom::blink::TriggerDataSetPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::TriggerDataSetPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::TriggerDataSetPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::TriggerDataSet::trigger_data)& trigger_data(
      const ::attribution_reporting::mojom::blink::TriggerDataSetPtr& input) {
    return input->trigger_data;
  }

  static bool Read(::attribution_reporting::mojom::blink::TriggerDataSet::DataView input, ::attribution_reporting::mojom::blink::TriggerDataSetPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableDebugReportingContribution::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableDebugReportingContributionPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableDebugReportingContributionPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableDebugReportingContributionPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableDebugReportingContribution::key_piece)& key_piece(
      const ::attribution_reporting::mojom::blink::AggregatableDebugReportingContributionPtr& input) {
    return input->key_piece;
  }

  static decltype(::attribution_reporting::mojom::blink::AggregatableDebugReportingContribution::value) value(
      const ::attribution_reporting::mojom::blink::AggregatableDebugReportingContributionPtr& input) {
    return input->value;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableDebugReportingContribution::DataView input, ::attribution_reporting::mojom::blink::AggregatableDebugReportingContributionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableDebugReportingConfig::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableDebugReportingConfig::key_piece)& key_piece(
      const ::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr& input) {
    return input->key_piece;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableDebugReportingConfig::debug_data)& debug_data(
      const ::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr& input) {
    return input->debug_data;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableDebugReportingConfig::aggregation_coordinator_origin)& aggregation_coordinator_origin(
      const ::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr& input) {
    return input->aggregation_coordinator_origin;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableDebugReportingConfig::DataView input, ::attribution_reporting::mojom::blink::AggregatableDebugReportingConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfig::DataView,
                                         ::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfigPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfigPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfigPtr* output) { output->reset(); }

  static decltype(::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfig::budget) budget(
      const ::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfigPtr& input) {
    return input->budget;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfig::config)& config(
      const ::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfigPtr& input) {
    return input->config;
  }

  static bool Read(::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfig::DataView input, ::attribution_reporting::mojom::blink::SourceAggregatableDebugReportingConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AttributionScopesSet::DataView,
                                         ::attribution_reporting::mojom::blink::AttributionScopesSetPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AttributionScopesSetPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AttributionScopesSetPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AttributionScopesSet::scopes)& scopes(
      const ::attribution_reporting::mojom::blink::AttributionScopesSetPtr& input) {
    return input->scopes;
  }

  static bool Read(::attribution_reporting::mojom::blink::AttributionScopesSet::DataView input, ::attribution_reporting::mojom::blink::AttributionScopesSetPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AttributionScopesData::DataView,
                                         ::attribution_reporting::mojom::blink::AttributionScopesDataPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AttributionScopesDataPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AttributionScopesDataPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AttributionScopesData::attribution_scopes_set)& attribution_scopes_set(
      const ::attribution_reporting::mojom::blink::AttributionScopesDataPtr& input) {
    return input->attribution_scopes_set;
  }

  static decltype(::attribution_reporting::mojom::blink::AttributionScopesData::attribution_scope_limit) attribution_scope_limit(
      const ::attribution_reporting::mojom::blink::AttributionScopesDataPtr& input) {
    return input->attribution_scope_limit;
  }

  static decltype(::attribution_reporting::mojom::blink::AttributionScopesData::max_event_states) max_event_states(
      const ::attribution_reporting::mojom::blink::AttributionScopesDataPtr& input) {
    return input->max_event_states;
  }

  static bool Read(::attribution_reporting::mojom::blink::AttributionScopesData::DataView input, ::attribution_reporting::mojom::blink::AttributionScopesDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefs::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefsPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefsPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefsPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefs::budgets)& budgets(
      const ::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefsPtr& input) {
    return input->budgets;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefs::DataView input, ::attribution_reporting::mojom::blink::AggregatableNamedBudgetDefsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::SourceRegistration::DataView,
                                         ::attribution_reporting::mojom::blink::SourceRegistrationPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::SourceRegistrationPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::destinations)& destinations(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->destinations;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::source_event_id) source_event_id(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->source_event_id;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::expiry)& expiry(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->expiry;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::trigger_data)& trigger_data(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->trigger_data;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::event_report_windows)& event_report_windows(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->event_report_windows;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::max_event_level_reports) max_event_level_reports(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->max_event_level_reports;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::aggregatable_report_window)& aggregatable_report_window(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->aggregatable_report_window;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::priority) priority(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->priority;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::debug_key) debug_key(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->debug_key;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::filter_data)& filter_data(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->filter_data;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::aggregation_keys)& aggregation_keys(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->aggregation_keys;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::debug_reporting) debug_reporting(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->debug_reporting;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::trigger_data_matching) trigger_data_matching(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->trigger_data_matching;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::event_level_epsilon) event_level_epsilon(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->event_level_epsilon;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::aggregatable_debug_reporting_config)& aggregatable_debug_reporting_config(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->aggregatable_debug_reporting_config;
  }

  static decltype(::attribution_reporting::mojom::blink::SourceRegistration::destination_limit_priority) destination_limit_priority(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->destination_limit_priority;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::attribution_scopes_data)& attribution_scopes_data(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->attribution_scopes_data;
  }

  static const decltype(::attribution_reporting::mojom::blink::SourceRegistration::aggregatable_named_budget_defs)& aggregatable_named_budget_defs(
      const ::attribution_reporting::mojom::blink::SourceRegistrationPtr& input) {
    return input->aggregatable_named_budget_defs;
  }

  static bool Read(::attribution_reporting::mojom::blink::SourceRegistration::DataView input, ::attribution_reporting::mojom::blink::SourceRegistrationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::EventTriggerData::DataView,
                                         ::attribution_reporting::mojom::blink::EventTriggerDataPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::EventTriggerDataPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::EventTriggerDataPtr* output) { output->reset(); }

  static decltype(::attribution_reporting::mojom::blink::EventTriggerData::data) data(
      const ::attribution_reporting::mojom::blink::EventTriggerDataPtr& input) {
    return input->data;
  }

  static decltype(::attribution_reporting::mojom::blink::EventTriggerData::priority) priority(
      const ::attribution_reporting::mojom::blink::EventTriggerDataPtr& input) {
    return input->priority;
  }

  static decltype(::attribution_reporting::mojom::blink::EventTriggerData::dedup_key) dedup_key(
      const ::attribution_reporting::mojom::blink::EventTriggerDataPtr& input) {
    return input->dedup_key;
  }

  static const decltype(::attribution_reporting::mojom::blink::EventTriggerData::filters)& filters(
      const ::attribution_reporting::mojom::blink::EventTriggerDataPtr& input) {
    return input->filters;
  }

  static bool Read(::attribution_reporting::mojom::blink::EventTriggerData::DataView input, ::attribution_reporting::mojom::blink::EventTriggerDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableDedupKey::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableDedupKeyPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableDedupKeyPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableDedupKeyPtr* output) { output->reset(); }

  static decltype(::attribution_reporting::mojom::blink::AggregatableDedupKey::dedup_key) dedup_key(
      const ::attribution_reporting::mojom::blink::AggregatableDedupKeyPtr& input) {
    return input->dedup_key;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableDedupKey::filters)& filters(
      const ::attribution_reporting::mojom::blink::AggregatableDedupKeyPtr& input) {
    return input->filters;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableDedupKey::DataView input, ::attribution_reporting::mojom::blink::AggregatableDedupKeyPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableValuesValue::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableValuesValuePtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableValuesValuePtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableValuesValuePtr* output) { output->reset(); }

  static decltype(::attribution_reporting::mojom::blink::AggregatableValuesValue::value) value(
      const ::attribution_reporting::mojom::blink::AggregatableValuesValuePtr& input) {
    return input->value;
  }

  static decltype(::attribution_reporting::mojom::blink::AggregatableValuesValue::filtering_id) filtering_id(
      const ::attribution_reporting::mojom::blink::AggregatableValuesValuePtr& input) {
    return input->filtering_id;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableValuesValue::DataView input, ::attribution_reporting::mojom::blink::AggregatableValuesValuePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableValues::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableValuesPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableValuesPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableValuesPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableValues::values)& values(
      const ::attribution_reporting::mojom::blink::AggregatableValuesPtr& input) {
    return input->values;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableValues::filters)& filters(
      const ::attribution_reporting::mojom::blink::AggregatableValuesPtr& input) {
    return input->filters;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableValues::DataView input, ::attribution_reporting::mojom::blink::AggregatableValuesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidate::DataView,
                                         ::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidatePtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidatePtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidatePtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidate::name)& name(
      const ::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidatePtr& input) {
    return input->name;
  }

  static const decltype(::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidate::filters)& filters(
      const ::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidatePtr& input) {
    return input->filters;
  }

  static bool Read(::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidate::DataView input, ::attribution_reporting::mojom::blink::AggregatableNamedBudgetCandidatePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::TriggerRegistration::DataView,
                                         ::attribution_reporting::mojom::blink::TriggerRegistrationPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::TriggerRegistrationPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::event_triggers)& event_triggers(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->event_triggers;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::filters)& filters(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->filters;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregatable_trigger_data)& aggregatable_trigger_data(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregatable_trigger_data;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregatable_values)& aggregatable_values(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregatable_values;
  }

  static decltype(::attribution_reporting::mojom::blink::TriggerRegistration::debug_key) debug_key(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->debug_key;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregatable_dedup_keys)& aggregatable_dedup_keys(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregatable_dedup_keys;
  }

  static decltype(::attribution_reporting::mojom::blink::TriggerRegistration::debug_reporting) debug_reporting(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->debug_reporting;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregation_coordinator_origin)& aggregation_coordinator_origin(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregation_coordinator_origin;
  }

  static decltype(::attribution_reporting::mojom::blink::TriggerRegistration::source_registration_time_config) source_registration_time_config(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->source_registration_time_config;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::trigger_context_id)& trigger_context_id(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->trigger_context_id;
  }

  static decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregatable_filtering_id_max_bytes) aggregatable_filtering_id_max_bytes(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregatable_filtering_id_max_bytes;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregatable_debug_reporting_config)& aggregatable_debug_reporting_config(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregatable_debug_reporting_config;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::attribution_scopes)& attribution_scopes(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->attribution_scopes;
  }

  static const decltype(::attribution_reporting::mojom::blink::TriggerRegistration::aggregatable_named_budget_candidates)& aggregatable_named_budget_candidates(
      const ::attribution_reporting::mojom::blink::TriggerRegistrationPtr& input) {
    return input->aggregatable_named_budget_candidates;
  }

  static bool Read(::attribution_reporting::mojom::blink::TriggerRegistration::DataView input, ::attribution_reporting::mojom::blink::TriggerRegistrationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::OsRegistrationItem::DataView,
                                         ::attribution_reporting::mojom::blink::OsRegistrationItemPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::OsRegistrationItemPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::OsRegistrationItemPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::OsRegistrationItem::url)& url(
      const ::attribution_reporting::mojom::blink::OsRegistrationItemPtr& input) {
    return input->url;
  }

  static decltype(::attribution_reporting::mojom::blink::OsRegistrationItem::debug_reporting) debug_reporting(
      const ::attribution_reporting::mojom::blink::OsRegistrationItemPtr& input) {
    return input->debug_reporting;
  }

  static bool Read(::attribution_reporting::mojom::blink::OsRegistrationItem::DataView input, ::attribution_reporting::mojom::blink::OsRegistrationItemPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::attribution_reporting::mojom::blink::OsRegistration::DataView,
                                         ::attribution_reporting::mojom::blink::OsRegistrationPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::blink::OsRegistrationPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::blink::OsRegistrationPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::blink::OsRegistration::items)& items(
      const ::attribution_reporting::mojom::blink::OsRegistrationPtr& input) {
    return input->items;
  }

  static bool Read(::attribution_reporting::mojom::blink::OsRegistration::DataView input, ::attribution_reporting::mojom::blink::OsRegistrationPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_BLINK_H_