// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.h.template is used to generate vector_icons.h. Edit the former
// rather than the latter.

#ifndef CHROMEOS_UI_VECTOR_ICONS_VECTOR_ICONS_H_
#define CHROMEOS_UI_VECTOR_ICONS_VECTOR_ICONS_H_

namespace gfx {
struct VectorIcon;
}

#define VECTOR_ICON_TEMPLATE_H(icon_name) \
extern const gfx::VectorIcon icon_name;

namespace chromeos {

VECTOR_ICON_TEMPLATE_H(kAssistantIcon)
VECTOR_ICON_TEMPLATE_H(kCalculateIcon)
VECTOR_ICON_TEMPLATE_H(kConversionPathIcon)
VECTOR_ICON_TEMPLATE_H(kDictionaryIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuElaborateIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuEmojifyIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuFormalizeIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuPenSparkIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuProofreadIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuRephraseIcon)
VECTOR_ICON_TEMPLATE_H(kEditorMenuShortenIcon)
VECTOR_ICON_TEMPLATE_H(kEnterpriseIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeArchiveIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeAudioIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeChartIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeExcelIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeFolderIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGdocIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGdrawIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGenericIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGformIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGmaillayoutIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGmapIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGsheetIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGsiteIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGslidesIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeGtableIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeImageIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeLinuxIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypePdfIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypePptIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeScriptIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeSharedIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeSitesIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeTeamDriveIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeTiniIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeVideoIcon)
VECTOR_ICON_TEMPLATE_H(kFiletypeWordIcon)
VECTOR_ICON_TEMPLATE_H(kFloatWindowIcon)
VECTOR_ICON_TEMPLATE_H(kGameDashboardGamepadIcon)
VECTOR_ICON_TEMPLATE_H(kInfoSparkIcon)
VECTOR_ICON_TEMPLATE_H(kKeyboardShortcutsIcon)
VECTOR_ICON_TEMPLATE_H(kMahiOutlinesIcon)
VECTOR_ICON_TEMPLATE_H(kMahiSimplifyIcon)
VECTOR_ICON_TEMPLATE_H(kMahiSparkIcon)
VECTOR_ICON_TEMPLATE_H(kMahiSummarizeIcon)
VECTOR_ICON_TEMPLATE_H(kNotificationAssistantIcon)
VECTOR_ICON_TEMPLATE_H(kNotificationSupervisedUserIcon)
VECTOR_ICON_TEMPLATE_H(kPersonPinCircleIcon)
VECTOR_ICON_TEMPLATE_H(kRedeemIcon)
VECTOR_ICON_TEMPLATE_H(kScreenshotIcon)
VECTOR_ICON_TEMPLATE_H(kSentimentVerySatisfiedIcon)
VECTOR_ICON_TEMPLATE_H(kStraightenIcon)
VECTOR_ICON_TEMPLATE_H(kTextIcon)
VECTOR_ICON_TEMPLATE_H(kTimerIcon)
VECTOR_ICON_TEMPLATE_H(kTranslateIcon)
VECTOR_ICON_TEMPLATE_H(kUnfloatButtonIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlBackIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlBottomSnappedIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlDezoomIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlFloatIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlLeftSnappedIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlRightSnappedIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlTopSnappedIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlUnfloatIcon)
VECTOR_ICON_TEMPLATE_H(kWindowControlZoomIcon)

}  // namespace chromeos

#undef VECTOR_ICON_TEMPLATE_H

#endif  // CHROMEOS_UI_VECTOR_ICONS_VECTOR_ICONS_H_
