// chrome/updater/mojom/updater_service_internal.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_UPDATER_MOJOM_UPDATER_SERVICE_INTERNAL_MOJOM_H_
#define CHROME_UPDATER_MOJOM_UPDATER_SERVICE_INTERNAL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/updater/mojom/updater_service_internal.mojom-features.h"  // IWYU pragma: export
#include "chrome/updater/mojom/updater_service_internal.mojom-shared.h"  // IWYU pragma: export
#include "chrome/updater/mojom/updater_service_internal.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace updater::mojom {

class UpdateServiceInternalProxy;

template <typename ImplRefTraits>
class UpdateServiceInternalStub;

class UpdateServiceInternalRequestValidator;
class UpdateServiceInternalResponseValidator;


class UpdateServiceInternal
    : public UpdateServiceInternalInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "updater.mojom.UpdateServiceInternal";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UpdateServiceInternalInterfaceBase;
  using Proxy_ = UpdateServiceInternalProxy;

  template <typename ImplRefTraits>
  using Stub_ = UpdateServiceInternalStub<ImplRefTraits>;

  using RequestValidator_ = UpdateServiceInternalRequestValidator;
  using ResponseValidator_ = UpdateServiceInternalResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRunMinVersion = 0,
    kHelloMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Run_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Hello_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UpdateServiceInternal() = default;

  using RunCallback = base::OnceCallback<void()>;
  using RunMojoCallback = base::OnceCallback<void()>;

  virtual void Run(RunCallback callback) = 0;

  using HelloCallback = base::OnceCallback<void()>;
  using HelloMojoCallback = base::OnceCallback<void()>;

  virtual void Hello(HelloCallback callback) = 0;
};



class  UpdateServiceInternalProxy
    : public UpdateServiceInternal {
 public:
  using InterfaceType = UpdateServiceInternal;

  explicit UpdateServiceInternalProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Run(RunCallback callback) final;
  
  void Hello(HelloCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UpdateServiceInternalStubDispatch {
 public:
  static bool Accept(UpdateServiceInternal* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UpdateServiceInternal* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UpdateServiceInternal>>
class UpdateServiceInternalStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UpdateServiceInternalStub() = default;
  ~UpdateServiceInternalStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UpdateServiceInternalStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UpdateServiceInternalStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UpdateServiceInternalRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UpdateServiceInternalResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // updater::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_UPDATER_MOJOM_UPDATER_SERVICE_INTERNAL_MOJOM_H_