// chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-params-data.h"
#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-shared-message-ids.h"

#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-import-headers.h"
#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

RemovableStorageWriter::IPCStableHashFunction RemovableStorageWriter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemovableStorageWriter>(message.name())) {
    case messages::RemovableStorageWriter::kWrite: {
      return &RemovableStorageWriter::Write_Sym::IPCStableHash;
    }
    case messages::RemovableStorageWriter::kVerify: {
      return &RemovableStorageWriter::Verify_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemovableStorageWriter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemovableStorageWriter>(message.name())) {
      case messages::RemovableStorageWriter::kWrite:
            return "Receive chrome::mojom::RemovableStorageWriter::Write";
      case messages::RemovableStorageWriter::kVerify:
            return "Receive chrome::mojom::RemovableStorageWriter::Verify";
    }
  } else {
    switch (static_cast<messages::RemovableStorageWriter>(message.name())) {
      case messages::RemovableStorageWriter::kWrite:
            return "Receive reply chrome::mojom::RemovableStorageWriter::Write";
      case messages::RemovableStorageWriter::kVerify:
            return "Receive reply chrome::mojom::RemovableStorageWriter::Verify";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemovableStorageWriter::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb16781fa;  // IPCStableHash for chrome::mojom::RemovableStorageWriter::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemovableStorageWriter::Verify_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffee548f;  // IPCStableHash for chrome::mojom::RemovableStorageWriter::Verify
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemovableStorageWriterProxy::RemovableStorageWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemovableStorageWriterProxy::Write(
    const ::base::FilePath& in_source, const ::base::FilePath& in_target, ::mojo::PendingRemote<RemovableStorageWriterClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RemovableStorageWriter::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<RemovableStorageWriterClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemovableStorageWriter::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RemovableStorageWriter_Write_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in RemovableStorageWriter.Write request");
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_target,
    target_fragment);

  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target in RemovableStorageWriter.Write request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::RemovableStorageWriterClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in RemovableStorageWriter.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemovableStorageWriter::Name_);
  message.set_method_name("Write");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemovableStorageWriterProxy::Verify(
    const ::base::FilePath& in_source, const ::base::FilePath& in_target, ::mojo::PendingRemote<RemovableStorageWriterClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RemovableStorageWriter::Verify", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<RemovableStorageWriterClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemovableStorageWriter::kVerify), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RemovableStorageWriter_Verify_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in RemovableStorageWriter.Verify request");
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_target,
    target_fragment);

  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target in RemovableStorageWriter.Verify request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::RemovableStorageWriterClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in RemovableStorageWriter.Verify request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemovableStorageWriter::Name_);
  message.set_method_name("Verify");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemovableStorageWriterStubDispatch::Accept(
    RemovableStorageWriter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemovableStorageWriter>(message->header()->name)) {
    case messages::RemovableStorageWriter::kWrite: {
      DCHECK(message->is_serialized());
      internal::RemovableStorageWriter_Write_Params_Data* params =
          reinterpret_cast<internal::RemovableStorageWriter_Write_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemovableStorageWriter.0
      bool success = true;
      ::base::FilePath p_source{};
      ::base::FilePath p_target{};
      ::mojo::PendingRemote<RemovableStorageWriterClient> p_client{};
      RemovableStorageWriter_Write_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemovableStorageWriter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_source), 
        std::move(p_target), 
        std::move(p_client));
      return true;
    }
    case messages::RemovableStorageWriter::kVerify: {
      DCHECK(message->is_serialized());
      internal::RemovableStorageWriter_Verify_Params_Data* params =
          reinterpret_cast<internal::RemovableStorageWriter_Verify_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemovableStorageWriter.1
      bool success = true;
      ::base::FilePath p_source{};
      ::base::FilePath p_target{};
      ::mojo::PendingRemote<RemovableStorageWriterClient> p_client{};
      RemovableStorageWriter_Verify_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemovableStorageWriter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Verify(        
        std::move(p_source), 
        std::move(p_target), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool RemovableStorageWriterStubDispatch::AcceptWithResponder(
    RemovableStorageWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemovableStorageWriter>(message->header()->name)) {
    case messages::RemovableStorageWriter::kWrite: {
      break;
    }
    case messages::RemovableStorageWriter::kVerify: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemovableStorageWriterValidationInfo[] = {
    { &internal::RemovableStorageWriter_Write_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemovableStorageWriter_Verify_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemovableStorageWriterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::RemovableStorageWriter::Name_,
    kRemovableStorageWriterValidationInfo);
}

// The declaration includes the definition on other builds.

RemovableStorageWriterClient::IPCStableHashFunction RemovableStorageWriterClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemovableStorageWriterClient>(message.name())) {
    case messages::RemovableStorageWriterClient::kProgress: {
      return &RemovableStorageWriterClient::Progress_Sym::IPCStableHash;
    }
    case messages::RemovableStorageWriterClient::kComplete: {
      return &RemovableStorageWriterClient::Complete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemovableStorageWriterClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemovableStorageWriterClient>(message.name())) {
      case messages::RemovableStorageWriterClient::kProgress:
            return "Receive chrome::mojom::RemovableStorageWriterClient::Progress";
      case messages::RemovableStorageWriterClient::kComplete:
            return "Receive chrome::mojom::RemovableStorageWriterClient::Complete";
    }
  } else {
    switch (static_cast<messages::RemovableStorageWriterClient>(message.name())) {
      case messages::RemovableStorageWriterClient::kProgress:
            return "Receive reply chrome::mojom::RemovableStorageWriterClient::Progress";
      case messages::RemovableStorageWriterClient::kComplete:
            return "Receive reply chrome::mojom::RemovableStorageWriterClient::Complete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemovableStorageWriterClient::Progress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabdfe0ac;  // IPCStableHash for chrome::mojom::RemovableStorageWriterClient::Progress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemovableStorageWriterClient::Complete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbef9c88;  // IPCStableHash for chrome::mojom::RemovableStorageWriterClient::Complete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemovableStorageWriterClientProxy::RemovableStorageWriterClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemovableStorageWriterClientProxy::Progress(
    int64_t in_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RemovableStorageWriterClient::Progress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress"), in_progress,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemovableStorageWriterClient::kProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RemovableStorageWriterClient_Progress_Params_Data> params(
          message);
  params.Allocate();

  params->progress = in_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemovableStorageWriterClient::Name_);
  message.set_method_name("Progress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemovableStorageWriterClientProxy::Complete(
    const std::optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::RemovableStorageWriterClient::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemovableStorageWriterClient::kComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::RemovableStorageWriterClient_Complete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemovableStorageWriterClient::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemovableStorageWriterClientStubDispatch::Accept(
    RemovableStorageWriterClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemovableStorageWriterClient>(message->header()->name)) {
    case messages::RemovableStorageWriterClient::kProgress: {
      DCHECK(message->is_serialized());
      internal::RemovableStorageWriterClient_Progress_Params_Data* params =
          reinterpret_cast<internal::RemovableStorageWriterClient_Progress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemovableStorageWriterClient.0
      bool success = true;
      int64_t p_progress{};
      RemovableStorageWriterClient_Progress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_progress = input_data_view.progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemovableStorageWriterClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Progress(        
        std::move(p_progress));
      return true;
    }
    case messages::RemovableStorageWriterClient::kComplete: {
      DCHECK(message->is_serialized());
      internal::RemovableStorageWriterClient_Complete_Params_Data* params =
          reinterpret_cast<internal::RemovableStorageWriterClient_Complete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemovableStorageWriterClient.1
      bool success = true;
      std::optional<std::string> p_error{};
      RemovableStorageWriterClient_Complete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemovableStorageWriterClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(        
        std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool RemovableStorageWriterClientStubDispatch::AcceptWithResponder(
    RemovableStorageWriterClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemovableStorageWriterClient>(message->header()->name)) {
    case messages::RemovableStorageWriterClient::kProgress: {
      break;
    }
    case messages::RemovableStorageWriterClient::kComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemovableStorageWriterClientValidationInfo[] = {
    { &internal::RemovableStorageWriterClient_Progress_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemovableStorageWriterClient_Complete_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemovableStorageWriterClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::RemovableStorageWriterClient::Name_,
    kRemovableStorageWriterClientValidationInfo);
}



}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void RemovableStorageWriterInterceptorForTesting::Write(const ::base::FilePath& source, const ::base::FilePath& target, ::mojo::PendingRemote<RemovableStorageWriterClient> client) {
  GetForwardingInterface()->Write(
    std::move(source)
    , 
    std::move(target)
    , 
    std::move(client)
    );
}
void RemovableStorageWriterInterceptorForTesting::Verify(const ::base::FilePath& source, const ::base::FilePath& target, ::mojo::PendingRemote<RemovableStorageWriterClient> client) {
  GetForwardingInterface()->Verify(
    std::move(source)
    , 
    std::move(target)
    , 
    std::move(client)
    );
}
RemovableStorageWriterAsyncWaiter::RemovableStorageWriterAsyncWaiter(
    RemovableStorageWriter* proxy) : proxy_(proxy) {}

RemovableStorageWriterAsyncWaiter::~RemovableStorageWriterAsyncWaiter() = default;





void RemovableStorageWriterClientInterceptorForTesting::Progress(int64_t progress) {
  GetForwardingInterface()->Progress(
    std::move(progress)
    );
}
void RemovableStorageWriterClientInterceptorForTesting::Complete(const std::optional<std::string>& error) {
  GetForwardingInterface()->Complete(
    std::move(error)
    );
}
RemovableStorageWriterClientAsyncWaiter::RemovableStorageWriterClientAsyncWaiter(
    RemovableStorageWriterClient* proxy) : proxy_(proxy) {}

RemovableStorageWriterClientAsyncWaiter::~RemovableStorageWriterClientAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif