// chrome/services/printing/public/mojom/print_backend_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/print_backend_service.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/print_backend_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "printing/backend/mojom/print_backend.mojom.h"
#include "printing/mojom/print.mojom-forward.h"
#include "printing/mojom/printing_context.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"




namespace printing::mojom {

class UnsandboxedPrintBackendHostProxy;

template <typename ImplRefTraits>
class UnsandboxedPrintBackendHostStub;

class UnsandboxedPrintBackendHostRequestValidator;


class UnsandboxedPrintBackendHost
    : public UnsandboxedPrintBackendHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.UnsandboxedPrintBackendHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UnsandboxedPrintBackendHostInterfaceBase;
  using Proxy_ = UnsandboxedPrintBackendHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = UnsandboxedPrintBackendHostStub<ImplRefTraits>;

  using RequestValidator_ = UnsandboxedPrintBackendHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindBackendMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindBackend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UnsandboxedPrintBackendHost() = default;

  virtual void BindBackend(::mojo::PendingReceiver<PrintBackendService> service) = 0;
};

class SandboxedPrintBackendHostProxy;

template <typename ImplRefTraits>
class SandboxedPrintBackendHostStub;

class SandboxedPrintBackendHostRequestValidator;


class SandboxedPrintBackendHost
    : public SandboxedPrintBackendHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.SandboxedPrintBackendHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kPrintBackend;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SandboxedPrintBackendHostInterfaceBase;
  using Proxy_ = SandboxedPrintBackendHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SandboxedPrintBackendHostStub<ImplRefTraits>;

  using RequestValidator_ = SandboxedPrintBackendHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindBackendMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindBackend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SandboxedPrintBackendHost() = default;

  virtual void BindBackend(::mojo::PendingReceiver<PrintBackendService> service) = 0;
};

class PrintBackendServiceProxy;

template <typename ImplRefTraits>
class PrintBackendServiceStub;

class PrintBackendServiceRequestValidator;
class PrintBackendServiceResponseValidator;


class PrintBackendService
    : public PrintBackendServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PrintBackendService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrintBackendServiceInterfaceBase;
  using Proxy_ = PrintBackendServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintBackendServiceStub<ImplRefTraits>;

  using RequestValidator_ = PrintBackendServiceRequestValidator;
  using ResponseValidator_ = PrintBackendServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitMinVersion = 0,
    kPokeMinVersion = 0,
    kEnumeratePrintersMinVersion = 0,
    kGetDefaultPrinterNameMinVersion = 0,
    kFetchCapabilitiesMinVersion = 0,
    kEstablishPrintingContextMinVersion = 0,
    kUseDefaultSettingsMinVersion = 0,
    kUpdatePrintSettingsMinVersion = 0,
    kStartPrintingMinVersion = 0,
    kRenderPrintedDocumentMinVersion = 0,
    kDocumentDoneMinVersion = 0,
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Init_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Poke_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnumeratePrinters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDefaultPrinterName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchCapabilities_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EstablishPrintingContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UseDefaultSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePrintSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartPrinting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenderPrintedDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DocumentDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrintBackendService() = default;

  virtual void Init(const std::string& locale) = 0;

  virtual void Poke() = 0;

  using EnumeratePrintersCallback = base::OnceCallback<void(base::expected<
  std::vector<::printing::PrinterBasicInfo>,
  ::printing::mojom::ResultCode>)>;
  using EnumeratePrintersResult = base::expected<
  std::vector<::printing::PrinterBasicInfo>,
  ::printing::mojom::ResultCode>;
  using EnumeratePrintersMojoCallback = base::OnceCallback<void(PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr)>;

  virtual void EnumeratePrinters(EnumeratePrintersCallback callback) = 0;

  using GetDefaultPrinterNameCallback = base::OnceCallback<void(base::expected<
  std::string,
  ::printing::mojom::ResultCode>)>;
  using GetDefaultPrinterNameResult = base::expected<
  std::string,
  ::printing::mojom::ResultCode>;
  using GetDefaultPrinterNameMojoCallback = base::OnceCallback<void(PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr)>;

  virtual void GetDefaultPrinterName(GetDefaultPrinterNameCallback callback) = 0;

  using FetchCapabilitiesCallback = base::OnceCallback<void(base::expected<
  PrinterCapsAndInfoPtr,
  ::printing::mojom::ResultCode>)>;
  using FetchCapabilitiesResult = base::expected<
  PrinterCapsAndInfoPtr,
  ::printing::mojom::ResultCode>;
  using FetchCapabilitiesMojoCallback = base::OnceCallback<void(PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr)>;

  virtual void FetchCapabilities(const std::string& printer_name, FetchCapabilitiesCallback callback) = 0;

  virtual void EstablishPrintingContext(uint32_t context_id) = 0;

  using UseDefaultSettingsCallback = base::OnceCallback<void(base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode>)>;
  using UseDefaultSettingsResult = base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode>;
  using UseDefaultSettingsMojoCallback = base::OnceCallback<void(PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr)>;

  virtual void UseDefaultSettings(uint32_t context_id, UseDefaultSettingsCallback callback) = 0;

  using UpdatePrintSettingsCallback = base::OnceCallback<void(base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode>)>;
  using UpdatePrintSettingsResult = base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode>;
  using UpdatePrintSettingsMojoCallback = base::OnceCallback<void(PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr)>;

  virtual void UpdatePrintSettings(uint32_t context_id, ::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) = 0;

  using StartPrintingCallback = base::OnceCallback<void(::printing::mojom::ResultCode, int32_t)>;
  using StartPrintingMojoCallback = base::OnceCallback<void(::printing::mojom::ResultCode, int32_t)>;

  virtual void StartPrinting(uint32_t context_id, int32_t document_cookie, const ::std::u16string& document_name, const std::optional<::printing::PrintSettings>& settings, StartPrintingCallback callback) = 0;

  using RenderPrintedDocumentCallback = base::OnceCallback<void(::printing::mojom::ResultCode)>;
  using RenderPrintedDocumentMojoCallback = base::OnceCallback<void(::printing::mojom::ResultCode)>;

  virtual void RenderPrintedDocument(int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc, RenderPrintedDocumentCallback callback) = 0;

  using DocumentDoneCallback = base::OnceCallback<void(::printing::mojom::ResultCode)>;
  using DocumentDoneMojoCallback = base::OnceCallback<void(::printing::mojom::ResultCode)>;

  virtual void DocumentDone(int32_t document_cookie, DocumentDoneCallback callback) = 0;

  using CancelCallback = base::OnceCallback<void()>;
  using CancelMojoCallback = base::OnceCallback<void()>;

  virtual void Cancel(int32_t document_cookie, CancelCallback callback) = 0;
};



class  UnsandboxedPrintBackendHostProxy
    : public UnsandboxedPrintBackendHost {
 public:
  using InterfaceType = UnsandboxedPrintBackendHost;

  explicit UnsandboxedPrintBackendHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindBackend(::mojo::PendingReceiver<PrintBackendService> service) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SandboxedPrintBackendHostProxy
    : public SandboxedPrintBackendHost {
 public:
  using InterfaceType = SandboxedPrintBackendHost;

  explicit SandboxedPrintBackendHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindBackend(::mojo::PendingReceiver<PrintBackendService> service) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PrintBackendServiceProxy
    : public PrintBackendService {
 public:
  using InterfaceType = PrintBackendService;

  explicit PrintBackendServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Init(const std::string& locale) final;
  
  void Poke() final;
  
  void EnumeratePrinters(EnumeratePrintersCallback callback) final;
  
  void GetDefaultPrinterName(GetDefaultPrinterNameCallback callback) final;
  
  void FetchCapabilities(const std::string& printer_name, FetchCapabilitiesCallback callback) final;
  
  void EstablishPrintingContext(uint32_t context_id) final;
  
  void UseDefaultSettings(uint32_t context_id, UseDefaultSettingsCallback callback) final;
  
  void UpdatePrintSettings(uint32_t context_id, ::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) final;
  
  void StartPrinting(uint32_t context_id, int32_t document_cookie, const ::std::u16string& document_name, const std::optional<::printing::PrintSettings>& settings, StartPrintingCallback callback) final;
  
  void RenderPrintedDocument(int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc, RenderPrintedDocumentCallback callback) final;
  
  void DocumentDone(int32_t document_cookie, DocumentDoneCallback callback) final;
  
  void Cancel(int32_t document_cookie, CancelCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UnsandboxedPrintBackendHostStubDispatch {
 public:
  static bool Accept(UnsandboxedPrintBackendHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UnsandboxedPrintBackendHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UnsandboxedPrintBackendHost>>
class UnsandboxedPrintBackendHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UnsandboxedPrintBackendHostStub() = default;
  ~UnsandboxedPrintBackendHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnsandboxedPrintBackendHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UnsandboxedPrintBackendHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SandboxedPrintBackendHostStubDispatch {
 public:
  static bool Accept(SandboxedPrintBackendHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SandboxedPrintBackendHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SandboxedPrintBackendHost>>
class SandboxedPrintBackendHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SandboxedPrintBackendHostStub() = default;
  ~SandboxedPrintBackendHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SandboxedPrintBackendHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SandboxedPrintBackendHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintBackendServiceStubDispatch {
 public:
  static bool Accept(PrintBackendService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintBackendService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintBackendService>>
class PrintBackendServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintBackendServiceStub() = default;
  ~PrintBackendServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintBackendServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintBackendServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UnsandboxedPrintBackendHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SandboxedPrintBackendHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintBackendServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintBackendServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  PrintBackendService_EnumeratePrinters_ResponseParam_Result {
 public:
  using DataView = PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView;
  using Data_ = internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data;
  using Tag = Data_::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Tag;

  template <typename... Args>
  static PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr NewSuccess(
      std::vector<::printing::PrinterBasicInfo> value);
  // Construct an instance holding |failure|.
  static PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr NewFailure(
      ::printing::mojom::ResultCode value);

  template <typename U>
  static PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintBackendService_EnumeratePrinters_ResponseParam_Result>::Convert(*this);
  }
  ~PrintBackendService_EnumeratePrinters_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PrintBackendService_EnumeratePrinters_ResponseParam_Result(const PrintBackendService_EnumeratePrinters_ResponseParam_Result& other) = delete;
  PrintBackendService_EnumeratePrinters_ResponseParam_Result& operator=(const PrintBackendService_EnumeratePrinters_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr>
  PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_EnumeratePrinters_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_EnumeratePrinters_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const std::vector<::printing::PrinterBasicInfo>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  std::vector<::printing::PrinterBasicInfo>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(std::vector<::printing::PrinterBasicInfo> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ::printing::mojom::ResultCode get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::printing::mojom::ResultCode failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintBackendService_EnumeratePrinters_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PrintBackendService_EnumeratePrinters_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        std::vector<::printing::PrinterBasicInfo> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::printing::mojom::ResultCode value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<::printing::PrinterBasicInfo> success;
    ::printing::mojom::ResultCode failure;
  };

  PrintBackendService_EnumeratePrinters_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      std::vector<::printing::PrinterBasicInfo> value);
  PrintBackendService_EnumeratePrinters_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::printing::mojom::ResultCode value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  PrintBackendService_GetDefaultPrinterName_ResponseParam_Result {
 public:
  using DataView = PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView;
  using Data_ = internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data;
  using Tag = Data_::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Tag;

  template <typename... Args>
  static PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr NewSuccess(
      const std::string& value);
  // Construct an instance holding |failure|.
  static PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr NewFailure(
      ::printing::mojom::ResultCode value);

  template <typename U>
  static PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintBackendService_GetDefaultPrinterName_ResponseParam_Result>::Convert(*this);
  }
  ~PrintBackendService_GetDefaultPrinterName_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PrintBackendService_GetDefaultPrinterName_ResponseParam_Result(const PrintBackendService_GetDefaultPrinterName_ResponseParam_Result& other) = delete;
  PrintBackendService_GetDefaultPrinterName_ResponseParam_Result& operator=(const PrintBackendService_GetDefaultPrinterName_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr>
  PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_GetDefaultPrinterName_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_GetDefaultPrinterName_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const std::string& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  std::string& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const std::string& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ::printing::mojom::ResultCode get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::printing::mojom::ResultCode failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::printing::mojom::ResultCode value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string success;
    ::printing::mojom::ResultCode failure;
  };

  PrintBackendService_GetDefaultPrinterName_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const std::string& value);
  PrintBackendService_GetDefaultPrinterName_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::printing::mojom::ResultCode value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  PrintBackendService_FetchCapabilities_ResponseParam_Result {
 public:
  using DataView = PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView;
  using Data_ = internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data;
  using Tag = Data_::PrintBackendService_FetchCapabilities_ResponseParam_Result_Tag;

  template <typename... Args>
  static PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr NewSuccess(
      PrinterCapsAndInfoPtr value);
  // Construct an instance holding |failure|.
  static PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr NewFailure(
      ::printing::mojom::ResultCode value);

  template <typename U>
  static PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintBackendService_FetchCapabilities_ResponseParam_Result>::Convert(*this);
  }
  ~PrintBackendService_FetchCapabilities_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PrintBackendService_FetchCapabilities_ResponseParam_Result(const PrintBackendService_FetchCapabilities_ResponseParam_Result& other) = delete;
  PrintBackendService_FetchCapabilities_ResponseParam_Result& operator=(const PrintBackendService_FetchCapabilities_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr>
  PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_FetchCapabilities_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_FetchCapabilities_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const PrinterCapsAndInfoPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  PrinterCapsAndInfoPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(PrinterCapsAndInfoPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ::printing::mojom::ResultCode get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::printing::mojom::ResultCode failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintBackendService_FetchCapabilities_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PrintBackendService_FetchCapabilities_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        PrinterCapsAndInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::printing::mojom::ResultCode value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    PrinterCapsAndInfoPtr success;
    ::printing::mojom::ResultCode failure;
  };

  PrintBackendService_FetchCapabilities_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      PrinterCapsAndInfoPtr value);
  PrintBackendService_FetchCapabilities_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::printing::mojom::ResultCode value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  PrintBackendService_UseDefaultSettings_ResponseParam_Result {
 public:
  using DataView = PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView;
  using Data_ = internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data;
  using Tag = Data_::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Tag;

  template <typename... Args>
  static PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr NewSuccess(
      const ::printing::PrintSettings& value);
  // Construct an instance holding |failure|.
  static PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr NewFailure(
      ::printing::mojom::ResultCode value);

  template <typename U>
  static PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintBackendService_UseDefaultSettings_ResponseParam_Result>::Convert(*this);
  }
  ~PrintBackendService_UseDefaultSettings_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PrintBackendService_UseDefaultSettings_ResponseParam_Result(const PrintBackendService_UseDefaultSettings_ResponseParam_Result& other) = delete;
  PrintBackendService_UseDefaultSettings_ResponseParam_Result& operator=(const PrintBackendService_UseDefaultSettings_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr>
  PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_UseDefaultSettings_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_UseDefaultSettings_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::printing::PrintSettings& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::printing::PrintSettings& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::printing::PrintSettings& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ::printing::mojom::ResultCode get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::printing::mojom::ResultCode failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintBackendService_UseDefaultSettings_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PrintBackendService_UseDefaultSettings_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::printing::PrintSettings& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::printing::mojom::ResultCode value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::printing::PrintSettings success;
    ::printing::mojom::ResultCode failure;
  };

  PrintBackendService_UseDefaultSettings_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::printing::PrintSettings& value);
  PrintBackendService_UseDefaultSettings_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::printing::mojom::ResultCode value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  PrintBackendService_UpdatePrintSettings_ResponseParam_Result {
 public:
  using DataView = PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView;
  using Data_ = internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data;
  using Tag = Data_::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Tag;

  template <typename... Args>
  static PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr NewSuccess(
      const ::printing::PrintSettings& value);
  // Construct an instance holding |failure|.
  static PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr NewFailure(
      ::printing::mojom::ResultCode value);

  template <typename U>
  static PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintBackendService_UpdatePrintSettings_ResponseParam_Result>::Convert(*this);
  }
  ~PrintBackendService_UpdatePrintSettings_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PrintBackendService_UpdatePrintSettings_ResponseParam_Result(const PrintBackendService_UpdatePrintSettings_ResponseParam_Result& other) = delete;
  PrintBackendService_UpdatePrintSettings_ResponseParam_Result& operator=(const PrintBackendService_UpdatePrintSettings_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr>
  PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_UpdatePrintSettings_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintBackendService_UpdatePrintSettings_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::printing::PrintSettings& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::printing::PrintSettings& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::printing::PrintSettings& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  ::printing::mojom::ResultCode get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::printing::mojom::ResultCode failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::printing::PrintSettings& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::printing::mojom::ResultCode value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::printing::PrintSettings success;
    ::printing::mojom::ResultCode failure;
  };

  PrintBackendService_UpdatePrintSettings_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::printing::PrintSettings& value);
  PrintBackendService_UpdatePrintSettings_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::printing::mojom::ResultCode value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  PrinterCapsAndInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrinterCapsAndInfo, T>::value>;
  using DataView = PrinterCapsAndInfoDataView;
  using Data_ = internal::PrinterCapsAndInfo_Data;

  template <typename... Args>
  static PrinterCapsAndInfoPtr New(Args&&... args) {
    return PrinterCapsAndInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrinterCapsAndInfoPtr From(const U& u) {
    return mojo::TypeConverter<PrinterCapsAndInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrinterCapsAndInfo>::Convert(*this);
  }


  PrinterCapsAndInfo();

  PrinterCapsAndInfo(
      const ::printing::PrinterBasicInfo& printer_info,
      const ::printing::PrinterSemanticCapsAndDefaults& printer_caps);


  ~PrinterCapsAndInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrinterCapsAndInfoPtr>
  PrinterCapsAndInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrinterCapsAndInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrinterCapsAndInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrinterCapsAndInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrinterCapsAndInfo_UnserializedMessageContext<
            UserType, PrinterCapsAndInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrinterCapsAndInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrinterCapsAndInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrinterCapsAndInfo_UnserializedMessageContext<
            UserType, PrinterCapsAndInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrinterCapsAndInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::printing::PrinterBasicInfo printer_info;
  
  ::printing::PrinterSemanticCapsAndDefaults printer_caps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrinterCapsAndInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr PrintBackendService_EnumeratePrinters_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PrintBackendService_EnumeratePrinters_ResponseParam_Result>::value>::type*>
bool PrintBackendService_EnumeratePrinters_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PrintBackendService_GetDefaultPrinterName_ResponseParam_Result>::value>::type*>
bool PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr PrintBackendService_FetchCapabilities_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PrintBackendService_FetchCapabilities_ResponseParam_Result>::value>::type*>
bool PrintBackendService_FetchCapabilities_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr PrintBackendService_UseDefaultSettings_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PrintBackendService_UseDefaultSettings_ResponseParam_Result>::value>::type*>
bool PrintBackendService_UseDefaultSettings_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr PrintBackendService_UpdatePrintSettings_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PrintBackendService_UpdatePrintSettings_ResponseParam_Result>::value>::type*>
bool PrintBackendService_UpdatePrintSettings_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
PrinterCapsAndInfoPtr PrinterCapsAndInfo::Clone() const {
  return New(
      mojo::Clone(printer_info),
      mojo::Clone(printer_caps)
  );
}

template <typename T, PrinterCapsAndInfo::EnableIfSame<T>*>
bool PrinterCapsAndInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->printer_info, other_struct.printer_info))
    return false;
  if (!mojo::Equals(this->printer_caps, other_struct.printer_caps))
    return false;
  return true;
}

template <typename T, PrinterCapsAndInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.printer_info < rhs.printer_info)
    return true;
  if (rhs.printer_info < lhs.printer_info)
    return false;
  if (lhs.printer_caps < rhs.printer_caps)
    return true;
  if (rhs.printer_caps < lhs.printer_caps)
    return false;
  return false;
}


}  // printing::mojom

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PrinterCapsAndInfo::DataView,
                                         ::printing::mojom::PrinterCapsAndInfoPtr> {
  static bool IsNull(const ::printing::mojom::PrinterCapsAndInfoPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrinterCapsAndInfoPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrinterCapsAndInfo::printer_info)& printer_info(
      const ::printing::mojom::PrinterCapsAndInfoPtr& input) {
    return input->printer_info;
  }

  static const decltype(::printing::mojom::PrinterCapsAndInfo::printer_caps)& printer_caps(
      const ::printing::mojom::PrinterCapsAndInfoPtr& input) {
    return input->printer_caps;
  }

  static bool Read(::printing::mojom::PrinterCapsAndInfo::DataView input, ::printing::mojom::PrinterCapsAndInfoPtr* output);
};


template <>
struct  UnionTraits<::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::DataView,
                                        ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr> {
  static bool IsNull(const ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::Tag GetTag(const ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const std::vector<::printing::PrinterBasicInfo>& success(const ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::printing::mojom::ResultCode failure(const ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_Result::DataView input, ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DataView,
                                        ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr> {
  static bool IsNull(const ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::Tag GetTag(const ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const std::string& success(const ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::printing::mojom::ResultCode failure(const ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result::DataView input, ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::DataView,
                                        ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr> {
  static bool IsNull(const ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::Tag GetTag(const ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::printing::mojom::PrinterCapsAndInfoPtr& success(const ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::printing::mojom::ResultCode failure(const ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_Result::DataView input, ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::DataView,
                                        ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr> {
  static bool IsNull(const ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::Tag GetTag(const ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::printing::PrintSettings& success(const ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::printing::mojom::ResultCode failure(const ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_Result::DataView input, ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DataView,
                                        ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr> {
  static bool IsNull(const ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::Tag GetTag(const ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::printing::PrintSettings& success(const ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::printing::mojom::ResultCode failure(const ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_Result::DataView input, ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_H_