// chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-params-data.h"
namespace printing {
namespace mojom {

NOINLINE static const char* PwgRasterSettings_TransformTypeToStringHelper(PwgRasterSettings_TransformType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PwgRasterSettings_TransformType::TRANSFORM_NORMAL:
      return "TRANSFORM_NORMAL";
    case PwgRasterSettings_TransformType::TRANSFORM_ROTATE_180:
      return "TRANSFORM_ROTATE_180";
    case PwgRasterSettings_TransformType::TRANSFORM_FLIP_HORIZONTAL:
      return "TRANSFORM_FLIP_HORIZONTAL";
    case PwgRasterSettings_TransformType::TRANSFORM_FLIP_VERTICAL:
      return "TRANSFORM_FLIP_VERTICAL";
    default:
      return nullptr;
  }
}

std::string PwgRasterSettings_TransformTypeToString(PwgRasterSettings_TransformType value) {
  const char *str = PwgRasterSettings_TransformTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PwgRasterSettings_TransformType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PwgRasterSettings_TransformType value) {
  return os << PwgRasterSettings_TransformTypeToString(value);
}

NOINLINE static const char* PwgRasterSettings_DuplexModeToStringHelper(PwgRasterSettings_DuplexMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PwgRasterSettings_DuplexMode::SIMPLEX:
      return "SIMPLEX";
    case PwgRasterSettings_DuplexMode::LONG_EDGE:
      return "LONG_EDGE";
    case PwgRasterSettings_DuplexMode::SHORT_EDGE:
      return "SHORT_EDGE";
    default:
      return nullptr;
  }
}

std::string PwgRasterSettings_DuplexModeToString(PwgRasterSettings_DuplexMode value) {
  const char *str = PwgRasterSettings_DuplexModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PwgRasterSettings_DuplexMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PwgRasterSettings_DuplexMode value) {
  return os << PwgRasterSettings_DuplexModeToString(value);
}

namespace internal {


// static
bool PwgRasterSettings_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PwgRasterSettings_Data* object =
      static_cast<const PwgRasterSettings_Data*>(data);


  if (!::printing::mojom::internal::PwgRasterSettings_DuplexMode_Data
        ::Validate(object->duplex_mode, validation_context))
    return false;


  if (!::printing::mojom::internal::PwgRasterSettings_TransformType_Data
        ::Validate(object->odd_page_transform, validation_context))
    return false;

  return true;
}

PwgRasterSettings_Data::PwgRasterSettings_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfToPwgRasterConverter_Convert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfToPwgRasterConverter_Convert_Params_Data* object =
      static_cast<const PdfToPwgRasterConverter_Convert_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pdf_region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pdf_region, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pdf_settings, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pdf_settings, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pwg_raster_settings, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pwg_raster_settings, validation_context))
    return false;

  return true;
}

PdfToPwgRasterConverter_Convert_Params_Data::PdfToPwgRasterConverter_Convert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfToPwgRasterConverter_Convert_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfToPwgRasterConverter_Convert_ResponseParams_Data* object =
      static_cast<const PdfToPwgRasterConverter_Convert_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->pwg_raster_region, validation_context))
    return false;

  return true;
}

PdfToPwgRasterConverter_Convert_ResponseParams_Data::PdfToPwgRasterConverter_Convert_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data* object =
      static_cast<const PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data*>(data);

  return true;
}

PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PwgRasterSettings_TransformType>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PwgRasterSettings_TransformType value) {
  return std::move(context).WriteString(::printing::mojom::PwgRasterSettings_TransformTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PwgRasterSettings_DuplexMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PwgRasterSettings_DuplexMode value) {
  return std::move(context).WriteString(::printing::mojom::PwgRasterSettings_DuplexModeToString(value));
}

} // namespace perfetto