// chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_PARAMS_DATA_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace printing::mojom {
namespace internal {
class  PdfToPwgRasterConverter_Convert_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> pdf_region;
  mojo::internal::Pointer<::printing::mojom::internal::PdfRenderSettings_Data> pdf_settings;
  mojo::internal::Pointer<internal::PwgRasterSettings_Data> pwg_raster_settings;

 private:
  friend class mojo::internal::MessageFragment<PdfToPwgRasterConverter_Convert_Params_Data>;

  PdfToPwgRasterConverter_Convert_Params_Data();
  ~PdfToPwgRasterConverter_Convert_Params_Data() = delete;
};
static_assert(sizeof(PdfToPwgRasterConverter_Convert_Params_Data) == 32,
              "Bad sizeof(PdfToPwgRasterConverter_Convert_Params_Data)");
class  PdfToPwgRasterConverter_Convert_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> pwg_raster_region;
  uint32_t page_count;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PdfToPwgRasterConverter_Convert_ResponseParams_Data>;

  PdfToPwgRasterConverter_Convert_ResponseParams_Data();
  ~PdfToPwgRasterConverter_Convert_ResponseParams_Data() = delete;
};
static_assert(sizeof(PdfToPwgRasterConverter_Convert_ResponseParams_Data) == 24,
              "Bad sizeof(PdfToPwgRasterConverter_Convert_ResponseParams_Data)");
class  PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t use_skia : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data>;

  PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data();
  ~PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data() = delete;
};
static_assert(sizeof(PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data) == 16,
              "Bad sizeof(PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data)");

}  // namespace internal


class PdfToPwgRasterConverter_Convert_ParamsDataView {
 public:
  PdfToPwgRasterConverter_Convert_ParamsDataView() = default;

  PdfToPwgRasterConverter_Convert_ParamsDataView(
      internal::PdfToPwgRasterConverter_Convert_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPdfRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfRegion(UserType* output) {
    
    auto* pointer = data_->pdf_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetPdfSettingsDataView(
      ::printing::mojom::PdfRenderSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfSettings(UserType* output) {
    
    auto* pointer = data_->pdf_settings.Get();
    return mojo::internal::Deserialize<::printing::mojom::PdfRenderSettingsDataView>(
        pointer, output, message_);
  }
  inline void GetPwgRasterSettingsDataView(
      PwgRasterSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPwgRasterSettings(UserType* output) {
    
    auto* pointer = data_->pwg_raster_settings.Get();
    return mojo::internal::Deserialize<::printing::mojom::PwgRasterSettingsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PdfToPwgRasterConverter_Convert_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfToPwgRasterConverter_Convert_ResponseParamsDataView {
 public:
  PdfToPwgRasterConverter_Convert_ResponseParamsDataView() = default;

  PdfToPwgRasterConverter_Convert_ResponseParamsDataView(
      internal::PdfToPwgRasterConverter_Convert_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPwgRasterRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPwgRasterRegion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `pwg_raster_region` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPwgRasterRegion` instead "
    "of `ReadPwgRasterRegion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pwg_raster_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  uint32_t page_count() const {
    return data_->page_count;
  }
 private:
  internal::PdfToPwgRasterConverter_Convert_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_ParamsDataView {
 public:
  PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_ParamsDataView() = default;

  PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_ParamsDataView(
      internal::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool use_skia() const {
    return data_->use_skia;
  }
 private:
  internal::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data* data_ = nullptr;
};

inline void PdfToPwgRasterConverter_Convert_ParamsDataView::GetPdfRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->pdf_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void PdfToPwgRasterConverter_Convert_ParamsDataView::GetPdfSettingsDataView(
    ::printing::mojom::PdfRenderSettingsDataView* output) {
  auto pointer = data_->pdf_settings.Get();
  *output = ::printing::mojom::PdfRenderSettingsDataView(pointer, message_);
}
inline void PdfToPwgRasterConverter_Convert_ParamsDataView::GetPwgRasterSettingsDataView(
    PwgRasterSettingsDataView* output) {
  auto pointer = data_->pwg_raster_settings.Get();
  *output = PwgRasterSettingsDataView(pointer, message_);
}


inline void PdfToPwgRasterConverter_Convert_ResponseParamsDataView::GetPwgRasterRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->pwg_raster_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}





}  // printing::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_PARAMS_DATA_H_