// chrome/services/printing/public/mojom/pdf_render_settings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "chrome/services/printing/public/mojom/pdf_render_settings_mojom_traits.h"




namespace printing::mojom {








class  PdfRenderSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PdfRenderSettings, T>::value>;
  using DataView = PdfRenderSettingsDataView;
  using Data_ = internal::PdfRenderSettings_Data;
  using Mode = PdfRenderSettings_Mode;

  template <typename... Args>
  static PdfRenderSettingsPtr New(Args&&... args) {
    return PdfRenderSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PdfRenderSettingsPtr From(const U& u) {
    return mojo::TypeConverter<PdfRenderSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PdfRenderSettings>::Convert(*this);
  }


  PdfRenderSettings();

  PdfRenderSettings(
      const ::gfx::Rect& area,
      const ::gfx::Point& offsets,
      const ::gfx::Size& dpi,
      bool autorotate,
      bool use_color,
      ::printing::PdfRenderSettings::Mode mode);


  ~PdfRenderSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PdfRenderSettingsPtr>
  PdfRenderSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PdfRenderSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PdfRenderSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PdfRenderSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PdfRenderSettings_UnserializedMessageContext<
            UserType, PdfRenderSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PdfRenderSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PdfRenderSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PdfRenderSettings_UnserializedMessageContext<
            UserType, PdfRenderSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PdfRenderSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect area;
  
  ::gfx::Point offsets;
  
  ::gfx::Size dpi;
  
  bool autorotate;
  
  bool use_color;
  
  ::printing::PdfRenderSettings::Mode mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PdfRenderSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PdfRenderSettingsPtr PdfRenderSettings::Clone() const {
  return New(
      mojo::Clone(area),
      mojo::Clone(offsets),
      mojo::Clone(dpi),
      mojo::Clone(autorotate),
      mojo::Clone(use_color),
      mojo::Clone(mode)
  );
}

template <typename T, PdfRenderSettings::EnableIfSame<T>*>
bool PdfRenderSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->area, other_struct.area))
    return false;
  if (!mojo::Equals(this->offsets, other_struct.offsets))
    return false;
  if (!mojo::Equals(this->dpi, other_struct.dpi))
    return false;
  if (!mojo::Equals(this->autorotate, other_struct.autorotate))
    return false;
  if (!mojo::Equals(this->use_color, other_struct.use_color))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  return true;
}

template <typename T, PdfRenderSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.area < rhs.area)
    return true;
  if (rhs.area < lhs.area)
    return false;
  if (lhs.offsets < rhs.offsets)
    return true;
  if (rhs.offsets < lhs.offsets)
    return false;
  if (lhs.dpi < rhs.dpi)
    return true;
  if (rhs.dpi < lhs.dpi)
    return false;
  if (lhs.autorotate < rhs.autorotate)
    return true;
  if (rhs.autorotate < lhs.autorotate)
    return false;
  if (lhs.use_color < rhs.use_color)
    return true;
  if (rhs.use_color < lhs.use_color)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  return false;
}


}  // printing::mojom

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PdfRenderSettings::DataView,
                                         ::printing::mojom::PdfRenderSettingsPtr> {
  static bool IsNull(const ::printing::mojom::PdfRenderSettingsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PdfRenderSettingsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PdfRenderSettings::area)& area(
      const ::printing::mojom::PdfRenderSettingsPtr& input) {
    return input->area;
  }

  static const decltype(::printing::mojom::PdfRenderSettings::offsets)& offsets(
      const ::printing::mojom::PdfRenderSettingsPtr& input) {
    return input->offsets;
  }

  static const decltype(::printing::mojom::PdfRenderSettings::dpi)& dpi(
      const ::printing::mojom::PdfRenderSettingsPtr& input) {
    return input->dpi;
  }

  static decltype(::printing::mojom::PdfRenderSettings::autorotate) autorotate(
      const ::printing::mojom::PdfRenderSettingsPtr& input) {
    return input->autorotate;
  }

  static decltype(::printing::mojom::PdfRenderSettings::use_color) use_color(
      const ::printing::mojom::PdfRenderSettingsPtr& input) {
    return input->use_color;
  }

  static decltype(::printing::mojom::PdfRenderSettings::mode) mode(
      const ::printing::mojom::PdfRenderSettingsPtr& input) {
    return input->mode;
  }

  static bool Read(::printing::mojom::PdfRenderSettings::DataView input, ::printing::mojom::PdfRenderSettingsPtr* output);
};

}  // namespace mojo

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_H_