// chrome/services/media_gallery_util/public/mojom/media_parser.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_TEST_UTILS_H_
#define CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_TEST_UTILS_H_

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom.h"


namespace chrome::mojom {


class  MediaParserInterceptorForTesting : public MediaParser {
  virtual MediaParser* GetForwardingInterface() = 0;
  void ParseMediaMetadata(const std::string& mime_type, int64_t total_size, bool get_attached_images, ::mojo::PendingRemote<MediaDataSource> media_data_source, ParseMediaMetadataCallback callback) override;
  void CheckMediaFile(::base::TimeDelta decode_time, ::base::File file, CheckMediaFileCallback callback) override;
  void GetCpuInfo(GetCpuInfoCallback callback) override;
};
class  MediaParserAsyncWaiter {
 public:
  explicit MediaParserAsyncWaiter(MediaParser* proxy);

  MediaParserAsyncWaiter(const MediaParserAsyncWaiter&) = delete;
  MediaParserAsyncWaiter& operator=(const MediaParserAsyncWaiter&) = delete;

  ~MediaParserAsyncWaiter();
  void ParseMediaMetadata(
      const std::string& mime_type, int64_t total_size, bool get_attached_images, ::mojo::PendingRemote<MediaDataSource> media_data_source, bool* out_parse_success, MediaMetadataPtr* out_metadata, std::vector<::metadata::AttachedImage>* out_attached_images);
  
  void CheckMediaFile(
      ::base::TimeDelta decode_time, ::base::File file, bool* out_success);
  bool CheckMediaFile(::base::TimeDelta decode_time, ::base::File file);
  void GetCpuInfo(
      int64_t* out_libyuv_cpu_flags, int64_t* out_ffmpeg_cpu_flags);
  

 private:
  MediaParser* const proxy_;
};


class  MediaParserFactoryInterceptorForTesting : public MediaParserFactory {
  virtual MediaParserFactory* GetForwardingInterface() = 0;
  void CreateMediaParser(int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags, CreateMediaParserCallback callback) override;
};
class  MediaParserFactoryAsyncWaiter {
 public:
  explicit MediaParserFactoryAsyncWaiter(MediaParserFactory* proxy);

  MediaParserFactoryAsyncWaiter(const MediaParserFactoryAsyncWaiter&) = delete;
  MediaParserFactoryAsyncWaiter& operator=(const MediaParserFactoryAsyncWaiter&) = delete;

  ~MediaParserFactoryAsyncWaiter();
  void CreateMediaParser(
      int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags, ::mojo::PendingRemote<MediaParser>* out_media_parser);
  ::mojo::PendingRemote<MediaParser> CreateMediaParser(int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags);

 private:
  MediaParserFactory* const proxy_;
};


class  MediaDataSourceInterceptorForTesting : public MediaDataSource {
  virtual MediaDataSource* GetForwardingInterface() = 0;
  void Read(int64_t position, int64_t length, ReadCallback callback) override;
};
class  MediaDataSourceAsyncWaiter {
 public:
  explicit MediaDataSourceAsyncWaiter(MediaDataSource* proxy);

  MediaDataSourceAsyncWaiter(const MediaDataSourceAsyncWaiter&) = delete;
  MediaDataSourceAsyncWaiter& operator=(const MediaDataSourceAsyncWaiter&) = delete;

  ~MediaDataSourceAsyncWaiter();
  void Read(
      int64_t position, int64_t length, std::vector<uint8_t>* out_data);
  std::vector<uint8_t> Read(int64_t position, int64_t length);

 private:
  MediaDataSource* const proxy_;
};




}  // chrome::mojom

#endif  // CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_TEST_UTILS_H_