// chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-params-data.h"
namespace chrome {
namespace mojom {

namespace internal {


// static
bool MediaStreamInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaStreamInfo_Data* object =
      static_cast<const MediaStreamInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_properties, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->additional_properties, validation_context))
    return false;

  return true;
}

MediaStreamInfo_Data::MediaStreamInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetadata_Data* object =
      static_cast<const MediaMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->album, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& album_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->album, validation_context,
                                         &album_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artist, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& artist_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->artist, validation_context,
                                         &artist_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->comment, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& comment_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->comment, validation_context,
                                         &comment_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->copyright, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& copyright_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->copyright, validation_context,
                                         &copyright_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->genre, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& genre_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->genre, validation_context,
                                         &genre_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_tags, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_tags_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_tags, validation_context,
                                         &raw_tags_validate_params)) {
    return false;
  }

  return true;
}

MediaMetadata_Data::MediaMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AttachedImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AttachedImage_Data* object =
      static_cast<const AttachedImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

AttachedImage_Data::AttachedImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParser_ParseMediaMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParser_ParseMediaMetadata_Params_Data* object =
      static_cast<const MediaParser_ParseMediaMetadata_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_data_source, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_data_source,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaParser_ParseMediaMetadata_Params_Data::MediaParser_ParseMediaMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParser_ParseMediaMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParser_ParseMediaMetadata_ResponseParams_Data* object =
      static_cast<const MediaParser_ParseMediaMetadata_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attached_images, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attached_images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attached_images, validation_context,
                                         &attached_images_validate_params)) {
    return false;
  }

  return true;
}

MediaParser_ParseMediaMetadata_ResponseParams_Data::MediaParser_ParseMediaMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParser_CheckMediaFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParser_CheckMediaFile_Params_Data* object =
      static_cast<const MediaParser_CheckMediaFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decode_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->decode_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

MediaParser_CheckMediaFile_Params_Data::MediaParser_CheckMediaFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParser_CheckMediaFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParser_CheckMediaFile_ResponseParams_Data* object =
      static_cast<const MediaParser_CheckMediaFile_ResponseParams_Data*>(data);

  return true;
}

MediaParser_CheckMediaFile_ResponseParams_Data::MediaParser_CheckMediaFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParser_GetCpuInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParser_GetCpuInfo_Params_Data* object =
      static_cast<const MediaParser_GetCpuInfo_Params_Data*>(data);

  return true;
}

MediaParser_GetCpuInfo_Params_Data::MediaParser_GetCpuInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParser_GetCpuInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParser_GetCpuInfo_ResponseParams_Data* object =
      static_cast<const MediaParser_GetCpuInfo_ResponseParams_Data*>(data);

  return true;
}

MediaParser_GetCpuInfo_ResponseParams_Data::MediaParser_GetCpuInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParserFactory_CreateMediaParser_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParserFactory_CreateMediaParser_Params_Data* object =
      static_cast<const MediaParserFactory_CreateMediaParser_Params_Data*>(data);

  return true;
}

MediaParserFactory_CreateMediaParser_Params_Data::MediaParserFactory_CreateMediaParser_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaParserFactory_CreateMediaParser_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaParserFactory_CreateMediaParser_ResponseParams_Data* object =
      static_cast<const MediaParserFactory_CreateMediaParser_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_parser, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_parser,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaParserFactory_CreateMediaParser_ResponseParams_Data::MediaParserFactory_CreateMediaParser_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaDataSource_Read_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaDataSource_Read_Params_Data* object =
      static_cast<const MediaDataSource_Read_Params_Data*>(data);

  return true;
}

MediaDataSource_Read_Params_Data::MediaDataSource_Read_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaDataSource_Read_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaDataSource_Read_ResponseParams_Data* object =
      static_cast<const MediaDataSource_Read_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

MediaDataSource_Read_ResponseParams_Data::MediaDataSource_Read_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome