// chrome/common/read_anything/read_anything.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_SHARED_H_
#define CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/read_anything/read_anything.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/accessibility/ax_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/read_anything/read_anything.mojom-data-view.h"




namespace std {

template <>
struct hash<::read_anything::mojom::InstallationState>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::InstallationState> {};

template <>
struct hash<::read_anything::mojom::ErrorCode>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::ErrorCode> {};

template <>
struct hash<::read_anything::mojom::Colors>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::Colors> {};

template <>
struct hash<::read_anything::mojom::LetterSpacing>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::LetterSpacing> {};

template <>
struct hash<::read_anything::mojom::LineSpacing>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::LineSpacing> {};

template <>
struct hash<::read_anything::mojom::HighlightGranularity>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::HighlightGranularity> {};

template <>
struct hash<::read_anything::mojom::DistillationStatus>
    : public mojo::internal::EnumHashImpl<::read_anything::mojom::DistillationStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::InstallationState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::InstallationState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::InstallationState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::ErrorCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::ErrorCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::ErrorCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::Colors, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::Colors, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::Colors>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::LetterSpacing, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::LetterSpacing, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::LetterSpacing>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::LineSpacing, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::LineSpacing, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::LineSpacing>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::HighlightGranularity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::HighlightGranularity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::HighlightGranularity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::DistillationStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::read_anything::mojom::DistillationStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::DistillationStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::VoicePackInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::read_anything::mojom::VoicePackInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::read_anything::mojom::internal::VoicePackInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::pack_state(input)) in_pack_state = Traits::pack_state(input);
    mojo::internal::MessageFragment<decltype(fragment->pack_state)>
        pack_state_fragment(fragment.message());
    pack_state_fragment.Claim(&fragment->pack_state);
    
    mojo::internal::Serialize<::read_anything::mojom::VoicePackInstallationStateDataView>(
      in_pack_state,
      pack_state_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pack_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pack_state in VoicePackInfo struct");

    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language,
      language_fragment);

    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in VoicePackInfo struct");
  }

  static bool Deserialize(::read_anything::mojom::internal::VoicePackInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::read_anything::mojom::VoicePackInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::read_anything::mojom::VoicePackInstallationStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::read_anything::mojom::VoicePackInstallationStateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::read_anything::mojom::internal::VoicePackInstallationState_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::read_anything::mojom::VoicePackInstallationStateDataView::Tag::kInstallationState: {
    decltype(Traits::installation_state(input))
    in_installation_state = Traits::installation_state(input);
        
mojo::internal::Serialize<::read_anything::mojom::InstallationState>(
  in_installation_state,
  &fragment->data.f_installation_state);
    break;
  }
  case ::read_anything::mojom::VoicePackInstallationStateDataView::Tag::kErrorCode: {
    decltype(Traits::error_code(input))
    in_error_code = Traits::error_code(input);
        
mojo::internal::Serialize<::read_anything::mojom::ErrorCode>(
  in_error_code,
  &fragment->data.f_error_code);
    break;
  }
}
  }

  static bool Deserialize(::read_anything::mojom::internal::VoicePackInstallationState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::read_anything::mojom::VoicePackInstallationStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace read_anything::mojom {

inline void VoicePackInfoDataView::GetPackStateDataView(
    VoicePackInstallationStateDataView* output) {
  auto pointer = &data_->pack_state;
  *output = VoicePackInstallationStateDataView(pointer, message_);
}
inline void VoicePackInfoDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}




}  // read_anything::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::InstallationState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::InstallationState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::ErrorCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::ErrorCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::Colors> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::Colors value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::LetterSpacing> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::LetterSpacing value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::LineSpacing> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::LineSpacing value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::HighlightGranularity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::HighlightGranularity value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::read_anything::mojom::DistillationStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::read_anything::mojom::DistillationStatus value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_SHARED_H_