// chrome/common/plugin.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_PLUGIN_MOJOM_SHARED_H_
#define CHROME_COMMON_PLUGIN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/plugin.mojom-shared-internal.h"
#include "content/public/common/webplugininfo.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "chrome/common/plugin.mojom-data-view.h"




namespace std {

template <>
struct hash<::chrome::mojom::PluginStatus>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::PluginStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::PluginStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::PluginStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::PluginStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::PluginInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::PluginInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::PluginInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::chrome::mojom::PluginStatus>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::plugin(input)) in_plugin = Traits::plugin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->plugin)::BaseType> plugin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::content::mojom::WebPluginInfoDataView>(
      in_plugin,
      plugin_fragment);

    fragment->plugin.Set(
        plugin_fragment.is_null() ? nullptr : plugin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->plugin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin in PluginInfo struct");

    decltype(Traits::actual_mime_type(input)) in_actual_mime_type = Traits::actual_mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->actual_mime_type)::BaseType> actual_mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_actual_mime_type,
      actual_mime_type_fragment);

    fragment->actual_mime_type.Set(
        actual_mime_type_fragment.is_null() ? nullptr : actual_mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->actual_mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null actual_mime_type in PluginInfo struct");

    decltype(Traits::group_identifier(input)) in_group_identifier = Traits::group_identifier(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_identifier)::BaseType> group_identifier_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_identifier,
      group_identifier_fragment);

    fragment->group_identifier.Set(
        group_identifier_fragment.is_null() ? nullptr : group_identifier_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_identifier.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_identifier in PluginInfo struct");

    decltype(Traits::group_name(input)) in_group_name = Traits::group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_name)::BaseType> group_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_group_name,
      group_name_fragment);

    fragment->group_name.Set(
        group_name_fragment.is_null() ? nullptr : group_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_name in PluginInfo struct");
  }

  static bool Deserialize(::chrome::mojom::internal::PluginInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::PluginInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::PluginParamDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::PluginParamDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::PluginParam_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PluginParam struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in PluginParam struct");
  }

  static bool Deserialize(::chrome::mojom::internal::PluginParam_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::PluginParamDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome::mojom {

inline void PluginInfoDataView::GetPluginDataView(
    ::content::mojom::WebPluginInfoDataView* output) {
  auto pointer = data_->plugin.Get();
  *output = ::content::mojom::WebPluginInfoDataView(pointer, message_);
}
inline void PluginInfoDataView::GetActualMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->actual_mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PluginInfoDataView::GetGroupIdentifierDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_identifier.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PluginInfoDataView::GetGroupNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->group_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PluginParamDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PluginParamDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::PluginStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::PluginStatus value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_PLUGIN_MOJOM_SHARED_H_