// chrome/common/plugin.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_PLUGIN_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_PLUGIN_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/common/plugin.mojom-shared-internal.h"
#include "content/public/common/webplugininfo.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace chrome::mojom {
class PluginInfoDataView;

class PluginParamDataView;



}  // chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome::mojom::PluginInfoDataView> {
  using Data = ::chrome::mojom::internal::PluginInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::PluginParamDataView> {
  using Data = ::chrome::mojom::internal::PluginParam_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome::mojom {


enum class PluginStatus : int32_t {
  
  kAllowed = 0,
  
  kBlocked = 1,
  
  kBlockedByPolicy = 2,
  
  kDisabled = 3,
  
  kNotFound = 4,
  
  kPlayImportantContent = 5,
  
  kUnauthorized = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, PluginStatus value);
inline bool IsKnownEnumValue(PluginStatus value) {
  return internal::PluginStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PluginHostInterfaceBase {};

using PluginHostPtrDataView =
    mojo::InterfacePtrDataView<PluginHostInterfaceBase>;
using PluginHostRequestDataView =
    mojo::InterfaceRequestDataView<PluginHostInterfaceBase>;
using PluginHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PluginHostInterfaceBase>;
using PluginHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PluginHostInterfaceBase>;
class PluginAuthHostInterfaceBase {};

using PluginAuthHostPtrDataView =
    mojo::InterfacePtrDataView<PluginAuthHostInterfaceBase>;
using PluginAuthHostRequestDataView =
    mojo::InterfaceRequestDataView<PluginAuthHostInterfaceBase>;
using PluginAuthHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PluginAuthHostInterfaceBase>;
using PluginAuthHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PluginAuthHostInterfaceBase>;
class PluginInfoHostInterfaceBase {};

using PluginInfoHostPtrDataView =
    mojo::InterfacePtrDataView<PluginInfoHostInterfaceBase>;
using PluginInfoHostRequestDataView =
    mojo::InterfaceRequestDataView<PluginInfoHostInterfaceBase>;
using PluginInfoHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PluginInfoHostInterfaceBase>;
using PluginInfoHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PluginInfoHostInterfaceBase>;


class PluginInfoDataView {
 public:
  PluginInfoDataView() = default;

  PluginInfoDataView(
      internal::PluginInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::chrome::mojom::PluginStatus>(
        data_value, output);
  }
  PluginStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::PluginStatus>(data_->status));
  }
  inline void GetPluginDataView(
      ::content::mojom::WebPluginInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlugin(UserType* output) {
    
    auto* pointer = data_->plugin.Get();
    return mojo::internal::Deserialize<::content::mojom::WebPluginInfoDataView>(
        pointer, output, message_);
  }
  inline void GetActualMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActualMimeType(UserType* output) {
    
    auto* pointer = data_->actual_mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdentifierDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupIdentifier(UserType* output) {
    
    auto* pointer = data_->group_identifier.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGroupNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupName(UserType* output) {
    
    auto* pointer = data_->group_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::PluginInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PluginParamDataView {
 public:
  PluginParamDataView() = default;

  PluginParamDataView(
      internal::PluginParam_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::PluginParam_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // chrome::mojom

#endif  // CHROME_COMMON_PLUGIN_MOJOM_DATA_VIEW_H_