// chrome/common/mac/app_shim.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MAC_APP_SHIM_MOJOM_SHARED_H_
#define CHROME_COMMON_MAC_APP_SHIM_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/mac/app_shim.mojom-shared-internal.h"
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/metrics/public/mojom/histogram_fetcher.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/mac/app_shim.mojom-data-view.h"




namespace std {

template <>
struct hash<::chrome::mojom::AppShimLaunchType>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::AppShimLaunchType> {};

template <>
struct hash<::chrome::mojom::AppShimLaunchResult>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::AppShimLaunchResult> {};

template <>
struct hash<::chrome::mojom::AppShimAttentionType>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::AppShimAttentionType> {};

template <>
struct hash<::chrome::mojom::AppShimLoginItemRestoreState>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::AppShimLoginItemRestoreState> {};

template <>
struct hash<::chrome::mojom::AppShimScreenReaderSupportMode>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::AppShimScreenReaderSupportMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AppShimLaunchType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::AppShimLaunchType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::AppShimLaunchType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AppShimLaunchResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::AppShimLaunchResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::AppShimLaunchResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AppShimAttentionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::AppShimAttentionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::AppShimAttentionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AppShimLoginItemRestoreState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::AppShimLoginItemRestoreState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::AppShimLoginItemRestoreState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AppShimScreenReaderSupportMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::AppShimScreenReaderSupportMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::AppShimScreenReaderSupportMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::ProfileMenuItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::ProfileMenuItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::ProfileMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ProfileMenuItem struct");

    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
      in_icon,
      icon_fragment);

    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());

    fragment->menu_index = Traits::menu_index(input);

    fragment->active = Traits::active(input);

    decltype(Traits::profile_path(input)) in_profile_path = Traits::profile_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->profile_path)::BaseType> profile_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_profile_path,
      profile_path_fragment);

    fragment->profile_path.Set(
        profile_path_fragment.is_null() ? nullptr : profile_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->profile_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null profile_path in ProfileMenuItem struct");
  }

  static bool Deserialize(::chrome::mojom::internal::ProfileMenuItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::ProfileMenuItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::ApplicationDockMenuItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::ApplicationDockMenuItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::ApplicationDockMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ApplicationDockMenuItem struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ApplicationDockMenuItem struct");
  }

  static bool Deserialize(::chrome::mojom::internal::ApplicationDockMenuItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::ApplicationDockMenuItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AppShimInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::AppShimInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::AppShimInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::profile_path(input)) in_profile_path = Traits::profile_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->profile_path)::BaseType> profile_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_profile_path,
      profile_path_fragment);

    fragment->profile_path.Set(
        profile_path_fragment.is_null() ? nullptr : profile_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->profile_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null profile_path in AppShimInfo struct");

    decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_id)::BaseType> app_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id,
      app_id_fragment);

    fragment->app_id.Set(
        app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->app_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppShimInfo struct");

    decltype(Traits::app_url(input)) in_app_url = Traits::app_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_url)::BaseType> app_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_app_url,
      app_url_fragment);

    fragment->app_url.Set(
        app_url_fragment.is_null() ? nullptr : app_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->app_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_url in AppShimInfo struct");

    
    mojo::internal::Serialize<::chrome::mojom::AppShimLaunchType>(
      Traits::launch_type(input),
      &fragment->launch_type);

    decltype(Traits::files(input)) in_files = Traits::files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->files)::BaseType>
        files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_files,
      files_fragment,
      &files_validate_params);

    fragment->files.Set(
        files_fragment.is_null() ? nullptr : files_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->files.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null files in AppShimInfo struct");

    
    mojo::internal::Serialize<::chrome::mojom::AppShimLoginItemRestoreState>(
      Traits::login_item_restore_state(input),
      &fragment->login_item_restore_state);

    decltype(Traits::urls(input)) in_urls = Traits::urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->urls)::BaseType>
        urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_urls,
      urls_fragment,
      &urls_validate_params);

    fragment->urls.Set(
        urls_fragment.is_null() ? nullptr : urls_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->urls.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null urls in AppShimInfo struct");

    decltype(Traits::notification_action_handler(input)) in_notification_action_handler = Traits::notification_action_handler(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationActionHandlerInterfaceBase>>(
      in_notification_action_handler,
      &fragment->notification_action_handler,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->notification_action_handler)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid notification_action_handler in AppShimInfo struct");
  }

  static bool Deserialize(::chrome::mojom::internal::AppShimInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::AppShimInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::FeatureStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::FeatureStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::FeatureState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::field_trial_states(input)) in_field_trial_states = Traits::field_trial_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_trial_states)::BaseType> field_trial_states_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_field_trial_states,
      field_trial_states_fragment);

    fragment->field_trial_states.Set(
        field_trial_states_fragment.is_null() ? nullptr : field_trial_states_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->field_trial_states.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_trial_states in FeatureState struct");

    decltype(Traits::field_trial_params(input)) in_field_trial_params = Traits::field_trial_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_trial_params)::BaseType> field_trial_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_field_trial_params,
      field_trial_params_fragment);

    fragment->field_trial_params.Set(
        field_trial_params_fragment.is_null() ? nullptr : field_trial_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->field_trial_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_trial_params in FeatureState struct");

    decltype(Traits::enable_features(input)) in_enable_features = Traits::enable_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enable_features)::BaseType> enable_features_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_enable_features,
      enable_features_fragment);

    fragment->enable_features.Set(
        enable_features_fragment.is_null() ? nullptr : enable_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->enable_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null enable_features in FeatureState struct");

    decltype(Traits::disable_features(input)) in_disable_features = Traits::disable_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disable_features)::BaseType> disable_features_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_disable_features,
      disable_features_fragment);

    fragment->disable_features.Set(
        disable_features_fragment.is_null() ? nullptr : disable_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->disable_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disable_features in FeatureState struct");
  }

  static bool Deserialize(::chrome::mojom::internal::FeatureState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::FeatureStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome::mojom {

inline void ProfileMenuItemDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ProfileMenuItemDataView::GetIconDataView(
    ::gfx::mojom::ImageSkiaDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::gfx::mojom::ImageSkiaDataView(pointer, message_);
}
inline void ProfileMenuItemDataView::GetProfilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->profile_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void ApplicationDockMenuItemDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ApplicationDockMenuItemDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void AppShimInfoDataView::GetProfilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->profile_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void AppShimInfoDataView::GetAppIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->app_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppShimInfoDataView::GetAppUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->app_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AppShimInfoDataView::GetFilesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}
inline void AppShimInfoDataView::GetUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}


inline void FeatureStateDataView::GetFieldTrialStatesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->field_trial_states.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FeatureStateDataView::GetFieldTrialParamsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->field_trial_params.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FeatureStateDataView::GetEnableFeaturesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->enable_features.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FeatureStateDataView::GetDisableFeaturesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->disable_features.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::AppShimLaunchType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::AppShimLaunchType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::AppShimLaunchResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::AppShimLaunchResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::AppShimAttentionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::AppShimAttentionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::AppShimLoginItemRestoreState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::AppShimLoginItemRestoreState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::AppShimScreenReaderSupportMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::AppShimScreenReaderSupportMode value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_MAC_APP_SHIM_MOJOM_SHARED_H_