// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   chrome/common/extensions/api/experimental_ai_data.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#ifndef CHROME_COMMON_EXTENSIONS_API_EXPERIMENTAL_AI_DATA_H__
#define CHROME_COMMON_EXTENSIONS_API_EXPERIMENTAL_AI_DATA_H__

#include <stdint.h>

#include <map>
#include <memory>
#include <optional>
#include <string>
#include <vector>

#include "base/values.h"

namespace extensions {
namespace api {
namespace experimental_ai_data {

//
// Functions
//

namespace GetAiData {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  int dom_node_id;

  std::string frame_id;

  std::string user_input;

  int tab_id;


 private:
  Params();
};

namespace Results {

base::Value::List Create(const std::vector<uint8_t>& data);
}  // namespace Results

}  // namespace GetAiData

namespace GetAiDataWithSpecifier {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  int tab_id;

  std::vector<uint8_t> ai_data_specifier;


 private:
  Params();
};

namespace Results {

base::Value::List Create(const std::vector<uint8_t>& data);
}  // namespace Results

}  // namespace GetAiDataWithSpecifier

}  // namespace experimental_ai_data
}  // namespace api
}  // namespace extensions

#endif  // CHROME_COMMON_EXTENSIONS_API_EXPERIMENTAL_AI_DATA_H__
