// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/apps/platform_apps/api/generated_schemas.h"

#include <algorithm>
#include <iterator>
#include <string_view>

#include "base/containers/fixed_flat_map.h"

namespace {
constexpr char kBrowser[] = R"R({"namespace":"browser","types":[{"id":"browser.OpenTabOptions","properties":{"url":{"name":"url","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"browser.OpenTabOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"openTab","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kMediaGalleries[] = R"R({"namespace":"mediaGalleries","types":[{"id":"mediaGalleries.GalleryChangeType","type":"string","enum":[{"name":"contents_changed"},{"name":"watch_dropped"}]},{"id":"mediaGalleries.GetMediaFileSystemsInteractivity","type":"string","enum":[{"name":"no"},{"name":"yes"},{"name":"if_needed"}]},{"id":"mediaGalleries.GetMetadataType","type":"string","enum":[{"name":"all"},{"name":"mimeTypeAndTags"},{"name":"mimeTypeOnly"}]},{"id":"mediaGalleries.GalleryChangeDetails","properties":{"type":{"name":"type","$ref":"mediaGalleries.GalleryChangeType"},"galleryId":{"name":"galleryId","type":"string"}},"type":"object"},{"id":"mediaGalleries.MediaFileSystemsDetails","properties":{"interactive":{"optional":true,"name":"interactive","$ref":"mediaGalleries.GetMediaFileSystemsInteractivity"}},"type":"object"},{"id":"mediaGalleries.MediaMetadataOptions","properties":{"metadataType":{"optional":true,"name":"metadataType","$ref":"mediaGalleries.GetMetadataType"}},"type":"object"},{"id":"mediaGalleries.MediaFileSystemMetadata","properties":{"name":{"name":"name","type":"string"},"galleryId":{"name":"galleryId","type":"string"},"deviceId":{"optional":true,"name":"deviceId","type":"string"},"isRemovable":{"name":"isRemovable","type":"boolean"},"isMediaDevice":{"name":"isMediaDevice","type":"boolean"},"isAvailable":{"name":"isAvailable","type":"boolean"}},"type":"object"},{"id":"mediaGalleries.StreamInfo","properties":{"type":{"name":"type","type":"string"},"tags":{"name":"tags","type":"object","additionalProperties":{"type":"any"}}},"type":"object"},{"id":"mediaGalleries.MediaMetadata","properties":{"mimeType":{"name":"mimeType","type":"string"},"height":{"optional":true,"name":"height","type":"integer"},"width":{"optional":true,"name":"width","type":"integer"},"duration":{"optional":true,"name":"duration","type":"number"},"rotation":{"optional":true,"name":"rotation","type":"integer"},"album":{"optional":true,"name":"album","type":"string"},"artist":{"optional":true,"name":"artist","type":"string"},"comment":{"optional":true,"name":"comment","type":"string"},"copyright":{"optional":true,"name":"copyright","type":"string"},"disc":{"optional":true,"name":"disc","type":"integer"},"genre":{"optional":true,"name":"genre","type":"string"},"language":{"optional":true,"name":"language","type":"string"},"title":{"optional":true,"name":"title","type":"string"},"track":{"optional":true,"name":"track","type":"integer"},"rawTags":{"name":"rawTags","type":"array","items":{"$ref":"mediaGalleries.StreamInfo"}},"attachedImages":{"name":"attachedImages","type":"array","items":{"type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Blob"}}},"type":"object"},{"id":"mediaGalleries.AddGalleryWatchResult","properties":{"galleryId":{"name":"galleryId","type":"string"},"success":{"name":"success","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"details","optional":true,"$ref":"mediaGalleries.MediaFileSystemsDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"mediaFileSystems","type":"array","items":{"type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DOMFileSystem"}}]},"name":"getMediaFileSystems","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"mediaFileSystems","type":"array","items":{"type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DOMFileSystem"}},{"name":"selectedFileSystemName","type":"string"}],"does_not_support_promises":"Multi-parameter callback crbug.com/1313625"},"name":"addUserSelectedFolder","type":"function"},{"parameters":[{"name":"mediaFileSystem","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DOMFileSystem"}],"returns":{"name":"getMediaFileSystemMetadata","$ref":"mediaGalleries.MediaFileSystemMetadata","optional":true},"name":"getMediaFileSystemMetadata","type":"function"},{"parameters":[{"name":"mediaFile","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Blob"},{"name":"options","optional":true,"$ref":"mediaGalleries.MediaMetadataOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"metadata","$ref":"mediaGalleries.MediaMetadata"}]},"name":"getMetadata","type":"function"},{"parameters":[{"name":"galleryId","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"mediaGalleries.AddGalleryWatchResult"}]},"name":"addGalleryWatch","type":"function"},{"parameters":[{"name":"galleryId","type":"string"}],"name":"removeGalleryWatch","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"details","$ref":"mediaGalleries.GalleryChangeDetails"}],"name":"onGalleryChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSyncFileSystem[] = R"R({"namespace":"syncFileSystem","types":[{"id":"syncFileSystem.SyncAction","type":"string","enum":[{"name":"added"},{"name":"updated"},{"name":"deleted"}]},{"id":"syncFileSystem.ServiceStatus","type":"string","enum":[{"name":"initializing"},{"name":"running"},{"name":"authentication_required"},{"name":"temporary_unavailable"},{"name":"disabled"}]},{"id":"syncFileSystem.FileStatus","type":"string","enum":[{"name":"synced"},{"name":"pending"},{"name":"conflicting"}]},{"id":"syncFileSystem.SyncDirection","type":"string","enum":[{"name":"local_to_remote"},{"name":"remote_to_local"}]},{"id":"syncFileSystem.ConflictResolutionPolicy","type":"string","enum":[{"name":"last_write_win"},{"name":"manual"}]},{"id":"syncFileSystem.FileInfo","properties":{"fileEntry":{"name":"fileEntry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"},"status":{"name":"status","$ref":"syncFileSystem.FileStatus"},"action":{"optional":true,"name":"action","$ref":"syncFileSystem.SyncAction"},"direction":{"optional":true,"name":"direction","$ref":"syncFileSystem.SyncDirection"}},"type":"object"},{"id":"syncFileSystem.FileStatusInfo","properties":{"fileEntry":{"name":"fileEntry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"},"status":{"name":"status","$ref":"syncFileSystem.FileStatus"},"error":{"optional":true,"name":"error","type":"string"}},"type":"object"},{"id":"syncFileSystem.StorageInfo","properties":{"usageBytes":{"name":"usageBytes","type":"integer"},"quotaBytes":{"name":"quotaBytes","type":"integer"}},"type":"object"},{"id":"syncFileSystem.ServiceInfo","properties":{"state":{"name":"state","$ref":"syncFileSystem.ServiceStatus"},"description":{"name":"description","type":"string"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"fileSystem","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DOMFileSystem"}]},"name":"requestFileSystem","type":"function"},{"parameters":[{"name":"policy","$ref":"syncFileSystem.ConflictResolutionPolicy"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setConflictResolutionPolicy","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"policy","$ref":"syncFileSystem.ConflictResolutionPolicy"}]},"name":"getConflictResolutionPolicy","type":"function"},{"parameters":[{"name":"fileSystem","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DOMFileSystem"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"syncFileSystem.StorageInfo"}]},"name":"getUsageAndQuota","type":"function"},{"parameters":[{"name":"fileEntry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"syncFileSystem.FileStatus"}]},"name":"getFileStatus","type":"function"},{"parameters":[{"name":"fileEntries","type":"array","items":{"type":"object","additionalProperties":{"type":"any"}}}],"returns_async":{"name":"callback","parameters":[{"name":"status","type":"array","items":{"$ref":"syncFileSystem.FileStatusInfo"}}]},"name":"getFileStatuses","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"status","$ref":"syncFileSystem.ServiceStatus"}]},"name":"getServiceStatus","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"detail","$ref":"syncFileSystem.ServiceInfo"}],"name":"onServiceStatusChanged","type":"function"},{"parameters":[{"name":"detail","$ref":"syncFileSystem.FileInfo"}],"name":"onFileStatusChanged","type":"function"}],"platforms":null,"deprecated":null})R";
}  // namespace

namespace chrome_apps {
namespace api {

// static
bool ChromeAppsGeneratedSchemas::IsGenerated(std::string_view name) {
  return !Get(name).empty();
}

// static
std::string_view ChromeAppsGeneratedSchemas::Get(std::string_view name) {
  static constexpr auto kSchemas = base::MakeFixedFlatMap<std::string_view, std::string_view>({
    {"browser", kBrowser},
    {"mediaGalleries", kMediaGalleries},
    {"syncFileSystem", kSyncFileSystem},
  });
  auto it = kSchemas.find(name);
  return it != kSchemas.end() ? it->second : std::string_view();
}

}  // namespace api
}  // namespace chrome_apps
