// chrome/common/actor_webui.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/actor_webui.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/actor_webui.mojom-params-data.h"
#include "chrome/common/actor_webui.mojom-shared-message-ids.h"

#include "chrome/common/actor_webui.mojom-import-headers.h"
#include "chrome/common/actor_webui.mojom-test-utils.h"


namespace actor::webui::mojom {
TaskOptions::TaskOptions()
    : title() {}

TaskOptions::TaskOptions(
    const std::optional<std::string>& title_in)
    : title(std::move(title_in)) {}

TaskOptions::~TaskOptions() = default;

void TaskOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TaskOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Credential::Credential()
    : id(),
      username(),
      source_site_or_app(),
      request_origin() {}

Credential::Credential(
    int32_t id_in,
    const std::string& username_in,
    const std::string& source_site_or_app_in,
    const ::url::Origin& request_origin_in)
    : id(std::move(id_in)),
      username(std::move(username_in)),
      source_site_or_app(std::move(source_site_or_app_in)),
      request_origin(std::move(request_origin_in)) {}

Credential::~Credential() = default;

void Credential::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username"), this->username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_site_or_app"), this->source_site_or_app,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_origin"), this->request_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Credential::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectCredentialDialogRequest::SelectCredentialDialogRequest()
    : task_id(),
      show_dialog(),
      credentials(),
      icons() {}

SelectCredentialDialogRequest::SelectCredentialDialogRequest(
    int32_t task_id_in,
    bool show_dialog_in,
    std::vector<CredentialPtr> credentials_in,
    const base::flat_map<std::string, ::SkBitmap>& icons_in)
    : task_id(std::move(task_id_in)),
      show_dialog(std::move(show_dialog_in)),
      credentials(std::move(credentials_in)),
      icons(std::move(icons_in)) {}

SelectCredentialDialogRequest::~SelectCredentialDialogRequest() = default;

void SelectCredentialDialogRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_dialog"), this->show_dialog,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials"), this->credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CredentialPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, ::SkBitmap>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectCredentialDialogRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectCredentialDialogResponse::SelectCredentialDialogResponse()
    : task_id(),
      error_reason(),
      permission_duration(),
      selected_credential_id() {}

SelectCredentialDialogResponse::SelectCredentialDialogResponse(
    int32_t task_id_in,
    std::optional<SelectCredentialDialogErrorReason> error_reason_in,
    std::optional<UserGrantedPermissionDuration> permission_duration_in,
    std::optional<int32_t> selected_credential_id_in)
    : task_id(std::move(task_id_in)),
      error_reason(std::move(error_reason_in)),
      permission_duration(std::move(permission_duration_in)),
      selected_credential_id(std::move(selected_credential_id_in)) {}

SelectCredentialDialogResponse::~SelectCredentialDialogResponse() = default;

void SelectCredentialDialogResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_reason"), this->error_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<SelectCredentialDialogErrorReason>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_duration"), this->permission_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<UserGrantedPermissionDuration>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_credential_id"), this->selected_credential_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectCredentialDialogResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutofillSuggestion::AutofillSuggestion()
    : id(),
      title(),
      details(),
      icon() {}

AutofillSuggestion::AutofillSuggestion(
    const std::string& id_in,
    const std::string& title_in,
    const std::string& details_in,
    const ::SkBitmap& icon_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      details(std::move(details_in)),
      icon(std::move(icon_in)) {}

AutofillSuggestion::~AutofillSuggestion() = default;

void AutofillSuggestion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkBitmap&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutofillSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormFillingRequest::FormFillingRequest()
    : requested_data(),
      suggestions() {}

FormFillingRequest::FormFillingRequest(
    int64_t requested_data_in,
    std::vector<AutofillSuggestionPtr> suggestions_in)
    : requested_data(std::move(requested_data_in)),
      suggestions(std::move(suggestions_in)) {}

FormFillingRequest::~FormFillingRequest() = default;

void FormFillingRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_data"), this->requested_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions"), this->suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AutofillSuggestionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormFillingRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectAutofillSuggestionsDialogRequest::SelectAutofillSuggestionsDialogRequest()
    : task_id(),
      form_filling_requests() {}

SelectAutofillSuggestionsDialogRequest::SelectAutofillSuggestionsDialogRequest(
    int32_t task_id_in,
    std::vector<FormFillingRequestPtr> form_filling_requests_in)
    : task_id(std::move(task_id_in)),
      form_filling_requests(std::move(form_filling_requests_in)) {}

SelectAutofillSuggestionsDialogRequest::~SelectAutofillSuggestionsDialogRequest() = default;

void SelectAutofillSuggestionsDialogRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_filling_requests"), this->form_filling_requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FormFillingRequestPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectAutofillSuggestionsDialogRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormFillingResponse::FormFillingResponse()
    : selected_suggestion_id() {}

FormFillingResponse::FormFillingResponse(
    const std::string& selected_suggestion_id_in)
    : selected_suggestion_id(std::move(selected_suggestion_id_in)) {}

FormFillingResponse::~FormFillingResponse() = default;
size_t FormFillingResponse::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->selected_suggestion_id);
  return seed;
}

void FormFillingResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_suggestion_id"), this->selected_suggestion_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormFillingResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectAutofillSuggestionsDialogResponse::SelectAutofillSuggestionsDialogResponse()
    : task_id(),
      result() {}

SelectAutofillSuggestionsDialogResponse::SelectAutofillSuggestionsDialogResponse(
    int32_t task_id_in,
    SelectAutofillSuggestionsDialogResultPtr result_in)
    : task_id(std::move(task_id_in)),
      result(std::move(result_in)) {}

SelectAutofillSuggestionsDialogResponse::~SelectAutofillSuggestionsDialogResponse() = default;

void SelectAutofillSuggestionsDialogResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SelectAutofillSuggestionsDialogResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectAutofillSuggestionsDialogResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserConfirmationDialogPayload::UserConfirmationDialogPayload()
    : navigation_origin(),
      for_blocklisted_origin() {}

UserConfirmationDialogPayload::UserConfirmationDialogPayload(
    const ::url::Origin& navigation_origin_in,
    bool for_blocklisted_origin_in)
    : navigation_origin(std::move(navigation_origin_in)),
      for_blocklisted_origin(std::move(for_blocklisted_origin_in)) {}

UserConfirmationDialogPayload::~UserConfirmationDialogPayload() = default;

void UserConfirmationDialogPayload::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_origin"), this->navigation_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "for_blocklisted_origin"), this->for_blocklisted_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserConfirmationDialogPayload::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserConfirmationDialogRequest::UserConfirmationDialogRequest()
    : payload() {}

UserConfirmationDialogRequest::UserConfirmationDialogRequest(
    UserConfirmationDialogPayloadPtr payload_in)
    : payload(std::move(payload_in)) {}

UserConfirmationDialogRequest::~UserConfirmationDialogRequest() = default;

void UserConfirmationDialogRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload"), this->payload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserConfirmationDialogPayloadPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserConfirmationDialogRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserConfirmationDialogResponse::UserConfirmationDialogResponse()
    : result() {}

UserConfirmationDialogResponse::UserConfirmationDialogResponse(
    ConfirmationRequestResultPtr result_in)
    : result(std::move(result_in)) {}

UserConfirmationDialogResponse::~UserConfirmationDialogResponse() = default;
size_t UserConfirmationDialogResponse::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->result);
  return seed;
}

void UserConfirmationDialogResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConfirmationRequestResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserConfirmationDialogResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationConfirmationRequest::NavigationConfirmationRequest()
    : task_id(),
      navigation_origin() {}

NavigationConfirmationRequest::NavigationConfirmationRequest(
    int32_t task_id_in,
    const ::url::Origin& navigation_origin_in)
    : task_id(std::move(task_id_in)),
      navigation_origin(std::move(navigation_origin_in)) {}

NavigationConfirmationRequest::~NavigationConfirmationRequest() = default;

void NavigationConfirmationRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_origin"), this->navigation_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NavigationConfirmationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationConfirmationResponse::NavigationConfirmationResponse()
    : result() {}

NavigationConfirmationResponse::NavigationConfirmationResponse(
    ConfirmationRequestResultPtr result_in)
    : result(std::move(result_in)) {}

NavigationConfirmationResponse::~NavigationConfirmationResponse() = default;
size_t NavigationConfirmationResponse::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->result);
  return seed;
}

void NavigationConfirmationResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConfirmationRequestResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NavigationConfirmationResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectAutofillSuggestionsDialogResultPtr
SelectAutofillSuggestionsDialogResult::NewErrorReason(
    SelectAutofillSuggestionsDialogErrorReason value) {
  return SelectAutofillSuggestionsDialogResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
      std::move(value));
}

SelectAutofillSuggestionsDialogResultPtr
SelectAutofillSuggestionsDialogResult::NewSelectedSuggestions(
    std::vector<FormFillingResponsePtr> value) {
  return SelectAutofillSuggestionsDialogResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSelectedSuggestions)>,
      std::move(value));
}

SelectAutofillSuggestionsDialogResult::SelectAutofillSuggestionsDialogResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    SelectAutofillSuggestionsDialogErrorReason value)
    : tag_(Tag::kErrorReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
            std::move(value)) {}

SelectAutofillSuggestionsDialogResult::SelectAutofillSuggestionsDialogResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSelectedSuggestions)>,
    std::vector<FormFillingResponsePtr> value)
    : tag_(Tag::kSelectedSuggestions),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSelectedSuggestions)>,
            std::move(value)) {}
SelectAutofillSuggestionsDialogResult::~SelectAutofillSuggestionsDialogResult() {
  DestroyActive();
}

void SelectAutofillSuggestionsDialogResult::set_error_reason(SelectAutofillSuggestionsDialogErrorReason error_reason) {
  if (tag_ != Tag::kErrorReason) {
    DestroyActive();
    tag_ = Tag::kErrorReason;
  }
  data_.error_reason = error_reason;
}

void SelectAutofillSuggestionsDialogResult::set_selected_suggestions(std::vector<FormFillingResponsePtr> selected_suggestions) {
  if (tag_ == Tag::kSelectedSuggestions) {
    data_.selected_suggestions = std::move(selected_suggestions);
  } else {
    DestroyActive();
    tag_ = Tag::kSelectedSuggestions;
    new (&data_.selected_suggestions) std::vector<FormFillingResponsePtr>(
        std::move(selected_suggestions));
  }
}


SelectAutofillSuggestionsDialogResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    SelectAutofillSuggestionsDialogErrorReason value)
    : error_reason(std::move(value)) {}

SelectAutofillSuggestionsDialogResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSelectedSuggestions)>,
    std::vector<FormFillingResponsePtr> value)
    : selected_suggestions(std::move(value)) {}

void SelectAutofillSuggestionsDialogResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorReason:
      std::destroy_at(&data_.error_reason);
      break;
    case Tag::kSelectedSuggestions:
      std::destroy_at(&data_.selected_suggestions);
      break;
  }
}

bool SelectAutofillSuggestionsDialogResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UserConfirmationDialogResultPtr
UserConfirmationDialogResult::NewPermissionGranted(
    bool value) {
  return UserConfirmationDialogResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPermissionGranted)>,
      std::move(value));
}

UserConfirmationDialogResultPtr
UserConfirmationDialogResult::NewErrorReason(
    ConfirmationRequestErrorReason value) {
  return UserConfirmationDialogResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
      std::move(value));
}

UserConfirmationDialogResult::UserConfirmationDialogResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
    bool value)
    : tag_(Tag::kPermissionGranted),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPermissionGranted)>,
            std::move(value)) {}

UserConfirmationDialogResult::UserConfirmationDialogResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    ConfirmationRequestErrorReason value)
    : tag_(Tag::kErrorReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
            std::move(value)) {}
UserConfirmationDialogResult::~UserConfirmationDialogResult() {
  DestroyActive();
}

void UserConfirmationDialogResult::set_permission_granted(bool permission_granted) {
  if (tag_ != Tag::kPermissionGranted) {
    DestroyActive();
    tag_ = Tag::kPermissionGranted;
  }
  data_.permission_granted = permission_granted;
}

void UserConfirmationDialogResult::set_error_reason(ConfirmationRequestErrorReason error_reason) {
  if (tag_ != Tag::kErrorReason) {
    DestroyActive();
    tag_ = Tag::kErrorReason;
  }
  data_.error_reason = error_reason;
}


UserConfirmationDialogResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
    bool value)
    : permission_granted(std::move(value)) {}

UserConfirmationDialogResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    ConfirmationRequestErrorReason value)
    : error_reason(std::move(value)) {}

void UserConfirmationDialogResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPermissionGranted:
      std::destroy_at(&data_.permission_granted);
      break;
    case Tag::kErrorReason:
      std::destroy_at(&data_.error_reason);
      break;
  }
}
size_t UserConfirmationDialogResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kPermissionGranted:
      return mojo::internal::Hash(seed, data_.permission_granted);
    case Tag::kErrorReason:
      return mojo::internal::Hash(seed, data_.error_reason);
    default:
      NOTREACHED();
  }
}

bool UserConfirmationDialogResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ConfirmationRequestResultPtr
ConfirmationRequestResult::NewPermissionGranted(
    bool value) {
  return ConfirmationRequestResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPermissionGranted)>,
      std::move(value));
}

ConfirmationRequestResultPtr
ConfirmationRequestResult::NewErrorReason(
    ConfirmationRequestErrorReason value) {
  return ConfirmationRequestResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
      std::move(value));
}

ConfirmationRequestResult::ConfirmationRequestResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
    bool value)
    : tag_(Tag::kPermissionGranted),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPermissionGranted)>,
            std::move(value)) {}

ConfirmationRequestResult::ConfirmationRequestResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    ConfirmationRequestErrorReason value)
    : tag_(Tag::kErrorReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
            std::move(value)) {}
ConfirmationRequestResult::~ConfirmationRequestResult() {
  DestroyActive();
}

void ConfirmationRequestResult::set_permission_granted(bool permission_granted) {
  if (tag_ != Tag::kPermissionGranted) {
    DestroyActive();
    tag_ = Tag::kPermissionGranted;
  }
  data_.permission_granted = permission_granted;
}

void ConfirmationRequestResult::set_error_reason(ConfirmationRequestErrorReason error_reason) {
  if (tag_ != Tag::kErrorReason) {
    DestroyActive();
    tag_ = Tag::kErrorReason;
  }
  data_.error_reason = error_reason;
}


ConfirmationRequestResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
    bool value)
    : permission_granted(std::move(value)) {}

ConfirmationRequestResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    ConfirmationRequestErrorReason value)
    : error_reason(std::move(value)) {}

void ConfirmationRequestResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPermissionGranted:
      std::destroy_at(&data_.permission_granted);
      break;
    case Tag::kErrorReason:
      std::destroy_at(&data_.error_reason);
      break;
  }
}
size_t ConfirmationRequestResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kPermissionGranted:
      return mojo::internal::Hash(seed, data_.permission_granted);
    case Tag::kErrorReason:
      return mojo::internal::Hash(seed, data_.error_reason);
    default:
      NOTREACHED();
  }
}

bool ConfirmationRequestResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // actor::webui::mojom


namespace mojo {


// static
bool StructTraits<::actor::webui::mojom::TaskOptions::DataView, ::actor::webui::mojom::TaskOptionsPtr>::Read(
    ::actor::webui::mojom::TaskOptions::DataView input,
    ::actor::webui::mojom::TaskOptionsPtr* output) {
  bool success = true;
  ::actor::webui::mojom::TaskOptionsPtr result(::actor::webui::mojom::TaskOptions::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::Credential::DataView, ::actor::webui::mojom::CredentialPtr>::Read(
    ::actor::webui::mojom::Credential::DataView input,
    ::actor::webui::mojom::CredentialPtr* output) {
  bool success = true;
  ::actor::webui::mojom::CredentialPtr result(::actor::webui::mojom::Credential::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadUsername(&result->username))
        success = false;
      if (success && !input.ReadSourceSiteOrApp(&result->source_site_or_app))
        success = false;
      if (success && !input.ReadRequestOrigin(&result->request_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::SelectCredentialDialogRequest::DataView, ::actor::webui::mojom::SelectCredentialDialogRequestPtr>::Read(
    ::actor::webui::mojom::SelectCredentialDialogRequest::DataView input,
    ::actor::webui::mojom::SelectCredentialDialogRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::SelectCredentialDialogRequestPtr result(::actor::webui::mojom::SelectCredentialDialogRequest::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success)
        result->show_dialog = input.show_dialog();
      if (success && !input.ReadCredentials(&result->credentials))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::SelectCredentialDialogResponse::DataView, ::actor::webui::mojom::SelectCredentialDialogResponsePtr>::Read(
    ::actor::webui::mojom::SelectCredentialDialogResponse::DataView input,
    ::actor::webui::mojom::SelectCredentialDialogResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::SelectCredentialDialogResponsePtr result(::actor::webui::mojom::SelectCredentialDialogResponse::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success && !input.ReadErrorReason(&result->error_reason)) {
        success = false;
      }
      if (success && !input.ReadPermissionDuration(&result->permission_duration)) {
        success = false;
      }
      if (success) {
        result->selected_credential_id = input.selected_credential_id();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::AutofillSuggestion::DataView, ::actor::webui::mojom::AutofillSuggestionPtr>::Read(
    ::actor::webui::mojom::AutofillSuggestion::DataView input,
    ::actor::webui::mojom::AutofillSuggestionPtr* output) {
  bool success = true;
  ::actor::webui::mojom::AutofillSuggestionPtr result(::actor::webui::mojom::AutofillSuggestion::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::FormFillingRequest::DataView, ::actor::webui::mojom::FormFillingRequestPtr>::Read(
    ::actor::webui::mojom::FormFillingRequest::DataView input,
    ::actor::webui::mojom::FormFillingRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::FormFillingRequestPtr result(::actor::webui::mojom::FormFillingRequest::New());
  
      if (success)
        result->requested_data = input.requested_data();
      if (success && !input.ReadSuggestions(&result->suggestions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::DataView, ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr>::Read(
    ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::DataView input,
    ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr result(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequest::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success && !input.ReadFormFillingRequests(&result->form_filling_requests))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::FormFillingResponse::DataView, ::actor::webui::mojom::FormFillingResponsePtr>::Read(
    ::actor::webui::mojom::FormFillingResponse::DataView input,
    ::actor::webui::mojom::FormFillingResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::FormFillingResponsePtr result(::actor::webui::mojom::FormFillingResponse::New());
  
      if (success && !input.ReadSelectedSuggestionId(&result->selected_suggestion_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::DataView, ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr>::Read(
    ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::DataView input,
    ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr result(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponse::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::UserConfirmationDialogPayload::DataView, ::actor::webui::mojom::UserConfirmationDialogPayloadPtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogPayload::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogPayloadPtr* output) {
  bool success = true;
  ::actor::webui::mojom::UserConfirmationDialogPayloadPtr result(::actor::webui::mojom::UserConfirmationDialogPayload::New());
  
      if (success && !input.ReadNavigationOrigin(&result->navigation_origin))
        success = false;
      if (success)
        result->for_blocklisted_origin = input.for_blocklisted_origin();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::UserConfirmationDialogRequest::DataView, ::actor::webui::mojom::UserConfirmationDialogRequestPtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogRequest::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::UserConfirmationDialogRequestPtr result(::actor::webui::mojom::UserConfirmationDialogRequest::New());
  
      if (success && !input.ReadPayload(&result->payload))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::UserConfirmationDialogResponse::DataView, ::actor::webui::mojom::UserConfirmationDialogResponsePtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogResponse::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::UserConfirmationDialogResponsePtr result(::actor::webui::mojom::UserConfirmationDialogResponse::New());
  
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::NavigationConfirmationRequest::DataView, ::actor::webui::mojom::NavigationConfirmationRequestPtr>::Read(
    ::actor::webui::mojom::NavigationConfirmationRequest::DataView input,
    ::actor::webui::mojom::NavigationConfirmationRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::NavigationConfirmationRequestPtr result(::actor::webui::mojom::NavigationConfirmationRequest::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success && !input.ReadNavigationOrigin(&result->navigation_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::NavigationConfirmationResponse::DataView, ::actor::webui::mojom::NavigationConfirmationResponsePtr>::Read(
    ::actor::webui::mojom::NavigationConfirmationResponse::DataView input,
    ::actor::webui::mojom::NavigationConfirmationResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::NavigationConfirmationResponsePtr result(::actor::webui::mojom::NavigationConfirmationResponse::New());
  
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResult::DataView, ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr>::Read(
    ::actor::webui::mojom::SelectAutofillSuggestionsDialogResult::DataView input,
    ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultPtr* output) {
  using UnionType = ::actor::webui::mojom::SelectAutofillSuggestionsDialogResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorReason: {
      ::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason result_error_reason;
      if (!input.ReadErrorReason(&result_error_reason))
        return false;

      *output = UnionType::NewErrorReason(result_error_reason);
      break;
    }
    case Tag::kSelectedSuggestions: {
      std::vector<::actor::webui::mojom::FormFillingResponsePtr> result_selected_suggestions{};
      if (!input.ReadSelectedSuggestions(&result_selected_suggestions))
        return false;

      *output = UnionType::NewSelectedSuggestions(
          std::move(result_selected_suggestions));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::actor::webui::mojom::UserConfirmationDialogResult::DataView, ::actor::webui::mojom::UserConfirmationDialogResultPtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogResult::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogResultPtr* output) {
  using UnionType = ::actor::webui::mojom::UserConfirmationDialogResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPermissionGranted: {
      *output = UnionType::NewPermissionGranted(input.permission_granted());
      break;
    }
    case Tag::kErrorReason: {
      ::actor::webui::mojom::ConfirmationRequestErrorReason result_error_reason;
      if (!input.ReadErrorReason(&result_error_reason))
        return false;

      *output = UnionType::NewErrorReason(result_error_reason);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::actor::webui::mojom::ConfirmationRequestResult::DataView, ::actor::webui::mojom::ConfirmationRequestResultPtr>::Read(
    ::actor::webui::mojom::ConfirmationRequestResult::DataView input,
    ::actor::webui::mojom::ConfirmationRequestResultPtr* output) {
  using UnionType = ::actor::webui::mojom::ConfirmationRequestResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPermissionGranted: {
      *output = UnionType::NewPermissionGranted(input.permission_granted());
      break;
    }
    case Tag::kErrorReason: {
      ::actor::webui::mojom::ConfirmationRequestErrorReason result_error_reason;
      if (!input.ReadErrorReason(&result_error_reason))
        return false;

      *output = UnionType::NewErrorReason(result_error_reason);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace actor::webui::mojom {




}  // actor::webui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif