// chrome/browser/web_applications/mojom/web_app_shortcut_copier.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/web_applications/mojom/web_app_shortcut_copier.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/web_applications/mojom/web_app_shortcut_copier.mojom-params-data.h"
#include "chrome/browser/web_applications/mojom/web_app_shortcut_copier.mojom-shared-message-ids.h"

#include "chrome/browser/web_applications/mojom/web_app_shortcut_copier.mojom-import-headers.h"
#include "chrome/browser/web_applications/mojom/web_app_shortcut_copier.mojom-test-utils.h"


namespace web_app::mojom {
// The declaration includes the definition on other builds.

WebAppShortcutCopier::IPCStableHashFunction WebAppShortcutCopier::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebAppShortcutCopier>(message.name())) {
    case messages::WebAppShortcutCopier::kCopyWebAppShortcut: {
      return &WebAppShortcutCopier::CopyWebAppShortcut_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebAppShortcutCopier::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebAppShortcutCopier>(message.name())) {
      case messages::WebAppShortcutCopier::kCopyWebAppShortcut:
            return "Receive web_app::mojom::WebAppShortcutCopier::CopyWebAppShortcut";
    }
  } else {
    switch (static_cast<messages::WebAppShortcutCopier>(message.name())) {
      case messages::WebAppShortcutCopier::kCopyWebAppShortcut:
            return "Receive reply web_app::mojom::WebAppShortcutCopier::CopyWebAppShortcut";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebAppShortcutCopier::CopyWebAppShortcut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd864c7ea;  // IPCStableHash for web_app::mojom::WebAppShortcutCopier::CopyWebAppShortcut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool WebAppShortcutCopier::CopyWebAppShortcut(const ::base::FilePath& source_path, const ::base::FilePath& destination_path, bool* out_result) {
  NOTREACHED();
}
class WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse(const WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse&) = delete;
  WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse& operator=(const WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;};

class WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback(
      WebAppShortcutCopier::CopyWebAppShortcutCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback(const WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback&) = delete;
  WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback& operator=(const WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppShortcutCopier::CopyWebAppShortcutCallback callback_;
};

WebAppShortcutCopierProxy::WebAppShortcutCopierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool WebAppShortcutCopierProxy::CopyWebAppShortcut(
    const ::base::FilePath& param_source_path, const ::base::FilePath& param_destination_path, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call web_app::mojom::WebAppShortcutCopier::CopyWebAppShortcut (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_path"), param_source_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_path"), param_destination_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "WebAppShortcutCopier::CopyWebAppShortcut");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppShortcutCopier::kCopyWebAppShortcut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_app::mojom::internal::WebAppShortcutCopier_CopyWebAppShortcut_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_path)::BaseType> source_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_source_path,
    source_path_fragment);

  params->source_path.Set(
      source_path_fragment.is_null() ? nullptr : source_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_path in WebAppShortcutCopier.CopyWebAppShortcut request");
  mojo::internal::MessageFragment<
      typename decltype(params->destination_path)::BaseType> destination_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_destination_path,
    destination_path_fragment);

  params->destination_path.Set(
      destination_path_fragment.is_null() ? nullptr : destination_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination_path in WebAppShortcutCopier.CopyWebAppShortcut request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppShortcutCopier::Name_);
  message.set_method_name("CopyWebAppShortcut");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebAppShortcutCopier::CopyWebAppShortcut", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void WebAppShortcutCopierProxy::CopyWebAppShortcut(
    const ::base::FilePath& in_source_path, const ::base::FilePath& in_destination_path, CopyWebAppShortcutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send web_app::mojom::WebAppShortcutCopier::CopyWebAppShortcut", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_path"), in_source_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_path"), in_destination_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppShortcutCopier::kCopyWebAppShortcut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_app::mojom::internal::WebAppShortcutCopier_CopyWebAppShortcut_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_path)::BaseType> source_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_source_path,
    source_path_fragment);

  params->source_path.Set(
      source_path_fragment.is_null() ? nullptr : source_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_path in WebAppShortcutCopier.CopyWebAppShortcut request");
  mojo::internal::MessageFragment<
      typename decltype(params->destination_path)::BaseType> destination_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_destination_path,
    destination_path_fragment);

  params->destination_path.Set(
      destination_path_fragment.is_null() ? nullptr : destination_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination_path in WebAppShortcutCopier.CopyWebAppShortcut request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppShortcutCopier::Name_);
  message.set_method_name("CopyWebAppShortcut");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppShortcutCopier::CopyWebAppShortcutCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder> proxy(
        new WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppShortcutCopier::CopyWebAppShortcutCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool WebAppShortcutCopier_CopyWebAppShortcut_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppShortcutCopier_CopyWebAppShortcut_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppShortcutCopier_CopyWebAppShortcut_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppShortcutCopier.0
  bool success = true;
  bool p_result{};
  WebAppShortcutCopier_CopyWebAppShortcut_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppShortcutCopier::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply web_app::mojom::WebAppShortcutCopier::CopyWebAppShortcut", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppShortcutCopier::kCopyWebAppShortcut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::web_app::mojom::internal::WebAppShortcutCopier_CopyWebAppShortcut_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppShortcutCopier::Name_);
  message.set_method_name("CopyWebAppShortcut");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebAppShortcutCopier_CopyWebAppShortcut_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppShortcutCopier_CopyWebAppShortcut_ResponseParams_Data* params =
      reinterpret_cast<internal::WebAppShortcutCopier_CopyWebAppShortcut_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebAppShortcutCopier.0
  bool success = true;
  bool p_result{};
  WebAppShortcutCopier_CopyWebAppShortcut_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppShortcutCopier::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}

// static
bool WebAppShortcutCopierStubDispatch::Accept(
    WebAppShortcutCopier* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebAppShortcutCopier>(message->header()->name)) {
    case messages::WebAppShortcutCopier::kCopyWebAppShortcut: {
      break;
    }
  }
  return false;
}

// static
bool WebAppShortcutCopierStubDispatch::AcceptWithResponder(
    WebAppShortcutCopier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebAppShortcutCopier>(message->header()->name)) {
    case messages::WebAppShortcutCopier::kCopyWebAppShortcut: {
      internal::WebAppShortcutCopier_CopyWebAppShortcut_Params_Data* params =
          reinterpret_cast<
              internal::WebAppShortcutCopier_CopyWebAppShortcut_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppShortcutCopier.0
      bool success = true;
      ::base::FilePath p_source_path{};
      ::base::FilePath p_destination_path{};
      WebAppShortcutCopier_CopyWebAppShortcut_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourcePath(&p_source_path))
        success = false;
      if (success && !input_data_view.ReadDestinationPath(&p_destination_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppShortcutCopier::Name_, 0, false);
        return false;
      }
      auto callback =
          WebAppShortcutCopier_CopyWebAppShortcut_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyWebAppShortcut(        
        std::move(p_source_path), 
        std::move(p_destination_path), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebAppShortcutCopierValidationInfo[] = {
    { &internal::WebAppShortcutCopier_CopyWebAppShortcut_Params_Data::Validate,
     &internal::WebAppShortcutCopier_CopyWebAppShortcut_ResponseParams_Data::Validate},
};

bool WebAppShortcutCopierRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::web_app::mojom::WebAppShortcutCopier::Name_,
    kWebAppShortcutCopierValidationInfo);
}

bool WebAppShortcutCopierResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::web_app::mojom::WebAppShortcutCopier::Name_,
    kWebAppShortcutCopierValidationInfo);
}


}  // web_app::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace web_app::mojom {


void WebAppShortcutCopierInterceptorForTesting::CopyWebAppShortcut(const ::base::FilePath& source_path, const ::base::FilePath& destination_path, CopyWebAppShortcutCallback callback) {
  GetForwardingInterface()->CopyWebAppShortcut(
    std::move(source_path)
    , 
    std::move(destination_path)
    , std::move(callback));
}
WebAppShortcutCopierAsyncWaiter::WebAppShortcutCopierAsyncWaiter(
    WebAppShortcutCopier* proxy) : proxy_(proxy) {}

WebAppShortcutCopierAsyncWaiter::~WebAppShortcutCopierAsyncWaiter() = default;


void WebAppShortcutCopierAsyncWaiter::CopyWebAppShortcut(
    const ::base::FilePath& source_path, const ::base::FilePath& destination_path, bool* out_result) {
  base::RunLoop loop;
  proxy_->CopyWebAppShortcut(
      std::move(source_path),
      std::move(destination_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool WebAppShortcutCopierAsyncWaiter::CopyWebAppShortcut(
    const ::base::FilePath& source_path, const ::base::FilePath& destination_path) {
  bool async_wait_result;
  CopyWebAppShortcut(std::move(source_path),std::move(destination_path),&async_wait_result);
  return async_wait_result;
}






}  // web_app::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif