// chrome/browser/ui/webui/whats_new/whats_new.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_WHATS_NEW_WHATS_NEW_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_WHATS_NEW_WHATS_NEW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace whats_new::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "whats_new.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "whats_new.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetServerUrlMinVersion = 0,
    kRecordTimeToLoadContentMinVersion = 0,
    kRecordVersionPageLoadedMinVersion = 0,
    kRecordEditionPageLoadedMinVersion = 0,
    kRecordModuleImpressionMinVersion = 0,
    kRecordExploreMoreToggledMinVersion = 0,
    kRecordScrollDepthMinVersion = 0,
    kRecordTimeOnPageMinVersion = 0,
    kRecordModuleLinkClickedMinVersion = 0,
    kRecordModuleVideoStartedMinVersion = 0,
    kRecordModuleVideoEndedMinVersion = 0,
    kRecordModulePlayClickedMinVersion = 0,
    kRecordModulePauseClickedMinVersion = 0,
    kRecordModuleRestartClickedMinVersion = 0,
    kRecordBrowserCommandExecutedMinVersion = 0,
    kRecordQrCodeToggledMinVersion = 0,
    kRecordNavClickMinVersion = 0,
    kRecordFeatureTileNavigationMinVersion = 0,
    kRecordCarouselScrollButtonClickMinVersion = 0,
    kRecordExpandMediaToggledMinVersion = 0,
    kRecordCtaClickMinVersion = 0,
    kRecordNextButtonClickMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetServerUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordTimeToLoadContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordVersionPageLoaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordEditionPageLoaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModuleImpression_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordExploreMoreToggled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordScrollDepth_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordTimeOnPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModuleLinkClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModuleVideoStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModuleVideoEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModulePlayClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModulePauseClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordModuleRestartClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordBrowserCommandExecuted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordQrCodeToggled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordNavClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordFeatureTileNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordCarouselScrollButtonClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordExpandMediaToggled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordCtaClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordNextButtonClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetServerUrlCallback = base::OnceCallback<void(const ::GURL&)>;
  using GetServerUrlMojoCallback = base::OnceCallback<void(const ::GURL&)>;

  virtual void GetServerUrl(bool is_staging, GetServerUrlCallback callback) = 0;

  virtual void RecordTimeToLoadContent(::base::Time time) = 0;

  virtual void RecordVersionPageLoaded(bool is_auto_open) = 0;

  virtual void RecordEditionPageLoaded(const std::string& page_uid, bool is_auto_open) = 0;

  virtual void RecordModuleImpression(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordExploreMoreToggled(bool expanded) = 0;

  virtual void RecordScrollDepth(ScrollDepth depth) = 0;

  virtual void RecordTimeOnPage(::base::TimeDelta time) = 0;

  virtual void RecordModuleLinkClicked(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordModuleVideoStarted(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordModuleVideoEnded(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordModulePlayClicked(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordModulePauseClicked(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordModuleRestartClicked(const std::string& module_name, ModulePosition position) = 0;

  virtual void RecordBrowserCommandExecuted() = 0;

  virtual void RecordQrCodeToggled(bool expanded) = 0;

  virtual void RecordNavClick() = 0;

  virtual void RecordFeatureTileNavigation() = 0;

  virtual void RecordCarouselScrollButtonClick() = 0;

  virtual void RecordExpandMediaToggled(const std::string& module_name, bool expanded) = 0;

  virtual void RecordCtaClick() = 0;

  virtual void RecordNextButtonClick() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "whats_new.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetServerUrl(bool is_staging, GetServerUrlCallback callback) final;
  
  void RecordTimeToLoadContent(::base::Time time) final;
  
  void RecordVersionPageLoaded(bool is_auto_open) final;
  
  void RecordEditionPageLoaded(const std::string& page_uid, bool is_auto_open) final;
  
  void RecordModuleImpression(const std::string& module_name, ModulePosition position) final;
  
  void RecordExploreMoreToggled(bool expanded) final;
  
  void RecordScrollDepth(ScrollDepth depth) final;
  
  void RecordTimeOnPage(::base::TimeDelta time) final;
  
  void RecordModuleLinkClicked(const std::string& module_name, ModulePosition position) final;
  
  void RecordModuleVideoStarted(const std::string& module_name, ModulePosition position) final;
  
  void RecordModuleVideoEnded(const std::string& module_name, ModulePosition position) final;
  
  void RecordModulePlayClicked(const std::string& module_name, ModulePosition position) final;
  
  void RecordModulePauseClicked(const std::string& module_name, ModulePosition position) final;
  
  void RecordModuleRestartClicked(const std::string& module_name, ModulePosition position) final;
  
  void RecordBrowserCommandExecuted() final;
  
  void RecordQrCodeToggled(bool expanded) final;
  
  void RecordNavClick() final;
  
  void RecordFeatureTileNavigation() final;
  
  void RecordCarouselScrollButtonClick() final;
  
  void RecordExpandMediaToggled(const std::string& module_name, bool expanded) final;
  
  void RecordCtaClick() final;
  
  void RecordNextButtonClick() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // whats_new::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_WHATS_NEW_WHATS_NEW_MOJOM_H_