// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::InstallIsolatedWebAppSuccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::InstallIsolatedWebAppSuccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::InstallIsolatedWebAppSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::web_bundle_id(input)) in_web_bundle_id = Traits::web_bundle_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_bundle_id)::BaseType> web_bundle_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_web_bundle_id,
        web_bundle_id_fragment);

      fragment->web_bundle_id.Set(
          web_bundle_id_fragment.is_null() ? nullptr : web_bundle_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_bundle_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_id in InstallIsolatedWebAppSuccess struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::UpdateInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::UpdateInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::UpdateInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::update_manifest_url(input)) in_update_manifest_url = Traits::update_manifest_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->update_manifest_url)::BaseType> update_manifest_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_update_manifest_url,
        update_manifest_url_fragment);

      fragment->update_manifest_url.Set(
          update_manifest_url_fragment.is_null() ? nullptr : update_manifest_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->update_manifest_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null update_manifest_url in UpdateInfo struct");

      decltype(Traits::update_channel(input)) in_update_channel = Traits::update_channel(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->update_channel)::BaseType> update_channel_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_update_channel,
        update_channel_fragment);

      fragment->update_channel.Set(
          update_channel_fragment.is_null() ? nullptr : update_channel_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->update_channel.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null update_channel in UpdateInfo struct");

      decltype(Traits::pinned_version(input)) in_pinned_version = Traits::pinned_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pinned_version)::BaseType> pinned_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_pinned_version,
        pinned_version_fragment);

      fragment->pinned_version.Set(
          pinned_version_fragment.is_null() ? nullptr : pinned_version_fragment.data());

      fragment->allow_downgrades = Traits::allow_downgrades(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::IwaDevModeAppInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::IwaDevModeAppInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::IwaDevModeAppInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->app_id)::BaseType> app_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_app_id,
        app_id_fragment);

      fragment->app_id.Set(
          app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->app_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_id in IwaDevModeAppInfo struct");

      decltype(Traits::web_bundle_id(input)) in_web_bundle_id = Traits::web_bundle_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_bundle_id)::BaseType> web_bundle_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_web_bundle_id,
        web_bundle_id_fragment);

      fragment->web_bundle_id.Set(
          web_bundle_id_fragment.is_null() ? nullptr : web_bundle_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_bundle_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_id in IwaDevModeAppInfo struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IwaDevModeAppInfo struct");

      decltype(Traits::location(input)) in_location = Traits::location(input);
      mojo::internal::MessageFragment<decltype(fragment->location)>
          location_fragment(fragment.message());
      location_fragment.Claim(&fragment->location);
      
      mojo::internal::Serialize<::mojom::IwaDevModeLocationDataView, send_validation>(
        in_location,
        location_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in IwaDevModeAppInfo struct");

      decltype(Traits::installed_version(input)) in_installed_version = Traits::installed_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->installed_version)::BaseType> installed_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_installed_version,
        installed_version_fragment);

      fragment->installed_version.Set(
          installed_version_fragment.is_null() ? nullptr : installed_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->installed_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null installed_version in IwaDevModeAppInfo struct");

      decltype(Traits::update_info(input)) in_update_info = Traits::update_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->update_info)::BaseType> update_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojom::UpdateInfoDataView, send_validation>(
        in_update_info,
        update_info_fragment);

      fragment->update_info.Set(
          update_info_fragment.is_null() ? nullptr : update_info_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::VersionEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::VersionEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::VersionEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::version(input)) in_version = Traits::version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->version)::BaseType> version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_version,
        version_fragment);

      fragment->version.Set(
          version_fragment.is_null() ? nullptr : version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null version in VersionEntry struct");

      decltype(Traits::web_bundle_url(input)) in_web_bundle_url = Traits::web_bundle_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_bundle_url)::BaseType> web_bundle_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_web_bundle_url,
        web_bundle_url_fragment);

      fragment->web_bundle_url.Set(
          web_bundle_url_fragment.is_null() ? nullptr : web_bundle_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_bundle_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_url in VersionEntry struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::UpdateManifestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::UpdateManifestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::UpdateManifest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::versions(input)) in_versions = Traits::versions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->versions)::BaseType>
          versions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& versions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojom::VersionEntryDataView>, send_validation>(
        in_versions,
        versions_fragment,
        &versions_validate_params);

      fragment->versions.Set(
          versions_fragment.is_null() ? nullptr : versions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->versions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null versions in UpdateManifest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::InstallFromBundleUrlParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::InstallFromBundleUrlParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::InstallFromBundleUrlParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::web_bundle_url(input)) in_web_bundle_url = Traits::web_bundle_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_bundle_url)::BaseType> web_bundle_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_web_bundle_url,
        web_bundle_url_fragment);

      fragment->web_bundle_url.Set(
          web_bundle_url_fragment.is_null() ? nullptr : web_bundle_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_bundle_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_url in InstallFromBundleUrlParams struct");

      decltype(Traits::update_info(input)) in_update_info = Traits::update_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->update_info)::BaseType> update_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojom::UpdateInfoDataView, send_validation>(
        in_update_info,
        update_info_fragment);

      fragment->update_info.Set(
          update_info_fragment.is_null() ? nullptr : update_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->update_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null update_info in InstallFromBundleUrlParams struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::mojom::InstallIsolatedWebAppResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojom::InstallIsolatedWebAppResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojom::internal::InstallIsolatedWebAppResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojom::InstallIsolatedWebAppResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojom::InstallIsolatedWebAppSuccessDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in InstallIsolatedWebAppResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojom::InstallIsolatedWebAppResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in InstallIsolatedWebAppResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::mojom::IwaDevModeLocationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojom::IwaDevModeLocationDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojom::internal::IwaDevModeLocation_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojom::IwaDevModeLocationDataView::Tag::kProxyOrigin: {
    decltype(Traits::proxy_origin(input))
    in_proxy_origin = Traits::proxy_origin(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_proxy_origin)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
  in_proxy_origin,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null proxy_origin in IwaDevModeLocation union");
    fragment->data.f_proxy_origin.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojom::IwaDevModeLocationDataView::Tag::kBundlePath: {
    decltype(Traits::bundle_path(input))
    in_bundle_path = Traits::bundle_path(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bundle_path)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
  in_bundle_path,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bundle_path in IwaDevModeLocation union");
    fragment->data.f_bundle_path.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::mojom::ParseUpdateManifestFromUrlResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojom::ParseUpdateManifestFromUrlResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojom::internal::ParseUpdateManifestFromUrlResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojom::ParseUpdateManifestFromUrlResultDataView::Tag::kUpdateManifest: {
    decltype(Traits::update_manifest(input))
    in_update_manifest = Traits::update_manifest(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_update_manifest)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojom::UpdateManifestDataView, send_validation>(
  in_update_manifest,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null update_manifest in ParseUpdateManifestFromUrlResult union");
    fragment->data.f_update_manifest.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojom::ParseUpdateManifestFromUrlResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in ParseUpdateManifestFromUrlResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_SEND_VALIDATION_H_