// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ColorSpec as tabGroups_mojom_ColorSpec,
  Color as tabGroups_mojom_Color
} from './tab_group_types.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tab_strip_internals.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "tab_strip_internals.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tab_strip_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getTabStripData(): Promise<{
        data: Container, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getTabStripData(): Promise<{
        data: Container, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetTabStripData_ParamsSpec.$,
        PageHandler_GetTabStripData_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetTabStripData_ParamsSpec.$,
        PageHandler_GetTabStripData_ResponseParamsSpec.$,
        impl.getTabStripData.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "tab_strip_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getTabStripData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getTabStripData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetTabStripData_ParamsSpec.$,
        PageHandler_GetTabStripData_ResponseParamsSpec.$,
        this.getTabStripData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tab_strip_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onTabStripUpdated(data: Container): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onTabStripUpdated(
      data: Container): void {
    this.proxy.sendMessage(
        0,
        Page_OnTabStripUpdated_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnTabStripUpdated_ParamsSpec.$,
        null,
        impl.onTabStripUpdated.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "tab_strip_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onTabStripUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onTabStripUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnTabStripUpdated_ParamsSpec.$,
        null,
        this.onTabStripUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ContainerSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripTreeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WindowNodeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NodeIdSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripModelSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NodeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripCollectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PinnedCollectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UnpinnedCollectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GroupCollectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabGroupVisualDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SplitCollectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SplitTabVisualDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SelectionModelSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabStripData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabStripData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnTabStripUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ContainerMojoType {
  tabstripTree: TabStripTree;
}


export type Container = ContainerMojoType;
mojo.internal.Struct<ContainerMojoType>(
    ContainerSpec.$,
    'Container',
    [
      mojo.internal.StructField<ContainerMojoType, TabStripTree>(
        'tabstripTree', 0,
        0,
        TabStripTreeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabStripTreeMojoType {
  windows: WindowNode[];
}


export type TabStripTree = TabStripTreeMojoType;
mojo.internal.Struct<TabStripTreeMojoType>(
    TabStripTreeSpec.$,
    'TabStripTree',
    [
      mojo.internal.StructField<TabStripTreeMojoType, WindowNode[]>(
        'windows', 0,
        0,
        mojo.internal.Array(WindowNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WindowNodeMojoType {
  id: NodeId;
  tabstripModel: TabStripModel;
  selectionModel: SelectionModel;
}


export type WindowNode = WindowNodeMojoType;
mojo.internal.Struct<WindowNodeMojoType>(
    WindowNodeSpec.$,
    'WindowNode',
    [
      mojo.internal.StructField<WindowNodeMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WindowNodeMojoType, TabStripModel>(
        'tabstripModel', 8,
        0,
        TabStripModelSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WindowNodeMojoType, SelectionModel>(
        'selectionModel', 16,
        0,
        SelectionModelSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);




export const NodeId_TypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum NodeId_Type {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kTab = 0,
  kCollection = 1,
  kWindow = 2,
}


export interface NodeIdMojoType {
  nodeId: string;
  type: NodeId_Type;
}


export type NodeId = NodeIdMojoType;
mojo.internal.Struct<NodeIdMojoType>(
    NodeIdSpec.$,
    'NodeId',
    [
      mojo.internal.StructField<NodeIdMojoType, string>(
        'nodeId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NodeIdMojoType, NodeId_Type>(
        'type', 8,
        0,
        NodeId_TypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripModelMojoType {
  root: (Node | null);
}


export type TabStripModel = TabStripModelMojoType;
mojo.internal.Struct<TabStripModelMojoType>(
    TabStripModelSpec.$,
    'TabStripModel',
    [
      mojo.internal.StructField<TabStripModelMojoType, Node>(
        'root', 0,
        0,
        NodeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NodeMojoType {
  data: Data;
  children: Node[];
}


export type Node = NodeMojoType;
mojo.internal.Struct<NodeMojoType>(
    NodeSpec.$,
    'Node',
    [
      mojo.internal.StructField<NodeMojoType, Data>(
        'data', 0,
        0,
        DataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NodeMojoType, Node[]>(
        'children', 16,
        0,
        mojo.internal.Array(NodeSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TabMojoType {
  id: NodeId;
  title: string;
  url: url_mojom_Url;
}


export type Tab = TabMojoType;
mojo.internal.Struct<TabMojoType>(
    TabSpec.$,
    'Tab',
    [
      mojo.internal.StructField<TabMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, url_mojom_Url>(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TabStripCollectionMojoType {
  id: NodeId;
}


export type TabStripCollection = TabStripCollectionMojoType;
mojo.internal.Struct<TabStripCollectionMojoType>(
    TabStripCollectionSpec.$,
    'TabStripCollection',
    [
      mojo.internal.StructField<TabStripCollectionMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PinnedCollectionMojoType {
  id: NodeId;
}


export type PinnedCollection = PinnedCollectionMojoType;
mojo.internal.Struct<PinnedCollectionMojoType>(
    PinnedCollectionSpec.$,
    'PinnedCollection',
    [
      mojo.internal.StructField<PinnedCollectionMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UnpinnedCollectionMojoType {
  id: NodeId;
}


export type UnpinnedCollection = UnpinnedCollectionMojoType;
mojo.internal.Struct<UnpinnedCollectionMojoType>(
    UnpinnedCollectionSpec.$,
    'UnpinnedCollection',
    [
      mojo.internal.StructField<UnpinnedCollectionMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GroupCollectionMojoType {
  id: NodeId;
  visualData: TabGroupVisualData;
}


export type GroupCollection = GroupCollectionMojoType;
mojo.internal.Struct<GroupCollectionMojoType>(
    GroupCollectionSpec.$,
    'GroupCollection',
    [
      mojo.internal.StructField<GroupCollectionMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GroupCollectionMojoType, TabGroupVisualData>(
        'visualData', 8,
        0,
        TabGroupVisualDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabGroupVisualDataMojoType {
  title: string;
  color: tabGroups_mojom_Color;
  isCollapsed: boolean;
}


export type TabGroupVisualData = TabGroupVisualDataMojoType;
mojo.internal.Struct<TabGroupVisualDataMojoType>(
    TabGroupVisualDataSpec.$,
    'TabGroupVisualData',
    [
      mojo.internal.StructField<TabGroupVisualDataMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupVisualDataMojoType, tabGroups_mojom_Color>(
        'color', 8,
        0,
        tabGroups_mojom_ColorSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupVisualDataMojoType, boolean>(
        'isCollapsed', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SplitCollectionMojoType {
  id: NodeId;
  visualData: SplitTabVisualData;
}


export type SplitCollection = SplitCollectionMojoType;
mojo.internal.Struct<SplitCollectionMojoType>(
    SplitCollectionSpec.$,
    'SplitCollection',
    [
      mojo.internal.StructField<SplitCollectionMojoType, NodeId>(
        'id', 0,
        0,
        NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SplitCollectionMojoType, SplitTabVisualData>(
        'visualData', 8,
        0,
        SplitTabVisualDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);




export const SplitTabVisualData_LayoutSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SplitTabVisualData_Layout {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kVertical = 0,
  kHorizontal = 1,
}


export interface SplitTabVisualDataMojoType {
  layout: SplitTabVisualData_Layout;
  splitRatio: number;
}


export type SplitTabVisualData = SplitTabVisualDataMojoType;
mojo.internal.Struct<SplitTabVisualDataMojoType>(
    SplitTabVisualDataSpec.$,
    'SplitTabVisualData',
    [
      mojo.internal.StructField<SplitTabVisualDataMojoType, SplitTabVisualData_Layout>(
        'layout', 0,
        0,
        SplitTabVisualData_LayoutSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SplitTabVisualDataMojoType, number>(
        'splitRatio', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SelectionModelMojoType {
  activeIndex: number;
  anchorIndex: number;
  selectedIndices: number[];
}


export type SelectionModel = SelectionModelMojoType;
mojo.internal.Struct<SelectionModelMojoType>(
    SelectionModelSpec.$,
    'SelectionModel',
    [
      mojo.internal.StructField<SelectionModelMojoType, number>(
        'activeIndex', 0,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectionModelMojoType, number>(
        'anchorIndex', 4,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectionModelMojoType, number[]>(
        'selectedIndices', 8,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetTabStripData_ParamsMojoType {
}


export type PageHandler_GetTabStripData_Params = PageHandler_GetTabStripData_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabStripData_ParamsMojoType>(
    PageHandler_GetTabStripData_ParamsSpec.$,
    'PageHandler_GetTabStripData_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabStripData_ResponseParamsMojoType {
  data: Container;
}


export type PageHandler_GetTabStripData_ResponseParams = PageHandler_GetTabStripData_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabStripData_ResponseParamsMojoType>(
    PageHandler_GetTabStripData_ResponseParamsSpec.$,
    'PageHandler_GetTabStripData_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabStripData_ResponseParamsMojoType, Container>(
        'data', 0,
        0,
        ContainerSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnTabStripUpdated_ParamsMojoType {
  data: Container;
}


export type Page_OnTabStripUpdated_Params = Page_OnTabStripUpdated_ParamsMojoType;
mojo.internal.Struct<Page_OnTabStripUpdated_ParamsMojoType>(
    Page_OnTabStripUpdated_ParamsSpec.$,
    'Page_OnTabStripUpdated_Params',
    [
      mojo.internal.StructField<Page_OnTabStripUpdated_ParamsMojoType, Container>(
        'data', 0,
        0,
        ContainerSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    DataSpec.$, 'Data',
    {
      'tab': {
        'ordinal': 0,
        'type': TabSpec.$,
      },
      'tabStripCollection': {
        'ordinal': 1,
        'type': TabStripCollectionSpec.$,
      },
      'pinnedTabCollection': {
        'ordinal': 2,
        'type': PinnedCollectionSpec.$,
      },
      'unpinnedTabCollection': {
        'ordinal': 3,
        'type': UnpinnedCollectionSpec.$,
      },
      'tabGroupCollection': {
        'ordinal': 4,
        'type': GroupCollectionSpec.$,
      },
      'splitTabCollection': {
        'ordinal': 5,
        'type': SplitCollectionSpec.$,
      },
    });

export interface Data {
  tab?: Tab,
  tabStripCollection?: TabStripCollection,
  pinnedTabCollection?: PinnedCollection,
  unpinnedTabCollection?: UnpinnedCollection,
  tabGroupCollection?: GroupCollection,
  splitTabCollection?: SplitCollection,
}

export enum DataFieldTags {
  TAB,
  TAB_STRIP_COLLECTION,
  PINNED_TAB_COLLECTION,
  UNPINNED_TAB_COLLECTION,
  TAB_GROUP_COLLECTION,
  SPLIT_TAB_COLLECTION,
}

export function whichData(u: Data): DataFieldTags {
  if (u.tab !== null && u.tab !== undefined) {
    return DataFieldTags.TAB;
  }
  if (u.tabStripCollection !== null && u.tabStripCollection !== undefined) {
    return DataFieldTags.TAB_STRIP_COLLECTION;
  }
  if (u.pinnedTabCollection !== null && u.pinnedTabCollection !== undefined) {
    return DataFieldTags.PINNED_TAB_COLLECTION;
  }
  if (u.unpinnedTabCollection !== null && u.unpinnedTabCollection !== undefined) {
    return DataFieldTags.UNPINNED_TAB_COLLECTION;
  }
  if (u.tabGroupCollection !== null && u.tabGroupCollection !== undefined) {
    return DataFieldTags.TAB_GROUP_COLLECTION;
  }
  if (u.splitTabCollection !== null && u.splitTabCollection !== undefined) {
    return DataFieldTags.SPLIT_TAB_COLLECTION;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
