// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared-internal.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::tab_strip_internals::mojom::NodeId_Type>
    : public mojo::internal::EnumHashImpl<::tab_strip_internals::mojom::NodeId_Type> {};

template <>
struct hash<::tab_strip_internals::mojom::SplitTabVisualData_Layout>
    : public mojo::internal::EnumHashImpl<::tab_strip_internals::mojom::SplitTabVisualData_Layout> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::NodeId_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_strip_internals::mojom::NodeId_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_strip_internals::mojom::NodeId_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SplitTabVisualData_Layout, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_strip_internals::mojom::SplitTabVisualData_Layout, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::ContainerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::ContainerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::Container_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tabstrip_tree(input)) in_tabstrip_tree = Traits::tabstrip_tree(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabstrip_tree)::BaseType> tabstrip_tree_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabStripTreeDataView>(
      in_tabstrip_tree,
      tabstrip_tree_fragment);

    fragment->tabstrip_tree.Set(
        tabstrip_tree_fragment.is_null() ? nullptr : tabstrip_tree_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabstrip_tree.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabstrip_tree in Container struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Container_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::ContainerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabStripTreeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabStripTreeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabStripTree_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::windows(input)) in_windows = Traits::windows(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->windows)::BaseType>
        windows_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::WindowNodeDataView>>(
      in_windows,
      windows_fragment,
      &windows_validate_params);

    fragment->windows.Set(
        windows_fragment.is_null() ? nullptr : windows_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->windows.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null windows in TabStripTree struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabStripTree_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabStripTreeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::WindowNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::WindowNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::WindowNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in WindowNode struct");

    decltype(Traits::tabstrip_model(input)) in_tabstrip_model = Traits::tabstrip_model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabstrip_model)::BaseType> tabstrip_model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabStripModelDataView>(
      in_tabstrip_model,
      tabstrip_model_fragment);

    fragment->tabstrip_model.Set(
        tabstrip_model_fragment.is_null() ? nullptr : tabstrip_model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabstrip_model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabstrip_model in WindowNode struct");

    decltype(Traits::selection_model(input)) in_selection_model = Traits::selection_model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection_model)::BaseType> selection_model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::SelectionModelDataView>(
      in_selection_model,
      selection_model_fragment);

    fragment->selection_model.Set(
        selection_model_fragment.is_null() ? nullptr : selection_model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selection_model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selection_model in WindowNode struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::WindowNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::WindowNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::NodeIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::NodeIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::NodeId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::node_id(input)) in_node_id = Traits::node_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->node_id)::BaseType> node_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_node_id,
      node_id_fragment);

    fragment->node_id.Set(
        node_id_fragment.is_null() ? nullptr : node_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->node_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null node_id in NodeId struct");

    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeId_Type>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::NodeId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::NodeIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabStripModelDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabStripModelDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabStripModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::root(input)) in_root = Traits::root(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root)::BaseType> root_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeDataView>(
      in_root,
      root_fragment);

    fragment->root.Set(
        root_fragment.is_null() ? nullptr : root_fragment.data());
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabStripModel_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabStripModelDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::NodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::NodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::Node_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::DataDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Node struct");

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::NodeDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in Node struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Node_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::NodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in Tab struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Tab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Tab struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Tab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabStripCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabStripCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabStripCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabStripCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabStripCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabStripCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::PinnedCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::PinnedCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::PinnedCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PinnedCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::PinnedCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::PinnedCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::UnpinnedCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::UnpinnedCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::UnpinnedCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in UnpinnedCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::UnpinnedCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::UnpinnedCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::GroupCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::GroupCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::GroupCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GroupCollection struct");

    decltype(Traits::visualData(input)) in_visualData = Traits::visualData(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visualData)::BaseType> visualData_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
      in_visualData,
      visualData_fragment);

    fragment->visualData.Set(
        visualData_fragment.is_null() ? nullptr : visualData_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visualData.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visualData in GroupCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::GroupCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::GroupCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabGroupVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabGroupVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabGroupVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabGroupVisualData struct");

    
    mojo::internal::Serialize<::tab_groups::mojom::Color>(
      Traits::color(input),
      &fragment->color);

    fragment->is_collapsed = Traits::is_collapsed(input);
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabGroupVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabGroupVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SplitCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::SplitCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::SplitCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in SplitCollection struct");

    decltype(Traits::visualData(input)) in_visualData = Traits::visualData(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visualData)::BaseType> visualData_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::SplitTabVisualDataDataView>(
      in_visualData,
      visualData_fragment);

    fragment->visualData.Set(
        visualData_fragment.is_null() ? nullptr : visualData_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visualData.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visualData in SplitCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::SplitCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::SplitCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SplitTabVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::SplitTabVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::SplitTabVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(
      Traits::layout(input),
      &fragment->layout);

    fragment->split_ratio = Traits::split_ratio(input);
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::SplitTabVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::SplitTabVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SelectionModelDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::SelectionModelDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::SelectionModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->active_index = Traits::active_index(input);

    fragment->anchor_index = Traits::anchor_index(input);

    decltype(Traits::selected_indices(input)) in_selected_indices = Traits::selected_indices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_indices)::BaseType>
        selected_indices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& selected_indices_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_selected_indices,
      selected_indices_fragment,
      &selected_indices_validate_params);

    fragment->selected_indices.Set(
        selected_indices_fragment.is_null() ? nullptr : selected_indices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selected_indices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selected_indices in SelectionModel struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::SelectionModel_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::SelectionModelDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::DataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tab_strip_internals::mojom::DataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tab_strip_internals::mojom::internal::Data_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tab_strip_internals::mojom::DataDataView::Tag::kTab: {
    decltype(Traits::tab(input))
    in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabDataView>(
  in_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab in Data union");
    fragment->data.f_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kTabStripCollection: {
    decltype(Traits::tab_strip_collection(input))
    in_tab_strip_collection = Traits::tab_strip_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_strip_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabStripCollectionDataView>(
  in_tab_strip_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_strip_collection in Data union");
    fragment->data.f_tab_strip_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kPinnedTabCollection: {
    decltype(Traits::pinned_tab_collection(input))
    in_pinned_tab_collection = Traits::pinned_tab_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pinned_tab_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::PinnedCollectionDataView>(
  in_pinned_tab_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pinned_tab_collection in Data union");
    fragment->data.f_pinned_tab_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kUnpinnedTabCollection: {
    decltype(Traits::unpinned_tab_collection(input))
    in_unpinned_tab_collection = Traits::unpinned_tab_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unpinned_tab_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::UnpinnedCollectionDataView>(
  in_unpinned_tab_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unpinned_tab_collection in Data union");
    fragment->data.f_unpinned_tab_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kTabGroupCollection: {
    decltype(Traits::tab_group_collection(input))
    in_tab_group_collection = Traits::tab_group_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_group_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::GroupCollectionDataView>(
  in_tab_group_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_group_collection in Data union");
    fragment->data.f_tab_group_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kSplitTabCollection: {
    decltype(Traits::split_tab_collection(input))
    in_split_tab_collection = Traits::split_tab_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_split_tab_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::SplitCollectionDataView>(
  in_split_tab_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null split_tab_collection in Data union");
    fragment->data.f_split_tab_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Data_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::DataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tab_strip_internals::mojom {

inline void ContainerDataView::GetTabstripTreeDataView(
    TabStripTreeDataView* output) {
  auto pointer = data_->tabstrip_tree.Get();
  *output = TabStripTreeDataView(pointer, message_);
}


inline void TabStripTreeDataView::GetWindowsDataView(
    mojo::ArrayDataView<WindowNodeDataView>* output) {
  auto pointer = data_->windows.Get();
  *output = mojo::ArrayDataView<WindowNodeDataView>(pointer, message_);
}


inline void WindowNodeDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void WindowNodeDataView::GetTabstripModelDataView(
    TabStripModelDataView* output) {
  auto pointer = data_->tabstrip_model.Get();
  *output = TabStripModelDataView(pointer, message_);
}
inline void WindowNodeDataView::GetSelectionModelDataView(
    SelectionModelDataView* output) {
  auto pointer = data_->selection_model.Get();
  *output = SelectionModelDataView(pointer, message_);
}


inline void NodeIdDataView::GetNodeIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->node_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TabStripModelDataView::GetRootDataView(
    NodeDataView* output) {
  auto pointer = data_->root.Get();
  *output = NodeDataView(pointer, message_);
}


inline void NodeDataView::GetDataDataView(
    DataDataView* output) {
  auto pointer = &data_->data;
  *output = DataDataView(pointer, message_);
}
inline void NodeDataView::GetChildrenDataView(
    mojo::ArrayDataView<NodeDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<NodeDataView>(pointer, message_);
}


inline void TabDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void TabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void TabStripCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}


inline void PinnedCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}


inline void UnpinnedCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}


inline void GroupCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void GroupCollectionDataView::GetVisualDataDataView(
    TabGroupVisualDataDataView* output) {
  auto pointer = data_->visualData.Get();
  *output = TabGroupVisualDataDataView(pointer, message_);
}


inline void TabGroupVisualDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SplitCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void SplitCollectionDataView::GetVisualDataDataView(
    SplitTabVisualDataDataView* output) {
  auto pointer = data_->visualData.Get();
  *output = SplitTabVisualDataDataView(pointer, message_);
}




inline void SelectionModelDataView::GetSelectedIndicesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->selected_indices.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}


inline void DataDataView::GetTabDataView(
    TabDataView* output) const {
  CHECK(is_tab());
  *output = TabDataView(data_->data.f_tab.Get(), message_);
}
inline void DataDataView::GetTabStripCollectionDataView(
    TabStripCollectionDataView* output) const {
  CHECK(is_tab_strip_collection());
  *output = TabStripCollectionDataView(data_->data.f_tab_strip_collection.Get(), message_);
}
inline void DataDataView::GetPinnedTabCollectionDataView(
    PinnedCollectionDataView* output) const {
  CHECK(is_pinned_tab_collection());
  *output = PinnedCollectionDataView(data_->data.f_pinned_tab_collection.Get(), message_);
}
inline void DataDataView::GetUnpinnedTabCollectionDataView(
    UnpinnedCollectionDataView* output) const {
  CHECK(is_unpinned_tab_collection());
  *output = UnpinnedCollectionDataView(data_->data.f_unpinned_tab_collection.Get(), message_);
}
inline void DataDataView::GetTabGroupCollectionDataView(
    GroupCollectionDataView* output) const {
  CHECK(is_tab_group_collection());
  *output = GroupCollectionDataView(data_->data.f_tab_group_collection.Get(), message_);
}
inline void DataDataView::GetSplitTabCollectionDataView(
    SplitCollectionDataView* output) const {
  CHECK(is_split_tab_collection());
  *output = SplitCollectionDataView(data_->data.f_split_tab_collection.Get(), message_);
}


}  // tab_strip_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_strip_internals::mojom::NodeId_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_strip_internals::mojom::NodeId_Type value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_strip_internals::mojom::SplitTabVisualData_Layout> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_strip_internals::mojom::SplitTabVisualData_Layout value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_H_