// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_INTERNAL_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace tab_strip_internals::mojom {
namespace internal {
class Container_Data;
class TabStripTree_Data;
class WindowNode_Data;
class NodeId_Data;
class TabStripModel_Data;
class Node_Data;
class Tab_Data;
class TabStripCollection_Data;
class PinnedCollection_Data;
class UnpinnedCollection_Data;
class GroupCollection_Data;
class TabGroupVisualData_Data;
class SplitCollection_Data;
class SplitTabVisualData_Data;
class SelectionModel_Data;
class Data_Data;

struct NodeId_Type_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SplitTabVisualData_Layout_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  Data_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  Data_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~Data_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<Data_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class Data_Tag : uint32_t {

    
    kTab,
    
    kTabStripCollection,
    
    kPinnedTabCollection,
    
    kUnpinnedTabCollection,
    
    kTabGroupCollection,
    
    kSplitTabCollection,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::Tab_Data> f_tab;
    mojo::internal::Pointer<internal::TabStripCollection_Data> f_tab_strip_collection;
    mojo::internal::Pointer<internal::PinnedCollection_Data> f_pinned_tab_collection;
    mojo::internal::Pointer<internal::UnpinnedCollection_Data> f_unpinned_tab_collection;
    mojo::internal::Pointer<internal::GroupCollection_Data> f_tab_group_collection;
    mojo::internal::Pointer<internal::SplitCollection_Data> f_split_tab_collection;
    uint64_t unknown;
  };

  uint32_t size;
  Data_Tag tag;
  Union_ data;
};
static_assert(sizeof(Data_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(Data_Data)");
class  Container_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::TabStripTree_Data> tabstrip_tree;

 private:
  friend class mojo::internal::MessageFragment<Container_Data>;

  Container_Data();
  ~Container_Data() = delete;
};
static_assert(sizeof(Container_Data) == 16,
              "Bad sizeof(Container_Data)");
// Used by Container::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Container_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Container_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Container_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Container_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Container_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabStripTree_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::WindowNode_Data>>> windows;

 private:
  friend class mojo::internal::MessageFragment<TabStripTree_Data>;

  TabStripTree_Data();
  ~TabStripTree_Data() = delete;
};
static_assert(sizeof(TabStripTree_Data) == 16,
              "Bad sizeof(TabStripTree_Data)");
// Used by TabStripTree::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabStripTree_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabStripTree_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabStripTree_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabStripTree_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabStripTree_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WindowNode_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;
  mojo::internal::Pointer<internal::TabStripModel_Data> tabstrip_model;
  mojo::internal::Pointer<internal::SelectionModel_Data> selection_model;

 private:
  friend class mojo::internal::MessageFragment<WindowNode_Data>;

  WindowNode_Data();
  ~WindowNode_Data() = delete;
};
static_assert(sizeof(WindowNode_Data) == 32,
              "Bad sizeof(WindowNode_Data)");
// Used by WindowNode::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WindowNode_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WindowNode_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WindowNode_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WindowNode_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WindowNode_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  NodeId_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> node_id;
  int32_t type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NodeId_Data>;

  NodeId_Data();
  ~NodeId_Data() = delete;
};
static_assert(sizeof(NodeId_Data) == 24,
              "Bad sizeof(NodeId_Data)");
// Used by NodeId::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NodeId_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NodeId_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NodeId_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<NodeId_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NodeId_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabStripModel_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Node_Data> root;

 private:
  friend class mojo::internal::MessageFragment<TabStripModel_Data>;

  TabStripModel_Data();
  ~TabStripModel_Data() = delete;
};
static_assert(sizeof(TabStripModel_Data) == 16,
              "Bad sizeof(TabStripModel_Data)");
// Used by TabStripModel::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabStripModel_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabStripModel_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabStripModel_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabStripModel_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabStripModel_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Node_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::Data_Data data;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Node_Data>>> children;

 private:
  friend class mojo::internal::MessageFragment<Node_Data>;

  Node_Data();
  ~Node_Data() = delete;
};
static_assert(sizeof(Node_Data) == 32,
              "Bad sizeof(Node_Data)");
// Used by Node::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Node_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Node_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Node_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Node_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Node_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Tab_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<Tab_Data>;

  Tab_Data();
  ~Tab_Data() = delete;
};
static_assert(sizeof(Tab_Data) == 32,
              "Bad sizeof(Tab_Data)");
// Used by Tab::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Tab_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Tab_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Tab_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Tab_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Tab_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabStripCollection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<TabStripCollection_Data>;

  TabStripCollection_Data();
  ~TabStripCollection_Data() = delete;
};
static_assert(sizeof(TabStripCollection_Data) == 16,
              "Bad sizeof(TabStripCollection_Data)");
// Used by TabStripCollection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabStripCollection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabStripCollection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabStripCollection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabStripCollection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabStripCollection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PinnedCollection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<PinnedCollection_Data>;

  PinnedCollection_Data();
  ~PinnedCollection_Data() = delete;
};
static_assert(sizeof(PinnedCollection_Data) == 16,
              "Bad sizeof(PinnedCollection_Data)");
// Used by PinnedCollection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PinnedCollection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PinnedCollection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PinnedCollection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PinnedCollection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PinnedCollection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UnpinnedCollection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<UnpinnedCollection_Data>;

  UnpinnedCollection_Data();
  ~UnpinnedCollection_Data() = delete;
};
static_assert(sizeof(UnpinnedCollection_Data) == 16,
              "Bad sizeof(UnpinnedCollection_Data)");
// Used by UnpinnedCollection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UnpinnedCollection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UnpinnedCollection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UnpinnedCollection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UnpinnedCollection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UnpinnedCollection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GroupCollection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;
  mojo::internal::Pointer<internal::TabGroupVisualData_Data> visualData;

 private:
  friend class mojo::internal::MessageFragment<GroupCollection_Data>;

  GroupCollection_Data();
  ~GroupCollection_Data() = delete;
};
static_assert(sizeof(GroupCollection_Data) == 24,
              "Bad sizeof(GroupCollection_Data)");
// Used by GroupCollection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GroupCollection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GroupCollection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GroupCollection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GroupCollection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GroupCollection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabGroupVisualData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  int32_t color;
  uint8_t is_collapsed : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<TabGroupVisualData_Data>;

  TabGroupVisualData_Data();
  ~TabGroupVisualData_Data() = delete;
};
static_assert(sizeof(TabGroupVisualData_Data) == 24,
              "Bad sizeof(TabGroupVisualData_Data)");
// Used by TabGroupVisualData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabGroupVisualData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabGroupVisualData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabGroupVisualData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabGroupVisualData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabGroupVisualData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SplitCollection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NodeId_Data> id;
  mojo::internal::Pointer<internal::SplitTabVisualData_Data> visualData;

 private:
  friend class mojo::internal::MessageFragment<SplitCollection_Data>;

  SplitCollection_Data();
  ~SplitCollection_Data() = delete;
};
static_assert(sizeof(SplitCollection_Data) == 24,
              "Bad sizeof(SplitCollection_Data)");
// Used by SplitCollection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SplitCollection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SplitCollection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SplitCollection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SplitCollection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SplitCollection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SplitTabVisualData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t layout;
  uint8_t pad0_[4];
  double split_ratio;

 private:
  friend class mojo::internal::MessageFragment<SplitTabVisualData_Data>;

  SplitTabVisualData_Data();
  ~SplitTabVisualData_Data() = delete;
};
static_assert(sizeof(SplitTabVisualData_Data) == 24,
              "Bad sizeof(SplitTabVisualData_Data)");
// Used by SplitTabVisualData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SplitTabVisualData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SplitTabVisualData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SplitTabVisualData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SplitTabVisualData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SplitTabVisualData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SelectionModel_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t active_index;
  int32_t anchor_index;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> selected_indices;

 private:
  friend class mojo::internal::MessageFragment<SelectionModel_Data>;

  SelectionModel_Data();
  ~SelectionModel_Data() = delete;
};
static_assert(sizeof(SelectionModel_Data) == 24,
              "Bad sizeof(SelectionModel_Data)");
// Used by SelectionModel::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SelectionModel_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SelectionModel_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SelectionModel_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SelectionModel_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SelectionModel_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // tab_strip_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_INTERNAL_H_