// chrome/browser/ui/webui/tab_search/tab_search.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom.h"


namespace tab_search::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void CloseTab(int32_t tab_id) override;
  void CloseWebUiTab() override;
  void DeclutterTabs(const std::vector<int32_t>& tab_ids, const std::vector<::GURL>& urls) override;
  void AcceptTabOrganization(int32_t session_id, int32_t organization_id, std::vector<TabPtr> tabs) override;
  void RejectTabOrganization(int32_t session_id, int32_t organization_id) override;
  void RenameTabOrganization(int32_t session_id, int32_t organization_id, const ::std::u16string& name) override;
  void ExcludeFromStaleTabs(int32_t tab_id) override;
  void ExcludeFromDuplicateTabs(const ::GURL& url) override;
  void GetProfileData(GetProfileDataCallback callback) override;
  void GetUnusedTabs(GetUnusedTabsCallback callback) override;
  void GetTabSearchSection(GetTabSearchSectionCallback callback) override;
  void GetTabOrganizationFeature(GetTabOrganizationFeatureCallback callback) override;
  void GetTabOrganizationSession(GetTabOrganizationSessionCallback callback) override;
  void GetTabOrganizationModelStrategy(GetTabOrganizationModelStrategyCallback callback) override;
  void GetIsSplit(GetIsSplitCallback callback) override;
  void SwitchToTab(SwitchToTabInfoPtr switch_to_tab_info) override;
  void OpenRecentlyClosedEntry(int32_t session_id) override;
  void RequestTabOrganization() override;
  void RemoveTabFromOrganization(int32_t session_id, int32_t organization_id, TabPtr tab) override;
  void RejectSession(int32_t session_id) override;
  void ReplaceActiveSplitTab(int32_t replacement_tab_id) override;
  void RestartSession() override;
  void SaveRecentlyClosedExpandedPref(bool expanded) override;
  void SetOrganizationFeature(TabOrganizationFeature feature) override;
  void StartTabGroupTutorial() override;
  void TriggerFeedback(int32_t session_id) override;
  void TriggerSignIn() override;
  void OpenHelpPage() override;
  void SetTabOrganizationModelStrategy(TabOrganizationModelStrategy strategy) override;
  void SetTabOrganizationUserInstruction(const std::string& user_instruction) override;
  void SetUserFeedback(int32_t session_id, UserFeedback feedback) override;
  void NotifyOrganizationUIReadyToShow() override;
  void NotifySearchUIReadyToShow() override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetProfileData(
      ProfileDataPtr* out_profile_data);
  ProfileDataPtr GetProfileData();
  void GetUnusedTabs(
      UnusedTabInfoPtr* out_tabs);
  UnusedTabInfoPtr GetUnusedTabs();
  void GetTabSearchSection(
      TabSearchSection* out_section);
  TabSearchSection GetTabSearchSection();
  void GetTabOrganizationFeature(
      TabOrganizationFeature* out_feature);
  TabOrganizationFeature GetTabOrganizationFeature();
  void GetTabOrganizationSession(
      TabOrganizationSessionPtr* out_session);
  TabOrganizationSessionPtr GetTabOrganizationSession();
  void GetTabOrganizationModelStrategy(
      TabOrganizationModelStrategy* out_strategy);
  TabOrganizationModelStrategy GetTabOrganizationModelStrategy();
  void GetIsSplit(
      bool* out_is_split);
  bool GetIsSplit();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void TabOrganizationSessionUpdated(TabOrganizationSessionPtr session) override;
  void TabOrganizationModelStrategyUpdated(TabOrganizationModelStrategy strategy) override;
  void HostWindowChanged() override;
  void TabsChanged(ProfileDataPtr profile_tabs) override;
  void TabUpdated(TabUpdateInfoPtr tabUpdateInfo) override;
  void TabsRemoved(TabsRemovedInfoPtr tabsRemovedInfo) override;
  void TabSearchSectionChanged(TabSearchSection section) override;
  void TabOrganizationFeatureChanged(TabOrganizationFeature feature) override;
  void ShowFREChanged(bool show) override;
  void TabOrganizationEnabledChanged(bool enabled) override;
  void UnusedTabsChanged(UnusedTabInfoPtr tabs) override;
  void TabUnsplit() override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // tab_search::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_TEST_UTILS_H_