// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-params-data.h"
namespace reading_list {
namespace mojom {

NOINLINE static const char* CurrentPageActionButtonStateToStringHelper(CurrentPageActionButtonState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CurrentPageActionButtonState::kAdd:
      return "kAdd";
    case CurrentPageActionButtonState::kDisabled:
      return "kDisabled";
    case CurrentPageActionButtonState::kMarkAsRead:
      return "kMarkAsRead";
    default:
      return nullptr;
  }
}

std::string CurrentPageActionButtonStateToString(CurrentPageActionButtonState value) {
  const char *str = CurrentPageActionButtonStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CurrentPageActionButtonState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CurrentPageActionButtonState value) {
  return os << CurrentPageActionButtonStateToString(value);
}

namespace internal {


// static
bool ReadLaterEntriesByStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadLaterEntriesByStatus_Data* object =
      static_cast<const ReadLaterEntriesByStatus_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unread_entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& unread_entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->unread_entries, validation_context,
                                         &unread_entries_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->read_entries, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& read_entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->read_entries, validation_context,
                                         &read_entries_validate_params)) {
    return false;
  }

  return true;
}

ReadLaterEntriesByStatus_Data::ReadLaterEntriesByStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadLaterEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadLaterEntry_Data* object =
      static_cast<const ReadLaterEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_url, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_url, validation_context,
                                         &display_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_time_since_update, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_time_since_update_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_time_since_update, validation_context,
                                         &display_time_since_update_validate_params)) {
    return false;
  }

  return true;
}

ReadLaterEntry_Data::ReadLaterEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Window_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Window_Data* object =
      static_cast<const Window_Data*>(data);

  return true;
}

Window_Data::Window_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetReadLaterEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetReadLaterEntries_Params_Data* object =
      static_cast<const PageHandler_GetReadLaterEntries_Params_Data*>(data);

  return true;
}

PageHandler_GetReadLaterEntries_Params_Data::PageHandler_GetReadLaterEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetReadLaterEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetReadLaterEntries_ResponseParams_Data* object =
      static_cast<const PageHandler_GetReadLaterEntries_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entries, validation_context))
    return false;

  return true;
}

PageHandler_GetReadLaterEntries_ResponseParams_Data::PageHandler_GetReadLaterEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenURL_Params_Data* object =
      static_cast<const PageHandler_OpenURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_modifiers, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_modifiers, validation_context))
    return false;

  return true;
}

PageHandler_OpenURL_Params_Data::PageHandler_OpenURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateReadStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateReadStatus_Params_Data* object =
      static_cast<const PageHandler_UpdateReadStatus_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_UpdateReadStatus_Params_Data::PageHandler_UpdateReadStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MarkCurrentTabAsRead_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MarkCurrentTabAsRead_Params_Data* object =
      static_cast<const PageHandler_MarkCurrentTabAsRead_Params_Data*>(data);

  return true;
}

PageHandler_MarkCurrentTabAsRead_Params_Data::PageHandler_MarkCurrentTabAsRead_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddCurrentTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddCurrentTab_Params_Data* object =
      static_cast<const PageHandler_AddCurrentTab_Params_Data*>(data);

  return true;
}

PageHandler_AddCurrentTab_Params_Data::PageHandler_AddCurrentTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RemoveEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RemoveEntry_Params_Data* object =
      static_cast<const PageHandler_RemoveEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_RemoveEntry_Params_Data::PageHandler_RemoveEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowContextMenuForURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowContextMenuForURL_Params_Data* object =
      static_cast<const PageHandler_ShowContextMenuForURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_ShowContextMenuForURL_Params_Data::PageHandler_ShowContextMenuForURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateCurrentPageActionButtonState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateCurrentPageActionButtonState_Params_Data* object =
      static_cast<const PageHandler_UpdateCurrentPageActionButtonState_Params_Data*>(data);

  return true;
}

PageHandler_UpdateCurrentPageActionButtonState_Params_Data::PageHandler_UpdateCurrentPageActionButtonState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowUI_Params_Data* object =
      static_cast<const PageHandler_ShowUI_Params_Data*>(data);

  return true;
}

PageHandler_ShowUI_Params_Data::PageHandler_ShowUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseUI_Params_Data* object =
      static_cast<const PageHandler_CloseUI_Params_Data*>(data);

  return true;
}

PageHandler_CloseUI_Params_Data::PageHandler_CloseUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetWindowData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetWindowData_Params_Data* object =
      static_cast<const PageHandler_GetWindowData_Params_Data*>(data);

  return true;
}

PageHandler_GetWindowData_Params_Data::PageHandler_GetWindowData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetWindowData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetWindowData_ResponseParams_Data* object =
      static_cast<const PageHandler_GetWindowData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->windows, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->windows, validation_context,
                                         &windows_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetWindowData_ResponseParams_Data::PageHandler_GetWindowData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ItemsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ItemsChanged_Params_Data* object =
      static_cast<const Page_ItemsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entries, validation_context))
    return false;

  return true;
}

Page_ItemsChanged_Params_Data::Page_ItemsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_CurrentPageActionButtonStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_CurrentPageActionButtonStateChanged_Params_Data* object =
      static_cast<const Page_CurrentPageActionButtonStateChanged_Params_Data*>(data);


  if (!::reading_list::mojom::internal::CurrentPageActionButtonState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

Page_CurrentPageActionButtonStateChanged_Params_Data::Page_CurrentPageActionButtonStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace reading_list

namespace perfetto {

// static
void TraceFormatTraits<::reading_list::mojom::CurrentPageActionButtonState>::WriteIntoTrace(
   perfetto::TracedValue context, ::reading_list::mojom::CurrentPageActionButtonState value) {
  return std::move(context).WriteString(::reading_list::mojom::CurrentPageActionButtonStateToString(value));
}

} // namespace perfetto