// chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-params-data.h"
namespace side_panel {
namespace customize_chrome {
namespace mojom {

NOINLINE static const char* DescriptorDNameToStringHelper(DescriptorDName value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DescriptorDName::kYellow:
      return "kYellow";
    default:
      return nullptr;
  }
}

std::string DescriptorDNameToString(DescriptorDName value) {
  const char *str = DescriptorDNameToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DescriptorDName value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DescriptorDName value) {
  return os << DescriptorDNameToString(value);
}

NOINLINE static const char* WallpaperSearchStatusToStringHelper(WallpaperSearchStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WallpaperSearchStatus::kOk:
      return "kOk";
    case WallpaperSearchStatus::kError:
      return "kError";
    case WallpaperSearchStatus::kRequestThrottled:
      return "kRequestThrottled";
    case WallpaperSearchStatus::kOffline:
      return "kOffline";
    case WallpaperSearchStatus::kSignedOut:
      return "kSignedOut";
    default:
      return nullptr;
  }
}

std::string WallpaperSearchStatusToString(WallpaperSearchStatus value) {
  const char *str = WallpaperSearchStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WallpaperSearchStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WallpaperSearchStatus value) {
  return os << WallpaperSearchStatusToString(value);
}

NOINLINE static const char* UserFeedbackToStringHelper(UserFeedback value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserFeedback::kUnspecified:
      return "kUnspecified";
    case UserFeedback::kThumbsUp:
      return "kThumbsUp";
    case UserFeedback::kThumbsDown:
      return "kThumbsDown";
    default:
      return nullptr;
  }
}

std::string UserFeedbackToString(UserFeedback value) {
  const char *str = UserFeedbackToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserFeedback value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserFeedback value) {
  return os << UserFeedbackToString(value);
}

namespace internal {
// static
bool DescriptorDValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DescriptorDValue_Data* object = static_cast<const DescriptorDValue_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DescriptorDValue_Tag::kColor: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_color, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_color, validation_context))
        return false;
      return true;
    }
    case DescriptorDValue_Tag::kHue: {

      return true;
    }
    case DescriptorDValue_Tag::kName: {


      if (!::side_panel::customize_chrome::mojom::internal::DescriptorDName_Data
            ::Validate(object->data.f_name, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DescriptorDValue");
      return false;
    }
  }
}


// static
bool KeyLabel_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const KeyLabel_Data* object =
      static_cast<const KeyLabel_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

KeyLabel_Data::KeyLabel_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Group_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Group_Data* object =
      static_cast<const Group_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->category, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& category_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->category, validation_context,
                                         &category_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_as, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_as_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_as, validation_context,
                                         &descriptor_as_validate_params)) {
    return false;
  }

  return true;
}

Group_Data::Group_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DescriptorB_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DescriptorB_Data* object =
      static_cast<const DescriptorB_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_path, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& image_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_path, validation_context,
                                         &image_path_validate_params)) {
    return false;
  }

  return true;
}

DescriptorB_Data::DescriptorB_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Descriptors_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Descriptors_Data* object =
      static_cast<const Descriptors_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->groups, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->groups, validation_context,
                                         &groups_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_b, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_b_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_b, validation_context,
                                         &descriptor_b_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_c, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_c_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_c, validation_context,
                                         &descriptor_c_validate_params)) {
    return false;
  }

  return true;
}

Descriptors_Data::Descriptors_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Inspiration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Inspiration_Data* object =
      static_cast<const Inspiration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumbnail_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->thumbnail_url, validation_context))
    return false;

  return true;
}

Inspiration_Data::Inspiration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspirationDescriptors_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InspirationDescriptors_Data* object =
      static_cast<const InspirationDescriptors_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->subject, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->style, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mood, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->color, validation_context))
    return false;

  return true;
}

InspirationDescriptors_Data::InspirationDescriptors_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspirationGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InspirationGroup_Data* object =
      static_cast<const InspirationGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptors, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptors, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inspirations, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& inspirations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->inspirations, validation_context,
                                         &inspirations_validate_params)) {
    return false;
  }

  return true;
}

InspirationGroup_Data::InspirationGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchResult_Data* object =
      static_cast<const WallpaperSearchResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& image_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image, validation_context,
                                         &image_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->descriptors, validation_context))
    return false;

  return true;
}

WallpaperSearchResult_Data::WallpaperSearchResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResultDescriptors_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResultDescriptors_Data* object =
      static_cast<const ResultDescriptors_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& subject_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subject, validation_context,
                                         &subject_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& style_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->style, validation_context,
                                         &style_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& mood_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mood, validation_context,
                                         &mood_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->color, validation_context))
    return false;

  return true;
}

ResultDescriptors_Data::ResultDescriptors_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data* object =
      static_cast<const WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data::WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_GetDescriptors_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_GetDescriptors_Params_Data* object =
      static_cast<const WallpaperSearchHandler_GetDescriptors_Params_Data*>(data);

  return true;
}

WallpaperSearchHandler_GetDescriptors_Params_Data::WallpaperSearchHandler_GetDescriptors_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_GetDescriptors_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_GetDescriptors_ResponseParams_Data* object =
      static_cast<const WallpaperSearchHandler_GetDescriptors_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->descriptors, validation_context))
    return false;

  return true;
}

WallpaperSearchHandler_GetDescriptors_ResponseParams_Data::WallpaperSearchHandler_GetDescriptors_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_GetInspirations_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_GetInspirations_Params_Data* object =
      static_cast<const WallpaperSearchHandler_GetInspirations_Params_Data*>(data);

  return true;
}

WallpaperSearchHandler_GetInspirations_Params_Data::WallpaperSearchHandler_GetInspirations_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_GetInspirations_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_GetInspirations_ResponseParams_Data* object =
      static_cast<const WallpaperSearchHandler_GetInspirations_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& inspirationGroups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->inspirationGroups, validation_context,
                                         &inspirationGroups_validate_params)) {
    return false;
  }

  return true;
}

WallpaperSearchHandler_GetInspirations_ResponseParams_Data::WallpaperSearchHandler_GetInspirations_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data* object =
      static_cast<const WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result_descriptors, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result_descriptors, validation_context))
    return false;

  return true;
}

WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data::WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data* object =
      static_cast<const WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data*>(data);


  if (!::side_panel::customize_chrome::mojom::internal::WallpaperSearchStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  return true;
}

WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data::WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_SetResultRenderTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_SetResultRenderTime_Params_Data* object =
      static_cast<const WallpaperSearchHandler_SetResultRenderTime_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result_ids, validation_context,
                                         &result_ids_validate_params)) {
    return false;
  }

  return true;
}

WallpaperSearchHandler_SetResultRenderTime_Params_Data::WallpaperSearchHandler_SetResultRenderTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data* object =
      static_cast<const WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptors, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptors, validation_context))
    return false;

  return true;
}

WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data::WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data* object =
      static_cast<const WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_url, validation_context))
    return false;

  return true;
}

WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data::WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data* object =
      static_cast<const WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptors, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptors, validation_context))
    return false;

  return true;
}

WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data::WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_UpdateHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_UpdateHistory_Params_Data* object =
      static_cast<const WallpaperSearchHandler_UpdateHistory_Params_Data*>(data);

  return true;
}

WallpaperSearchHandler_UpdateHistory_Params_Data::WallpaperSearchHandler_UpdateHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_SetUserFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_SetUserFeedback_Params_Data* object =
      static_cast<const WallpaperSearchHandler_SetUserFeedback_Params_Data*>(data);


  if (!::side_panel::customize_chrome::mojom::internal::UserFeedback_Data
        ::Validate(object->selected_option, validation_context))
    return false;

  return true;
}

WallpaperSearchHandler_SetUserFeedback_Params_Data::WallpaperSearchHandler_SetUserFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_OpenHelpArticle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_OpenHelpArticle_Params_Data* object =
      static_cast<const WallpaperSearchHandler_OpenHelpArticle_Params_Data*>(data);

  return true;
}

WallpaperSearchHandler_OpenHelpArticle_Params_Data::WallpaperSearchHandler_OpenHelpArticle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchHandler_LaunchHatsSurvey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchHandler_LaunchHatsSurvey_Params_Data* object =
      static_cast<const WallpaperSearchHandler_LaunchHatsSurvey_Params_Data*>(data);

  return true;
}

WallpaperSearchHandler_LaunchHatsSurvey_Params_Data::WallpaperSearchHandler_LaunchHatsSurvey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WallpaperSearchClient_SetHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WallpaperSearchClient_SetHistory_Params_Data* object =
      static_cast<const WallpaperSearchClient_SetHistory_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->history, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& history_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->history, validation_context,
                                         &history_validate_params)) {
    return false;
  }

  return true;
}

WallpaperSearchClient_SetHistory_Params_Data::WallpaperSearchClient_SetHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace customize_chrome
}  // namespace side_panel

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::customize_chrome::mojom::DescriptorDName>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::DescriptorDName value) {
  return std::move(context).WriteString(::side_panel::customize_chrome::mojom::DescriptorDNameToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::customize_chrome::mojom::WallpaperSearchStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::WallpaperSearchStatus value) {
  return std::move(context).WriteString(::side_panel::customize_chrome::mojom::WallpaperSearchStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::customize_chrome::mojom::UserFeedback>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::UserFeedback value) {
  return std::move(context).WriteString(::side_panel::customize_chrome::mojom::UserFeedbackToString(value));
}

} // namespace perfetto