// chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace side_panel::customize_chrome::mojom {

class CustomizeToolbarHandlerFactoryProxy;

template <typename ImplRefTraits>
class CustomizeToolbarHandlerFactoryStub;

class CustomizeToolbarHandlerFactoryRequestValidator;


class CustomizeToolbarHandlerFactory
    : public CustomizeToolbarHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.customize_chrome.mojom.CustomizeToolbarHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeToolbarHandlerFactoryInterfaceBase;
  using Proxy_ = CustomizeToolbarHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeToolbarHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeToolbarHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateCustomizeToolbarHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCustomizeToolbarHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeToolbarHandlerFactory() = default;

  virtual void CreateCustomizeToolbarHandler(::mojo::PendingRemote<CustomizeToolbarClient> client, ::mojo::PendingReceiver<CustomizeToolbarHandler> handler) = 0;
};

class CustomizeToolbarHandlerProxy;

template <typename ImplRefTraits>
class CustomizeToolbarHandlerStub;

class CustomizeToolbarHandlerRequestValidator;
class CustomizeToolbarHandlerResponseValidator;


class CustomizeToolbarHandler
    : public CustomizeToolbarHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.customize_chrome.mojom.CustomizeToolbarHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeToolbarHandlerInterfaceBase;
  using Proxy_ = CustomizeToolbarHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeToolbarHandlerStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeToolbarHandlerRequestValidator;
  using ResponseValidator_ = CustomizeToolbarHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kListActionsMinVersion = 0,
    kListCategoriesMinVersion = 0,
    kPinActionMinVersion = 0,
    kGetIsCustomizedMinVersion = 0,
    kResetToDefaultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ListActions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ListCategories_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PinAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsCustomized_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetToDefault_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeToolbarHandler() = default;

  using ListActionsCallback = base::OnceCallback<void(std::vector<ActionPtr>)>;
  using ListActionsMojoCallback = base::OnceCallback<void(std::vector<ActionPtr>)>;

  virtual void ListActions(ListActionsCallback callback) = 0;

  using ListCategoriesCallback = base::OnceCallback<void(std::vector<CategoryPtr>)>;
  using ListCategoriesMojoCallback = base::OnceCallback<void(std::vector<CategoryPtr>)>;

  virtual void ListCategories(ListCategoriesCallback callback) = 0;

  virtual void PinAction(ActionId action_id, bool pinned) = 0;

  using GetIsCustomizedCallback = base::OnceCallback<void(bool)>;
  using GetIsCustomizedMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetIsCustomized(GetIsCustomizedCallback callback) = 0;

  virtual void ResetToDefault() = 0;
};

class CustomizeToolbarClientProxy;

template <typename ImplRefTraits>
class CustomizeToolbarClientStub;

class CustomizeToolbarClientRequestValidator;


class CustomizeToolbarClient
    : public CustomizeToolbarClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.customize_chrome.mojom.CustomizeToolbarClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeToolbarClientInterfaceBase;
  using Proxy_ = CustomizeToolbarClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeToolbarClientStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeToolbarClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetActionPinnedMinVersion = 0,
    kNotifyActionsUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetActionPinned_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyActionsUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeToolbarClient() = default;

  virtual void SetActionPinned(ActionId action_id, bool pinned) = 0;

  virtual void NotifyActionsUpdated() = 0;
};



class  CustomizeToolbarHandlerFactoryProxy
    : public CustomizeToolbarHandlerFactory {
 public:
  using InterfaceType = CustomizeToolbarHandlerFactory;

  explicit CustomizeToolbarHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCustomizeToolbarHandler(::mojo::PendingRemote<CustomizeToolbarClient> client, ::mojo::PendingReceiver<CustomizeToolbarHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomizeToolbarHandlerProxy
    : public CustomizeToolbarHandler {
 public:
  using InterfaceType = CustomizeToolbarHandler;

  explicit CustomizeToolbarHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ListActions(ListActionsCallback callback) final;
  
  void ListCategories(ListCategoriesCallback callback) final;
  
  void PinAction(ActionId action_id, bool pinned) final;
  
  void GetIsCustomized(GetIsCustomizedCallback callback) final;
  
  void ResetToDefault() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomizeToolbarClientProxy
    : public CustomizeToolbarClient {
 public:
  using InterfaceType = CustomizeToolbarClient;

  explicit CustomizeToolbarClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetActionPinned(ActionId action_id, bool pinned) final;
  
  void NotifyActionsUpdated() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CustomizeToolbarHandlerFactoryStubDispatch {
 public:
  static bool Accept(CustomizeToolbarHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeToolbarHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeToolbarHandlerFactory>>
class CustomizeToolbarHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeToolbarHandlerFactoryStub() = default;
  ~CustomizeToolbarHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeToolbarHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeToolbarHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeToolbarHandlerStubDispatch {
 public:
  static bool Accept(CustomizeToolbarHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeToolbarHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeToolbarHandler>>
class CustomizeToolbarHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeToolbarHandlerStub() = default;
  ~CustomizeToolbarHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeToolbarHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeToolbarHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeToolbarClientStubDispatch {
 public:
  static bool Accept(CustomizeToolbarClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeToolbarClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeToolbarClient>>
class CustomizeToolbarClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeToolbarClientStub() = default;
  ~CustomizeToolbarClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeToolbarClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeToolbarClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeToolbarHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeToolbarHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeToolbarClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeToolbarHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  Category {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Category, T>::value>;
  using DataView = CategoryDataView;
  using Data_ = internal::Category_Data;

  template <typename... Args>
  static CategoryPtr New(Args&&... args) {
    return CategoryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CategoryPtr From(const U& u) {
    return mojo::TypeConverter<CategoryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Category>::Convert(*this);
  }


  Category();

  Category(
      CategoryId id,
      const std::string& display_name);


  ~Category();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CategoryPtr>
  CategoryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Category::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Category::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Category::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Category::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Category::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Category::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Category_UnserializedMessageContext<
            UserType, Category::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Category::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Category::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Category_UnserializedMessageContext<
            UserType, Category::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Category::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CategoryId id;
  
  std::string display_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Category::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Category::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Category::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Category::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  Action {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Action, T>::value>;
  using DataView = ActionDataView;
  using Data_ = internal::Action_Data;

  template <typename... Args>
  static ActionPtr New(Args&&... args) {
    return ActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ActionPtr From(const U& u) {
    return mojo::TypeConverter<ActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Action>::Convert(*this);
  }


  Action();

  Action(
      ActionId id,
      const std::string& display_name,
      bool pinned,
      bool has_enterprise_controlled_pinned_state,
      CategoryId category,
      const ::GURL& icon_url);


  ~Action();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ActionPtr>
  ActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Action::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Action::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Action::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Action::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Action::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Action::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Action_UnserializedMessageContext<
            UserType, Action::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Action::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Action::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Action_UnserializedMessageContext<
            UserType, Action::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Action::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ActionId id;
  
  std::string display_name;
  
  bool pinned;
  
  bool has_enterprise_controlled_pinned_state;
  
  CategoryId category;
  
  ::GURL icon_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Action::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ActionPtr Action::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(display_name),
      mojo::Clone(pinned),
      mojo::Clone(has_enterprise_controlled_pinned_state),
      mojo::Clone(category),
      mojo::Clone(icon_url)
  );
}

template <typename T, Action::EnableIfSame<T>*>
bool Action::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->pinned, other_struct.pinned))
    return false;
  if (!mojo::Equals(this->has_enterprise_controlled_pinned_state, other_struct.has_enterprise_controlled_pinned_state))
    return false;
  if (!mojo::Equals(this->category, other_struct.category))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  return true;
}

template <typename T, Action::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.pinned < rhs.pinned)
    return true;
  if (rhs.pinned < lhs.pinned)
    return false;
  if (lhs.has_enterprise_controlled_pinned_state < rhs.has_enterprise_controlled_pinned_state)
    return true;
  if (rhs.has_enterprise_controlled_pinned_state < lhs.has_enterprise_controlled_pinned_state)
    return false;
  if (lhs.category < rhs.category)
    return true;
  if (rhs.category < lhs.category)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  return false;
}
template <typename StructPtrType>
CategoryPtr Category::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(display_name)
  );
}

template <typename T, Category::EnableIfSame<T>*>
bool Category::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  return true;
}

template <typename T, Category::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  return false;
}


}  // side_panel::customize_chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::Action::DataView,
                                         ::side_panel::customize_chrome::mojom::ActionPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::ActionPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::ActionPtr* output) { output->reset(); }

  static decltype(::side_panel::customize_chrome::mojom::Action::id) id(
      const ::side_panel::customize_chrome::mojom::ActionPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Action::display_name)& display_name(
      const ::side_panel::customize_chrome::mojom::ActionPtr& input) {
    return input->display_name;
  }

  static decltype(::side_panel::customize_chrome::mojom::Action::pinned) pinned(
      const ::side_panel::customize_chrome::mojom::ActionPtr& input) {
    return input->pinned;
  }

  static decltype(::side_panel::customize_chrome::mojom::Action::has_enterprise_controlled_pinned_state) has_enterprise_controlled_pinned_state(
      const ::side_panel::customize_chrome::mojom::ActionPtr& input) {
    return input->has_enterprise_controlled_pinned_state;
  }

  static decltype(::side_panel::customize_chrome::mojom::Action::category) category(
      const ::side_panel::customize_chrome::mojom::ActionPtr& input) {
    return input->category;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Action::icon_url)& icon_url(
      const ::side_panel::customize_chrome::mojom::ActionPtr& input) {
    return input->icon_url;
  }

  static bool Read(::side_panel::customize_chrome::mojom::Action::DataView input, ::side_panel::customize_chrome::mojom::ActionPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::Category::DataView,
                                         ::side_panel::customize_chrome::mojom::CategoryPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::CategoryPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::CategoryPtr* output) { output->reset(); }

  static decltype(::side_panel::customize_chrome::mojom::Category::id) id(
      const ::side_panel::customize_chrome::mojom::CategoryPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Category::display_name)& display_name(
      const ::side_panel::customize_chrome::mojom::CategoryPtr& input) {
    return input->display_name;
  }

  static bool Read(::side_panel::customize_chrome::mojom::Category::DataView input, ::side_panel::customize_chrome::mojom::CategoryPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_H_