// chrome/browser/ui/webui/search_engine_choice/search_engine_choice.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/search_engine_choice/search_engine_choice.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/search_engine_choice/search_engine_choice.mojom-params-data.h"
namespace search_engine_choice {
namespace mojom {

NOINLINE static const char* PageHandler_ScrollStateToStringHelper(PageHandler_ScrollState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PageHandler_ScrollState::kAtTheBottom:
      return "kAtTheBottom";
    case PageHandler_ScrollState::kAtTheBottomWithErrorMargin:
      return "kAtTheBottomWithErrorMargin";
    case PageHandler_ScrollState::kNotAtTheBottom:
      return "kNotAtTheBottom";
    default:
      return nullptr;
  }
}

std::string PageHandler_ScrollStateToString(PageHandler_ScrollState value) {
  const char *str = PageHandler_ScrollStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PageHandler_ScrollState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PageHandler_ScrollState value) {
  return os << PageHandler_ScrollStateToString(value);
}

namespace internal {


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DisplayDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DisplayDialog_Params_Data* object =
      static_cast<const PageHandler_DisplayDialog_Params_Data*>(data);

  return true;
}

PageHandler_DisplayDialog_Params_Data::PageHandler_DisplayDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HandleSearchEngineChoiceSelected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HandleSearchEngineChoiceSelected_Params_Data* object =
      static_cast<const PageHandler_HandleSearchEngineChoiceSelected_Params_Data*>(data);

  return true;
}

PageHandler_HandleSearchEngineChoiceSelected_Params_Data::PageHandler_HandleSearchEngineChoiceSelected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HandleLearnMoreLinkClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HandleLearnMoreLinkClicked_Params_Data* object =
      static_cast<const PageHandler_HandleLearnMoreLinkClicked_Params_Data*>(data);

  return true;
}

PageHandler_HandleLearnMoreLinkClicked_Params_Data::PageHandler_HandleLearnMoreLinkClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_HandleMoreButtonClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_HandleMoreButtonClicked_Params_Data* object =
      static_cast<const PageHandler_HandleMoreButtonClicked_Params_Data*>(data);

  return true;
}

PageHandler_HandleMoreButtonClicked_Params_Data::PageHandler_HandleMoreButtonClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordScrollState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordScrollState_Params_Data* object =
      static_cast<const PageHandler_RecordScrollState_Params_Data*>(data);


  if (!::search_engine_choice::mojom::internal::PageHandler_ScrollState_Data
        ::Validate(object->scroll_state, validation_context))
    return false;

  return true;
}

PageHandler_RecordScrollState_Params_Data::PageHandler_RecordScrollState_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace search_engine_choice

namespace perfetto {

// static
void TraceFormatTraits<::search_engine_choice::mojom::PageHandler_ScrollState>::WriteIntoTrace(
   perfetto::TracedValue context, ::search_engine_choice::mojom::PageHandler_ScrollState value) {
  return std::move(context).WriteString(::search_engine_choice::mojom::PageHandler_ScrollStateToString(value));
}

} // namespace perfetto