// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const AutocompleteControllerTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AutocompleteControllerType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kBrowser = 0,
  kDebug = 1,
  kMlDisabledDebug = 2,
}



export type OmniboxPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<OmniboxPageHandlerPendingReceiver>;

export class OmniboxPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<OmniboxPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<OmniboxPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|OmniboxPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'mojom.OmniboxPageHandler',
        scope);
  }
}

export interface OmniboxPageHandlerInterface {
  setClientPage(page: OmniboxPageRemote): void;
  startOmniboxQuery(inputString: string, resetAutocompleteController: boolean, cursorPosition: number, zeroSuggest: boolean, preventInlineAutocomplete: boolean, preferKeyword: boolean, currentUrl: string, pageClassification: number): void;
  getMlModelVersion(): Promise<{
        version: number, }>;
  startMl(signals: Signals): Promise<{
        score: number, }>;
}

export class OmniboxPageHandlerRemote implements OmniboxPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<OmniboxPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<OmniboxPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|OmniboxPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OmniboxPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setClientPage(
      page: OmniboxPageRemote): void {
    this.proxy.sendMessage(
        0,
        OmniboxPageHandler_SetClientPage_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  startOmniboxQuery(
      inputString: string,
      resetAutocompleteController: boolean,
      cursorPosition: number,
      zeroSuggest: boolean,
      preventInlineAutocomplete: boolean,
      preferKeyword: boolean,
      currentUrl: string,
      pageClassification: number): void {
    this.proxy.sendMessage(
        1,
        OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$,
        null,
        [
          inputString,
          resetAutocompleteController,
          cursorPosition,
          zeroSuggest,
          preventInlineAutocomplete,
          preferKeyword,
          currentUrl,
          pageClassification
        ],
        false);
  }

  getMlModelVersion(): Promise<{
        version: number, }> {
    return this.proxy.sendMessage(
        2,
        OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$,
        OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  startMl(
      signals: Signals): Promise<{
        score: number, }> {
    return this.proxy.sendMessage(
        3,
        OmniboxPageHandler_StartMl_ParamsSpec.$,
        OmniboxPageHandler_StartMl_ResponseParamsSpec.$,
        [
          signals
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OmniboxPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OmniboxPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OmniboxPageHandlerRemote, OmniboxPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OmniboxPageHandlerRemote, OmniboxPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: OmniboxPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OmniboxPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OmniboxPageHandler_SetClientPage_ParamsSpec.$,
        null,
        impl.setClientPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$,
        null,
        impl.startOmniboxQuery.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$,
        OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$,
        impl.getMlModelVersion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OmniboxPageHandler_StartMl_ParamsSpec.$,
        OmniboxPageHandler_StartMl_ResponseParamsSpec.$,
        impl.startMl.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OmniboxPageHandler {
  static get $interfaceName(): string {
    return "mojom.OmniboxPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): OmniboxPageHandlerRemote {
    let remote = new OmniboxPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the OmniboxPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OmniboxPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OmniboxPageHandlerRemote, OmniboxPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OmniboxPageHandlerRemote, OmniboxPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setClientPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startOmniboxQuery: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getMlModelVersion: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startMl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OmniboxPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setClientPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OmniboxPageHandler_SetClientPage_ParamsSpec.$,
        null,
        this.setClientPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.startOmniboxQuery =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$,
        null,
        this.startOmniboxQuery.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getMlModelVersion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$,
        OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$,
        this.getMlModelVersion.createReceiverHandler(true /* expectsResponse */),
        false);
    this.startMl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OmniboxPageHandler_StartMl_ParamsSpec.$,
        OmniboxPageHandler_StartMl_ResponseParamsSpec.$,
        this.startMl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type OmniboxPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<OmniboxPagePendingReceiver>;

export class OmniboxPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<OmniboxPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<OmniboxPagePendingReceiver>;
  constructor(handle: MojoHandle|OmniboxPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'mojom.OmniboxPage',
        scope);
  }
}

export interface OmniboxPageInterface {
  handleNewAutocompleteQuery(autocompleteControllerType: AutocompleteControllerType, inputText: string): void;
  handleNewAutocompleteResponse(autocompleteControllerType: AutocompleteControllerType, response: OmniboxResponse): void;
  handleNewMlResponse(autocompleteControllerType: AutocompleteControllerType, inputText: string, matches: AutocompleteMatch[]): void;
  handleAnswerIconImageData(autocompleteControllerType: AutocompleteControllerType, imageUrl: url_mojom_Url, imageData: string): void;
}

export class OmniboxPageRemote implements OmniboxPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<OmniboxPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<OmniboxPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|OmniboxPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OmniboxPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  handleNewAutocompleteQuery(
      autocompleteControllerType: AutocompleteControllerType,
      inputText: string): void {
    this.proxy.sendMessage(
        0,
        OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$,
        null,
        [
          autocompleteControllerType,
          inputText
        ],
        false);
  }

  handleNewAutocompleteResponse(
      autocompleteControllerType: AutocompleteControllerType,
      response: OmniboxResponse): void {
    this.proxy.sendMessage(
        1,
        OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$,
        null,
        [
          autocompleteControllerType,
          response
        ],
        false);
  }

  handleNewMlResponse(
      autocompleteControllerType: AutocompleteControllerType,
      inputText: string,
      matches: AutocompleteMatch[]): void {
    this.proxy.sendMessage(
        2,
        OmniboxPage_HandleNewMlResponse_ParamsSpec.$,
        null,
        [
          autocompleteControllerType,
          inputText,
          matches
        ],
        false);
  }

  handleAnswerIconImageData(
      autocompleteControllerType: AutocompleteControllerType,
      imageUrl: url_mojom_Url,
      imageData: string): void {
    this.proxy.sendMessage(
        3,
        OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$,
        null,
        [
          autocompleteControllerType,
          imageUrl,
          imageData
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OmniboxPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OmniboxPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OmniboxPageRemote, OmniboxPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OmniboxPageRemote, OmniboxPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: OmniboxPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OmniboxPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$,
        null,
        impl.handleNewAutocompleteQuery.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$,
        null,
        impl.handleNewAutocompleteResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OmniboxPage_HandleNewMlResponse_ParamsSpec.$,
        null,
        impl.handleNewMlResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$,
        null,
        impl.handleAnswerIconImageData.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OmniboxPage {
  static get $interfaceName(): string {
    return "mojom.OmniboxPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): OmniboxPageRemote {
    let remote = new OmniboxPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the OmniboxPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OmniboxPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OmniboxPageRemote, OmniboxPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OmniboxPageRemote, OmniboxPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  handleNewAutocompleteQuery: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  handleNewAutocompleteResponse: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  handleNewMlResponse: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  handleAnswerIconImageData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OmniboxPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.handleNewAutocompleteQuery =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$,
        null,
        this.handleNewAutocompleteQuery.createReceiverHandler(false /* expectsResponse */),
        false);
    this.handleNewAutocompleteResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$,
        null,
        this.handleNewAutocompleteResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    this.handleNewMlResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OmniboxPage_HandleNewMlResponse_ParamsSpec.$,
        null,
        this.handleNewMlResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    this.handleAnswerIconImageData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$,
        null,
        this.handleAnswerIconImageData.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ACMatchClassificationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SignalsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AutocompleteMatchSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AutocompleteResultsForProviderSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPageHandler_SetClientPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPageHandler_StartOmniboxQuery_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPageHandler_GetMlModelVersion_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPageHandler_StartMl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPageHandler_StartMl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPage_HandleNewMlResponse_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPage_HandleAnswerIconImageData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ACMatchClassificationMojoType {
  offset: number;
  style: number;
}


export type ACMatchClassification = ACMatchClassificationMojoType;
mojo.internal.Struct<ACMatchClassificationMojoType>(
    ACMatchClassificationSpec.$,
    'ACMatchClassification',
    [
      mojo.internal.StructField<ACMatchClassificationMojoType, number>(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ACMatchClassificationMojoType, number>(
        'style', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SignalsMojoType {
  typedCount: (number | null);
  visitCount: (number | null);
  elapsedTimeLastVisitSecs: (bigint | null);
  shortcutVisitCount: (number | null);
  shortestShortcutLen: (number | null);
  elapsedTimeLastShortcutVisitSec: (bigint | null);
  isHostOnly: (boolean | null);
  numBookmarksOfUrl: (number | null);
  firstBookmarkTitleMatchPosition: (number | null);
  totalBookmarkTitleMatchLength: (number | null);
  numInputTermsMatchedByBookmarkTitle: (number | null);
  firstUrlMatchPosition: (number | null);
  totalUrlMatchLength: (number | null);
  hostMatchAtWordBoundary: (boolean | null);
  totalHostMatchLength: (number | null);
  totalPathMatchLength: (number | null);
  totalQueryOrRefMatchLength: (number | null);
  totalTitleMatchLength: (number | null);
  hasNonSchemeWwwMatch: (boolean | null);
  numInputTermsMatchedByTitle: (number | null);
  numInputTermsMatchedByUrl: (number | null);
  lengthOfUrl: (number | null);
  siteEngagement: (number | null);
  allowedToBeDefaultMatch: (boolean | null);
  searchSuggestRelevance: (number | null);
  isSearchSuggestEntity: (boolean | null);
  isVerbatim: (boolean | null);
  isNavsuggest: (boolean | null);
  isSearchSuggestTail: (boolean | null);
  isAnswerSuggest: (boolean | null);
  isCalculatorSuggest: (boolean | null);
}


export type Signals = SignalsMojoType;
mojo.internal.Struct<SignalsMojoType>(
    SignalsSpec.$,
    'Signals',
    [
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'typed_count_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "typed_count_$value",
          originalFieldName: "typedCount",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'typed_count_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "typedCount",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'visit_count_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "visit_count_$value",
          originalFieldName: "visitCount",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'visit_count_$value', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "visitCount",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'elapsed_time_last_visit_secs_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "elapsed_time_last_visit_secs_$value",
          originalFieldName: "elapsedTimeLastVisitSecs",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, bigint>(
        'elapsed_time_last_visit_secs_$value', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "elapsedTimeLastVisitSecs",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'shortcut_visit_count_$flag', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "shortcut_visit_count_$value",
          originalFieldName: "shortcutVisitCount",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'shortcut_visit_count_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "shortcutVisitCount",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'shortest_shortcut_len_$flag', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "shortest_shortcut_len_$value",
          originalFieldName: "shortestShortcutLen",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'shortest_shortcut_len_$value', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "shortestShortcutLen",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'elapsed_time_last_shortcut_visit_sec_$flag', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "elapsed_time_last_shortcut_visit_sec_$value",
          originalFieldName: "elapsedTimeLastShortcutVisitSec",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, bigint>(
        'elapsed_time_last_shortcut_visit_sec_$value', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "elapsedTimeLastShortcutVisitSec",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_host_only_$flag', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_host_only_$value",
          originalFieldName: "isHostOnly",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_host_only_$value', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isHostOnly",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'num_bookmarks_of_url_$flag', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "num_bookmarks_of_url_$value",
          originalFieldName: "numBookmarksOfUrl",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'num_bookmarks_of_url_$value', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numBookmarksOfUrl",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'first_bookmark_title_match_position_$flag', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "first_bookmark_title_match_position_$value",
          originalFieldName: "firstBookmarkTitleMatchPosition",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'first_bookmark_title_match_position_$value', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "firstBookmarkTitleMatchPosition",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'total_bookmark_title_match_length_$flag', 1,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "total_bookmark_title_match_length_$value",
          originalFieldName: "totalBookmarkTitleMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'total_bookmark_title_match_length_$value', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "totalBookmarkTitleMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'num_input_terms_matched_by_bookmark_title_$flag', 1,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "num_input_terms_matched_by_bookmark_title_$value",
          originalFieldName: "numInputTermsMatchedByBookmarkTitle",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'num_input_terms_matched_by_bookmark_title_$value', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numInputTermsMatchedByBookmarkTitle",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'first_url_match_position_$flag', 1,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "first_url_match_position_$value",
          originalFieldName: "firstUrlMatchPosition",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'first_url_match_position_$value', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "firstUrlMatchPosition",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'total_url_match_length_$flag', 1,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "total_url_match_length_$value",
          originalFieldName: "totalUrlMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'total_url_match_length_$value', 56,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "totalUrlMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'host_match_at_word_boundary_$flag', 1,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "host_match_at_word_boundary_$value",
          originalFieldName: "hostMatchAtWordBoundary",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'host_match_at_word_boundary_$value', 1,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "hostMatchAtWordBoundary",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'total_host_match_length_$flag', 2,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "total_host_match_length_$value",
          originalFieldName: "totalHostMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'total_host_match_length_$value', 60,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "totalHostMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'total_path_match_length_$flag', 2,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "total_path_match_length_$value",
          originalFieldName: "totalPathMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'total_path_match_length_$value', 64,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "totalPathMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'total_query_or_ref_match_length_$flag', 2,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "total_query_or_ref_match_length_$value",
          originalFieldName: "totalQueryOrRefMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'total_query_or_ref_match_length_$value', 68,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "totalQueryOrRefMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'total_title_match_length_$flag', 2,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "total_title_match_length_$value",
          originalFieldName: "totalTitleMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'total_title_match_length_$value', 72,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "totalTitleMatchLength",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'has_non_scheme_www_match_$flag', 2,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "has_non_scheme_www_match_$value",
          originalFieldName: "hasNonSchemeWwwMatch",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'has_non_scheme_www_match_$value', 2,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "hasNonSchemeWwwMatch",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'num_input_terms_matched_by_title_$flag', 2,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "num_input_terms_matched_by_title_$value",
          originalFieldName: "numInputTermsMatchedByTitle",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'num_input_terms_matched_by_title_$value', 76,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numInputTermsMatchedByTitle",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'num_input_terms_matched_by_url_$flag', 2,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "num_input_terms_matched_by_url_$value",
          originalFieldName: "numInputTermsMatchedByUrl",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'num_input_terms_matched_by_url_$value', 80,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numInputTermsMatchedByUrl",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'length_of_url_$flag', 3,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "length_of_url_$value",
          originalFieldName: "lengthOfUrl",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'length_of_url_$value', 84,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "lengthOfUrl",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'site_engagement_$flag', 3,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "site_engagement_$value",
          originalFieldName: "siteEngagement",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'site_engagement_$value', 88,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "siteEngagement",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'allowed_to_be_default_match_$flag', 3,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "allowed_to_be_default_match_$value",
          originalFieldName: "allowedToBeDefaultMatch",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'allowed_to_be_default_match_$value', 3,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "allowedToBeDefaultMatch",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'search_suggest_relevance_$flag', 3,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "search_suggest_relevance_$value",
          originalFieldName: "searchSuggestRelevance",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, number>(
        'search_suggest_relevance_$value', 92,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "searchSuggestRelevance",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_search_suggest_entity_$flag', 3,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_search_suggest_entity_$value",
          originalFieldName: "isSearchSuggestEntity",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_search_suggest_entity_$value', 3,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isSearchSuggestEntity",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_verbatim_$flag', 3,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_verbatim_$value",
          originalFieldName: "isVerbatim",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_verbatim_$value', 96,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isVerbatim",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_navsuggest_$flag', 96,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_navsuggest_$value",
          originalFieldName: "isNavsuggest",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_navsuggest_$value', 96,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isNavsuggest",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_search_suggest_tail_$flag', 96,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_search_suggest_tail_$value",
          originalFieldName: "isSearchSuggestTail",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_search_suggest_tail_$value', 96,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isSearchSuggestTail",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_answer_suggest_$flag', 96,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_answer_suggest_$value",
          originalFieldName: "isAnswerSuggest",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_answer_suggest_$value', 96,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isAnswerSuggest",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_calculator_suggest_$flag', 96,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_calculator_suggest_$value",
          originalFieldName: "isCalculatorSuggest",
        },
        undefined,
    ),
      mojo.internal.StructField<SignalsMojoType, boolean>(
        'is_calculator_suggest_$value', 97,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isCalculatorSuggest",
        },
        undefined,
    ),
    ],
    [[0, 112],]);





export interface AutocompleteMatchMojoType {
  providerName: string;
  providerDone: boolean;
  deletable: boolean;
  swapContentsAndDescription: boolean;
  allowedToBeDefaultMatch: boolean;
  isSearchType: boolean;
  hasTabMatch: boolean;
  starred: boolean;
  fromPrevious: boolean;
  relevance: number;
  fillIntoEdit: string;
  inlineAutocompletion: string;
  destinationUrl: url_mojom_Url;
  strippedDestinationUrl: url_mojom_Url;
  icon: url_mojom_Url;
  image: url_mojom_Url;
  contents: string;
  contentsClass: ACMatchClassification[];
  description: string;
  descriptionClass: ACMatchClassification[];
  answer: string;
  transition: string;
  type: string;
  aqsTypeSubtypes: string;
  associatedKeyword: string;
  keyword: string;
  duplicates: number;
  pedalId: number;
  scoringSignals: Signals;
  additionalInfo: {[key: string]: string};
}


export type AutocompleteMatch = AutocompleteMatchMojoType;
mojo.internal.Struct<AutocompleteMatchMojoType>(
    AutocompleteMatchSpec.$,
    'AutocompleteMatch',
    [
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'providerName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'providerDone', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, number>(
        'relevance', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'deletable', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'fillIntoEdit', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'inlineAutocompletion', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, url_mojom_Url>(
        'destinationUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, url_mojom_Url>(
        'strippedDestinationUrl', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, url_mojom_Url>(
        'icon', 48,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, url_mojom_Url>(
        'image', 56,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'contents', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, ACMatchClassification[]>(
        'contentsClass', 72,
        0,
        mojo.internal.Array(ACMatchClassificationSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'description', 80,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, ACMatchClassification[]>(
        'descriptionClass', 88,
        0,
        mojo.internal.Array(ACMatchClassificationSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'swapContentsAndDescription', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'answer', 96,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'transition', 104,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'allowedToBeDefaultMatch', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'type', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'isSearchType', 8,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'aqsTypeSubtypes', 120,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'hasTabMatch', 8,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'associatedKeyword', 128,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'keyword', 136,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'starred', 8,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, number>(
        'duplicates', 144,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'fromPrevious', 8,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, number>(
        'pedalId', 148,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, Signals>(
        'scoringSignals', 152,
        0,
        SignalsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, {[key: string]: string}>(
        'additionalInfo', 160,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 176],]);





export interface AutocompleteResultsForProviderMojoType {
  providerName: string;
  results: AutocompleteMatch[];
}


export type AutocompleteResultsForProvider = AutocompleteResultsForProviderMojoType;
mojo.internal.Struct<AutocompleteResultsForProviderMojoType>(
    AutocompleteResultsForProviderSpec.$,
    'AutocompleteResultsForProvider',
    [
      mojo.internal.StructField<AutocompleteResultsForProviderMojoType, string>(
        'providerName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteResultsForProviderMojoType, AutocompleteMatch[]>(
        'results', 8,
        0,
        mojo.internal.Array(AutocompleteMatchSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OmniboxResponseMojoType {
  cursorPosition: number;
  timeSinceOmniboxStartedMs: number;
  done: boolean;
  isTypedHost: boolean;
  type: string;
  host: string;
  inputText: string;
  combinedResults: AutocompleteMatch[];
  resultsByProvider: AutocompleteResultsForProvider[];
}


export type OmniboxResponse = OmniboxResponseMojoType;
mojo.internal.Struct<OmniboxResponseMojoType>(
    OmniboxResponseSpec.$,
    'OmniboxResponse',
    [
      mojo.internal.StructField<OmniboxResponseMojoType, number>(
        'cursorPosition', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, number>(
        'timeSinceOmniboxStartedMs', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, boolean>(
        'done', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, string>(
        'type', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, string>(
        'host', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, boolean>(
        'isTypedHost', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, string>(
        'inputText', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, AutocompleteMatch[]>(
        'combinedResults', 40,
        0,
        mojo.internal.Array(AutocompleteMatchSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxResponseMojoType, AutocompleteResultsForProvider[]>(
        'resultsByProvider', 48,
        0,
        mojo.internal.Array(AutocompleteResultsForProviderSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface OmniboxPageHandler_SetClientPage_ParamsMojoType {
  page: OmniboxPageRemote;
}


export type OmniboxPageHandler_SetClientPage_Params = OmniboxPageHandler_SetClientPage_ParamsMojoType;
mojo.internal.Struct<OmniboxPageHandler_SetClientPage_ParamsMojoType>(
    OmniboxPageHandler_SetClientPage_ParamsSpec.$,
    'OmniboxPageHandler_SetClientPage_Params',
    [
      mojo.internal.StructField<OmniboxPageHandler_SetClientPage_ParamsMojoType, OmniboxPageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(OmniboxPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType {
  inputString: string;
  resetAutocompleteController: boolean;
  zeroSuggest: boolean;
  preventInlineAutocomplete: boolean;
  preferKeyword: boolean;
  cursorPosition: number;
  currentUrl: string;
  pageClassification: number;
}


export type OmniboxPageHandler_StartOmniboxQuery_Params = OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType;
mojo.internal.Struct<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType>(
    OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$,
    'OmniboxPageHandler_StartOmniboxQuery_Params',
    [
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, string>(
        'inputString', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, boolean>(
        'resetAutocompleteController', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, number>(
        'cursorPosition', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, boolean>(
        'zeroSuggest', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, boolean>(
        'preventInlineAutocomplete', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, boolean>(
        'preferKeyword', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, string>(
        'currentUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPageHandler_StartOmniboxQuery_ParamsMojoType, number>(
        'pageClassification', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface OmniboxPageHandler_GetMlModelVersion_ParamsMojoType {
}


export type OmniboxPageHandler_GetMlModelVersion_Params = OmniboxPageHandler_GetMlModelVersion_ParamsMojoType;
mojo.internal.Struct<OmniboxPageHandler_GetMlModelVersion_ParamsMojoType>(
    OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$,
    'OmniboxPageHandler_GetMlModelVersion_Params',
    [
    ],
    [[0, 8],]);





export interface OmniboxPageHandler_GetMlModelVersion_ResponseParamsMojoType {
  version: number;
}


export type OmniboxPageHandler_GetMlModelVersion_ResponseParams = OmniboxPageHandler_GetMlModelVersion_ResponseParamsMojoType;
mojo.internal.Struct<OmniboxPageHandler_GetMlModelVersion_ResponseParamsMojoType>(
    OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$,
    'OmniboxPageHandler_GetMlModelVersion_ResponseParams',
    [
      mojo.internal.StructField<OmniboxPageHandler_GetMlModelVersion_ResponseParamsMojoType, number>(
        'version', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OmniboxPageHandler_StartMl_ParamsMojoType {
  signals: Signals;
}


export type OmniboxPageHandler_StartMl_Params = OmniboxPageHandler_StartMl_ParamsMojoType;
mojo.internal.Struct<OmniboxPageHandler_StartMl_ParamsMojoType>(
    OmniboxPageHandler_StartMl_ParamsSpec.$,
    'OmniboxPageHandler_StartMl_Params',
    [
      mojo.internal.StructField<OmniboxPageHandler_StartMl_ParamsMojoType, Signals>(
        'signals', 0,
        0,
        SignalsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OmniboxPageHandler_StartMl_ResponseParamsMojoType {
  score: number;
}


export type OmniboxPageHandler_StartMl_ResponseParams = OmniboxPageHandler_StartMl_ResponseParamsMojoType;
mojo.internal.Struct<OmniboxPageHandler_StartMl_ResponseParamsMojoType>(
    OmniboxPageHandler_StartMl_ResponseParamsSpec.$,
    'OmniboxPageHandler_StartMl_ResponseParams',
    [
      mojo.internal.StructField<OmniboxPageHandler_StartMl_ResponseParamsMojoType, number>(
        'score', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OmniboxPage_HandleNewAutocompleteQuery_ParamsMojoType {
  autocompleteControllerType: AutocompleteControllerType;
  inputText: string;
}


export type OmniboxPage_HandleNewAutocompleteQuery_Params = OmniboxPage_HandleNewAutocompleteQuery_ParamsMojoType;
mojo.internal.Struct<OmniboxPage_HandleNewAutocompleteQuery_ParamsMojoType>(
    OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$,
    'OmniboxPage_HandleNewAutocompleteQuery_Params',
    [
      mojo.internal.StructField<OmniboxPage_HandleNewAutocompleteQuery_ParamsMojoType, AutocompleteControllerType>(
        'autocompleteControllerType', 0,
        0,
        AutocompleteControllerTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPage_HandleNewAutocompleteQuery_ParamsMojoType, string>(
        'inputText', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OmniboxPage_HandleNewAutocompleteResponse_ParamsMojoType {
  autocompleteControllerType: AutocompleteControllerType;
  response: OmniboxResponse;
}


export type OmniboxPage_HandleNewAutocompleteResponse_Params = OmniboxPage_HandleNewAutocompleteResponse_ParamsMojoType;
mojo.internal.Struct<OmniboxPage_HandleNewAutocompleteResponse_ParamsMojoType>(
    OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$,
    'OmniboxPage_HandleNewAutocompleteResponse_Params',
    [
      mojo.internal.StructField<OmniboxPage_HandleNewAutocompleteResponse_ParamsMojoType, AutocompleteControllerType>(
        'autocompleteControllerType', 0,
        0,
        AutocompleteControllerTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPage_HandleNewAutocompleteResponse_ParamsMojoType, OmniboxResponse>(
        'response', 8,
        0,
        OmniboxResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OmniboxPage_HandleNewMlResponse_ParamsMojoType {
  autocompleteControllerType: AutocompleteControllerType;
  inputText: string;
  matches: AutocompleteMatch[];
}


export type OmniboxPage_HandleNewMlResponse_Params = OmniboxPage_HandleNewMlResponse_ParamsMojoType;
mojo.internal.Struct<OmniboxPage_HandleNewMlResponse_ParamsMojoType>(
    OmniboxPage_HandleNewMlResponse_ParamsSpec.$,
    'OmniboxPage_HandleNewMlResponse_Params',
    [
      mojo.internal.StructField<OmniboxPage_HandleNewMlResponse_ParamsMojoType, AutocompleteControllerType>(
        'autocompleteControllerType', 0,
        0,
        AutocompleteControllerTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPage_HandleNewMlResponse_ParamsMojoType, string>(
        'inputText', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPage_HandleNewMlResponse_ParamsMojoType, AutocompleteMatch[]>(
        'matches', 16,
        0,
        mojo.internal.Array(AutocompleteMatchSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface OmniboxPage_HandleAnswerIconImageData_ParamsMojoType {
  autocompleteControllerType: AutocompleteControllerType;
  imageUrl: url_mojom_Url;
  imageData: string;
}


export type OmniboxPage_HandleAnswerIconImageData_Params = OmniboxPage_HandleAnswerIconImageData_ParamsMojoType;
mojo.internal.Struct<OmniboxPage_HandleAnswerIconImageData_ParamsMojoType>(
    OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$,
    'OmniboxPage_HandleAnswerIconImageData_Params',
    [
      mojo.internal.StructField<OmniboxPage_HandleAnswerIconImageData_ParamsMojoType, AutocompleteControllerType>(
        'autocompleteControllerType', 0,
        0,
        AutocompleteControllerTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPage_HandleAnswerIconImageData_ParamsMojoType, url_mojom_Url>(
        'imageUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPage_HandleAnswerIconImageData_ParamsMojoType, string>(
        'imageData', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);



